/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.tracking;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.runtime.tracking.AutoValue_PermissionTrace;
import com.google.firebase.rules.runtime.tracking.PermissionTrace;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.Optional;

abstract class $AutoValue_PermissionTrace
extends PermissionTrace {
    private final String method;
    private final Expression expression;
    private final ImmutableMap<Expression, ExpressionValue> evaluationResults;
    private final Optional<String> error;

    $AutoValue_PermissionTrace(String method, Expression expression, ImmutableMap<Expression, ExpressionValue> evaluationResults, Optional<String> error) {
        if (method == null) {
            throw new NullPointerException("Null method");
        }
        this.method = method;
        if (expression == null) {
            throw new NullPointerException("Null expression");
        }
        this.expression = expression;
        if (evaluationResults == null) {
            throw new NullPointerException("Null evaluationResults");
        }
        this.evaluationResults = evaluationResults;
        if (error == null) {
            throw new NullPointerException("Null error");
        }
        this.error = error;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Expression expression() {
        return this.expression;
    }

    @Override
    public ImmutableMap<Expression, ExpressionValue> evaluationResults() {
        return this.evaluationResults;
    }

    @Override
    public Optional<String> error() {
        return this.error;
    }

    public String toString() {
        String string = this.method;
        String string2 = String.valueOf(this.expression);
        String string3 = String.valueOf(this.evaluationResults);
        String string4 = String.valueOf(this.error);
        return new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("PermissionTrace{method=").append(string).append(", expression=").append(string2).append(", evaluationResults=").append(string3).append(", error=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PermissionTrace) {
            PermissionTrace that = (PermissionTrace)o;
            return this.method.equals(that.method()) && this.expression.equals(that.expression()) && this.evaluationResults.equals(that.evaluationResults()) && this.error.equals(that.error());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.expression.hashCode();
        h$ *= 1000003;
        h$ ^= this.evaluationResults.hashCode();
        h$ *= 1000003;
        return h$ ^= this.error.hashCode();
    }

    static final class Builder
    extends PermissionTrace.Builder {
        private String method;
        private Expression expression;
        private ImmutableMap<Expression, ExpressionValue> evaluationResults;
        private Optional<String> error = Optional.empty();

        Builder() {
        }

        @Override
        public PermissionTrace.Builder method(String method) {
            if (method == null) {
                throw new NullPointerException("Null method");
            }
            this.method = method;
            return this;
        }

        @Override
        public PermissionTrace.Builder expression(Expression expression) {
            if (expression == null) {
                throw new NullPointerException("Null expression");
            }
            this.expression = expression;
            return this;
        }

        @Override
        public PermissionTrace.Builder evaluationResults(ImmutableMap<Expression, ExpressionValue> evaluationResults) {
            if (evaluationResults == null) {
                throw new NullPointerException("Null evaluationResults");
            }
            this.evaluationResults = evaluationResults;
            return this;
        }

        @Override
        public PermissionTrace.Builder error(String error) {
            this.error = Optional.of(error);
            return this;
        }

        @Override
        public PermissionTrace build() {
            String missing = "";
            if (this.method == null) {
                missing = String.valueOf(missing).concat(" method");
            }
            if (this.expression == null) {
                missing = String.valueOf(missing).concat(" expression");
            }
            if (this.evaluationResults == null) {
                missing = String.valueOf(missing).concat(" evaluationResults");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_PermissionTrace(this.method, this.expression, this.evaluationResults, this.error);
        }
    }
}

