/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.tracking;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.tracking.PermissionTrace;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;

public final class GranularExpressionListener
implements EvaluationListener {
    private final ConcurrentLinkedQueue<PermissionTrace> traces;
    private final Map<Expression, ExpressionValue> evaluationResults = new HashMap<Expression, ExpressionValue>();

    public GranularExpressionListener(ConcurrentLinkedQueue<PermissionTrace> traces) {
        this.traces = traces;
    }

    public GranularExpressionListener() {
        this(new ConcurrentLinkedQueue<PermissionTrace>());
    }

    public ImmutableList<PermissionTrace> traces() {
        return ImmutableList.copyOf(this.traces);
    }

    @Override
    public void afterExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer, @Nullable ExpressionValue expressionValue) {
        if (expressionValue != null) {
            this.evaluationResults.put(expression, expressionValue);
        } else {
            this.evaluationResults.put(expression, ExpressionValue.getDefaultInstance());
        }
    }

    @Override
    public void beforePermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts) {
        this.evaluationResults.clear();
    }

    @Override
    public void afterSinglePermissionEvaluation(Evaluator.Context context, boolean allow, Expression expression) {
        PermissionTrace.Builder builder = PermissionTrace.builder();
        builder.method(context.method());
        builder.expression(expression);
        builder.evaluationResults(ImmutableMap.copyOf(this.evaluationResults));
        this.traces.add(builder.build());
    }

    @Override
    public void afterSinglePermissionEvaluation(Evaluator.Context context, Throwable throwable, Expression expression) {
        PermissionTrace.Builder builder = PermissionTrace.builder();
        builder.method(context.method());
        builder.expression(expression);
        builder.evaluationResults(ImmutableMap.copyOf(this.evaluationResults));
        if (throwable.getMessage().isEmpty()) {
            builder.error(String.format("evaluation error at L%d:%s", expression.getSourcePosition().getLine(), expression.getSourcePosition().getColumn()));
        } else {
            builder.error(throwable.getMessage());
        }
        this.traces.add(builder.build());
    }
}

