/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.tracking;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.runtime.tracking.$AutoValue_PermissionTrace;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Undefined;
import java.util.Optional;
import java.util.function.Consumer;

@AutoValue
public abstract class PermissionTrace {
    private static final ExpressionValue PLACEHOLDER = ExpressionValue.newBuilder().setUndefined(Undefined.newBuilder().setCauseMessage("unevaluated")).build();

    public abstract String method();

    public abstract Expression expression();

    public abstract ImmutableMap<Expression, ExpressionValue> evaluationResults();

    public abstract Optional<String> error();

    public ImmutableList<ExpressionValue> values() {
        ImmutableList.Builder output = ImmutableList.builder();
        PreorderResults.traverse(output::add, this.evaluationResults(), this.expression());
        return output.build();
    }

    public static Builder builder() {
        return new $AutoValue_PermissionTrace.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder method(String var1);

        public abstract Builder expression(Expression var1);

        public abstract Builder error(String var1);

        public abstract Builder evaluationResults(ImmutableMap<Expression, ExpressionValue> var1);

        public abstract PermissionTrace build();
    }

    private static class PreorderResults
    extends AbstractAstVisitor {
        private final Consumer<ExpressionValue> consumer;
        private final ImmutableMap<Expression, ExpressionValue> results;

        private PreorderResults(Consumer<ExpressionValue> consumer, ImmutableMap<Expression, ExpressionValue> results) {
            this.consumer = consumer;
            this.results = results;
        }

        public static void traverse(Consumer<ExpressionValue> consumer, ImmutableMap<Expression, ExpressionValue> expressionResults, Expression e) {
            PreorderResults results = new PreorderResults(consumer, expressionResults);
            results.visit(e);
        }

        @Override
        protected void visit(Expression e) {
            ExpressionValue value = this.results.getOrDefault(e, PLACEHOLDER);
            this.consumer.accept(value);
            super.visit(e);
        }
    }
}

