/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.tracking;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.runtime.tracking.PermissionTrace;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RuleExpressionTracker<Report> {
    private final ReportNodeBuilder<Report> nodeBuilder;
    private final Table<Expression, ExpressionValue, Integer> underlying = HashBasedTable.create();

    public RuleExpressionTracker(ReportNodeBuilder<Report> nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public void addResultsFrom(Iterable<PermissionTrace> traces) {
        for (PermissionTrace trace : traces) {
            this.addAll(trace.evaluationResults());
        }
    }

    private void addAll(Map<Expression, ExpressionValue> toAdd) {
        toAdd.forEach(this::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void add(Expression expression, ExpressionValue expressionValue) {
        Preconditions.checkNotNull(expressionValue);
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            this.underlying.row(expression).compute(expressionValue, (k2, v2) -> (v2 == null ? 0 : v2) + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int totalEvaluationCount() {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return this.underlying.values().stream().mapToInt(Integer::intValue).sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ImmutableSet<ExpressionValue> allEvaluationResults() {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return ImmutableSet.copyOf(this.underlying.columnKeySet());
        }
    }

    public ImmutableCollection<Report> expressionReports(RulesetAst rules) {
        ImmutableSet<Expression> rootExpressions = ShallowExpressionCollector.collectExpressions(rules);
        ImmutableMap<Expression, SourcePosition> positionReplacements = ReplacementCollector.collectReplacements(rules);
        return this.buildExpressionReports(rootExpressions, positionReplacements);
    }

    private ImmutableSet<Report> buildExpressionReports(ImmutableSet<Expression> expressions, ImmutableMap<Expression, SourcePosition> positionReplacements) {
        return expressions.stream().filter(child -> !child.hasLiteral()).map(expression -> {
            ImmutableSet<Report> children = this.buildExpressionReports(ShallowExpressionCollector.collectExpressions(expression), positionReplacements);
            return this.nodeBuilder.create(children, (SourcePosition)positionReplacements.get(expression), this.collectExpressionValues((Expression)expression));
        }).collect(ImmutableSet.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableMap<ExpressionValue, Integer> collectExpressionValues(Expression expression) {
        Table<Expression, ExpressionValue, Integer> table = this.underlying;
        synchronized (table) {
            return ImmutableMap.copyOf(this.underlying.row(expression));
        }
    }

    private static final class ShallowExpressionCollector
    extends AbstractAstVisitor {
        private final ImmutableSet.Builder<Expression> expressions = ImmutableSet.builder();

        private ShallowExpressionCollector() {
        }

        static ImmutableSet<Expression> collectExpressions(RulesetAst ast) {
            ShallowExpressionCollector collector = new ShallowExpressionCollector();
            collector.visitAst(ast);
            return collector.expressions.build();
        }

        static ImmutableSet<Expression> collectExpressions(Expression expression) {
            ShallowExpressionCollector collector = new ShallowExpressionCollector();
            collector.visitExpression(expression);
            return collector.expressions.build();
        }

        private void visitExpression(Expression expression) {
            super.visit(expression);
        }

        @Override
        protected void visit(Expression expression) {
            this.expressions.add((Object)expression);
        }
    }

    static class PositionCollector
    extends AbstractAstVisitor {
        protected final ImmutableSet.Builder<SourcePosition> positions = ImmutableSet.builder();

        private PositionCollector() {
        }

        @Override
        protected void visitIdentifier(Identifier identifier) {
            this.positions.add((Object)identifier.getSourcePosition());
            super.visitIdentifier(identifier);
        }

        @Override
        protected void visitMatchRule(MatchRule matchRule) {
            this.positions.add((Object)matchRule.getSourcePosition());
            super.visitMatchRule(matchRule);
        }

        @Override
        protected void visit(Expression expression) {
            this.positions.add((Object)expression.getSourcePosition());
            super.visit(expression);
        }
    }

    static class ReplacementCollector
    extends PositionCollector {
        private final Map<Expression, SourcePosition> replacements = new HashMap<Expression, SourcePosition>();

        private ReplacementCollector() {
        }

        public static ImmutableMap<Expression, SourcePosition> collectReplacements(RulesetAst ast) {
            ReplacementCollector collector = new ReplacementCollector();
            collector.visitAst(ast);
            return ImmutableMap.copyOf(collector.replacements);
        }

        private static SourcePosition spanningPosition(ImmutableCollection<SourcePosition> allPositions) {
            SourcePosition start = allPositions.stream().min(Comparator.comparing(SourcePosition::getCurrentOffset)).get();
            int end = allPositions.stream().max(Comparator.comparing(SourcePosition::getEndOffset)).get().getEndOffset();
            return start.toBuilder().setEndOffset(end).build();
        }

        @Override
        protected void visit(Expression expression) {
            ReplacementCollector collector = new ReplacementCollector();
            collector.visitExpression(expression);
            ImmutableCollection positions = collector.positions.build();
            SourcePosition correctedPosition = ReplacementCollector.spanningPosition(positions);
            this.replacements.putAll(collector.replacements);
            if (expression.hasSourcePosition()) {
                this.replacements.put(expression, correctedPosition);
            }
            this.positions.add(correctedPosition);
        }

        protected void visitExpression(Expression expression) {
            super.visit(expression);
        }
    }

    public static interface ReportNodeBuilder<Report> {
        public Report create(ImmutableSet<Report> var1, @Nullable SourcePosition var2, ImmutableMap<ExpressionValue, Integer> var3);
    }
}

