/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.firebase.rules.lang.common.TypeName;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface FunctionExpects {
    public ExpectedExpressionKind[] arguments() default {};

    public static enum ExpectedExpressionKind {
        ANY{

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase != ExpressionValue.KindCase.KIND_NOT_SET && kindCase != ExpressionValue.KindCase.UNDEFINED;
            }
        }
        ,
        BOOL(TypeName.BOOL){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.BOOL_VALUE;
            }
        }
        ,
        FLOAT(TypeName.FLOAT){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.FLOAT_VALUE;
            }

            @Override
            public boolean isCoercibleFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.INT_VALUE;
            }

            @Override
            public ExpressionValue coerce(ExpressionValue argument) {
                Preconditions.checkArgument(argument.getKindCase() == ExpressionValue.KindCase.INT_VALUE);
                return ExpressionValueUtils.createValue((double)argument.getIntValue());
            }
        }
        ,
        LIST(TypeName.LIST){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.LIST_VALUE;
            }
        }
        ,
        SET(TypeName.SET){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.SET_VALUE;
            }
        }
        ,
        INT(TypeName.INT){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.INT_VALUE;
            }
        }
        ,
        NULL{

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.NULL_VALUE;
            }
        }
        ,
        DURATION(TypeName.DURATION){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.DURATION_VALUE;
            }
        }
        ,
        TIMESTAMP(TypeName.TIMESTAMP){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.TIMESTAMP_VALUE;
            }
        }
        ,
        LATLNG(TypeName.LATLNG){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.LATLNG_VALUE;
            }
        }
        ,
        MAP(TypeName.MAP){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.MAP_VALUE;
            }
        }
        ,
        CONSTRAINT(TypeName.CONSTRAINT){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.CONSTRAINT_VALUE;
            }
        }
        ,
        STRING(TypeName.STRING){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.STRING_VALUE;
            }
        }
        ,
        BYTES(TypeName.BYTES){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.BYTES_VALUE;
            }
        }
        ,
        PATH_TEMPLATE(TypeName.PATH_TEMPLATE){

            @Override
            public boolean isAssignableFrom(ExpressionValue.KindCase kindCase) {
                return kindCase == ExpressionValue.KindCase.PATH_VALUE;
            }
        };

        private final String friendlyName;

        private ExpectedExpressionKind() {
            this.friendlyName = Ascii.toLowerCase(this.name());
        }

        private ExpectedExpressionKind(TypeName typeName) {
            this.friendlyName = typeName.getFriendlyName();
        }

        public abstract boolean isAssignableFrom(ExpressionValue.KindCase var1);

        public String toString() {
            return this.friendlyName;
        }

        public boolean isCoercibleFrom(ExpressionValue.KindCase kindCase) {
            return false;
        }

        public ExpressionValue coerce(ExpressionValue argument) {
            throw new IllegalArgumentException();
        }
    }
}

