/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AsyncRuntimeFunction;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.TypedFunction;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.InvocationGuard;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class FunctionGuard<T>
implements InvocationGuard<T> {
    private static final Joiner SIGNATURE_JOINER = Joiner.on(", ").skipNulls();
    private final FunctionTemplate functionTemplate;
    @Nullable
    private final ExpressionValue.KindCase operand;
    private final int expectedArgCount;
    private final int overloadCount;
    private final List<TypedFunction<T>> overloads;
    private final List<FunctionExpects> expectations;
    private String expectedSignatures;

    public FunctionGuard(FunctionTemplate functionTemplate, @Nullable ExpressionValue.KindCase operand, ImmutableList<TypedFunction<T>> overloads) {
        Preconditions.checkArgument(!overloads.isEmpty());
        this.overloads = overloads;
        this.overloadCount = overloads.size();
        TypedFunction overloadFunction = (TypedFunction)overloads.get(0);
        FunctionExpects functionExpects = overloadFunction.getClass().getAnnotation(FunctionExpects.class);
        Preconditions.checkNotNull(functionExpects, "Guarded RuntimeFunction not annotated with @FunctionExpects");
        this.operand = operand;
        this.expectedArgCount = functionExpects.arguments().length;
        this.functionTemplate = functionTemplate;
        this.expectations = ImmutableList.copyOf(Iterables.transform(overloads, new FunctionExpectationTransform()));
        this.expectedSignatures = null;
    }

    public FunctionGuard(FunctionTemplate functionTemplate, @Nullable ExpressionValue.KindCase operand, TypedFunction<T> ... overloads) {
        this(functionTemplate, operand, ImmutableList.copyOf(overloads));
    }

    public FunctionGuard(FunctionTemplate functionTemplate, TypedFunction<T> ... overloads) {
        this(functionTemplate, null, ImmutableList.copyOf(overloads));
    }

    public FunctionGuard(String functionName, TypedFunction<T> ... overloads) {
        this(FunctionTemplate.MethodCallFunctionTemplate.makeFunctionTemplate(functionName), null, ImmutableList.copyOf(overloads));
    }

    protected String getExpectedSignatures() {
        if (this.expectedSignatures == null) {
            this.expectedSignatures = SIGNATURE_JOINER.join(Iterables.transform(this.expectations, new FunctionSignatureTransform()));
        }
        return this.expectedSignatures;
    }

    @Override
    @CheckReturnValue
    public InvocationGuard.OverloadExecutionRequest<T> check(ExecutionRequest request) throws EvaluationException {
        this.checkArgumentCount(request);
        for (int i = 0; i < this.overloadCount; ++i) {
            FunctionExpects expectation = this.expectations.get(i);
            ExecutionRequest modifiedRequest = this.matchWithCoercion(request, expectation);
            if (modifiedRequest == null) continue;
            return new InvocationGuard.OverloadExecutionRequest<T>(this.overloads.get(i), modifiedRequest);
        }
        throw EvaluationException.makeUnsupportedOperationError(request.getSourcePosition(), this.getSignature(request), this.getExpectedSignatures());
    }

    @Nullable
    private ExecutionRequest matchWithCoercion(ExecutionRequest request, FunctionExpects expectation) {
        HashSet<Integer> needCoercion = new HashSet<Integer>();
        for (int j = 0; j < this.expectedArgCount; ++j) {
            ExpressionValue arg = request.getArguments(j);
            FunctionExpects.ExpectedExpressionKind expectedArgType = expectation.arguments()[j];
            if (expectedArgType.isCoercibleFrom(arg.getKindCase())) {
                needCoercion.add(j);
                continue;
            }
            if (expectedArgType.isAssignableFrom(arg.getKindCase())) continue;
            return null;
        }
        if (needCoercion.isEmpty()) {
            return request;
        }
        ExecutionRequest.Builder requestBuilder = request.toBuilder();
        Iterator iterator = needCoercion.iterator();
        while (iterator.hasNext()) {
            int arg = (Integer)iterator.next();
            requestBuilder.setArguments(arg, expectation.arguments()[arg].coerce(request.getArguments(arg)));
        }
        return requestBuilder.build();
    }

    public static AsyncRuntimeFunction guard(final AsyncRuntimeFunction function) {
        FunctionTemplate template = FunctionTemplate.MethodCallFunctionTemplate.makeFunctionTemplate(function.name());
        final FunctionGuard guard = new FunctionGuard(template, function);
        return new AsyncRuntimeFunction(){

            @Override
            public String name() {
                return function.name();
            }

            @Override
            public ListenableFuture<ExecutionResponse> execute(ExecutionRequest request) {
                try {
                    request = guard.check(request).executionRequest();
                }
                catch (EvaluationException e) {
                    return Futures.immediateFailedFuture(e);
                }
                return function.execute(request);
            }
        };
    }

    protected String getSignature(FunctionExpects expectation) {
        FunctionExpects.ExpectedExpressionKind[] expectedArguments;
        ArrayList<String> expectedArgumentTypes = Lists.newArrayList();
        for (FunctionExpects.ExpectedExpressionKind expectedArgument : expectedArguments = expectation.arguments()) {
            expectedArgumentTypes.add(expectedArgument.toString());
        }
        return this.functionTemplate.getSignature(this.operand != null ? KindCaseHelper.kindToString(this.operand) : null, expectedArgumentTypes);
    }

    protected String getSignature(ExecutionRequest request) {
        ArrayList<String> argumentTypes = Lists.newArrayList();
        for (ExpressionValue argument : request.getArgumentsList()) {
            argumentTypes.add(KindCaseHelper.kindToString(argument.getKindCase()));
        }
        return this.functionTemplate.getSignature(request.hasOperand() ? KindCaseHelper.kindToString(request.getOperand().getKindCase()) : null, argumentTypes);
    }

    private void checkArgumentCount(ExecutionRequest request) throws EvaluationException {
        int actualArgCount = request.getArgumentsCount();
        if (actualArgCount != this.expectedArgCount) {
            throw EvaluationException.makeIncorrectArgumentCountError(request.getSourcePosition(), request.getArgumentsCount(), this.getExpectedSignatures());
        }
    }

    private class FunctionSignatureTransform
    implements Function<FunctionExpects, String> {
        private FunctionSignatureTransform() {
        }

        @Override
        public String apply(FunctionExpects expectation) {
            return FunctionGuard.this.getSignature(expectation);
        }
    }

    private class FunctionExpectationTransform
    implements Function<TypedFunction<T>, FunctionExpects> {
        private FunctionExpectationTransform() {
        }

        @Override
        public FunctionExpects apply(TypedFunction<T> function) {
            FunctionExpects functionExpects = function.getClass().getAnnotation(FunctionExpects.class);
            Preconditions.checkNotNull(functionExpects, "Guarded function not annotated with @FunctionExpects");
            Preconditions.checkState(functionExpects.arguments().length == FunctionGuard.this.expectedArgCount, "All the overloads should have same number of arguments.");
            return functionExpects;
        }
    }
}

