/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private JsonUtils() {
    }

    public static ExpressionValue jsonToExpressionValue(String jsonValue) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonValue);
        return JsonUtils.getExpressionValue(jsonElement);
    }

    public static Object jsonToPojo(String jsonValue) {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(jsonValue);
        return JsonUtils.getObjectValue(jsonElement);
    }

    static ExpressionValue getExpressionValue(JsonElement element) {
        if (element.isJsonNull()) {
            return ExpressionValueUtils.NULL;
        }
        if (element.isJsonPrimitive()) {
            return ExpressionValueUtils.createValue(JsonUtils.getPrimitiveObjectValue(element.getAsJsonPrimitive()));
        }
        if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            ExpressionListValue.Builder list = ExpressionListValue.newBuilder();
            for (JsonElement jsonElement : jsonArray) {
                list.addValues(JsonUtils.getExpressionValue(jsonElement));
            }
            return ExpressionValue.newBuilder().setListValue(list).build();
        }
        if (element.isJsonObject()) {
            ExpressionMapValue.Builder map = ExpressionMapValue.newBuilder();
            JsonObject jsonObject = element.getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                map.putFields(entry.getKey(), JsonUtils.getExpressionValue(entry.getValue()));
            }
            return ExpressionValue.newBuilder().setMapValue(map).build();
        }
        String string = String.valueOf(element);
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("cannot convert ").append(string).append(" to expression value.").toString());
    }

    private static Object getObjectValue(JsonElement jsonValue) {
        if (jsonValue.isJsonNull()) {
            return null;
        }
        if (jsonValue.isJsonObject()) {
            return JsonUtils.getObjectMapValue(jsonValue.getAsJsonObject());
        }
        if (jsonValue.isJsonArray()) {
            return JsonUtils.getObjectListValue(jsonValue.getAsJsonArray());
        }
        if (jsonValue.isJsonPrimitive()) {
            return JsonUtils.getPrimitiveObjectValue(jsonValue.getAsJsonPrimitive());
        }
        String string = String.valueOf(jsonValue);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported data type: ").append(string).toString());
    }

    private static List<Object> getObjectListValue(JsonArray array) {
        ArrayList<Object> list = Lists.newArrayList();
        for (JsonElement element : array) {
            list.add(JsonUtils.getObjectValue(element));
        }
        return list;
    }

    private static Map<String, Object> getObjectMapValue(JsonObject object) {
        HashMap<String, Object> map = Maps.newHashMap();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            map.put(entry.getKey(), JsonUtils.getObjectValue(entry.getValue()));
        }
        return map;
    }

    private static Object getPrimitiveObjectValue(JsonPrimitive primitive) {
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isString()) {
            return primitive.getAsString();
        }
        if (primitive.isNumber()) {
            boolean isIntLike;
            boolean bl = isIntLike = (double)primitive.getAsLong() == primitive.getAsDouble();
            if (isIntLike) {
                return primitive.getAsLong();
            }
            return primitive.getAsDouble();
        }
        String string = String.valueOf(primitive);
        throw new IllegalArgumentException(new StringBuilder(28 + String.valueOf(string).length()).append("Unsupported primitive type: ").append(string).toString());
    }
}

