/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.tree;

import com.google.common.collect.Lists;
import com.google.firebase.rules.tree.TreeNode;
import java.util.List;

public class TreeNodeImpl<V>
implements TreeNode<V> {
    private final V value;
    private final TreeNode<V> parent;
    private final List<TreeNode<V>> children = Lists.newArrayList();

    private TreeNodeImpl(TreeNode<V> parent, V value) {
        this.parent = parent;
        this.value = value;
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    @Override
    public TreeNode<V> makeChild(V value) {
        return new TreeNodeImpl<V>(this, value);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public List<TreeNode<V>> getChildren() {
        return this.children;
    }

    @Override
    public TreeNode<V> getParent() {
        return this.parent;
    }

    public static <V> TreeNode<V> makeRoot(V value) {
        return new TreeNodeImpl<V>(null, value);
    }
}

