/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.UUID;

public class ByteStringKeyUtils {
    private static final int UUID_BYTES_SIZE = 16;

    private ByteStringKeyUtils() {
    }

    public static String randomKey() {
        return UUID.randomUUID().toString();
    }

    public static boolean isValid(String key) {
        try {
            UUID.fromString(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ByteString toByteString(String string) {
        UUID uuid = UUID.fromString(string);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        byteBuffer.flip();
        return ByteString.copyFrom(byteBuffer);
    }

    public static String fromByteString(ByteString byteString) {
        Preconditions.checkArgument(byteString.size() == 16);
        ByteBuffer bb = byteString.asReadOnlyByteBuffer();
        return new UUID(bb.getLong(), bb.getLong()).toString();
    }
}

