/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.net.rpc3.RpcException;
import com.google.net.util.Status;
import com.google.net.util.error.Codes;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class FutureUtils {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/utils/FutureUtils");
    private static final ListenableFuture<Boolean> IMMEDIATE_FALSE_FUTURE = Futures.immediateFuture(false);

    private FutureUtils() {
    }

    public static ListenableFuture<Boolean> ternaryAnd(ImmutableList<ListenableFuture<Boolean>> futures) {
        return futures.size() < 2 ? FutureUtils.unaryFuture(futures) : new AndFuture(futures);
    }

    public static ListenableFuture<Boolean> ternaryOr(ImmutableList<ListenableFuture<Boolean>> futures) {
        return futures.size() < 2 ? FutureUtils.unaryFuture(futures) : new OrFuture(futures);
    }

    private static ListenableFuture<Boolean> unaryFuture(ImmutableList<ListenableFuture<Boolean>> futures) {
        Preconditions.checkArgument(futures.size() < 2);
        if (futures.isEmpty()) {
            return IMMEDIATE_FALSE_FUTURE;
        }
        return (ListenableFuture)futures.get(0);
    }

    public static <V> ListenableFuture<V> cloneFuture(ListenableFuture<V> future) {
        return Futures.whenAllComplete(future).call(() -> future.get(), MoreExecutors.directExecutor());
    }

    public static <V> void cancelPending(Iterable<? extends Future<? extends V>> futures) {
        for (Future<V> future : futures) {
            future.cancel(true);
        }
    }

    public static boolean isTrueOrCancelled(ListenableFuture<Boolean> futureValue) {
        if (!futureValue.isDone()) {
            return false;
        }
        try {
            return futureValue.isCancelled() || (Boolean)futureValue.get() != false;
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
    }

    public static boolean isFalseOrErrorOrCancelled(ListenableFuture<Boolean> futureValue) {
        if (!futureValue.isDone()) {
            return false;
        }
        try {
            return futureValue.isCancelled() || (Boolean)futureValue.get() == false;
        }
        catch (InterruptedException | ExecutionException e) {
            return true;
        }
    }

    public static RpcException handleFutureException(Exception ex) {
        if (ex instanceof ExecutionException) {
            Throwable cause = ex.getCause();
            if (cause instanceof RpcException) {
                return (RpcException)cause;
            }
            RpcException rpcException = new RpcException(Status.createCanonicalError((Codes.Code)Codes.Code.INTERNAL));
            rpcException.initCause(cause);
            return rpcException;
        }
        if (ex instanceof InterruptedException) {
            RpcException rpcException = new RpcException(Status.createCanonicalError((Codes.Code)Codes.Code.CANCELLED));
            rpcException.initCause(ex);
            Thread.currentThread().interrupt();
            return rpcException;
        }
        RpcException rpcException = new RpcException(Status.createCanonicalError((Codes.Code)Codes.Code.INTERNAL));
        rpcException.initCause(ex);
        return rpcException;
    }

    private static class AndFuture
    extends AggregatorFuture {
        public AndFuture(ImmutableList<ListenableFuture<Boolean>> futures) {
            super(futures);
        }

        @Override
        protected void onValueReady(boolean value) {
            if (!value) {
                this.set(false);
            }
        }

        @Override
        protected void allDoneNoResultYet(@Nullable Throwable throwable) {
            this.set(true);
        }

        @Override
        protected void onException(Throwable throwable) {
            this.setException(throwable);
        }
    }

    private static class OrFuture
    extends AggregatorFuture {
        public OrFuture(ImmutableList<ListenableFuture<Boolean>> futures) {
            super(futures);
        }

        @Override
        protected void onValueReady(boolean value) {
            if (value) {
                this.set(true);
            }
        }

        @Override
        protected void allDoneNoResultYet(@Nullable Throwable throwable) {
            if (throwable != null) {
                this.setException(throwable);
            } else {
                this.set(false);
            }
        }

        @Override
        protected void onException(Throwable throwable) {
        }
    }

    private static abstract class AggregatorFuture
    extends AbstractFuture<Boolean>
    implements FutureCallback<Boolean> {
        private ImmutableList<ListenableFuture<Boolean>> futures;
        private ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue();
        private final AtomicLong completedTasksCount = new AtomicLong(0L);

        public AggregatorFuture(ImmutableList<ListenableFuture<Boolean>> futures) {
            Preconditions.checkArgument(futures.size() > 1);
            this.futures = futures;
            for (ListenableFuture listenableFuture : futures) {
                Futures.addCallback(listenableFuture, this, MoreExecutors.directExecutor());
            }
        }

        @Override
        protected void afterDone() {
            this.releaseResources();
        }

        protected abstract void allDoneNoResultYet(@Nullable Throwable var1);

        protected abstract void onValueReady(boolean var1);

        protected abstract void onException(Throwable var1);

        @Override
        public void onSuccess(Boolean aBoolean) {
            this.onValueReady(aBoolean);
            if (!this.isDone() && this.completedTasksCount.incrementAndGet() == (long)this.futures.size()) {
                this.allDoneNoResultYet(this.exceptions.isEmpty() ? null : this.exceptions.peek());
            }
        }

        @Override
        public void onFailure(Throwable throwable) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(throwable)).withInjectedLogSite("com/google/firebase/rules/utils/FutureUtils$AggregatorFuture", "onFailure", 190, "FutureUtils.java")).log("Failed");
            if (throwable instanceof CancellationException) {
                this.cancel(true);
                return;
            }
            this.onException(throwable);
            if (!this.isDone()) {
                this.exceptions.add(throwable);
                if (this.completedTasksCount.incrementAndGet() == (long)this.futures.size()) {
                    this.allDoneNoResultYet(this.exceptions.isEmpty() ? null : this.exceptions.peek());
                }
            }
        }

        private void releaseResources() {
            FutureUtils.cancelPending(this.futures);
            this.futures = null;
            this.exceptions = null;
        }
    }
}

