/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.common.flogger.GoogleLogger;
import com.google.firebase.rules.exceptions.InvalidArgumentException;
import com.google.firebase.rules.exceptions.PermissionDeniedException;
import com.google.firebase.rules.exceptions.ResourceExhaustedException;
import com.google.firebase.rules.exceptions.ResourceNotFoundException;
import com.google.firebase.rules.utils.LoggingUtils;
import com.google.net.rpc3.RpcException;
import com.google.net.rpc3.impl.RpcStatusFactory;
import com.google.net.util.Status;
import com.google.net.util.error.Codes;
import javax.annotation.CheckReturnValue;

public class RpcExceptionUtils {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/utils/RpcExceptionUtils");

    private RpcExceptionUtils() {
    }

    @CheckReturnValue
    public static Codes.Code canonicalCodeFromError(Throwable t) {
        if (t instanceof InvalidArgumentException) {
            return Codes.Code.INVALID_ARGUMENT;
        }
        if (t instanceof ResourceNotFoundException) {
            return Codes.Code.NOT_FOUND;
        }
        if (t instanceof PermissionDeniedException) {
            return Codes.Code.PERMISSION_DENIED;
        }
        if (t instanceof ResourceExhaustedException) {
            return Codes.Code.RESOURCE_EXHAUSTED;
        }
        if (t instanceof RpcException) {
            return Codes.Code.UNAVAILABLE;
        }
        return Codes.Code.INTERNAL;
    }

    @CheckReturnValue
    public static RpcException handleError(Throwable t) {
        Codes.Code code = RpcExceptionUtils.canonicalCodeFromError(t);
        switch (code) {
            case INVALID_ARGUMENT: 
            case NOT_FOUND: 
            case PERMISSION_DENIED: 
            case RESOURCE_EXHAUSTED: {
                return RpcExceptionUtils.handleClientError(code, t);
            }
        }
        return RpcExceptionUtils.handleServerError(code, t);
    }

    private static RpcException handleClientError(Codes.Code code, Throwable t) {
        String message = t.getMessage();
        String string = String.valueOf(message);
        RpcException e = new RpcException(Status.createCanonicalError((Codes.Code)code, (String)(string.length() != 0 ? "Error details: ".concat(string) : new String("Error details: "))));
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withInjectedLogSite("com/google/firebase/rules/utils/RpcExceptionUtils", "handleClientError", 71, "RpcExceptionUtils.java")).log("[%d] Request failed. reason=%s", LoggingUtils.getTraceId(), (Object)e.getMessage());
        return e;
    }

    @CheckReturnValue
    public static RpcException handleServerError(Codes.Code code, Throwable t) {
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(t)).withInjectedLogSite("com/google/firebase/rules/utils/RpcExceptionUtils", "handleServerError", 79, "RpcExceptionUtils.java")).log("[%d] Unable to complete the operation.\nstatus=%s\nreason=%s\ncause=%s", LoggingUtils.getTraceId(), code, t.getMessage(), t.getCause() != null ? t.getCause().getMessage() : "n/a");
        RpcException rpcException = new RpcException(RpcStatusFactory.createServerError((String)"Unable to complete the operation.").withCanonicalCode(code));
        rpcException.initCause(t);
        return rpcException;
    }
}

