/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.utils;

import com.google.common.flogger.GoogleLogger;
import com.google.firebase.rules.runtime.utils.PathUtils;
import com.google.firebase.rules.utils.ByteStringKeyUtils;
import com.google.firebase.rules.utils.LoggingUtils;
import com.google.firebase.rules.utils.ResourceNameUtils;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.ListReleasesResponseOrBuilder;
import com.google.firebase.rules.v1.Ruleset;
import com.google.firebase.rules.v1.Source;
import com.google.firebase.rules.v1.TestCase;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.firebase.rules.validations.ValidationException;
import com.google.firebase.rules.validations.Validator;
import com.google.protobuf.Timestamp;
import com.google.protobuf.Value;
import com.google.protobuf.util.Timestamps;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RulesetValidator {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/utils/RulesetValidator");
    private static final String RULESET_NAME_FIELD = "RulesetName";
    private static final String SOURCE_FIELD_NAME = "source";
    private static final String RULESET_FIELD_NAME = "ruleset";
    private static final String FILE_NAME_FIELD = "Name";
    private static final String CONTENT_FIELD = "Content";
    private final Validator validator;

    public RulesetValidator(Validator validator) {
        this.validator = validator;
    }

    public void checkNotEmpty(Ruleset ruleset) throws ValidationException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkNotEmpty", 69, "RulesetValidator.java")).log("[%d] [checkNotEmpty] starting", LoggingUtils.getTraceId());
        this.validator.checkArgument(ruleset != null && !ruleset.equals(Ruleset.getDefaultInstance()), FirebaseRulesMessages.MUST_NOT_BE_BLANK, RULESET_FIELD_NAME);
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkNotEmpty", 74, "RulesetValidator.java")).log("[%d] [checkNotEmpty] complete", LoggingUtils.getTraceId());
    }

    public String checkRulesetName(String projectId, String rulesetName) throws ValidationException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkRulesetName", 78, "RulesetValidator.java")).log("[%d] [checkRulesetName] starting", LoggingUtils.getTraceId());
        ResourceNameUtils.RulesetReference rulesetReference = ResourceNameUtils.RulesetReference.parse(rulesetName, this.validator);
        this.validator.checkArgument(ByteStringKeyUtils.isValid(rulesetReference.rulesetId()), FirebaseRulesMessages.MUST_BE_VALID_KEY, RULESET_NAME_FIELD);
        this.validator.checkArgument(projectId.equals(rulesetReference.projectId()), FirebaseRulesMessages.INVALID_RULESET_NAME, rulesetName);
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkRulesetName", 86, "RulesetValidator.java")).log("[%d] [checkRulesetName] complete", LoggingUtils.getTraceId());
        return rulesetName;
    }

    public void checkSourceSize(Source source, int maxSourceFileSize) throws ValidationException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkSourceSize", 95, "RulesetValidator.java")).log("[%d] [checkSourceSize] starting", LoggingUtils.getTraceId());
        this.validator.checkNotNull(source, FirebaseRulesMessages.MUST_NOT_BE_BLANK, SOURCE_FIELD_NAME);
        this.validator.checkArgument(!source.equals(Source.getDefaultInstance()), FirebaseRulesMessages.MUST_NOT_BE_BLANK, SOURCE_FIELD_NAME);
        this.validator.checkArgument(source.getFilesCount() < 2, FirebaseRulesMessages.ONLY_ONE_SOURCE_FILE, new String[0]);
        int size = 0;
        for (File sourceFile : source.getFilesList()) {
            this.validator.checkArgument(!sourceFile.getName().isEmpty(), FirebaseRulesMessages.MUST_NOT_BE_BLANK, FILE_NAME_FIELD);
            this.validator.checkArgument(!sourceFile.getContent().isEmpty(), FirebaseRulesMessages.MUST_NOT_BE_BLANK, CONTENT_FIELD);
            if ((size += source.getSerializedSize()) <= maxSourceFileSize) continue;
            throw this.validator.fail(FirebaseRulesMessages.SOURCE_SIZE_EXCEED_LIMIT, Integer.toString(maxSourceFileSize));
        }
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkSourceSize", 110, "RulesetValidator.java")).log("[%d] [checkSourceSize] complete", LoggingUtils.getTraceId());
    }

    public void checkTestSourceIsEmpty(Source source) throws ValidationException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkTestSourceIsEmpty", 114, "RulesetValidator.java")).log("[%d] [checkTestSourceIsEmpty] starting", LoggingUtils.getTraceId());
        this.validator.checkArgument(source == null || source.equals(Source.getDefaultInstance()), FirebaseRulesMessages.INVALID_TEST_RULESET_REQUEST, new String[0]);
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkTestSourceIsEmpty", 117, "RulesetValidator.java")).log("[%d] [checkTestSourceIsEmpty] complete", LoggingUtils.getTraceId());
    }

    public void checkRulesetIsNotReferenced(ListReleasesResponseOrBuilder listRulesetReleases, String rulesetName) throws ValidationException {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkRulesetIsNotReferenced", 123, "RulesetValidator.java")).log("[%d] [checkRulesetIsNotReferenced] starting", LoggingUtils.getTraceId());
        this.validator.checkArgument(listRulesetReleases.getReleasesCount() == 0, FirebaseRulesMessages.RULESET_HAS_REFERENCE, rulesetName);
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/utils/RulesetValidator", "checkRulesetIsNotReferenced", 126, "RulesetValidator.java")).log("[%d] [checkRulesetIsNotReferenced] complete", LoggingUtils.getTraceId());
    }

    public void checkTestCasesAreValid(List<TestCase> testCaseList) throws ValidationException {
        for (TestCase testCase : testCaseList) {
            this.checkTestCaseIsValid(testCase);
        }
    }

    private void checkTestCaseIsValid(TestCase testCase) throws ValidationException {
        this.validator.checkArgument(testCase.getExpectation() != TestCase.Expectation.EXPECTATION_UNSPECIFIED, FirebaseRulesMessages.TEST_CASE_EXPECTATION_MUST_BE_SET, new String[0]);
        Value request = testCase.getRequest();
        this.validator.checkArgument(RulesetValidator.isValidJsonValue(request), FirebaseRulesMessages.TEST_CASE_REQUEST_INVALID, new String[0]);
        this.validator.checkArgument(request.getKindCase() == Value.KindCase.STRUCT_VALUE && request.getStructValue().getFieldsMap().containsKey("path") && request.getStructValue().getFieldsMap().containsKey("method"), FirebaseRulesMessages.TEST_CASE_REQUEST_PROPERTIES_MISSING, new String[0]);
        Map<String, Value> requestFields = request.getStructValue().getFieldsMap();
        Value requestPath = requestFields.get("path");
        this.validator.checkArgument(requestPath.getKindCase() == Value.KindCase.STRING_VALUE && requestPath.getStringValue().startsWith("/"), FirebaseRulesMessages.RESOURCE_PATH_SHOULD_START_WITH_SLASH, requestPath.toString());
        this.validator.checkArgument(requestPath.getKindCase() == Value.KindCase.STRING_VALUE && PathUtils.isValidEncodedPathString(requestPath.getStringValue()), FirebaseRulesMessages.RESOURCE_PATH_SHOULD_BE_URL_ENCODED, requestPath.toString());
        Value requestMethod = requestFields.get("method");
        this.validator.checkArgument(requestMethod.getKindCase() == Value.KindCase.STRING_VALUE, FirebaseRulesMessages.TEST_CASE_REQUEST_METHOD_PROPERTY_MUST_BE_STRING, new String[0]);
        if (requestFields.containsKey("auth")) {
            Value auth = requestFields.get("auth");
            this.validator.checkArgument(auth.getKindCase() == Value.KindCase.NULL_VALUE || auth.getKindCase() == Value.KindCase.STRUCT_VALUE, FirebaseRulesMessages.TEST_CASE_REQUEST_AUTH_PROPERTY_MUST_BE_NULL_OR_OBJECT, new String[0]);
        }
        if (requestFields.containsKey("time")) {
            Value time = requestFields.get("time");
            this.validator.checkArgument(time.getKindCase() == Value.KindCase.STRING_VALUE, FirebaseRulesMessages.TEST_CASE_REQUEST_TIME_PROPERTY_MUST_BE_A_TIMESTAMP, new String[0]);
            try {
                Timestamp timestamp = Timestamps.parse(time.getStringValue());
            }
            catch (ParseException e) {
                throw this.validator.fail(FirebaseRulesMessages.TEST_CASE_REQUEST_TIME_PROPERTY_MUST_BE_A_TIMESTAMP, new String[0]);
            }
        }
        if (!testCase.getResource().equals(Value.getDefaultInstance())) {
            this.validator.checkArgument(RulesetValidator.isValidJsonValue(testCase.getResource()), FirebaseRulesMessages.TEST_CASE_RESOURCE_INVALID, new String[0]);
        }
        for (TestCase.FunctionMock functionMock : testCase.getFunctionMocksList()) {
            this.validator.checkNotBlank(functionMock.getFunction(), FirebaseRulesMessages.TEST_CASE_FUNCTION_NAME_MUST_NOT_BE_BLANK, new String[0]);
            this.validator.checkArgument(!functionMock.getResult().equals(TestCase.FunctionMock.Result.getDefaultInstance()), FirebaseRulesMessages.TEST_CASE_FUNCTION_MOCK_MUST_HAVE_A_RESULT, new String[0]);
            if (functionMock.getResult().getTypeCase() == TestCase.FunctionMock.Result.TypeCase.VALUE) {
                this.validator.checkArgument(RulesetValidator.isValidJsonValue(functionMock.getResult().getValue()), FirebaseRulesMessages.TEST_CASE_FUNCTION_MOCK_RESULT_INVALID, new String[0]);
            }
            for (TestCase.FunctionMock.Arg arg : functionMock.getArgsList()) {
                this.validator.checkArgument(arg.getTypeCase() != TestCase.FunctionMock.Arg.TypeCase.TYPE_NOT_SET, FirebaseRulesMessages.TEST_CASE_FUNCTION_ARG_TYPE_MUST_BE_SET, new String[0]);
                if (arg.getTypeCase() != TestCase.FunctionMock.Arg.TypeCase.EXACT_VALUE) continue;
                this.validator.checkArgument(RulesetValidator.isValidJsonValue(arg.getExactValue()), FirebaseRulesMessages.TEST_CASE_FUNCTION_ARG_VALUE_MUST_NOT_BE_EMPTY, new String[0]);
            }
        }
        List<TestCase.FunctionMock> functionMocks = testCase.getFunctionMocksList();
        List anyOverloads = functionMocks.stream().filter(mock -> mock.getArgsList().stream().allMatch(arg -> arg.getTypeCase() == TestCase.FunctionMock.Arg.TypeCase.ANY_VALUE)).map(mock -> mock.getFunction()).collect(Collectors.toList());
        this.validator.checkArgument((long)anyOverloads.size() == anyOverloads.stream().distinct().count(), FirebaseRulesMessages.TEST_CASE_FUNCTION_MOCK_MUST_HAVE_ONLY_ONE_OVERLOAD_WITH_ALL_ANYS, new String[0]);
    }

    private static boolean isValidJsonValue(Value value) {
        switch (value.getKindCase()) {
            case BOOL_VALUE: 
            case NUMBER_VALUE: 
            case NULL_VALUE: 
            case STRING_VALUE: {
                return true;
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().allMatch(RulesetValidator::isValidJsonValue);
            }
            case STRUCT_VALUE: {
                return value.getStructValue().getFieldsMap().values().stream().allMatch(RulesetValidator::isValidJsonValue);
            }
            case KIND_NOT_SET: {
                return false;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }
}

