/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.v1beta1;

import com.google.firestore.v1beta1.ArrayValue;
import com.google.firestore.v1beta1.ArrayValueOrBuilder;
import com.google.firestore.v1beta1.DocumentProto;
import com.google.firestore.v1beta1.MapValue;
import com.google.firestore.v1beta1.MapValueOrBuilder;
import com.google.firestore.v1beta1.ValueOrBuilder;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MutableMessage;
import com.google.protobuf.NullValue;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.LatLng;
import com.google.type.LatLngOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Value
extends GeneratedMessage
implements ValueOrBuilder {
    private static final long serialVersionUID = 0L;
    private int valueTypeCase_ = 0;
    private Object valueType_;
    public static final int NULL_VALUE_FIELD_NUMBER = 11;
    public static final int BOOLEAN_VALUE_FIELD_NUMBER = 1;
    public static final int INTEGER_VALUE_FIELD_NUMBER = 2;
    public static final int DOUBLE_VALUE_FIELD_NUMBER = 3;
    public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 10;
    public static final int STRING_VALUE_FIELD_NUMBER = 17;
    public static final int BYTES_VALUE_FIELD_NUMBER = 18;
    public static final int REFERENCE_VALUE_FIELD_NUMBER = 5;
    public static final int GEO_POINT_VALUE_FIELD_NUMBER = 8;
    public static final int ARRAY_VALUE_FIELD_NUMBER = 9;
    public static final int MAP_VALUE_FIELD_NUMBER = 6;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Value DEFAULT_INSTANCE = new Value();
    private static final Parser<Value> PARSER = new AbstractParser<Value>(){

        @Override
        public Value parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new Value(input, extensionRegistry);
        }
    };

    private Value(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private Value() {
    }

    @Override
    protected Object newInstance(GeneratedMessage.UnusedPrivateParameter unused) {
        return new Value();
    }

    @Override
    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private Value(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block20: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block20;
                    }
                    case 8: {
                        this.valueTypeCase_ = 1;
                        this.valueType_ = input.readBool();
                        continue block20;
                    }
                    case 16: {
                        this.valueTypeCase_ = 2;
                        this.valueType_ = input.readInt64();
                        continue block20;
                    }
                    case 25: {
                        this.valueTypeCase_ = 3;
                        this.valueType_ = input.readDouble();
                        continue block20;
                    }
                    case 42: {
                        String s = input.readStringRequireUtf8();
                        this.valueTypeCase_ = 5;
                        this.valueType_ = s;
                        continue block20;
                    }
                    case 50: {
                        MapValue.Builder subBuilder = null;
                        if (this.valueTypeCase_ == 6) {
                            subBuilder = ((MapValue)this.valueType_).toBuilder();
                        }
                        this.valueType_ = input.readMessage(MapValue.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((MapValue)this.valueType_);
                            this.valueType_ = subBuilder.buildPartial();
                        }
                        this.valueTypeCase_ = 6;
                        continue block20;
                    }
                    case 66: {
                        LatLng.Builder subBuilder = null;
                        if (this.valueTypeCase_ == 8) {
                            subBuilder = ((LatLng)this.valueType_).toBuilder();
                        }
                        this.valueType_ = input.readMessage(LatLng.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((LatLng)this.valueType_);
                            this.valueType_ = subBuilder.buildPartial();
                        }
                        this.valueTypeCase_ = 8;
                        continue block20;
                    }
                    case 74: {
                        ArrayValue.Builder subBuilder = null;
                        if (this.valueTypeCase_ == 9) {
                            subBuilder = ((ArrayValue)this.valueType_).toBuilder();
                        }
                        this.valueType_ = input.readMessage(ArrayValue.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((ArrayValue)this.valueType_);
                            this.valueType_ = subBuilder.buildPartial();
                        }
                        this.valueTypeCase_ = 9;
                        continue block20;
                    }
                    case 82: {
                        Timestamp.Builder subBuilder = null;
                        if (this.valueTypeCase_ == 10) {
                            subBuilder = ((Timestamp)this.valueType_).toBuilder();
                        }
                        this.valueType_ = input.readMessage(Timestamp.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom((Timestamp)this.valueType_);
                            this.valueType_ = subBuilder.buildPartial();
                        }
                        this.valueTypeCase_ = 10;
                        continue block20;
                    }
                    case 88: {
                        int rawValue = input.readEnum();
                        this.valueTypeCase_ = 11;
                        this.valueType_ = rawValue;
                        continue block20;
                    }
                    case 138: {
                        String s = input.readStringRequireUtf8();
                        this.valueTypeCase_ = 17;
                        this.valueType_ = s;
                        continue block20;
                    }
                    case 146: {
                        this.valueTypeCase_ = 18;
                        this.valueType_ = input.readBytes();
                        continue block20;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage(this);
        }
        finally {
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return DocumentProto.internal_static_google_firestore_v1beta1_Value_descriptor;
    }

    @Override
    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return DocumentProto.internal_static_google_firestore_v1beta1_Value_fieldAccessorTable.ensureFieldAccessorsInitialized(Value.class, Builder.class);
    }

    @Override
    public ValueTypeCase getValueTypeCase() {
        return ValueTypeCase.forNumber(this.valueTypeCase_);
    }

    @Override
    public int getNullValueValue() {
        if (this.valueTypeCase_ == 11) {
            return (Integer)this.valueType_;
        }
        return 0;
    }

    @Override
    public NullValue getNullValue() {
        if (this.valueTypeCase_ == 11) {
            NullValue result = NullValue.forNumber((Integer)this.valueType_);
            return result == null ? NullValue.UNRECOGNIZED : result;
        }
        return NullValue.NULL_VALUE;
    }

    @Override
    public boolean getBooleanValue() {
        if (this.valueTypeCase_ == 1) {
            return (Boolean)this.valueType_;
        }
        return false;
    }

    @Override
    public long getIntegerValue() {
        if (this.valueTypeCase_ == 2) {
            return (Long)this.valueType_;
        }
        return 0L;
    }

    @Override
    public double getDoubleValue() {
        if (this.valueTypeCase_ == 3) {
            return (Double)this.valueType_;
        }
        return 0.0;
    }

    @Override
    public boolean hasTimestampValue() {
        return this.valueTypeCase_ == 10;
    }

    @Override
    public Timestamp getTimestampValue() {
        if (this.valueTypeCase_ == 10) {
            return (Timestamp)this.valueType_;
        }
        return Timestamp.getDefaultInstance();
    }

    @Override
    public TimestampOrBuilder getTimestampValueOrBuilder() {
        if (this.valueTypeCase_ == 10) {
            return (Timestamp)this.valueType_;
        }
        return Timestamp.getDefaultInstance();
    }

    @Override
    public String getStringValue() {
        Object ref = "";
        if (this.valueTypeCase_ == 17) {
            ref = this.valueType_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.valueTypeCase_ == 17) {
            this.valueType_ = s;
        }
        return s;
    }

    @Override
    public ByteString getStringValueBytes() {
        Object ref = "";
        if (this.valueTypeCase_ == 17) {
            ref = this.valueType_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            if (this.valueTypeCase_ == 17) {
                this.valueType_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public ByteString getBytesValue() {
        if (this.valueTypeCase_ == 18) {
            return (ByteString)this.valueType_;
        }
        return ByteString.EMPTY;
    }

    @Override
    public String getReferenceValue() {
        Object ref = "";
        if (this.valueTypeCase_ == 5) {
            ref = this.valueType_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.valueTypeCase_ == 5) {
            this.valueType_ = s;
        }
        return s;
    }

    @Override
    public ByteString getReferenceValueBytes() {
        Object ref = "";
        if (this.valueTypeCase_ == 5) {
            ref = this.valueType_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)ref);
            if (this.valueTypeCase_ == 5) {
                this.valueType_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasGeoPointValue() {
        return this.valueTypeCase_ == 8;
    }

    @Override
    public LatLng getGeoPointValue() {
        if (this.valueTypeCase_ == 8) {
            return (LatLng)this.valueType_;
        }
        return LatLng.getDefaultInstance();
    }

    @Override
    public LatLngOrBuilder getGeoPointValueOrBuilder() {
        if (this.valueTypeCase_ == 8) {
            return (LatLng)this.valueType_;
        }
        return LatLng.getDefaultInstance();
    }

    @Override
    public boolean hasArrayValue() {
        return this.valueTypeCase_ == 9;
    }

    @Override
    public ArrayValue getArrayValue() {
        if (this.valueTypeCase_ == 9) {
            return (ArrayValue)this.valueType_;
        }
        return ArrayValue.getDefaultInstance();
    }

    @Override
    public ArrayValueOrBuilder getArrayValueOrBuilder() {
        if (this.valueTypeCase_ == 9) {
            return (ArrayValue)this.valueType_;
        }
        return ArrayValue.getDefaultInstance();
    }

    @Override
    public boolean hasMapValue() {
        return this.valueTypeCase_ == 6;
    }

    @Override
    public MapValue getMapValue() {
        if (this.valueTypeCase_ == 6) {
            return (MapValue)this.valueType_;
        }
        return MapValue.getDefaultInstance();
    }

    @Override
    public MapValueOrBuilder getMapValueOrBuilder() {
        if (this.valueTypeCase_ == 6) {
            return (MapValue)this.valueType_;
        }
        return MapValue.getDefaultInstance();
    }

    @Override
    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.valueTypeCase_ == 1) {
            output.writeBool(1, (Boolean)this.valueType_);
        }
        if (this.valueTypeCase_ == 2) {
            output.writeInt64(2, (Long)this.valueType_);
        }
        if (this.valueTypeCase_ == 3) {
            output.writeDouble(3, (Double)this.valueType_);
        }
        if (this.valueTypeCase_ == 5) {
            GeneratedMessage.writeString(output, 5, this.valueType_);
        }
        if (this.valueTypeCase_ == 6) {
            output.writeMessage(6, (MapValue)this.valueType_);
        }
        if (this.valueTypeCase_ == 8) {
            output.writeMessage(8, (LatLng)this.valueType_);
        }
        if (this.valueTypeCase_ == 9) {
            output.writeMessage(9, (ArrayValue)this.valueType_);
        }
        if (this.valueTypeCase_ == 10) {
            output.writeMessage(10, (Timestamp)this.valueType_);
        }
        if (this.valueTypeCase_ == 11) {
            output.writeEnum(11, (Integer)this.valueType_);
        }
        if (this.valueTypeCase_ == 17) {
            GeneratedMessage.writeString(output, 17, this.valueType_);
        }
        if (this.valueTypeCase_ == 18) {
            output.writeBytes(18, (ByteString)this.valueType_);
        }
        this.unknownFields.writeTo(output);
    }

    @Override
    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.valueTypeCase_ == 1) {
            size += CodedOutputStream.computeBoolSize(1, (Boolean)this.valueType_);
        }
        if (this.valueTypeCase_ == 2) {
            size += CodedOutputStream.computeInt64Size(2, (Long)this.valueType_);
        }
        if (this.valueTypeCase_ == 3) {
            size += CodedOutputStream.computeDoubleSize(3, (Double)this.valueType_);
        }
        if (this.valueTypeCase_ == 5) {
            size += GeneratedMessage.computeStringSize(5, this.valueType_);
        }
        if (this.valueTypeCase_ == 6) {
            size += CodedOutputStream.computeMessageSize(6, (MapValue)this.valueType_);
        }
        if (this.valueTypeCase_ == 8) {
            size += CodedOutputStream.computeMessageSize(8, (LatLng)this.valueType_);
        }
        if (this.valueTypeCase_ == 9) {
            size += CodedOutputStream.computeMessageSize(9, (ArrayValue)this.valueType_);
        }
        if (this.valueTypeCase_ == 10) {
            size += CodedOutputStream.computeMessageSize(10, (Timestamp)this.valueType_);
        }
        if (this.valueTypeCase_ == 11) {
            size += CodedOutputStream.computeEnumSize(11, (Integer)this.valueType_);
        }
        if (this.valueTypeCase_ == 17) {
            size += GeneratedMessage.computeStringSize(17, this.valueType_);
        }
        if (this.valueTypeCase_ == 18) {
            size += CodedOutputStream.computeBytesSize(18, (ByteString)this.valueType_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Value)) {
            return super.equals(obj);
        }
        Value other = (Value)obj;
        if (!this.getValueTypeCase().equals(other.getValueTypeCase())) {
            return false;
        }
        switch (this.valueTypeCase_) {
            case 11: {
                if (this.getNullValueValue() == other.getNullValueValue()) break;
                return false;
            }
            case 1: {
                if (this.getBooleanValue() == other.getBooleanValue()) break;
                return false;
            }
            case 2: {
                if (this.getIntegerValue() == other.getIntegerValue()) break;
                return false;
            }
            case 3: {
                if (Double.doubleToLongBits(this.getDoubleValue()) == Double.doubleToLongBits(other.getDoubleValue())) break;
                return false;
            }
            case 10: {
                if (this.getTimestampValue().equals(other.getTimestampValue())) break;
                return false;
            }
            case 17: {
                if (this.getStringValue().equals(other.getStringValue())) break;
                return false;
            }
            case 18: {
                if (this.getBytesValue().equals(other.getBytesValue())) break;
                return false;
            }
            case 5: {
                if (this.getReferenceValue().equals(other.getReferenceValue())) break;
                return false;
            }
            case 8: {
                if (this.getGeoPointValue().equals(other.getGeoPointValue())) break;
                return false;
            }
            case 9: {
                if (this.getArrayValue().equals(other.getArrayValue())) break;
                return false;
            }
            case 6: {
                if (this.getMapValue().equals(other.getMapValue())) break;
                return false;
            }
        }
        return this.unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Value.getDescriptor().hashCode();
        switch (this.valueTypeCase_) {
            case 11: {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getNullValueValue();
                break;
            }
            case 1: {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashBoolean(this.getBooleanValue());
                break;
            }
            case 2: {
                hash = 37 * hash + 2;
                hash = 53 * hash + Internal.hashLong(this.getIntegerValue());
                break;
            }
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong(Double.doubleToLongBits(this.getDoubleValue()));
                break;
            }
            case 10: {
                hash = 37 * hash + 10;
                hash = 53 * hash + this.getTimestampValue().hashCode();
                break;
            }
            case 17: {
                hash = 37 * hash + 17;
                hash = 53 * hash + this.getStringValue().hashCode();
                break;
            }
            case 18: {
                hash = 37 * hash + 18;
                hash = 53 * hash + this.getBytesValue().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getReferenceValue().hashCode();
                break;
            }
            case 8: {
                hash = 37 * hash + 8;
                hash = 53 * hash + this.getGeoPointValue().hashCode();
                break;
            }
            case 9: {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getArrayValue().hashCode();
                break;
            }
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getMapValue().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    @Override
    protected MutableMessage internalMutableDefault() {
        return MutableDefaultLoader.get();
    }

    public static Value parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Value parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Value parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Value parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Value parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Value parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Value parseFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Value parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static Value parseDelimitedFrom(InputStream input) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input);
    }

    public static Value parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static Value parseFrom(CodedInputStream input) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input);
    }

    public static Value parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return GeneratedMessage.parseWithIOException(PARSER, input, extensionRegistry);
    }

    @Override
    public Builder newBuilderForType() {
        return Value.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Value prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @Override
    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Value getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Value> parser() {
        return PARSER;
    }

    public Parser<Value> getParserForType() {
        return PARSER;
    }

    @Override
    public Value getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements ValueOrBuilder {
        private int valueTypeCase_ = 0;
        private Object valueType_;
        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> timestampValueBuilder_;
        private SingleFieldBuilder<LatLng, LatLng.Builder, LatLngOrBuilder> geoPointValueBuilder_;
        private SingleFieldBuilder<ArrayValue, ArrayValue.Builder, ArrayValueOrBuilder> arrayValueBuilder_;
        private SingleFieldBuilder<MapValue, MapValue.Builder, MapValueOrBuilder> mapValueBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return DocumentProto.internal_static_google_firestore_v1beta1_Value_descriptor;
        }

        @Override
        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return DocumentProto.internal_static_google_firestore_v1beta1_Value_fieldAccessorTable.ensureFieldAccessorsInitialized(Value.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        @Override
        public Builder clear() {
            super.clear();
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
            return this;
        }

        @Override
        public Descriptors.Descriptor getDescriptorForType() {
            return DocumentProto.internal_static_google_firestore_v1beta1_Value_descriptor;
        }

        @Override
        public Value getDefaultInstanceForType() {
            return Value.getDefaultInstance();
        }

        @Override
        public Value build() {
            Value result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException(result);
            }
            return result;
        }

        @Override
        public Value buildPartial() {
            Value result = new Value(this);
            if (this.valueTypeCase_ == 11) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 1) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 2) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 3) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 10) {
                if (this.timestampValueBuilder_ == null) {
                    result.valueType_ = this.valueType_;
                } else {
                    result.valueType_ = this.timestampValueBuilder_.build();
                }
            }
            if (this.valueTypeCase_ == 17) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 18) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 5) {
                result.valueType_ = this.valueType_;
            }
            if (this.valueTypeCase_ == 8) {
                if (this.geoPointValueBuilder_ == null) {
                    result.valueType_ = this.valueType_;
                } else {
                    result.valueType_ = this.geoPointValueBuilder_.build();
                }
            }
            if (this.valueTypeCase_ == 9) {
                if (this.arrayValueBuilder_ == null) {
                    result.valueType_ = this.valueType_;
                } else {
                    result.valueType_ = this.arrayValueBuilder_.build();
                }
            }
            if (this.valueTypeCase_ == 6) {
                if (this.mapValueBuilder_ == null) {
                    result.valueType_ = this.valueType_;
                } else {
                    result.valueType_ = this.mapValueBuilder_.build();
                }
            }
            result.valueTypeCase_ = this.valueTypeCase_;
            this.onBuilt();
            return result;
        }

        @Override
        public Builder mergeFrom(Message other) {
            if (other instanceof Value) {
                return this.mergeFrom((Value)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Value other) {
            if (other == Value.getDefaultInstance()) {
                return this;
            }
            switch (other.getValueTypeCase()) {
                case NULL_VALUE: {
                    this.setNullValueValue(other.getNullValueValue());
                    break;
                }
                case BOOLEAN_VALUE: {
                    this.setBooleanValue(other.getBooleanValue());
                    break;
                }
                case INTEGER_VALUE: {
                    this.setIntegerValue(other.getIntegerValue());
                    break;
                }
                case DOUBLE_VALUE: {
                    this.setDoubleValue(other.getDoubleValue());
                    break;
                }
                case TIMESTAMP_VALUE: {
                    this.mergeTimestampValue(other.getTimestampValue());
                    break;
                }
                case STRING_VALUE: {
                    this.valueTypeCase_ = 17;
                    this.valueType_ = other.valueType_;
                    this.onChanged();
                    break;
                }
                case BYTES_VALUE: {
                    this.setBytesValue(other.getBytesValue());
                    break;
                }
                case REFERENCE_VALUE: {
                    this.valueTypeCase_ = 5;
                    this.valueType_ = other.valueType_;
                    this.onChanged();
                    break;
                }
                case GEO_POINT_VALUE: {
                    this.mergeGeoPointValue(other.getGeoPointValue());
                    break;
                }
                case ARRAY_VALUE: {
                    this.mergeArrayValue(other.getArrayValue());
                    break;
                }
                case MAP_VALUE: {
                    this.mergeMapValue(other.getMapValue());
                    break;
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        @Override
        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            Value parsedMessage = null;
            try {
                parsedMessage = (Value)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (Value)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public ValueTypeCase getValueTypeCase() {
            return ValueTypeCase.forNumber(this.valueTypeCase_);
        }

        public Builder clearValueType() {
            this.valueTypeCase_ = 0;
            this.valueType_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public int getNullValueValue() {
            if (this.valueTypeCase_ == 11) {
                return (Integer)this.valueType_;
            }
            return 0;
        }

        public Builder setNullValueValue(int value) {
            this.valueTypeCase_ = 11;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public NullValue getNullValue() {
            if (this.valueTypeCase_ == 11) {
                NullValue result = NullValue.forNumber((Integer)this.valueType_);
                return result == null ? NullValue.UNRECOGNIZED : result;
            }
            return NullValue.NULL_VALUE;
        }

        public Builder setNullValue(NullValue value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.valueTypeCase_ = 11;
            this.valueType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearNullValue() {
            if (this.valueTypeCase_ == 11) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean getBooleanValue() {
            if (this.valueTypeCase_ == 1) {
                return (Boolean)this.valueType_;
            }
            return false;
        }

        public Builder setBooleanValue(boolean value) {
            this.valueTypeCase_ = 1;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBooleanValue() {
            if (this.valueTypeCase_ == 1) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public long getIntegerValue() {
            if (this.valueTypeCase_ == 2) {
                return (Long)this.valueType_;
            }
            return 0L;
        }

        public Builder setIntegerValue(long value) {
            this.valueTypeCase_ = 2;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearIntegerValue() {
            if (this.valueTypeCase_ == 2) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public double getDoubleValue() {
            if (this.valueTypeCase_ == 3) {
                return (Double)this.valueType_;
            }
            return 0.0;
        }

        public Builder setDoubleValue(double value) {
            this.valueTypeCase_ = 3;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDoubleValue() {
            if (this.valueTypeCase_ == 3) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasTimestampValue() {
            return this.valueTypeCase_ == 10;
        }

        @Override
        public Timestamp getTimestampValue() {
            if (this.timestampValueBuilder_ == null) {
                if (this.valueTypeCase_ == 10) {
                    return (Timestamp)this.valueType_;
                }
                return Timestamp.getDefaultInstance();
            }
            if (this.valueTypeCase_ == 10) {
                return this.timestampValueBuilder_.getMessage();
            }
            return Timestamp.getDefaultInstance();
        }

        public Builder setTimestampValue(Timestamp value) {
            if (this.timestampValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.valueType_ = value;
                this.onChanged();
            } else {
                this.timestampValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 10;
            return this;
        }

        public Builder setTimestampValue(Timestamp.Builder builderForValue) {
            if (this.timestampValueBuilder_ == null) {
                this.valueType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.timestampValueBuilder_.setMessage(builderForValue.build());
            }
            this.valueTypeCase_ = 10;
            return this;
        }

        public Builder mergeTimestampValue(Timestamp value) {
            if (this.timestampValueBuilder_ == null) {
                this.valueType_ = this.valueTypeCase_ == 10 && this.valueType_ != Timestamp.getDefaultInstance() ? Timestamp.newBuilder((Timestamp)this.valueType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.valueTypeCase_ == 10) {
                    this.timestampValueBuilder_.mergeFrom(value);
                }
                this.timestampValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 10;
            return this;
        }

        public Builder clearTimestampValue() {
            if (this.timestampValueBuilder_ == null) {
                if (this.valueTypeCase_ == 10) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.valueTypeCase_ == 10) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                }
                this.timestampValueBuilder_.clear();
            }
            return this;
        }

        public Timestamp.Builder getTimestampValueBuilder() {
            return this.getTimestampValueFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getTimestampValueOrBuilder() {
            if (this.valueTypeCase_ == 10 && this.timestampValueBuilder_ != null) {
                return this.timestampValueBuilder_.getMessageOrBuilder();
            }
            if (this.valueTypeCase_ == 10) {
                return (Timestamp)this.valueType_;
            }
            return Timestamp.getDefaultInstance();
        }

        private SingleFieldBuilder<Timestamp, Timestamp.Builder, TimestampOrBuilder> getTimestampValueFieldBuilder() {
            if (this.timestampValueBuilder_ == null) {
                if (this.valueTypeCase_ != 10) {
                    this.valueType_ = Timestamp.getDefaultInstance();
                }
                this.timestampValueBuilder_ = new SingleFieldBuilder((Timestamp)this.valueType_, this.getParentForChildren(), this.isClean());
                this.valueType_ = null;
            }
            this.valueTypeCase_ = 10;
            this.onChanged();
            return this.timestampValueBuilder_;
        }

        @Override
        public String getStringValue() {
            Object ref = "";
            if (this.valueTypeCase_ == 17) {
                ref = this.valueType_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.valueTypeCase_ == 17) {
                    this.valueType_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStringValueBytes() {
            Object ref = "";
            if (this.valueTypeCase_ == 17) {
                ref = this.valueType_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                if (this.valueTypeCase_ == 17) {
                    this.valueType_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStringValue(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.valueTypeCase_ = 17;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearStringValue() {
            if (this.valueTypeCase_ == 17) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setStringValueBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Value.checkByteStringIsUtf8(value);
            this.valueTypeCase_ = 17;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getBytesValue() {
            if (this.valueTypeCase_ == 18) {
                return (ByteString)this.valueType_;
            }
            return ByteString.EMPTY;
        }

        public Builder setBytesValue(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.valueTypeCase_ = 18;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBytesValue() {
            if (this.valueTypeCase_ == 18) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getReferenceValue() {
            Object ref = "";
            if (this.valueTypeCase_ == 5) {
                ref = this.valueType_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.valueTypeCase_ == 5) {
                    this.valueType_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getReferenceValueBytes() {
            Object ref = "";
            if (this.valueTypeCase_ == 5) {
                ref = this.valueType_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)ref);
                if (this.valueTypeCase_ == 5) {
                    this.valueType_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setReferenceValue(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.valueTypeCase_ = 5;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearReferenceValue() {
            if (this.valueTypeCase_ == 5) {
                this.valueTypeCase_ = 0;
                this.valueType_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setReferenceValueBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Value.checkByteStringIsUtf8(value);
            this.valueTypeCase_ = 5;
            this.valueType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasGeoPointValue() {
            return this.valueTypeCase_ == 8;
        }

        @Override
        public LatLng getGeoPointValue() {
            if (this.geoPointValueBuilder_ == null) {
                if (this.valueTypeCase_ == 8) {
                    return (LatLng)this.valueType_;
                }
                return LatLng.getDefaultInstance();
            }
            if (this.valueTypeCase_ == 8) {
                return this.geoPointValueBuilder_.getMessage();
            }
            return LatLng.getDefaultInstance();
        }

        public Builder setGeoPointValue(LatLng value) {
            if (this.geoPointValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.valueType_ = value;
                this.onChanged();
            } else {
                this.geoPointValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 8;
            return this;
        }

        public Builder setGeoPointValue(LatLng.Builder builderForValue) {
            if (this.geoPointValueBuilder_ == null) {
                this.valueType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.geoPointValueBuilder_.setMessage(builderForValue.build());
            }
            this.valueTypeCase_ = 8;
            return this;
        }

        public Builder mergeGeoPointValue(LatLng value) {
            if (this.geoPointValueBuilder_ == null) {
                this.valueType_ = this.valueTypeCase_ == 8 && this.valueType_ != LatLng.getDefaultInstance() ? LatLng.newBuilder((LatLng)this.valueType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.valueTypeCase_ == 8) {
                    this.geoPointValueBuilder_.mergeFrom(value);
                }
                this.geoPointValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 8;
            return this;
        }

        public Builder clearGeoPointValue() {
            if (this.geoPointValueBuilder_ == null) {
                if (this.valueTypeCase_ == 8) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.valueTypeCase_ == 8) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                }
                this.geoPointValueBuilder_.clear();
            }
            return this;
        }

        public LatLng.Builder getGeoPointValueBuilder() {
            return this.getGeoPointValueFieldBuilder().getBuilder();
        }

        @Override
        public LatLngOrBuilder getGeoPointValueOrBuilder() {
            if (this.valueTypeCase_ == 8 && this.geoPointValueBuilder_ != null) {
                return this.geoPointValueBuilder_.getMessageOrBuilder();
            }
            if (this.valueTypeCase_ == 8) {
                return (LatLng)this.valueType_;
            }
            return LatLng.getDefaultInstance();
        }

        private SingleFieldBuilder<LatLng, LatLng.Builder, LatLngOrBuilder> getGeoPointValueFieldBuilder() {
            if (this.geoPointValueBuilder_ == null) {
                if (this.valueTypeCase_ != 8) {
                    this.valueType_ = LatLng.getDefaultInstance();
                }
                this.geoPointValueBuilder_ = new SingleFieldBuilder((LatLng)this.valueType_, this.getParentForChildren(), this.isClean());
                this.valueType_ = null;
            }
            this.valueTypeCase_ = 8;
            this.onChanged();
            return this.geoPointValueBuilder_;
        }

        @Override
        public boolean hasArrayValue() {
            return this.valueTypeCase_ == 9;
        }

        @Override
        public ArrayValue getArrayValue() {
            if (this.arrayValueBuilder_ == null) {
                if (this.valueTypeCase_ == 9) {
                    return (ArrayValue)this.valueType_;
                }
                return ArrayValue.getDefaultInstance();
            }
            if (this.valueTypeCase_ == 9) {
                return this.arrayValueBuilder_.getMessage();
            }
            return ArrayValue.getDefaultInstance();
        }

        public Builder setArrayValue(ArrayValue value) {
            if (this.arrayValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.valueType_ = value;
                this.onChanged();
            } else {
                this.arrayValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 9;
            return this;
        }

        public Builder setArrayValue(ArrayValue.Builder builderForValue) {
            if (this.arrayValueBuilder_ == null) {
                this.valueType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.arrayValueBuilder_.setMessage(builderForValue.build());
            }
            this.valueTypeCase_ = 9;
            return this;
        }

        public Builder mergeArrayValue(ArrayValue value) {
            if (this.arrayValueBuilder_ == null) {
                this.valueType_ = this.valueTypeCase_ == 9 && this.valueType_ != ArrayValue.getDefaultInstance() ? ArrayValue.newBuilder((ArrayValue)this.valueType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.valueTypeCase_ == 9) {
                    this.arrayValueBuilder_.mergeFrom(value);
                }
                this.arrayValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 9;
            return this;
        }

        public Builder clearArrayValue() {
            if (this.arrayValueBuilder_ == null) {
                if (this.valueTypeCase_ == 9) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.valueTypeCase_ == 9) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                }
                this.arrayValueBuilder_.clear();
            }
            return this;
        }

        public ArrayValue.Builder getArrayValueBuilder() {
            return this.getArrayValueFieldBuilder().getBuilder();
        }

        @Override
        public ArrayValueOrBuilder getArrayValueOrBuilder() {
            if (this.valueTypeCase_ == 9 && this.arrayValueBuilder_ != null) {
                return this.arrayValueBuilder_.getMessageOrBuilder();
            }
            if (this.valueTypeCase_ == 9) {
                return (ArrayValue)this.valueType_;
            }
            return ArrayValue.getDefaultInstance();
        }

        private SingleFieldBuilder<ArrayValue, ArrayValue.Builder, ArrayValueOrBuilder> getArrayValueFieldBuilder() {
            if (this.arrayValueBuilder_ == null) {
                if (this.valueTypeCase_ != 9) {
                    this.valueType_ = ArrayValue.getDefaultInstance();
                }
                this.arrayValueBuilder_ = new SingleFieldBuilder((ArrayValue)this.valueType_, this.getParentForChildren(), this.isClean());
                this.valueType_ = null;
            }
            this.valueTypeCase_ = 9;
            this.onChanged();
            return this.arrayValueBuilder_;
        }

        @Override
        public boolean hasMapValue() {
            return this.valueTypeCase_ == 6;
        }

        @Override
        public MapValue getMapValue() {
            if (this.mapValueBuilder_ == null) {
                if (this.valueTypeCase_ == 6) {
                    return (MapValue)this.valueType_;
                }
                return MapValue.getDefaultInstance();
            }
            if (this.valueTypeCase_ == 6) {
                return this.mapValueBuilder_.getMessage();
            }
            return MapValue.getDefaultInstance();
        }

        public Builder setMapValue(MapValue value) {
            if (this.mapValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.valueType_ = value;
                this.onChanged();
            } else {
                this.mapValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 6;
            return this;
        }

        public Builder setMapValue(MapValue.Builder builderForValue) {
            if (this.mapValueBuilder_ == null) {
                this.valueType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.mapValueBuilder_.setMessage(builderForValue.build());
            }
            this.valueTypeCase_ = 6;
            return this;
        }

        public Builder mergeMapValue(MapValue value) {
            if (this.mapValueBuilder_ == null) {
                this.valueType_ = this.valueTypeCase_ == 6 && this.valueType_ != MapValue.getDefaultInstance() ? MapValue.newBuilder((MapValue)this.valueType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                if (this.valueTypeCase_ == 6) {
                    this.mapValueBuilder_.mergeFrom(value);
                }
                this.mapValueBuilder_.setMessage(value);
            }
            this.valueTypeCase_ = 6;
            return this;
        }

        public Builder clearMapValue() {
            if (this.mapValueBuilder_ == null) {
                if (this.valueTypeCase_ == 6) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.valueTypeCase_ == 6) {
                    this.valueTypeCase_ = 0;
                    this.valueType_ = null;
                }
                this.mapValueBuilder_.clear();
            }
            return this;
        }

        public MapValue.Builder getMapValueBuilder() {
            return this.getMapValueFieldBuilder().getBuilder();
        }

        @Override
        public MapValueOrBuilder getMapValueOrBuilder() {
            if (this.valueTypeCase_ == 6 && this.mapValueBuilder_ != null) {
                return this.mapValueBuilder_.getMessageOrBuilder();
            }
            if (this.valueTypeCase_ == 6) {
                return (MapValue)this.valueType_;
            }
            return MapValue.getDefaultInstance();
        }

        private SingleFieldBuilder<MapValue, MapValue.Builder, MapValueOrBuilder> getMapValueFieldBuilder() {
            if (this.mapValueBuilder_ == null) {
                if (this.valueTypeCase_ != 6) {
                    this.valueType_ = MapValue.getDefaultInstance();
                }
                this.mapValueBuilder_ = new SingleFieldBuilder((MapValue)this.valueType_, this.getParentForChildren(), this.isClean());
                this.valueType_ = null;
            }
            this.valueTypeCase_ = 6;
            this.onChanged();
            return this.mapValueBuilder_;
        }

        @Override
        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }
    }

    private static final class MutableDefaultLoader {
        private static final Object defaultOrRuntimeException;

        private MutableDefaultLoader() {
        }

        public static MutableMessage get() {
            if (defaultOrRuntimeException instanceof RuntimeException) {
                throw (RuntimeException)defaultOrRuntimeException;
            }
            return (MutableMessage)defaultOrRuntimeException;
        }

        static {
            Object local;
            try {
                local = Value.internalMutableDefault("com.google.firestore.v1beta1.proto1api.Value");
            }
            catch (RuntimeException e) {
                local = e;
            }
            defaultOrRuntimeException = local;
        }
    }

    public static enum ValueTypeCase implements Internal.EnumLite
    {
        NULL_VALUE(11),
        BOOLEAN_VALUE(1),
        INTEGER_VALUE(2),
        DOUBLE_VALUE(3),
        TIMESTAMP_VALUE(10),
        STRING_VALUE(17),
        BYTES_VALUE(18),
        REFERENCE_VALUE(5),
        GEO_POINT_VALUE(8),
        ARRAY_VALUE(9),
        MAP_VALUE(6),
        VALUETYPE_NOT_SET(0);

        private final int value;

        private ValueTypeCase(int value) {
            this.value = value;
        }

        public static ValueTypeCase forNumber(int value) {
            switch (value) {
                case 11: {
                    return NULL_VALUE;
                }
                case 1: {
                    return BOOLEAN_VALUE;
                }
                case 2: {
                    return INTEGER_VALUE;
                }
                case 3: {
                    return DOUBLE_VALUE;
                }
                case 10: {
                    return TIMESTAMP_VALUE;
                }
                case 17: {
                    return STRING_VALUE;
                }
                case 18: {
                    return BYTES_VALUE;
                }
                case 5: {
                    return REFERENCE_VALUE;
                }
                case 8: {
                    return GEO_POINT_VALUE;
                }
                case 9: {
                    return ARRAY_VALUE;
                }
                case 6: {
                    return MAP_VALUE;
                }
                case 0: {
                    return VALUETYPE_NOT_SET;
                }
            }
            return null;
        }

        @Override
        public int getNumber() {
            return this.value;
        }
    }
}

