/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import java.util.HashSet;
import java.util.Set;

public class AsciiLimiter {
    private static final String[] highBit1Map_ = new String[]{"e", " ", "'", "f", "\"", ".", "!", "!", "^", "%", "S", "<", "O", " ", "Z", " ", " ", "'", "'", "\"", "\"", "*", "-", "-", "~", "t", "s", ">", "o", " ", "z", "Y", " ", "!", "c", "L", "$", "Y", "|", "S", ":", "C", "a", "<", "~", "-", "R", "-", "o", "+", "2", "3", "'", "u", "P", ".", ",", "1", "o", ">", "-", "-", "-", "?", "A", "A", "A", "A", "A", "A", "AE", "C", "E", "E", "E", "E", "I", "I", "I", "I", "D", "N", "O", "O", "O", "O", "O", "x", "O", "U", "U", "U", "U", "Y", "TH", "ss", "a", "a", "a", "a", "a", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i", "d", "n", "o", "o", "o", "o", "o", "/", "o", "u", "u", "u", "u", "y", "th", "y"};
    private static final String[] highBit2Map_ = new String[]{"A", "a", "A", "a", "A", "a", "C", "c", "C", "c", "C", "c", "C", "c", "D", "d", "D", "d", "E", "e", "E", "e", "E", "e", "E", "e", "E", "e", "G", "g", "G", "g", "G", "g", "G", "g", "H", "h", "H", "h", "I", "i", "I", "i", "I", "i", "I", "i", "I", "i", "IJ", "ij", "J", "j", "K", "k", "k", "L", "l", "L", "l", "L", "l", "L", "l", "L", "l", "N", "n", "N", "n", "N", "n", "'n", "N", "n", "O", "o", "O", "o", "O", "o", "OE", "oe", "R", "r", "R", "r", "R", "r", "S", "s", "S", "s", "S", "s", "S", "s", "T", "t", "T", "t", "T", "t", "U", "u", "U", "u", "U", "u", "U", "u", "U", "u", "U", "u", "W", "w", "Y", "y", "Y", "Z", "z", "Z", "z", "Z", "z", "s"};
    private final char sub_;
    private final char[] highBit0Map_ = new char[128];

    public AsciiLimiter(char sub) {
        this.sub_ = sub;
        for (int c = 0; c < 128; c = (int)((char)(c + 1))) {
            this.highBit0Map_[c] = c;
        }
    }

    public AsciiLimiter(char sub, boolean upperCaseOk, boolean lowerCaseOk, boolean digitsOk, String otherOkChars) {
        int c;
        char c2;
        this.sub_ = sub;
        for (c2 = '\u0000'; c2 < '\u0080'; c2 = (char)((char)(c2 + 1))) {
            this.highBit0Map_[c2] = sub;
        }
        for (int i = 0; i < otherOkChars.length(); ++i) {
            this.highBit0Map_[c] = c = otherOkChars.charAt(i);
        }
        if (upperCaseOk) {
            for (c2 = 'A'; c2 <= 'Z'; c2 = (char)((char)(c2 + 1))) {
                this.highBit0Map_[c2] = c2;
            }
        }
        if (lowerCaseOk) {
            for (c2 = 'a'; c2 <= 'z'; c2 = (char)((char)(c2 + 1))) {
                this.highBit0Map_[c2] = c2;
            }
        } else if (upperCaseOk) {
            int SHIFT = 32;
            for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
                this.highBit0Map_[c] = (char)(c - 32);
            }
        }
        if (digitsOk) {
            for (c2 = '0'; c2 <= '9'; c2 = (char)((char)(c2 + 1))) {
                this.highBit0Map_[c2] = c2;
            }
        }
        if (this.highBit0Map_[32] == ' ') {
            for (c2 = '\u0000'; c2 < ' '; c2 = (char)(c2 + '\u0001')) {
                if (this.highBit0Map_[c2] == c2) continue;
                this.highBit0Map_[c2] = 32;
            }
        }
    }

    public AsciiLimiter(char sub, String sets, String otherOkChars) {
        this(sub, sets.indexOf(65) >= 0, sets.indexOf(97) >= 0, sets.indexOf(57) >= 0, otherOkChars);
    }

    private static String toAscii(char c, char sub) {
        if (c < '\u0080') {
            return String.valueOf(c);
        }
        if (c < '\u0100') {
            return highBit1Map_[c - 128];
        }
        if (c < '\u0180') {
            return highBit2Map_[c - 256];
        }
        return String.valueOf(sub);
    }

    public static String toAscii(String s, char sub) {
        int len = s.length();
        StringBuilder bfr = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            bfr.append(AsciiLimiter.toAscii(s.charAt(i), sub));
        }
        return bfr.toString();
    }

    public String toAscii(String s) {
        return AsciiLimiter.toAscii(s, this.sub_);
    }

    public String limit(String s) {
        String asciiStr = this.toAscii(s);
        int len = asciiStr.length();
        StringBuilder bfr = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = asciiStr.charAt(i);
            if (c >= '\u0080') {
                char c2 = c;
                throw new IllegalArgumentException(new StringBuilder(48).append("char is not a 7 bit ascii character: ").append((int)c2).toString());
            }
            bfr.append(this.highBit0Map_[c]);
        }
        return bfr.toString();
    }

    public static Set<Character> getUnmatchedCharacters(String s) {
        HashSet<Character> unmatchedChars = new HashSet<Character>();
        for (char c : s.toCharArray()) {
            if (c <= '\u017f') continue;
            unmatchedChars.add(Character.valueOf(c));
        }
        return unmatchedChars;
    }
}

