/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.ibm.icu.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;

public abstract class Breaker {
    private static final Breaker CHARACTER = new StandardBreaker("Breaker.character()"){

        @Override
        BreakIterator newBreakIterator(Locale locale) {
            return BreakIterator.getCharacterInstance(locale);
        }
    };
    private static final Breaker LINE = new StandardBreaker("Breaker.line()"){

        @Override
        BreakIterator newBreakIterator(Locale locale) {
            return BreakIterator.getLineInstance(locale);
        }
    };
    private static final Breaker SENTENCE = new StandardBreaker("Breaker.sentence()"){

        @Override
        BreakIterator newBreakIterator(Locale locale) {
            return BreakIterator.getSentenceInstance(locale);
        }
    };
    private static final Breaker WORD = new StandardBreaker("Breaker.word()"){

        @Override
        BreakIterator newBreakIterator(Locale locale) {
            return BreakIterator.getWordInstance(locale);
        }
    };

    public static Breaker character() {
        return CHARACTER;
    }

    public static Breaker line() {
        return LINE;
    }

    public static Breaker sentence() {
        return SENTENCE;
    }

    public static Breaker word() {
        return WORD;
    }

    public abstract FluentIterable<String> breakText(String var1, Locale var2);

    private static abstract class StandardBreaker
    extends Breaker {
        final String description;

        StandardBreaker(String description) {
            this.description = Preconditions.checkNotNull(description);
        }

        abstract BreakIterator newBreakIterator(Locale var1);

        @Override
        public FluentIterable<String> breakText(final String text, final Locale locale) {
            Preconditions.checkNotNull(text);
            Preconditions.checkNotNull(locale);
            return new FluentIterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    BreakIterator breakIterator = this.newBreakIterator(locale);
                    breakIterator.setText(text);
                    breakIterator.first();
                    return StandardBreaker.newIterator(breakIterator, text);
                }
            };
        }

        public String toString() {
            return this.description;
        }

        static Iterator<String> newIterator(final BreakIterator breakIterator, final String text) {
            return new AbstractIterator<String>(){

                @Override
                protected String computeNext() {
                    int current = breakIterator.current();
                    int next = breakIterator.next();
                    if (next == -1) {
                        return (String)this.endOfData();
                    }
                    return text.substring(current, next);
                }
            };
        }
    }
}

