/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.ibm.icu.lang.UCharacter;

public class CharWidth {
    public static int of(int codePoint) {
        if (codePoint >= 32 && codePoint < 127) {
            return 1;
        }
        if (codePoint < 0 || codePoint >= 0x110000) {
            throw new IllegalArgumentException(new StringBuilder(28).append("not a codepoint: ").append(codePoint).toString());
        }
        if (codePoint == 0) {
            return 0;
        }
        int category = UCharacter.getType(codePoint);
        switch (category) {
            case 15: {
                return -1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 16: {
                return 0;
            }
        }
        if (UCharacter.hasBinaryProperty(codePoint, 5)) {
            return 0;
        }
        switch (UCharacter.getIntPropertyValue(codePoint, 4107)) {
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
        }
        if (codePoint >= 12872 && codePoint <= 19967) {
            if (codePoint <= 12879) {
                return 2;
            }
            if (codePoint >= 19904) {
                return 2;
            }
        }
        int eastAsianWidth = UCharacter.getIntPropertyValue(codePoint, 4100);
        int result = 0;
        switch (eastAsianWidth) {
            case 0: {
                result = 1;
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            case 2: {
                result = 1;
                break;
            }
            case 3: {
                result = 2;
                break;
            }
            case 4: {
                result = 1;
                break;
            }
            case 5: {
                result = 2;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(40).append("unrecognized EastAsianWidth: ").append(eastAsianWidth).toString());
            }
        }
        return result;
    }
}

