/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.i18n.Locales;
import java.util.Locale;

public class DateFormatSymbols {
    private static final LoadingCache<Locale, com.ibm.icu.text.DateFormatSymbols> cache = CacheBuilder.newBuilder().build(new CacheLoader<Locale, com.ibm.icu.text.DateFormatSymbols>(){

        @Override
        public com.ibm.icu.text.DateFormatSymbols load(Locale locale) {
            return com.ibm.icu.text.DateFormatSymbols.getInstance(locale);
        }
    });
    private java.text.DateFormatSymbols jdkSymbols;
    private com.ibm.icu.text.DateFormatSymbols icuSymbols;
    private boolean useIcu;

    public DateFormatSymbols(Locale locale) {
        if (locale.equals(Locales.TAGALOG)) {
            this.useIcu = false;
            this.jdkSymbols = java.text.DateFormatSymbols.getInstance(Locale.US);
        } else {
            this.useIcu = true;
            this.icuSymbols = cache.getUnchecked(locale);
        }
    }

    public String[] getEras() {
        return this.useIcu ? this.icuSymbols.getEras() : this.jdkSymbols.getEras();
    }

    public String[] getShortMonths() {
        return this.useIcu ? this.icuSymbols.getShortMonths() : this.jdkSymbols.getShortMonths();
    }

    public String[] getMonths() {
        return this.useIcu ? this.icuSymbols.getMonths() : this.jdkSymbols.getMonths();
    }

    public String[] getShortWeekdays() {
        return this.useIcu ? this.icuSymbols.getShortWeekdays() : this.jdkSymbols.getShortWeekdays();
    }

    public String[] getWeekdays() {
        return this.useIcu ? this.icuSymbols.getWeekdays() : this.jdkSymbols.getWeekdays();
    }

    public String[] getAmPmStrings() {
        return this.useIcu ? this.icuSymbols.getAmPmStrings() : this.jdkSymbols.getAmPmStrings();
    }
}

