/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.DateTimeFormatterInterface;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DateIntervalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.text.FieldPosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DateTimeFormatter
implements DateTimeFormatterInterface {
    private static final int DEFAULT_DATE_FORMAT = 2;
    private static final int DEFAULT_TIME_FORMAT = 1;
    private final DateTimeFormatterMemoizer memoizer;

    public static DateTimeFormatter getInstance(Locale locale) {
        return new DateTimeFormatter(locale);
    }

    private DateTimeFormatter(Locale locale) {
        this.memoizer = new DateTimeFormatterMemoizer(locale);
    }

    public String getDateString(Date date) {
        return this.getDateTimeString(date, 2, -1);
    }

    public String getDateString(Date date, int style) {
        return this.getDateTimeString(date, style, -1);
    }

    @Deprecated
    public String getDateString(Date date, int style, boolean localTime) {
        return this.getDateTimeString(date, style, -1);
    }

    public String getTimeString(Date date) {
        return this.getDateTimeString(date, -1, 1);
    }

    public String getTimeString(Date date, int style) {
        return this.getDateTimeString(date, -1, style);
    }

    @Deprecated
    public String getTimeString(Date date, int style, boolean localTime) {
        return this.getDateTimeString(date, -1, style);
    }

    public String getDateTimeString(Date date, int style) {
        return this.getDateTimeString(date, style, style);
    }

    @Deprecated
    public String getDateTimeString(Date date, int style, boolean localTime) {
        return this.getDateTimeString(date, style, style);
    }

    public String getDateTimeString(Date date) {
        return this.getDateTimeString(date, 2, 1);
    }

    public String getDateTimeString(Date date, int dateStyle, int timeStyle) {
        if (date == null) {
            return "";
        }
        DateFormat formatter = this.memoizer.getStyleFormatter(dateStyle, timeStyle);
        return formatter.format(date);
    }

    @Deprecated
    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.memoizer.getDateformatSymbols().clone();
    }

    @Override
    @Deprecated
    public String getYMDOrder() {
        return this.memoizer.getYmdOrder();
    }

    public String getMonthString(Date date, boolean abbreviate) {
        DateFormat formatter = this.memoizer.getSkeletonFormatter(abbreviate ? "MMM" : "MMMM");
        return formatter.format(date);
    }

    public String getMonthString(Date date) {
        return this.getMonthString(date, false);
    }

    public String getYearString(Date date) {
        DateFormat formatter = this.memoizer.getSkeletonFormatter("y");
        return formatter.format(date);
    }

    public String getDayOfMonthString(Date date) {
        DateFormat formatter = this.memoizer.getSkeletonFormatter("d");
        return formatter.format(date);
    }

    public String getMonthYearString(Date date, boolean abbreviate) {
        DateFormat formatter = this.memoizer.getSkeletonFormatter(abbreviate ? "MMMy" : "MMMMy");
        return formatter.format(date);
    }

    public String getMonthYearString(Date date) {
        return this.getMonthYearString(date, false);
    }

    public String getMonthDayString(Date date, boolean abbreviate) {
        DateFormat formatter = this.memoizer.getSkeletonFormatter(abbreviate ? "dMMM" : "dMMMM");
        return formatter.format(date);
    }

    public String getMonthDayString(Date date) {
        return this.getMonthDayString(date, false);
    }

    public String getMonthYearRangeString(Date from, Date to, boolean abbreviate) {
        Calendar cFrom = Calendar.getInstance();
        Calendar cTo = Calendar.getInstance();
        cFrom.setTime(from);
        cTo.setTime(to);
        DateIntervalFormat formatter = this.memoizer.getSkeletonIntervalFormatter(abbreviate ? "MMMy" : "MMMMy");
        StringBuffer appendTo = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        return formatter.format(cFrom, cTo, appendTo, pos).toString();
    }

    public String getMonthYearRangeString(Date from, Date to) {
        return this.getMonthYearRangeString(from, to, false);
    }

    public String getMonthDayYearRangeString(Date from, Date to, boolean abbreviate) {
        Calendar cFrom = Calendar.getInstance();
        Calendar cTo = Calendar.getInstance();
        cFrom.setTime(from);
        cTo.setTime(to);
        DateIntervalFormat formatter = this.memoizer.getSkeletonIntervalFormatter(abbreviate ? "dMMMy" : "dMMMMy");
        StringBuffer appendTo = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        return formatter.format(cFrom, cTo, appendTo, pos).toString();
    }

    public String getMonthDayYearRangeString(Date from, Date to) {
        return this.getMonthDayYearRangeString(from, to, false);
    }

    @Override
    public String getMonthString(int month, boolean abbreviate) {
        Calendar c = Calendar.getInstance();
        c.set(2, month);
        return this.getMonthString(c.getTime(), abbreviate);
    }

    public String getMonthYearString(int month, int year, boolean abbreviate) {
        Calendar c = Calendar.getInstance();
        c.set(2, month);
        c.set(1, year);
        return this.getMonthYearString(c.getTime(), abbreviate);
    }

    @Override
    public String getYearString(int year) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        return this.getYearString(c.getTime());
    }

    @Override
    public String getDayString(int day) {
        Calendar c = Calendar.getInstance();
        c.set(5, day);
        return this.getDayOfMonthString(c.getTime());
    }

    public boolean isCjk() {
        return this.memoizer.isCjk();
    }

    private static class DateTimeFormatterMemoizer {
        private final Locale locale;
        private final Map<String, DateFormat> styleBasedDateTimeFormatters = new HashMap<String, DateFormat>();
        private final Map<String, DateFormat> skeletonBasedDateTimeFormatters = new HashMap<String, DateFormat>();
        private final Map<String, DateIntervalFormat> skeletonBasedDateIntervalFormatters = new HashMap<String, DateIntervalFormat>();
        private DateFormatSymbols dateformatSymbols = null;
        private Boolean isCjk = null;
        private String ymdOrder = null;

        DateTimeFormatterMemoizer(Locale locale) {
            this.locale = locale;
        }

        DateFormat getStyleFormatter(int dateStyle, int timeStyle) {
            String theKey = new StringBuilder(34).append("DATE_").append(dateStyle).append("::TIME_").append(timeStyle).toString();
            return this.styleBasedDateTimeFormatters.computeIfAbsent(theKey, key -> DateFormat.getDateTimeInstance(dateStyle, timeStyle, this.locale));
        }

        DateFormat getSkeletonFormatter(String skeleton) {
            return this.skeletonBasedDateTimeFormatters.computeIfAbsent(skeleton, key -> DateFormat.getInstanceForSkeleton(skeleton, this.locale));
        }

        DateIntervalFormat getSkeletonIntervalFormatter(String skeleton) {
            return this.skeletonBasedDateIntervalFormatters.computeIfAbsent(skeleton, key -> DateIntervalFormat.getInstance(skeleton, this.locale));
        }

        DateFormatSymbols getDateformatSymbols() {
            if (this.dateformatSymbols == null) {
                this.dateformatSymbols = DateFormatSymbols.getInstance(this.locale);
            }
            return this.dateformatSymbols;
        }

        public boolean isCjk() {
            if (this.isCjk == null) {
                String language = this.locale.getLanguage();
                this.isCjk = language.equals("zh") || language.equals("ja") || language.equals("ko");
            }
            return this.isCjk;
        }

        String getYmdOrder() {
            if (this.ymdOrder == null) {
                SimpleDateFormat df = (SimpleDateFormat)DateFormat.getInstanceForSkeleton("dMMMMy", this.locale);
                String pattern = df.toPattern();
                int dayIndex = pattern.indexOf("d");
                int monthIndex = pattern.indexOf("M");
                if (monthIndex == -1) {
                    monthIndex = pattern.indexOf("L");
                }
                int yearIndex = pattern.indexOf("y");
                this.ymdOrder = dayIndex < monthIndex ? (yearIndex < dayIndex ? "YDM" : (yearIndex > monthIndex ? "DMY" : "DYM")) : (yearIndex < monthIndex ? "YMD" : (yearIndex > dayIndex ? "MDY" : "MYD"));
            }
            return this.ymdOrder;
        }
    }
}

