/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.DurationFormatter;
import com.google.i18n.SimpleDurationFormatter;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class DurationFormatterFactory {
    private static DurationFormatterFactory SINGLETON = new DurationFormatterFactory();
    private static final String DURATION_FORMAT_PROPERTIES = "com/google/i18n/durationformat.properties";
    private static Properties durationFormatProperties;

    public static DurationFormatterFactory getSingleton() {
        return SINGLETON;
    }

    public DurationFormatter getSimpleDurationFormatter(SimpleDurationFormatter.Style durationStyle, Locale loc) {
        return new SimpleDurationFormatter(durationStyle, loc, durationFormatProperties.getProperty(String.valueOf(loc.getLanguage()).concat(".spacer"), " "), durationFormatProperties.getProperty(String.valueOf(loc.getLanguage()).concat(".repeatAfter20"), "no").equals("yes"));
    }

    protected DurationFormatterFactory() {
        durationFormatProperties = new Properties();
        try {
            durationFormatProperties.load(this.getClass().getClassLoader().getResourceAsStream(DURATION_FORMAT_PROPERTIES));
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

