/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Maps;
import com.google.i18n.Charset;
import java.util.Locale;
import java.util.Map;

public class EmailCharset {
    private static final Map<Locale, Charset> LOCALE_TO_CHARSET_ = Maps.newHashMap();
    private static final Map<String, Charset> LANGUAGE_TO_CHARSET_ = Maps.newHashMap();

    public static Charset getCharset(Locale locale) {
        Charset charset = null;
        if (locale != null && (charset = LOCALE_TO_CHARSET_.get(locale)) == null) {
            charset = LANGUAGE_TO_CHARSET_.get(locale.getLanguage());
        }
        return charset;
    }

    public static Charset getCharset(Locale locale, String text) {
        if (EmailCharset.containsAsciiOnly(text)) {
            return Charset.US_ASCII;
        }
        Charset charset = EmailCharset.getCharset(locale);
        if (charset == null) {
            charset = Charset.ISO_8859_1;
        }
        if (charset.contains(text)) {
            return charset;
        }
        return Charset.UTF_8;
    }

    private static boolean containsAsciiOnly(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("Usage: java EmailCharset <locale: one of la1(Latin-1), cn, tw, jp, kr> <charset>");
            System.err.println("\treads from stdin the text in the charset (max length 1 << 24)");
            System.err.println("\tand it prints to stdout the charset name followed by the converted input in this charset");
            System.exit(1);
        }
        Locale loc = null;
        String cc = args[0];
        if (cc.equals("la1")) {
            loc = Locale.US;
        } else if (cc.equals("cn")) {
            loc = Locale.PRC;
        } else if (cc.equals("tw")) {
            loc = Locale.TAIWAN;
        } else if (cc.equals("jp")) {
            loc = Locale.JAPAN;
        } else if (cc.equals("kr")) {
            loc = Locale.KOREA;
        }
        String charset = args[1];
        byte[] input_buf = new byte[0x1000000];
        try {
            int len = System.in.read(input_buf);
            if (len <= 0) {
                return;
            }
            String input_text = new String(input_buf, 0, len, charset);
            charset = EmailCharset.getCharset(loc, input_text).toString();
            String string = String.valueOf(charset);
            System.out.println(string.length() != 0 ? "Output charset: ".concat(string) : new String("Output charset: "));
            System.out.write(input_text.getBytes(charset));
        }
        catch (Exception e) {
            String string = String.valueOf(e);
            System.err.println(new StringBuilder(9 + String.valueOf(string).length()).append("Failure: ").append(string).toString());
            System.exit(1);
        }
    }

    static {
        LOCALE_TO_CHARSET_.put(Locale.CANADA, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.CANADA_FRENCH, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.CHINA, Charset.GB2312);
        LOCALE_TO_CHARSET_.put(Locale.CHINESE, Charset.GB2312);
        LOCALE_TO_CHARSET_.put(Locale.ENGLISH, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.FRANCE, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.FRENCH, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.GERMAN, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.GERMANY, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.ITALIAN, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.ITALY, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.JAPAN, Charset.ISO_2022_JP);
        LOCALE_TO_CHARSET_.put(Locale.JAPANESE, Charset.ISO_2022_JP);
        LOCALE_TO_CHARSET_.put(Locale.KOREA, Charset.EUC_KR);
        LOCALE_TO_CHARSET_.put(Locale.KOREAN, Charset.EUC_KR);
        LOCALE_TO_CHARSET_.put(Locale.PRC, Charset.GB2312);
        LOCALE_TO_CHARSET_.put(Locale.SIMPLIFIED_CHINESE, Charset.GB2312);
        LOCALE_TO_CHARSET_.put(Locale.TAIWAN, Charset.BIG5);
        LOCALE_TO_CHARSET_.put(Locale.TRADITIONAL_CHINESE, Charset.BIG5);
        LOCALE_TO_CHARSET_.put(Locale.UK, Charset.ISO_8859_1);
        LOCALE_TO_CHARSET_.put(Locale.US, Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.CANADA.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.CANADA_FRENCH.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.CHINA.getLanguage(), Charset.GB2312);
        LANGUAGE_TO_CHARSET_.put(Locale.CHINESE.getLanguage(), Charset.GB2312);
        LANGUAGE_TO_CHARSET_.put(Locale.ENGLISH.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.FRANCE.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.FRENCH.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.GERMAN.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.GERMANY.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.ITALIAN.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.ITALY.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.JAPAN.getLanguage(), Charset.ISO_2022_JP);
        LANGUAGE_TO_CHARSET_.put(Locale.JAPANESE.getLanguage(), Charset.ISO_2022_JP);
        LANGUAGE_TO_CHARSET_.put(Locale.KOREA.getLanguage(), Charset.EUC_KR);
        LANGUAGE_TO_CHARSET_.put(Locale.KOREAN.getLanguage(), Charset.EUC_KR);
        LANGUAGE_TO_CHARSET_.put(Locale.PRC.getLanguage(), Charset.GB2312);
        LANGUAGE_TO_CHARSET_.put(Locale.SIMPLIFIED_CHINESE.getLanguage(), Charset.GB2312);
        LANGUAGE_TO_CHARSET_.put(Locale.TAIWAN.getLanguage(), Charset.BIG5);
        LANGUAGE_TO_CHARSET_.put(Locale.TRADITIONAL_CHINESE.getLanguage(), Charset.BIG5);
        LANGUAGE_TO_CHARSET_.put(Locale.UK.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put(Locale.US.getLanguage(), Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put("ar", Charset.ISO_8859_6);
        LANGUAGE_TO_CHARSET_.put("bg", Charset.ISO_8859_5);
        LANGUAGE_TO_CHARSET_.put("cs", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("el", Charset.ISO_8859_7);
        LANGUAGE_TO_CHARSET_.put("iw", Charset.ISO_8859_8);
        LANGUAGE_TO_CHARSET_.put("hu", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("is", Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put("id", Charset.ISO_8859_1);
        LANGUAGE_TO_CHARSET_.put("lv", Charset.ISO_8859_13);
        LANGUAGE_TO_CHARSET_.put("lt", Charset.ISO_8859_13);
        LANGUAGE_TO_CHARSET_.put("pl", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("ro", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("ru", Charset.KOI8_R);
        LANGUAGE_TO_CHARSET_.put("sr", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("sk", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("sl", Charset.ISO_8859_2);
        LANGUAGE_TO_CHARSET_.put("tr", Charset.ISO_8859_9);
        LANGUAGE_TO_CHARSET_.put("uk", Charset.ISO_8859_5);
    }
}

