/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.ibm.icu.text.IDNA;
import com.ibm.icu.text.StringPrepParseException;

public final class Idn {
    public static final int ALLOW_UNASSIGNED = 1;
    public static final int USE_STD3_ASCII_RULES = 2;
    public static final int USE_IDNA2003 = 0x40000000;
    private static final int DEFAULT_FLAGS = 4;
    private static final IDNA UTS46_INSTANCE = IDNA.getUTS46Instance(4);

    public static String toASCII(String name) {
        return Idn.toASCII(name, 0);
    }

    public static String toASCII(String name, int flags) {
        if ((flags & 0x40000000) != 0) {
            try {
                return IDNA.convertIDNToASCII(name, flags & 0xBFFFFFFF).toString();
            }
            catch (StringPrepParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        IDNA.Info info = new IDNA.Info();
        StringBuilder result = new StringBuilder();
        Idn.getUts46(flags).nameToASCII(name, result, info);
        if (info.hasErrors()) {
            throw new IllegalArgumentException(String.format("Errors: %s", Joiner.on(',').join(info.getErrors())));
        }
        return result.toString();
    }

    public static String toUnicode(String name) {
        return Idn.toUnicode(name, 0);
    }

    public static String toUnicode(String name, int flags) {
        if ((flags & 0x40000000) != 0) {
            try {
                return IDNA.convertIDNToUnicode(name, flags & 0xBFFFFFFF).toString();
            }
            catch (StringPrepParseException e) {
                return name;
            }
        }
        IDNA.Info info = new IDNA.Info();
        StringBuilder result = new StringBuilder();
        Idn.getUts46(flags).nameToUnicode(name, result, info);
        return info.hasErrors() ? name : result.toString();
    }

    private static final IDNA getUts46(int flags) {
        Preconditions.checkArgument((flags & 1) == 0, "ALLOW_UNASSIGNED can only be specified with USE_IDNA2003");
        return flags == 0 || flags == 4 ? UTS46_INSTANCE : IDNA.getUTS46Instance(flags | 4);
    }
}

