/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.StringUtil;
import com.google.i18n.DateFormatSymbols;
import com.google.i18n.DateFormatterFactory;
import com.google.i18n.JsSimpleDateFormatBuilder;
import com.google.i18n.Locales;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

@Deprecated
public class JsSimpleDateFormat {
    private static final String patternChars = "GyYuMdhHmsSEeDFwWakKzZvgA";
    private String pattern;
    private DateFormatSymbols formatData;

    public JsSimpleDateFormat() {
        this(DateFormatterFactory.Style.SHORT, DateFormatterFactory.Style.SHORT, Locale.getDefault());
    }

    public JsSimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public JsSimpleDateFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        this.formatData = new DateFormatSymbols(locale);
    }

    public JsSimpleDateFormat(DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle) {
        this(timeStyle, dateStyle, Locale.getDefault());
    }

    public JsSimpleDateFormat(DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle, Locale locale) {
        if (locale.equals(Locales.TAGALOG)) {
            locale = Locale.US;
        }
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = JsSimpleDateFormatBuilder.getPattern(timeStyle, dateStyle, locale);
    }

    public String toPattern() {
        return this.pattern;
    }

    public String formatJsFunction() {
        JsFunctionWriter w = new JsFunctionWriter();
        for (Token token : this.compile()) {
            this.formatPart(w, token);
        }
        return w.generateCode();
    }

    private static String getJsArray(String[] array) {
        return JsSimpleDateFormat.getJsArray(array, 0);
    }

    private static String getJsArray(String[] array, int startIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = startIndex; i < array.length; ++i) {
            if (i > startIndex) {
                sb.append(",");
            }
            String string = StringUtil.javaScriptEscapeToAscii(array[i]);
            sb.append(new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString());
        }
        sb.append("]");
        return sb.toString();
    }

    private void formatPart(JsFunctionWriter w, Token token) {
        if (token.type == TokenType.TEXT) {
            w.addStringOutput(token.text);
        } else {
            int count = token.text.length();
            switch (token.text.charAt(0)) {
                case 'G': {
                    String array = JsSimpleDateFormat.getJsArray(this.formatData.getEras());
                    w.addOutput(String.valueOf(array).concat("[d.getFullYear()>0?1:0]"));
                    break;
                }
                case 'y': {
                    JsVar v = w.addVar("d.getFullYear()");
                    w.addStatement("if(v<=0)v=-v+1".replace("v", v.toString()));
                    if (count >= 4) {
                        w.pad(v, count);
                        break;
                    }
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(4 + String.valueOf(string).length()).append(string).append("%100").toString(), 2);
                    break;
                }
                case 'M': {
                    if (count >= 3) {
                        String array = count == 3 ? JsSimpleDateFormat.getJsArray(this.formatData.getShortMonths()) : JsSimpleDateFormat.getJsArray(this.formatData.getMonths());
                        w.addOutput(String.valueOf(array).concat("[d.getMonth()]"));
                        break;
                    }
                    w.pad("d.getMonth()+1", count);
                    break;
                }
                case 'd': {
                    w.pad("d.getDate()", count);
                    break;
                }
                case 'k': {
                    w.pad("d.getHours()||24", count);
                    break;
                }
                case 'H': {
                    w.pad("d.getHours()", count);
                    break;
                }
                case 'm': {
                    w.pad("d.getMinutes()", count);
                    break;
                }
                case 's': {
                    w.pad("d.getSeconds()", count);
                    break;
                }
                case 'S': {
                    w.pad("d.getMilliseconds()", count);
                    break;
                }
                case 'E': {
                    String array = count >= 4 ? JsSimpleDateFormat.getJsArray(this.formatData.getWeekdays(), 1) : JsSimpleDateFormat.getJsArray(this.formatData.getShortWeekdays(), 1);
                    w.addOutput(String.valueOf(array).concat("[d.getDay()]"));
                    break;
                }
                case 'a': {
                    String array = JsSimpleDateFormat.getJsArray(this.formatData.getAmPmStrings());
                    JsVar v = w.addVar("d.getHours()");
                    String string = String.valueOf(v);
                    String string2 = String.valueOf(v);
                    w.addOutput(new StringBuilder(15 + String.valueOf(array).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(array).append("[").append(string).append(">=12&&").append(string2).append("<24?1:0]").toString());
                    break;
                }
                case 'h': {
                    w.pad("d.getHours()%12||12", count);
                    break;
                }
                case 'K': {
                    w.pad("d.getHours()%12", count);
                    break;
                }
                case 'v': 
                case 'z': {
                    JsVar v = w.addVar("d.getTimezoneOffset()");
                    w.addStringOutput("GMT");
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(12 + String.valueOf(string).length()).append("(").append(string).append(">0?\"-\":\"+\")").toString());
                    string = String.valueOf(v);
                    w.pad(new StringBuilder(15 + String.valueOf(string).length()).append("Math.floor(").append(string).append("/60)").toString(), 2);
                    w.addStringOutput(":");
                    string = String.valueOf(v);
                    w.pad(new StringBuilder(3 + String.valueOf(string).length()).append(string).append("%60").toString(), 2);
                    break;
                }
                case 'Z': {
                    JsVar v = w.addVar("d.getTimezoneOffset()");
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(12 + String.valueOf(string).length()).append("(").append(string).append(">0?\"-\":\"+\")").toString());
                    string = String.valueOf(v);
                    String string3 = String.valueOf(v);
                    w.pad(new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append("/.6+").append(string3).append("%60").toString(), count);
                    break;
                }
                default: {
                    char c = token.text.charAt(0);
                    throw new IllegalArgumentException(new StringBuilder(32).append("The token '").append(c).append("' is not implemented").toString());
                }
            }
        }
    }

    private static void addToken(ArrayList<Token> list, Token token) {
        int length = list.size();
        if (length == 0) {
            list.add(token);
        } else {
            Token last = list.get(length - 1);
            if (last.type == TokenType.TEXT && token.type == TokenType.TEXT) {
                String string = String.valueOf(last.text);
                String string2 = String.valueOf(token.text);
                last.text = string2.length() != 0 ? string.concat(string2) : new String(string);
            } else {
                list.add(token);
            }
        }
    }

    private ArrayList<Token> compile() {
        ArrayList<Token> rv = new ArrayList<Token>();
        int length = this.pattern.length();
        int i = 0;
        boolean inQuote = false;
        while (i < length) {
            int j;
            char c = this.pattern.charAt(i);
            if (c == '\'') {
                if (i + 1 < length && this.pattern.charAt(i + 1) == '\'') {
                    JsSimpleDateFormat.addToken(rv, new Token(TokenType.TEXT, "'"));
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
                ++i;
                continue;
            }
            if (inQuote) {
                JsSimpleDateFormat.addToken(rv, new Token(TokenType.TEXT, new StringBuilder(1).append(c).toString()));
                ++i;
                continue;
            }
            boolean isPatternChar = false;
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (patternChars.indexOf(c) == -1) {
                    throw new IllegalArgumentException(new StringBuilder(29).append("Illegal pattern character '").append(c).append("'").toString());
                }
                isPatternChar = true;
            }
            for (j = i; j < length && this.pattern.charAt(j) == c; ++j) {
            }
            JsSimpleDateFormat.addToken(rv, new Token(isPatternChar ? TokenType.TOKEN : TokenType.TEXT, this.pattern.substring(i, j)));
            i = j;
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        return rv;
    }

    static class JsVar {
        public String name;
        public String value = null;

        JsVar(String name) {
            this.name = name;
        }

        JsVar(String name, String value) {
            this(name);
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }

    static class JsFunctionWriter {
        private boolean needsPadFunction = false;
        private int varCounter = 0;
        private ArrayList<JsVar> vars = new ArrayList();
        private ArrayList<String> statements = new ArrayList();
        private ArrayList<String> output = new ArrayList();

        JsFunctionWriter() {
        }

        JsVar addVar() {
            int n = this.varCounter++;
            JsVar v = new JsVar(new StringBuilder(12).append("v").append(n).toString());
            this.vars.add(v);
            return v;
        }

        JsVar addVar(String value) {
            JsVar v = this.addVar();
            v.value = value;
            return v;
        }

        void addStatement(String statement) {
            this.statements.add(statement);
        }

        void addOutput(String s) {
            this.output.add(s);
        }

        void addOutput(JsVar v) {
            this.output.add(v.toString());
        }

        void addStringOutput(String s) {
            String string = StringUtil.javaScriptEscapeToAscii(s);
            this.addOutput(new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString());
        }

        void pad(String expr, int count) {
            this.needsPadFunction = true;
            this.addOutput(new StringBuilder(17 + String.valueOf(expr).length()).append("pad(").append(expr).append(",").append(count).append(")").toString());
        }

        void pad(JsVar var, int count) {
            this.pad(var.toString(), count);
        }

        String generateCode() {
            StringBuilder sb = new StringBuilder();
            sb.append("function(d){");
            if (this.needsPadFunction) {
                sb.append("function pad(s,n){");
                sb.append("s=String(s);");
                String zeroPaddingNumber = "0";
                Iterator<String> iterator = StringUtil.javaScriptEscapeToAscii(zeroPaddingNumber);
                sb.append(new StringBuilder(54 + String.valueOf(iterator).length()).append("return(new Array(Math.max(0,n-s.length+1))).join('").append((String)((Object)iterator)).append("')+s").toString());
                sb.append("}\n");
            }
            if (this.vars.size() > 0) {
                sb.append("var ");
                boolean first = true;
                for (JsVar var : this.vars) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(var.name);
                    if (var.value != null) {
                        sb.append("=");
                        sb.append(var.value);
                    }
                    first = false;
                }
                sb.append(";");
            }
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    sb.append(s);
                    sb.append(";");
                }
            }
            sb.append("return ");
            boolean first = true;
            for (String s : this.output) {
                if (!first) {
                    sb.append("+");
                }
                sb.append(s);
                first = false;
            }
            sb.append("}");
            return sb.toString();
        }
    }

    static class Token {
        TokenType type;
        String text;

        Token(TokenType type, String text) {
            this.type = type;
            this.text = text;
        }
    }

    static enum TokenType {
        TEXT,
        TOKEN;

    }
}

