/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.StringUtil;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.i18n.DateFormatSymbols;
import com.google.i18n.DateFormatterFactory;
import com.google.i18n.Locales;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class JsSimpleDateFormatBuilder {
    private static final String patternChars = "GyYuMdhHmsSEeDFwWakKzZvgA";
    private static final LoadingCache<CacheKey, String> patternCache = CacheBuilder.newBuilder().build(new CacheLoader<CacheKey, String>(){

        @Override
        public String load(CacheKey key) {
            return JsSimpleDateFormatBuilder.makePattern(key.timeStyle, key.dateStyle, key.locale);
        }
    });
    private String padFunctionName = "DF_pad";
    private String buildStringFunctionName = "DF_buildString";
    private String dateConstantsName = "DF_CONSTANTS";
    private Boolean useExternalPadFunction = false;
    private Boolean useExternalBuildStringFunction = false;
    private Boolean useExternalDateConstants = false;
    private boolean needsPadFunction = false;
    private Set<ConstantName> usedConstants = Sets.newLinkedHashSet();
    private List<JsVar> variables = Lists.newArrayList();
    private List<Function> functions = Lists.newArrayList();
    private final DateFormatSymbols formatData;
    private final Locale locale;

    public JsSimpleDateFormatBuilder() {
        this(Locale.getDefault());
    }

    public JsSimpleDateFormatBuilder(Locale locale) {
        if (locale.equals(Locales.TAGALOG)) {
            locale = Locale.US;
        }
        this.locale = locale;
        this.formatData = new DateFormatSymbols(locale);
    }

    public void addFunction(String name, String pattern) {
        this.functions.add(new Function(name, "d", this.getFunctionBody(pattern)));
    }

    public void addFunction(String name, DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle) {
        this.addFunction(name, JsSimpleDateFormatBuilder.getPattern(timeStyle, dateStyle, this.locale));
    }

    public void addPatternAsStringVariable(String varName, String pattern) {
        this.variables.add(new JsVar(varName, new StringBuilder(2 + String.valueOf(pattern).length()).append("'").append(pattern).append("'").toString()));
    }

    public void addPatternAsStringVariable(String varName, DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle) {
        this.addPatternAsStringVariable(varName, JsSimpleDateFormatBuilder.getPattern(timeStyle, dateStyle, this.locale));
    }

    static String getPattern(DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle, Locale locale) {
        return patternCache.getUnchecked(new CacheKey(locale, dateStyle, timeStyle));
    }

    private static String makePattern(DateFormatterFactory.Style timeStyle, DateFormatterFactory.Style dateStyle, Locale locale) {
        DateFormat df;
        if (timeStyle != DateFormatterFactory.Style.NONE && dateStyle != DateFormatterFactory.Style.NONE) {
            df = DateFormat.getDateTimeInstance(dateStyle.getJDKStyle(), timeStyle.getJDKStyle(), locale);
        } else if (timeStyle != DateFormatterFactory.Style.NONE) {
            df = DateFormat.getTimeInstance(timeStyle.getJDKStyle(), locale);
        } else if (dateStyle != DateFormatterFactory.Style.NONE) {
            df = DateFormat.getDateInstance(dateStyle.getJDKStyle(), locale);
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        return ((SimpleDateFormat)df).toPattern();
    }

    private String getFunctionBody(String pattern) {
        FunctionBodyWriter w = new FunctionBodyWriter();
        for (Token token : this.compile(pattern)) {
            this.formatPart(w, token);
        }
        return w.generateCode(new StringBuilder()).toString();
    }

    private void assignStatement(StringBuilder sb, String name, String expr) {
        if (name.indexOf(46) == -1) {
            sb.append("var ");
        }
        sb.append(name);
        sb.append(" = ");
        sb.append(expr);
        sb.append(';');
    }

    public String generateCode() {
        StringBuilder sb = new StringBuilder();
        if (!this.useExternalDateConstants.booleanValue()) {
            this.assignStatement(sb, this.dateConstantsName, this.generateConstants());
            sb.append("\n");
        }
        if (!this.useExternalPadFunction.booleanValue() && this.needsPadFunction) {
            String zeroPaddingNumber = "0";
            String string = StringUtil.javaScriptEscapeToAscii(zeroPaddingNumber);
            String padBody = new StringBuilder(79 + String.valueOf(string).length()).append("s = String(s);\nreturn (new Array(Math.max(0, n - s.length + 1))).join('").append(string).append("') + s;\n").toString();
            Function padFunction = new Function(this.padFunctionName, "s", "n", padBody);
            padFunction.generateCode(sb);
        }
        if (!this.useExternalBuildStringFunction.booleanValue()) {
            Function buildStringFunction = new Function(this.buildStringFunctionName, "var_args", "return Array.prototype.join.call(arguments, '');\n");
            buildStringFunction.generateCode(sb);
        }
        for (JsVar var : this.variables) {
            var.generateStatement(sb);
        }
        for (Function f : this.functions) {
            f.generateCode(sb);
        }
        return sb.toString();
    }

    public void setPadFunctionName(String fullyQualifiedFunctionName) {
        this.padFunctionName = fullyQualifiedFunctionName;
    }

    public String getPadFunctionName() {
        return this.padFunctionName;
    }

    public void setBuildStringFunctionName(String buildStringFunctionName) {
        this.buildStringFunctionName = buildStringFunctionName;
    }

    public String getBuildStringFunctionName() {
        return this.buildStringFunctionName;
    }

    public void setDateConstantsName(String dateConstantsName) {
        this.dateConstantsName = dateConstantsName;
    }

    public String getDateConstantsName() {
        return this.dateConstantsName;
    }

    public void setUseExternalPadFunction(Boolean useExternalPadFunction) {
        this.useExternalPadFunction = useExternalPadFunction;
    }

    public Boolean getUseExternalPadFunction() {
        return this.useExternalPadFunction;
    }

    public void setUseExternalBuildStringFunction(Boolean useExternalBuildStringFunction) {
        this.useExternalBuildStringFunction = useExternalBuildStringFunction;
    }

    public Boolean getUseExternalBuildStringFunction() {
        return this.useExternalBuildStringFunction;
    }

    public void setUseExternalDateConstants(Boolean useExternalPadConstants) {
        this.useExternalDateConstants = useExternalPadConstants;
    }

    public Boolean getUseExternalDateConstants() {
        return this.useExternalDateConstants;
    }

    private String generateConstants() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Boolean first = true;
        for (ConstantName name : this.usedConstants) {
            if (!first.booleanValue()) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("\n");
            if (name == ConstantName.ERAS) {
                this.appendKeyValue(sb, name, this.formatData.getEras());
                continue;
            }
            if (name == ConstantName.MONTHS) {
                this.appendKeyValue(sb, name, this.formatData.getMonths(), 0, 12);
                continue;
            }
            if (name == ConstantName.SHORTMONTHS) {
                this.appendKeyValue(sb, name, this.formatData.getShortMonths(), 0, 12);
                continue;
            }
            if (name == ConstantName.WEEKDAYS) {
                this.appendKeyValue(sb, name, this.formatData.getWeekdays(), 1, 7);
                continue;
            }
            if (name == ConstantName.SHORTWEEKDAYS) {
                this.appendKeyValue(sb, name, this.formatData.getShortWeekdays(), 1, 7);
                continue;
            }
            if (name != ConstantName.AMPMS) continue;
            this.appendKeyValue(sb, name, this.formatData.getAmPmStrings());
        }
        if (!first.booleanValue()) {
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private void appendKeyValue(StringBuilder sb, ConstantName keyName, String[] array) {
        this.appendKeyValue(sb, keyName, array, 0, array.length);
    }

    private void appendKeyValue(StringBuilder sb, ConstantName keyName, String[] array, int startIndex, int length) {
        sb.append(keyName.toString());
        sb.append(": ");
        sb.append(JsSimpleDateFormatBuilder.getJsArray(array, startIndex, length));
    }

    private static String getJsArray(String[] array, int startIndex, int length) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int l = Math.min(array.length, length + startIndex);
        for (int i = startIndex; i < l; ++i) {
            if (i > startIndex) {
                sb.append(", ");
            }
            sb.append('\"');
            sb.append(StringUtil.javaScriptEscapeToAscii(array[i]));
            sb.append('\"');
        }
        sb.append("]");
        return sb.toString();
    }

    private String getConstantArray(ConstantName name) {
        this.usedConstants.add(name);
        String string = this.dateConstantsName;
        String string2 = String.valueOf((Object)name);
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
    }

    private void formatPart(FunctionBodyWriter w, Token token) {
        if (token.type == TokenType.TEXT) {
            w.addStringOutput(token.text);
        } else {
            int count = token.text.length();
            switch (token.text.charAt(0)) {
                case 'G': {
                    JsVar v = w.addConstAsNeeded("d.getFullYear()");
                    String array = this.getConstantArray(ConstantName.ERAS);
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(14 + String.valueOf(array).length() + String.valueOf(string).length()).append(array).append("[").append(string).append(" > 0 ? 1 : 0]").toString());
                    break;
                }
                case 'y': {
                    JsVar v = w.addVar("d.getFullYear()");
                    w.addStatement("if (v <= 0) v =- v + 1".replace("v", v.toString()));
                    if (count == 1) {
                        count = 4;
                    }
                    if (count >= 4) {
                        w.pad(v, count);
                        break;
                    }
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(6 + String.valueOf(string).length()).append(string).append(" % 100").toString(), 2);
                    break;
                }
                case 'M': {
                    JsVar v = w.addConstAsNeeded("d.getMonth()");
                    if (count >= 3) {
                        String array = count == 3 ? this.getConstantArray(ConstantName.SHORTMONTHS) : this.getConstantArray(ConstantName.MONTHS);
                        String string = String.valueOf(v);
                        w.addOutput(new StringBuilder(2 + String.valueOf(array).length() + String.valueOf(string).length()).append(array).append("[").append(string).append("]").toString());
                        break;
                    }
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(4 + String.valueOf(string).length()).append(string).append(" + 1").toString(), count);
                    break;
                }
                case 'd': {
                    JsVar v = w.addConstAsNeeded("d.getDate()");
                    w.pad(v, count);
                    break;
                }
                case 'k': {
                    JsVar v = w.addConstAsNeeded("d.getHours()");
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(6 + String.valueOf(string).length()).append(string).append(" || 24").toString(), count);
                    break;
                }
                case 'H': {
                    JsVar v = w.addConstAsNeeded("d.getHours()");
                    w.pad(v, count);
                    break;
                }
                case 'm': {
                    JsVar v = w.addConstAsNeeded("d.getMinutes()");
                    w.pad(v, count);
                    break;
                }
                case 's': {
                    JsVar v = w.addConstAsNeeded("d.getSeconds()");
                    w.pad(v, count);
                    break;
                }
                case 'S': {
                    JsVar v = w.addConstAsNeeded("d.getMilliseconds()");
                    w.pad(v, count);
                    break;
                }
                case 'E': {
                    JsVar v = w.addConstAsNeeded("d.getDay()");
                    String array = count >= 4 ? this.getConstantArray(ConstantName.WEEKDAYS) : this.getConstantArray(ConstantName.SHORTWEEKDAYS);
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(2 + String.valueOf(array).length() + String.valueOf(string).length()).append(array).append("[").append(string).append("]").toString());
                    break;
                }
                case 'a': {
                    String array = this.getConstantArray(ConstantName.AMPMS);
                    JsVar v = w.addConstAsNeeded("d.getHours()");
                    String string = String.valueOf(v);
                    String string2 = String.valueOf(v);
                    w.addOutput(new StringBuilder(25 + String.valueOf(array).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(array).append("[").append(string).append(" >= 12 && ").append(string2).append(" < 24 ? 1 : 0]").toString());
                    break;
                }
                case 'h': {
                    JsVar v = w.addConstAsNeeded("d.getHours()");
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(" % 12 || 12").toString(), count);
                    break;
                }
                case 'K': {
                    JsVar v = w.addConstAsNeeded("d.getHours()");
                    String string = String.valueOf(v);
                    w.pad(new StringBuilder(5 + String.valueOf(string).length()).append(string).append(" % 12").toString(), count);
                    break;
                }
                case 'v': 
                case 'z': {
                    JsVar v = w.addConstAsNeeded("d.getTimezoneOffset()");
                    w.addStringOutput("GMT");
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(18 + String.valueOf(string).length()).append("(").append(string).append(" > 0 ? \"-\" : \"+\")").toString());
                    string = String.valueOf(v);
                    w.pad(new StringBuilder(17 + String.valueOf(string).length()).append("Math.floor(").append(string).append(" / 60)").toString(), 2);
                    w.addStringOutput(":");
                    string = String.valueOf(v);
                    w.pad(new StringBuilder(5 + String.valueOf(string).length()).append(string).append(" % 60").toString(), 2);
                    break;
                }
                case 'Z': {
                    JsVar v = w.addConstAsNeeded("d.getTimezoneOffset()");
                    String string = String.valueOf(v);
                    w.addOutput(new StringBuilder(18 + String.valueOf(string).length()).append("(").append(string).append(" > 0 ? \"-\" : \"+\")").toString());
                    string = String.valueOf(v);
                    String string3 = String.valueOf(v);
                    w.pad(new StringBuilder(13 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append(" / .6 + ").append(string3).append(" % 60").toString(), count);
                    break;
                }
                default: {
                    char c = token.text.charAt(0);
                    throw new IllegalArgumentException(new StringBuilder(32).append("The token '").append(c).append("' is not implemented").toString());
                }
            }
        }
    }

    private static void addToken(List<Token> list, Token token) {
        int length = list.size();
        if (length == 0) {
            list.add(token);
        } else {
            Token last = list.get(length - 1);
            if (last.type == TokenType.TEXT && token.type == TokenType.TEXT) {
                String string = String.valueOf(last.text);
                String string2 = String.valueOf(token.text);
                last.text = string2.length() != 0 ? string.concat(string2) : new String(string);
            } else {
                list.add(token);
            }
        }
    }

    private List<Token> compile(String pattern) {
        ArrayList<Token> rv = Lists.newArrayList();
        int length = pattern.length();
        int i = 0;
        boolean inQuote = false;
        while (i < length) {
            int j;
            char c = pattern.charAt(i);
            if (c == '\'') {
                if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                    JsSimpleDateFormatBuilder.addToken(rv, new Token(TokenType.TEXT, "'"));
                    ++i;
                } else {
                    inQuote = !inQuote;
                }
                ++i;
                continue;
            }
            if (inQuote) {
                JsSimpleDateFormatBuilder.addToken(rv, new Token(TokenType.TEXT, new StringBuilder(1).append(c).toString()));
                ++i;
                continue;
            }
            boolean isPatternChar = false;
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (patternChars.indexOf(c) == -1) {
                    throw new IllegalArgumentException(new StringBuilder(29).append("Illegal pattern character '").append(c).append("'").toString());
                }
                isPatternChar = true;
            }
            for (j = i; j < length && pattern.charAt(j) == c; ++j) {
            }
            JsSimpleDateFormatBuilder.addToken(rv, new Token(isPatternChar ? TokenType.TOKEN : TokenType.TEXT, pattern.substring(i, j)));
            i = j;
        }
        if (inQuote) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        return rv;
    }

    static class JsVar {
        public final String name;
        public final String value;

        JsVar(String name) {
            this(name, null);
        }

        JsVar(String name, String value) {
            this.name = name;
            this.value = value;
        }

        StringBuilder generateExpression(StringBuilder sb) {
            sb.append(this.name);
            if (this.value != null) {
                sb.append(" = ");
                sb.append(this.value);
            }
            return sb;
        }

        StringBuilder generateStatement(StringBuilder sb) {
            sb.append("var ");
            this.generateExpression(sb);
            sb.append(";\n");
            return sb;
        }

        public String toString() {
            return this.name;
        }
    }

    class FunctionBodyWriter {
        private int varCounter = 0;
        private List<JsVar> vars = Lists.newArrayList();
        private Map<String, JsVar> varsByValue = Maps.newLinkedHashMap();
        private List<String> statements = Lists.newArrayList();
        private List<String> output = Lists.newArrayList();

        FunctionBodyWriter() {
        }

        private JsVar addVar_(@Nullable String name, @Nullable String value) {
            if (name == null) {
                name = "v";
            }
            String string = name;
            int n = this.varCounter++;
            JsVar v = new JsVar(new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString(), value);
            if (value != null) {
                this.varsByValue.put(value, v);
            }
            this.vars.add(v);
            return v;
        }

        JsVar addVar() {
            return this.addVar_(null, null);
        }

        JsVar addVar(String value) {
            return this.addVar_(null, value);
        }

        JsVar addConst(String value) {
            return this.addVar_("C", value);
        }

        JsVar addConstAsNeeded(String value) {
            if (this.varsByValue.containsKey(value)) {
                JsVar v = this.varsByValue.get(value);
                if (v.name.toUpperCase().equals(v.name)) {
                    return v;
                }
            }
            return this.addConst(value);
        }

        void addStatement(String statement) {
            this.statements.add(statement);
        }

        void addOutput(String s) {
            this.output.add(s);
        }

        void addOutput(JsVar v) {
            this.output.add(v.toString());
        }

        void addStringOutput(String s) {
            String string = StringUtil.javaScriptEscapeToAscii(s);
            this.addOutput(new StringBuilder(2 + String.valueOf(string).length()).append("\"").append(string).append("\"").toString());
        }

        void pad(String expr, int count) {
            JsSimpleDateFormatBuilder.this.needsPadFunction = true;
            String string = JsSimpleDateFormatBuilder.this.padFunctionName;
            this.addOutput(new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(expr).length()).append(string).append("(").append(expr).append(", ").append(count).append(")").toString());
        }

        void pad(JsVar var, int count) {
            this.pad(var.toString(), count);
        }

        StringBuilder generateCode(StringBuilder sb) {
            boolean first;
            if (this.vars.size() > 0) {
                sb.append("var ");
                first = true;
                for (JsVar var : this.vars) {
                    if (!first) {
                        sb.append(", ");
                    }
                    var.generateExpression(sb);
                    first = false;
                }
                sb.append(";\n");
            }
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    sb.append(s);
                    sb.append(";\n");
                }
            }
            sb.append("return ");
            if (this.output.size() > 2) {
                first = true;
                sb.append(JsSimpleDateFormatBuilder.this.buildStringFunctionName);
                sb.append("(");
                for (String s : this.output) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(s);
                    first = false;
                }
                sb.append(")");
            } else {
                sb.append(this.output.get(0));
                if (this.output.size() == 2) {
                    sb.append(" + ");
                    sb.append(this.output.get(1));
                }
            }
            sb.append(";\n");
            return sb;
        }
    }

    static class Token {
        TokenType type;
        String text;

        Token(TokenType type, String text) {
            this.type = type;
            this.text = text;
        }
    }

    static enum TokenType {
        TEXT,
        TOKEN;

    }

    private static enum ConstantName {
        AMPMS("AMPMS"),
        WEEKDAYS("WEEKDAYS"),
        SHORTWEEKDAYS("SHORTWEEKDAYS"),
        SHORTMONTHS("SHORTMONTHS"),
        MONTHS("MONTHS"),
        ERAS("ERAS");

        private final String name;

        private ConstantName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class Function {
        public String name = "";
        public String body = "";
        public String[] params = new String[0];

        public Function(String name, String param0, String param1, String body) {
            this(name, new String[]{param0, param1}, body);
        }

        public Function(String name, String param0, String body) {
            this(name, new String[]{param0}, body);
        }

        public Function(String name, String[] params, String body) {
            this.name = name;
            this.params = params;
            this.body = body;
        }

        public StringBuilder generateCode(StringBuilder sb) {
            Boolean needsSemiColon = true;
            if (this.name.equals("")) {
                sb.append("function(");
            } else if (this.name.indexOf(46) == -1) {
                sb.append("function ");
                sb.append(this.name);
                sb.append('(');
                needsSemiColon = false;
            } else {
                sb.append(this.name);
                sb.append(" = function(");
            }
            Boolean first = true;
            for (String param : this.params) {
                if (!first.booleanValue()) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(param);
            }
            sb.append(") {\n");
            sb.append(this.body);
            sb.append("}");
            if (needsSemiColon.booleanValue()) {
                sb.append(';');
            }
            sb.append("\n");
            return sb;
        }
    }

    private static class CacheKey {
        final Locale locale;
        final DateFormatterFactory.Style dateStyle;
        final DateFormatterFactory.Style timeStyle;

        CacheKey(Locale locale, DateFormatterFactory.Style dateStyle, DateFormatterFactory.Style timeStyle) {
            this.locale = locale;
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey key = (CacheKey)obj;
            return this.dateStyle == key.dateStyle && this.timeStyle == key.timeStyle && this.locale.equals(key.locale);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.dateStyle.hashCode();
            result = result * 31 + this.timeStyle.hashCode();
            result = result * 31 + this.locale.hashCode();
            return result;
        }
    }
}

