/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.flags.Flag;
import com.google.common.flags.FlagSpec;
import com.google.i18n.LanguageDirection;
import com.google.i18n.LocaleGroup;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageInfo;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.impl.IdentifierFactories;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleUtilNoXmb {
    @FlagSpec(help="Use stable identifiers instead of Locale.toString() (see http://go/iii, in -> id, ji -> yi, jw -> jv)", altName="use_iii_for_locale_string")
    private static final Flag<Boolean> useIiiForLocaleString = Flag.value(false);
    private static final Pattern lang_ = Pattern.compile("([a-z]{2,3}|x(?:-[a-zA-Z\\d]{1,8})+)");
    private static final Pattern langAndCountry_ = Pattern.compile("([a-z]{2,3}|x(?:-[a-zA-Z\\d]{1,8})+)_([A-Z]{2}|\\d{3})");
    private static final Pattern langAndCountryAndVariant_ = Pattern.compile("([a-z]{2,3}|x(?:-[a-zA-Z\\d]{1,8})+)_([A-Z]{2}|\\d{3})_([A-Z]{3})");
    private static boolean localesInit_ = false;
    private static List<Locale> supportedLocales_ = ImmutableList.of();
    private static final Map<Locale, Locale> aliasMap_ = new HashMap<Locale, Locale>();
    private static LocaleGroup localeGroup_ = new LocaleGroup(supportedLocales_);
    private static Set<Locale> additionalRightToLeftLocales_ = Collections.emptySet();
    private static final Set<String> latin1Languages_ = new HashSet<String>(Arrays.asList("ca", "da", "nl", "en", "fi", "fr", "de", "is", "it", "no", "pt", "es", "sv"));
    private static final Pattern LOCALE_PATTERN = Pattern.compile("(^[^_-]*)(?:[_-]([^_-]*)(?:[_-]([^_-]*))?)?");
    private static final CharMatcher ASCII_DIGIT = CharMatcher.inRange('0', '9');
    private static final Pattern SAFE_LOCALE_PATTERN = Pattern.compile("^([a-zA-Z]{2,3})(?:[_-]([a-zA-Z0-9]{2,})(?:[_-]([^_-]*))?)?");
    private static final CharMatcher ASCII_LETTER = CharMatcher.inRange('A', 'Z').or(CharMatcher.inRange('a', 'z'));

    public static Locale getLocaleFromStandardLocaleString(String s) {
        return LocaleUtilNoXmb.getLocaleFromLocaleString(s, LOCALE_PATTERN, Locale.ROOT);
    }

    private static Locale getLocaleFromLocaleString(String s, Pattern localePattern, Locale defaultLocale) {
        Locale locale;
        if (s == null) {
            return null;
        }
        if (useIiiForLocaleString.get().booleanValue() && null != (locale = LocaleUtilNoXmb.parseIiiCodeStringToJavaLocale(s))) {
            return locale;
        }
        Matcher matcher = localePattern.matcher(s);
        if (!matcher.find()) {
            return defaultLocale;
        }
        String language = Strings.nullToEmpty(matcher.group(1));
        String country = Strings.nullToEmpty(matcher.group(2));
        String variant = Strings.nullToEmpty(matcher.group(3));
        if (null == matcher.group(3) && (country.length() > 4 || country.length() == 4 && ASCII_DIGIT.matchesAllOf(country))) {
            variant = country;
            country = "";
        }
        return new Locale(language, country, variant);
    }

    private static Locale parseIiiCodeStringToJavaLocale(String s) {
        if (s.isEmpty()) {
            return null;
        }
        Locale locale = null;
        try {
            LanguageCode languageCode = LanguageCode.forString(s.trim());
            locale = JavaLocaleConverter.CONVERTER.toOther(languageCode);
        }
        catch (LanguageCode.IllFormedLanguageCode illFormedLanguageCode) {
        }
        catch (LanguageCode.InvalidLanguageCode invalidLanguageCode) {
            // empty catch block
        }
        return locale;
    }

    public static Locale getLocaleFromLocaleString(String s, Locale defaultLocale) {
        Locale locale = LocaleUtilNoXmb.getLocaleFromLocaleString(s, SAFE_LOCALE_PATTERN, defaultLocale);
        if (locale != null) {
            String country = locale.getCountry();
            int length = country.length();
            if (length == 0 || length == 2 && ASCII_LETTER.matchesAllOf(country) || length == 3 && ASCII_DIGIT.matchesAllOf(country)) {
                return locale;
            }
            if (length == 3 && ASCII_LETTER.matchesAllOf(country)) {
                return new Locale(locale.getLanguage(), country.substring(0, 2), locale.getVariant());
            }
            return defaultLocale;
        }
        return defaultLocale;
    }

    public static Locale getLocaleFromString(String hl) {
        return LocaleUtilNoXmb.getLocaleFromLocaleString(hl, null);
    }

    public static Locale getLocaleString(String hl, Locale defaultLocale, boolean canonicalize) {
        Locale locale = LocaleUtilNoXmb.getLocaleFromLocaleString(hl, defaultLocale);
        if (locale != null && canonicalize) {
            locale = LocaleUtilNoXmb.canonicalize(locale);
        }
        return locale;
    }

    public static String getStandardLocaleStringFromLocale(Locale l) {
        if (l == null) {
            return null;
        }
        String s = l.toString();
        if (useIiiForLocaleString.get().booleanValue()) {
            LanguageCode languageCode = JavaLocaleConverter.CONVERTER.fromOther(l);
            s = languageCode.toString();
        } else {
            int firstHyphen = (s = s.replace('_', '-')).indexOf(45);
            if (firstHyphen >= 0) {
                String string = String.valueOf(s.substring(0, firstHyphen).toLowerCase());
                String string2 = String.valueOf(s.substring(firstHyphen, s.length()).toUpperCase());
                s = string2.length() != 0 ? string.concat(string2) : new String(string);
            }
        }
        return s;
    }

    public static Locale getLocale(String hl) {
        if (hl == null) {
            return null;
        }
        hl = hl.replace('_', '-');
        return LocaleUtilNoXmb.getLocaleFromStandardLocaleString(hl);
    }

    private static boolean validateLocaleString(String localeString) {
        Locale locale;
        if (useIiiForLocaleString.get().booleanValue() && null != (locale = LocaleUtilNoXmb.parseIiiCodeStringToJavaLocale(localeString))) {
            return true;
        }
        return lang_.matcher(localeString).matches() || langAndCountry_.matcher(localeString).matches() || langAndCountryAndVariant_.matcher(localeString).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportedLocales(List<Locale> locales) {
        LocaleGroup group = new LocaleGroup(locales);
        ImmutableList<Locale> localeSet = ImmutableList.copyOf(locales);
        Class<LocaleUtilNoXmb> clazz = LocaleUtilNoXmb.class;
        synchronized (LocaleUtilNoXmb.class) {
            if (localesInit_) {
                throw new IllegalStateException("Locales were previously set");
            }
            localesInit_ = true;
            localeGroup_ = group;
            supportedLocales_ = localeSet;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areLocalesSet() {
        Class<LocaleUtilNoXmb> clazz = LocaleUtilNoXmb.class;
        synchronized (LocaleUtilNoXmb.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return localesInit_;
        }
    }

    public static void addAlias(Locale alias, Locale canonicalLocale) {
        if (!localesInit_) {
            throw new IllegalStateException("Locales have not been initialized yet");
        }
        Locale canonicalizedAlias = LocaleUtilNoXmb.canonicalize(alias);
        if (localeGroup_.contains(canonicalizedAlias)) {
            String string = String.valueOf(alias);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append(string).append(" is already supported").toString());
        }
        if (!LocaleUtilNoXmb.isLocaleSupported(canonicalLocale)) {
            String string = String.valueOf(canonicalLocale);
            throw new IllegalArgumentException(new StringBuilder(17 + String.valueOf(string).length()).append(string).append(" is not supported").toString());
        }
        aliasMap_.put(alias, canonicalLocale);
    }

    public static Locale getSupportedLocale(String localeString) {
        if (!LocaleUtilNoXmb.validateLocaleString(localeString)) {
            throw new IllegalArgumentException(String.valueOf(localeString).concat(" is an invalid locale string"));
        }
        Locale l = LocaleUtilNoXmb.getLocaleFromStandardLocaleString(localeString);
        return LocaleUtilNoXmb.getSupportedLocale(l);
    }

    public static Locale getSupportedLocale(Locale l) {
        l = LocaleUtilNoXmb.canonicalize(l);
        return supportedLocales_.isEmpty() ? Locale.getDefault() : localeGroup_.getLocale(l);
    }

    @Deprecated
    public static boolean isLocaleSupported(String localeString) {
        if (!LocaleUtilNoXmb.validateLocaleString(localeString)) {
            throw new IllegalArgumentException(String.valueOf(localeString).concat(" is an invalid locale string"));
        }
        Locale l = LocaleUtilNoXmb.getLocaleFromStandardLocaleString(localeString);
        return LocaleUtilNoXmb.isLocaleSupported(l);
    }

    @Deprecated
    @VisibleForTesting
    protected static boolean isLocaleSupported(Locale l) {
        Locale supported = localeGroup_.getLocale(l = LocaleUtilNoXmb.canonicalize(l), null);
        return supported != null;
    }

    private static Locale canonicalize(Locale locale) {
        if (aliasMap_.get(locale) != null) {
            return aliasMap_.get(locale);
        }
        return locale;
    }

    public static File getFile(Locale locale, String base, String filename) throws FileNotFoundException {
        ArrayList<Locale> locales = Lists.newArrayList();
        locales.addAll(localeGroup_.supportedLocaleFallbackChain(locale, Locale.getDefault()));
        locales.add(null);
        for (Locale nextLocale : locales) {
            String abstractPath = LocaleUtilNoXmb.getPath(nextLocale, "", filename);
            File file = new File(base, abstractPath);
            if (!file.exists()) continue;
            return file;
        }
        String string = String.valueOf(locale);
        throw new FileNotFoundException(new StringBuilder(72 + String.valueOf(string).length() + String.valueOf(base).length() + String.valueOf(filename).length()).append("Could not find localized (").append(string).append(") or default file for base \"").append(base).append("\", and filename \"").append(filename).append("\"").toString());
    }

    public static String getPath(Locale locale, String base, String filename) {
        if (base == null) {
            throw new IllegalArgumentException("base may not be null.");
        }
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("filename may not be null or empty.");
        }
        if (locale == null) {
            String string = String.valueOf(base);
            String string2 = String.valueOf(filename);
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        String language = "";
        String country = "";
        if (useIiiForLocaleString.get().booleanValue()) {
            LanguageCode languageCode = JavaLocaleConverter.CONVERTER.fromOther(locale);
            LanguageCode languageTag = languageCode.getLanguageSubtag();
            language = languageTag.toString();
            RegionCode regionCode = languageCode.getRegionSubtag();
            if (null != regionCode) {
                country = regionCode.toString();
            }
        } else {
            language = locale.getLanguage();
            country = locale.getCountry();
        }
        StringBuilder path = new StringBuilder();
        path.append(base);
        path.append(language);
        path.append("/");
        if (!country.isEmpty()) {
            path.append(country);
            path.append("/");
        }
        path.append(filename);
        return path.toString();
    }

    public static Set<Locale> getSupportedLocales() {
        return ImmutableSet.copyOf(supportedLocales_);
    }

    public static LocaleGroup getSupportedLocaleGroup() {
        return localeGroup_;
    }

    public static void setAdditionalRightToLeftLocales(Collection<Locale> locales) {
        additionalRightToLeftLocales_ = ImmutableSet.copyOf(locales);
    }

    public static boolean isRightToLeftLanguage(Locale loc) {
        if (null == loc) {
            return false;
        }
        if (additionalRightToLeftLocales_.contains(loc)) {
            return true;
        }
        LanguageCode languageCode = JavaLocaleConverter.CONVERTER.fromOther(loc);
        return LocaleUtilNoXmb.isRightToLeftLanguage(languageCode);
    }

    public static boolean isRightToLeftLanguage(LanguageCode languageCode) {
        Preconditions.checkNotNull(languageCode);
        LanguageInfo langInfo = IdentifierFactories.getLanguageInfo();
        return langInfo.isRightToLeftLanguage(languageCode);
    }

    public static LanguageDirection getLanguageDirection(LanguageCode languageCode) {
        return LocaleUtilNoXmb.isRightToLeftLanguage(languageCode) ? LanguageDirection.RIGHT_TO_LEFT : LanguageDirection.LEFT_TO_RIGHT;
    }

    public static LanguageDirection getLanguageDirection(Locale loc) {
        return LocaleUtilNoXmb.isRightToLeftLanguage(loc) ? LanguageDirection.RIGHT_TO_LEFT : LanguageDirection.LEFT_TO_RIGHT;
    }

    public static boolean isSupportedByLatin1(Locale loc) {
        return loc != null && latin1Languages_.contains(loc.getLanguage());
    }

    protected LocaleUtilNoXmb() {
    }
}

