/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.collect.Lists;
import com.google.i18n.Localizable;
import com.google.i18n.Localizables;
import java.util.List;
import java.util.Locale;

public class LocalizableBuilder
implements Localizable {
    private List<Localizable> components = Lists.newArrayList();

    public LocalizableBuilder appendLocalizable(Localizable lc) {
        this.components.add(lc);
        return this;
    }

    public void clear() {
        this.components.clear();
    }

    public LocalizableBuilder appendString(String s) {
        this.components.add(Localizables.unlocalizedString(s));
        return this;
    }

    @Override
    public String toString(Locale lc) {
        StringBuilder builder = new StringBuilder();
        for (Localizable component : this.components) {
            builder.append(component.toString(lc));
        }
        return builder.toString();
    }
}

