/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.i18n.Charset;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class Localizer {
    private ResourceBundle rb_;
    private HashMap<String, String> map_;
    private String base_;

    public Localizer(String base, Locale locale) {
        this.base_ = base;
        this.map_ = null;
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.rb_ = ResourceBundle.getBundle(this.base_, locale);
    }

    public void map(HashMap<String, String> map) {
        this.map_ = map;
    }

    private static final String toUnicode(String UTF8EncodedAsAscii) throws UnsupportedEncodingException {
        byte[] utf8 = UTF8EncodedAsAscii.getBytes(Charset.ISO_8859_1.getJavaName());
        return new String(utf8, Charset.UTF_8.getJavaName());
    }

    public final String localize(String appMessage) throws UnsupportedEncodingException {
        String key = "";
        String extraInfo = "";
        int separator = appMessage.indexOf(" ");
        if (separator < 0) {
            separator = appMessage.length();
        }
        key = appMessage.substring(0, separator);
        extraInfo = appMessage.substring(separator);
        String i18nMessage = null != this.map_ ? this.map_.get(key) : null;
        try {
            if (null == i18nMessage) {
                i18nMessage = this.rb_.getString(key);
            }
        }
        catch (Exception e) {
            i18nMessage = key;
        }
        String string = String.valueOf(i18nMessage);
        String string2 = String.valueOf(extraInfo);
        return Localizer.toUnicode(string2.length() != 0 ? string.concat(string2) : new String(string));
    }

    public static Locale bestLanguage(ArrayList<Locale> provided, ArrayList<Locale> requested) {
        Locale bestPartial = null;
        for (Locale req : requested) {
            for (Locale prov : provided) {
                if (req.equals(prov)) {
                    return prov;
                }
                if (bestPartial != null || !req.getLanguage().equals(prov.getLanguage())) continue;
                bestPartial = prov;
            }
        }
        return bestPartial == null ? provided.get(0) : bestPartial;
    }

    public final Locale getLocale() {
        return this.rb_.getLocale();
    }

    public static final String javaToHttpLocale(Locale locale) {
        String javaLocaleString = locale.toString();
        return javaLocaleString.replace("_", "-").toLowerCase();
    }
}

