/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.i18n.Localizable;
import com.google.i18n.Message;
import com.google.i18n.MessageBundleReference;
import com.google.i18n.MessageTextBlockMappingManager;
import java.util.Locale;

@Immutable
public abstract class MessageReference {
    private final MessageBundleReference messageBundleReference_;
    private final long id_;
    private final String textBlockId_;
    private final String experimentCandidateName_;

    @Deprecated
    public MessageReference(String source, long id) {
        this(new MessageBundleReference(source), id);
    }

    public MessageReference(MessageBundleReference messageBundleReference, long id) {
        this(messageBundleReference, id, "", "");
    }

    public MessageReference(MessageBundleReference messageBundleReference, long id, String textBlockId, String experimentCandidateName) {
        this.messageBundleReference_ = messageBundleReference;
        this.id_ = id;
        this.textBlockId_ = textBlockId;
        this.experimentCandidateName_ = experimentCandidateName;
    }

    public long getId() {
        return this.id_;
    }

    public String getTextBlockId() {
        return this.textBlockId_;
    }

    public String getExperimentCandidateName() {
        return this.experimentCandidateName_;
    }

    public Message getMessage(Locale locale) {
        return this.messageBundleReference_.getMessageBundle(locale).getMessage(this.id_);
    }

    protected static String localizedStringOf(Locale loc, Object o) {
        if (o instanceof Localizable) {
            return ((Localizable)o).toString(loc);
        }
        return o.toString();
    }

    protected Optional<String> toStringIfTranslated(Locale locale, String ... args) {
        return this.isTranslated(locale) ? Optional.of(this.getMessage(locale).toString(args)) : Optional.absent();
    }

    public boolean isTranslated(Locale locale) {
        return this.messageBundleReference_.getMessageBundle(locale).isTranslated(this.id_);
    }

    public abstract int getPlaceholdersCount();

    public ImmutableList<MessageReference> getExperimentCandidates() {
        return MessageTextBlockMappingManager.getExperimentCandidates(this.textBlockId_);
    }
}

