/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.i18n.MessageReference;
import java.lang.ref.SoftReference;
import java.util.Iterator;

public class MessageTextBlockMappingManager {
    private static final SetMultimap<String, SoftReference<MessageReference>> textBlockMap_ = Multimaps.synchronizedSetMultimap(MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build());

    public static void putTextBlockMapping(String textBlockId, MessageReference messageReference) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(textBlockId), "text-block-id shouldn't be null or empty");
        Preconditions.checkArgument(messageReference != null, "Message reference shouldn't be null");
        MessageTextBlockMappingManager.clearNullReferences(textBlockId);
        boolean alreadyExists = MessageTextBlockMappingManager.isMessageAlreadyExists(textBlockId, messageReference);
        if (!alreadyExists) {
            textBlockMap_.put(textBlockId, new SoftReference<MessageReference>(messageReference));
        }
    }

    public static ImmutableList<MessageReference> getExperimentCandidates(String textBlockId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SoftReference ref : textBlockMap_.get((Object)textBlockId)) {
            MessageReference msg = (MessageReference)ref.get();
            if (msg == null) continue;
            builder.add(msg);
        }
        return builder.build();
    }

    private static boolean isMessageAlreadyExists(String textBlockId, MessageReference messageReference) {
        for (SoftReference ref : textBlockMap_.get((Object)textBlockId)) {
            if (ref.get() != messageReference) continue;
            return true;
        }
        return false;
    }

    private static void clearNullReferences(String textBlockId) {
        Iterator it = textBlockMap_.get((Object)textBlockId).iterator();
        while (it.hasNext()) {
            if (((SoftReference)it.next()).get() != null) continue;
            it.remove();
        }
    }
}

