/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.i18n.identifiers.CaseNormalizingStringConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.RegionCode;

@GwtCompatible
public final class Iso3166Alpha2RegionConverter
extends CaseNormalizingStringConverter<RegionCode> {
    public static final Iso3166Alpha2RegionConverter CONVERTER = new Iso3166Alpha2RegionConverter();

    private Iso3166Alpha2RegionConverter() {
    }

    @Override
    public RegionCode getUnknown() {
        return RegionCode.ZZ;
    }

    @Override
    public CodeConverter.Status getStatusFromOther(String otherCode) {
        String upperCaseOtherCode = Iso3166Alpha2RegionConverter.toUpperCaseIfWellFormed(otherCode);
        if (upperCaseOtherCode == null) {
            return CodeConverter.Status.ILL_FORMED;
        }
        try {
            RegionCode result = RegionCode.forString(upperCaseOtherCode);
            if (Iso3166Alpha2RegionConverter.isPrivateUse(upperCaseOtherCode)) {
                return CodeConverter.Status.PRIVATE_USE;
            }
            return result.isCanonical() ? CodeConverter.Status.CANONICAL : CodeConverter.Status.NON_CANONICAL;
        }
        catch (IllegalArgumentException e) {
            return CodeConverter.Status.INVALID;
        }
    }

    @Override
    public CodeConverter.Status getStatus(RegionCode googleCode) {
        String otherCode = Iso3166Alpha2RegionConverter.toUpperCaseIfWellFormed(googleCode.toString());
        if (otherCode == null) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (Iso3166Alpha2RegionConverter.isPrivateUse(otherCode)) {
            return CodeConverter.Status.PRIVATE_USE;
        }
        return googleCode.isCanonical() ? CodeConverter.Status.CANONICAL : CodeConverter.Status.NON_CANONICAL;
    }

    @Override
    public String toOther(RegionCode googleCode) {
        String result = googleCode.toString();
        if (result.length() > 2) {
            return "ZZ";
        }
        return result;
    }

    @Override
    public RegionCode fromOther(String otherCode) {
        try {
            return RegionCode.forString(Ascii.toUpperCase(otherCode));
        }
        catch (IllegalArgumentException e) {
            return this.getUnknown();
        }
        catch (NullPointerException e) {
            return this.getUnknown();
        }
    }

    private static String toUpperCaseIfWellFormed(String s) {
        String upperS;
        if (s.length() == 2 && 'A' <= (upperS = Ascii.toUpperCase(s)).charAt(0) && upperS.charAt(0) <= 'Z' && 'A' <= upperS.charAt(1) && upperS.charAt(1) <= 'Z') {
            return upperS;
        }
        return null;
    }

    private static boolean isPrivateUse(String s) {
        char c0 = s.charAt(0);
        char c1 = s.charAt(1);
        return c0 == 'A' && c1 == 'A' || c0 == 'Q' && 'M' <= c1 && c1 <= 'T' || c0 == 'Q' && 'V' <= c1 && c1 <= 'Z' || c0 == 'X' && 'A' <= c1 && c1 <= 'Z' || c0 == 'Z' && c1 == 'Z';
    }
}

