/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.collect.Maps;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.BasicCodeConverter;
import com.google.i18n.identifiers.CodeConverter;
import java.util.Map;

public final class Iso4217NumericCurrencyCodeConverter
extends BasicCodeConverter<CurrencyCode, Integer> {
    private final Map<Integer, CurrencyCode> nonCanonicalFromOther = Maps.newHashMap();
    private final Map<CurrencyCode, Integer> nonCanonicalToOther = Maps.newHashMap();
    public static final Iso4217NumericCurrencyCodeConverter CONVERTER = new Iso4217NumericCurrencyCodeConverter();

    @Override
    public CodeConverter.Status getStatusFromOther(Integer code) {
        int val = code;
        if (val < 0 || val > 999) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (this.mapFromString.containsKey(code)) {
            return CodeConverter.Status.CANONICAL;
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public CodeConverter.Status getStatus(CurrencyCode code) {
        if (this.nonCanonicalToOther.containsKey(code)) {
            return CodeConverter.Status.NON_CANONICAL;
        }
        if (this.mapToString.containsKey(code)) {
            return CodeConverter.Status.CANONICAL;
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public CurrencyCode getUnknown() {
        return CurrencyCode.XXX;
    }

    private void addNonCanonical(int val, CurrencyCode code) {
        Integer intVal = val;
        this.nonCanonicalFromOther.put(intVal, code);
        this.nonCanonicalToOther.put(code, intVal);
    }

    private Iso4217NumericCurrencyCodeConverter() {
        this.addNonCanonical(643, CurrencyCode.SUR);
        this.add(643, CurrencyCode.SUR);
        this.add(20, CurrencyCode.ADP);
        this.add(4, CurrencyCode.AFA);
        this.add(24, CurrencyCode.AON);
        this.add(982, CurrencyCode.AOR);
        this.add(40, CurrencyCode.ATS);
        this.add(31, CurrencyCode.AZM);
        this.add(70, CurrencyCode.BAD);
        this.add(56, CurrencyCode.BEF);
        this.add(100, CurrencyCode.BGL);
        this.add(76, CurrencyCode.BRE);
        this.add(987, CurrencyCode.BRR);
        this.add(112, CurrencyCode.BYB);
        this.add(200, CurrencyCode.CSK);
        this.add(196, CurrencyCode.CYP);
        this.add(276, CurrencyCode.DEM);
        this.add(218, CurrencyCode.ECS);
        this.add(233, CurrencyCode.EEK);
        this.add(724, CurrencyCode.ESP);
        this.add(246, CurrencyCode.FIM);
        this.add(250, CurrencyCode.FRF);
        this.add(268, CurrencyCode.GEK);
        this.add(226, CurrencyCode.GQE);
        this.add(288, CurrencyCode.GHC);
        this.add(300, CurrencyCode.GRD);
        this.add(624, CurrencyCode.GWP);
        this.add(372, CurrencyCode.IEP);
        this.add(380, CurrencyCode.ITL);
        this.add(420, CurrencyCode.LTT);
        this.add(442, CurrencyCode.LUF);
        this.add(450, CurrencyCode.MGF);
        this.add(470, CurrencyCode.MTL);
        this.add(508, CurrencyCode.MZM);
        this.add(528, CurrencyCode.NLG);
        this.add(616, CurrencyCode.PLZ);
        this.add(620, CurrencyCode.PTE);
        this.add(642, CurrencyCode.ROL);
        this.add(810, CurrencyCode.RUR);
        this.add(705, CurrencyCode.SIT);
        this.add(736, CurrencyCode.SDD);
        this.add(703, CurrencyCode.SKK);
        this.add(740, CurrencyCode.SRG);
        this.add(762, CurrencyCode.TJR);
        this.add(795, CurrencyCode.TMM);
        this.add(626, CurrencyCode.TPE);
        this.add(792, CurrencyCode.TRL);
        this.add(804, CurrencyCode.UAK);
        this.add(862, CurrencyCode.VEB);
        this.add(937, CurrencyCode.VEF);
        this.add(890, CurrencyCode.YUN);
        this.add(894, CurrencyCode.ZMK);
        this.add(716, CurrencyCode.ZWD);
        this.add(939, CurrencyCode.GHP);
        this.add(440, CurrencyCode.LTL);
        this.add(784, CurrencyCode.AED);
        this.add(971, CurrencyCode.AFN);
        this.add(8, CurrencyCode.ALL);
        this.add(51, CurrencyCode.AMD);
        this.add(532, CurrencyCode.ANG);
        this.add(973, CurrencyCode.AOA);
        this.add(36, CurrencyCode.AUD);
        this.add(533, CurrencyCode.AWG);
        this.add(944, CurrencyCode.AZN);
        this.add(977, CurrencyCode.BAM);
        this.add(52, CurrencyCode.BBD);
        this.add(50, CurrencyCode.BDT);
        this.add(975, CurrencyCode.BGN);
        this.add(48, CurrencyCode.BHD);
        this.add(108, CurrencyCode.BIF);
        this.add(60, CurrencyCode.BMD);
        this.add(96, CurrencyCode.BND);
        this.add(44, CurrencyCode.BSD);
        this.add(64, CurrencyCode.BTN);
        this.add(72, CurrencyCode.BWP);
        this.add(933, CurrencyCode.BYN);
        this.add(974, CurrencyCode.BYR);
        this.add(84, CurrencyCode.BZD);
        this.add(124, CurrencyCode.CAD);
        this.add(976, CurrencyCode.CDF);
        this.add(756, CurrencyCode.CHF);
        this.add(152, CurrencyCode.CLP);
        this.add(156, CurrencyCode.CNY);
        this.add(170, CurrencyCode.COP);
        this.add(188, CurrencyCode.CRC);
        this.add(192, CurrencyCode.CUP);
        this.add(132, CurrencyCode.CVE);
        this.add(203, CurrencyCode.CZK);
        this.add(262, CurrencyCode.DJF);
        this.add(208, CurrencyCode.DKK);
        this.add(214, CurrencyCode.DOP);
        this.add(12, CurrencyCode.DZD);
        this.add(818, CurrencyCode.EGP);
        this.add(232, CurrencyCode.ERN);
        this.add(230, CurrencyCode.ETB);
        this.add(978, CurrencyCode.EUR);
        this.add(242, CurrencyCode.FJD);
        this.add(238, CurrencyCode.FKP);
        this.add(826, CurrencyCode.GBP);
        this.add(981, CurrencyCode.GEL);
        this.add(936, CurrencyCode.GHS);
        this.add(292, CurrencyCode.GIP);
        this.add(270, CurrencyCode.GMD);
        this.add(324, CurrencyCode.GNF);
        this.add(320, CurrencyCode.GTQ);
        this.add(328, CurrencyCode.GYD);
        this.add(344, CurrencyCode.HKD);
        this.add(340, CurrencyCode.HNL);
        this.add(332, CurrencyCode.HTG);
        this.add(348, CurrencyCode.HUF);
        this.add(360, CurrencyCode.IDR);
        this.add(356, CurrencyCode.INR);
        this.add(368, CurrencyCode.IQD);
        this.add(364, CurrencyCode.IRR);
        this.add(352, CurrencyCode.ISK);
        this.add(388, CurrencyCode.JMD);
        this.add(400, CurrencyCode.JOD);
        this.add(392, CurrencyCode.JPY);
        this.add(404, CurrencyCode.KES);
        this.add(417, CurrencyCode.KGS);
        this.add(116, CurrencyCode.KHR);
        this.add(174, CurrencyCode.KMF);
        this.add(408, CurrencyCode.KPW);
        this.add(410, CurrencyCode.KRW);
        this.add(414, CurrencyCode.KWD);
        this.add(136, CurrencyCode.KYD);
        this.add(398, CurrencyCode.KZT);
        this.add(418, CurrencyCode.LAK);
        this.add(422, CurrencyCode.LBP);
        this.add(144, CurrencyCode.LKR);
        this.add(430, CurrencyCode.LRD);
        this.add(426, CurrencyCode.LSL);
        this.add(434, CurrencyCode.LYD);
        this.add(504, CurrencyCode.MAD);
        this.add(498, CurrencyCode.MDL);
        this.add(969, CurrencyCode.MGA);
        this.add(807, CurrencyCode.MKD);
        this.add(104, CurrencyCode.MMK);
        this.add(496, CurrencyCode.MNT);
        this.add(466, CurrencyCode.MOP);
        this.add(478, CurrencyCode.MRO);
        this.add(480, CurrencyCode.MUR);
        this.add(462, CurrencyCode.MVR);
        this.add(454, CurrencyCode.MWK);
        this.add(458, CurrencyCode.MYR);
        this.add(943, CurrencyCode.MZN);
        this.add(516, CurrencyCode.NAD);
        this.add(566, CurrencyCode.NGN);
        this.add(558, CurrencyCode.NIO);
        this.add(578, CurrencyCode.NOK);
        this.add(524, CurrencyCode.NPR);
        this.add(554, CurrencyCode.NZD);
        this.add(512, CurrencyCode.OMR);
        this.add(590, CurrencyCode.PAB);
        this.add(598, CurrencyCode.PGK);
        this.add(608, CurrencyCode.PHP);
        this.add(586, CurrencyCode.PKR);
        this.add(985, CurrencyCode.PLN);
        this.add(600, CurrencyCode.PYG);
        this.add(634, CurrencyCode.QAR);
        this.add(946, CurrencyCode.RON);
        this.add(941, CurrencyCode.RSD);
        this.add(643, CurrencyCode.RUB);
        this.add(646, CurrencyCode.RWF);
        this.add(682, CurrencyCode.SAR);
        this.add(90, CurrencyCode.SBD);
        this.add(690, CurrencyCode.SCR);
        this.add(938, CurrencyCode.SDG);
        this.add(752, CurrencyCode.SEK);
        this.add(702, CurrencyCode.SGD);
        this.add(654, CurrencyCode.SHP);
        this.add(694, CurrencyCode.SLL);
        this.add(706, CurrencyCode.SOS);
        this.add(968, CurrencyCode.SRD);
        this.add(728, CurrencyCode.SSP);
        this.add(678, CurrencyCode.STD);
        this.add(222, CurrencyCode.SVC);
        this.add(760, CurrencyCode.SYP);
        this.add(748, CurrencyCode.SZL);
        this.add(764, CurrencyCode.THB);
        this.add(972, CurrencyCode.TJS);
        this.add(934, CurrencyCode.TMT);
        this.add(788, CurrencyCode.TND);
        this.add(776, CurrencyCode.TOP);
        this.add(949, CurrencyCode.TRY);
        this.add(780, CurrencyCode.TTD);
        this.add(901, CurrencyCode.TWD);
        this.add(834, CurrencyCode.TZS);
        this.add(980, CurrencyCode.UAH);
        this.add(800, CurrencyCode.UGX);
        this.add(840, CurrencyCode.USD);
        this.add(858, CurrencyCode.UYU);
        this.add(860, CurrencyCode.UZS);
        this.add(928, CurrencyCode.VES);
        this.add(704, CurrencyCode.VND);
        this.add(548, CurrencyCode.VUV);
        this.add(882, CurrencyCode.WST);
        this.add(950, CurrencyCode.XAF);
        this.add(951, CurrencyCode.XCD);
        this.add(952, CurrencyCode.XOF);
        this.add(953, CurrencyCode.XPF);
        this.add(999, CurrencyCode.XXX);
        this.add(886, CurrencyCode.YER);
        this.add(710, CurrencyCode.ZAR);
        this.add(967, CurrencyCode.ZMW);
        this.add(932, CurrencyCode.ZWL);
    }
}

