/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.base.Ascii;
import com.google.common.base.Converter;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;

public class Iso6392Converters {
    private static final LanguageCodeEquivalence[] LANGUAGE_CODE_EQUIVALENCES = new LanguageCodeEquivalence[]{Iso6392Converters.add("aar", "aar", "aa"), Iso6392Converters.add("abk", "abk", "ab"), Iso6392Converters.add("afr", "afr", "af"), Iso6392Converters.add("aka", "aka", "ak"), Iso6392Converters.add("amh", "amh", "am"), Iso6392Converters.add("ara", "ara", "ar"), Iso6392Converters.add("arg", "arg", "an"), Iso6392Converters.add("asm", "asm", "as"), Iso6392Converters.add("ava", "ava", "av"), Iso6392Converters.add("ave", "ave", "ae"), Iso6392Converters.add("aym", "aym", "ay"), Iso6392Converters.add("aze", "aze", "az"), Iso6392Converters.add("bak", "bak", "ba"), Iso6392Converters.add("bam", "bam", "bm"), Iso6392Converters.add("bel", "bel", "be"), Iso6392Converters.add("ben", "ben", "bn"), Iso6392Converters.add("bih", "bih", "bh"), Iso6392Converters.add("bis", "bis", "bi"), Iso6392Converters.add("tib", "bod", "bo"), Iso6392Converters.add("bos", "bos", "bs"), Iso6392Converters.add("bre", "bre", "br"), Iso6392Converters.add("bul", "bul", "bg"), Iso6392Converters.add("cat", "cat", "ca"), Iso6392Converters.add("cze", "ces", "cs"), Iso6392Converters.add("cha", "cha", "ch"), Iso6392Converters.add("che", "che", "ce"), Iso6392Converters.add("chu", "chu", "cu"), Iso6392Converters.add("chv", "chv", "cv"), Iso6392Converters.add("cor", "cor", "kw"), Iso6392Converters.add("cos", "cos", "co"), Iso6392Converters.add("cre", "cre", "cr"), Iso6392Converters.add("wel", "cym", "cy"), Iso6392Converters.add("dan", "dan", "da"), Iso6392Converters.add("ger", "deu", "de"), Iso6392Converters.add("div", "div", "dv"), Iso6392Converters.add("dzo", "dzo", "dz"), Iso6392Converters.add("gre", "ell", "el"), Iso6392Converters.add("eng", "eng", "en"), Iso6392Converters.add("epo", "epo", "eo"), Iso6392Converters.add("est", "est", "et"), Iso6392Converters.add("baq", "eus", "eu"), Iso6392Converters.add("ewe", "ewe", "ee"), Iso6392Converters.add("fao", "fao", "fo"), Iso6392Converters.add("per", "fas", "fa"), Iso6392Converters.add("fij", "fij", "fj"), Iso6392Converters.add("fin", "fin", "fi"), Iso6392Converters.add("fre", "fra", "fr"), Iso6392Converters.add("fry", "fry", "fy"), Iso6392Converters.add("ful", "ful", "ff"), Iso6392Converters.add("gla", "gla", "gd"), Iso6392Converters.add("gle", "gle", "ga"), Iso6392Converters.add("glg", "glg", "gl"), Iso6392Converters.add("glv", "glv", "gv"), Iso6392Converters.add("grn", "grn", "gn"), Iso6392Converters.add("guj", "guj", "gu"), Iso6392Converters.add("hat", "hat", "ht"), Iso6392Converters.add("hau", "hau", "ha"), Iso6392Converters.add("hbs", "hbs", "sh"), Iso6392Converters.add("heb", "heb", "iw"), Iso6392Converters.add("her", "her", "hz"), Iso6392Converters.add("hin", "hin", "hi"), Iso6392Converters.add("hmo", "hmo", "ho"), Iso6392Converters.add("hrv", "hrv", "hr"), Iso6392Converters.add("hun", "hun", "hu"), Iso6392Converters.add("arm", "hye", "hy"), Iso6392Converters.add("ibo", "ibo", "ig"), Iso6392Converters.add("ido", "ido", "io"), Iso6392Converters.add("iii", "iii", "ii"), Iso6392Converters.add("iku", "iku", "iu"), Iso6392Converters.add("ile", "ile", "ie"), Iso6392Converters.add("ina", "ina", "ia"), Iso6392Converters.add("ind", "ind", "id"), Iso6392Converters.add("ipk", "ipk", "ik"), Iso6392Converters.add("ice", "isl", "is"), Iso6392Converters.add("ita", "ita", "it"), Iso6392Converters.add("jav", "jav", "jv"), Iso6392Converters.add("jpn", "jpn", "ja"), Iso6392Converters.add("kal", "kal", "kl"), Iso6392Converters.add("kan", "kan", "kn"), Iso6392Converters.add("kas", "kas", "ks"), Iso6392Converters.add("geo", "kat", "ka"), Iso6392Converters.add("kau", "kau", "kr"), Iso6392Converters.add("kaz", "kaz", "kk"), Iso6392Converters.add("khm", "khm", "km"), Iso6392Converters.add("kik", "kik", "ki"), Iso6392Converters.add("kin", "kin", "rw"), Iso6392Converters.add("kir", "kir", "ky"), Iso6392Converters.add("kom", "kom", "kv"), Iso6392Converters.add("kon", "kon", "kg"), Iso6392Converters.add("kor", "kor", "ko"), Iso6392Converters.add("kua", "kua", "kj"), Iso6392Converters.add("kur", "kur", "ku"), Iso6392Converters.add("lao", "lao", "lo"), Iso6392Converters.add("lat", "lat", "la"), Iso6392Converters.add("lav", "lav", "lv"), Iso6392Converters.add("lim", "lim", "li"), Iso6392Converters.add("lin", "lin", "ln"), Iso6392Converters.add("lit", "lit", "lt"), Iso6392Converters.add("ltz", "ltz", "lb"), Iso6392Converters.add("lub", "lub", "lu"), Iso6392Converters.add("lug", "lug", "lg"), Iso6392Converters.add("mah", "mah", "mh"), Iso6392Converters.add("mal", "mal", "ml"), Iso6392Converters.add("mar", "mar", "mr"), Iso6392Converters.add("mac", "mkd", "mk"), Iso6392Converters.add("mlg", "mlg", "mg"), Iso6392Converters.add("mlt", "mlt", "mt"), Iso6392Converters.add("mol", "mol", "mo"), Iso6392Converters.add("mon", "mon", "mn"), Iso6392Converters.add("mao", "mri", "mi"), Iso6392Converters.add("may", "msa", "ms"), Iso6392Converters.add("bur", "mya", "my"), Iso6392Converters.add("nau", "nau", "na"), Iso6392Converters.add("nav", "nav", "nv"), Iso6392Converters.add("nbl", "nbl", "nr"), Iso6392Converters.add("nde", "nde", "nd"), Iso6392Converters.add("ndo", "ndo", "ng"), Iso6392Converters.add("nep", "nep", "ne"), Iso6392Converters.add("dut", "nld", "nl"), Iso6392Converters.add("nno", "nno", "nn"), Iso6392Converters.add("nob", "nob", "nb"), Iso6392Converters.add("nor", "nor", "no"), Iso6392Converters.add("nya", "nya", "ny"), Iso6392Converters.add("oci", "oci", "oc"), Iso6392Converters.add("oji", "oji", "oj"), Iso6392Converters.add("ori", "ori", "or"), Iso6392Converters.add("orm", "orm", "om"), Iso6392Converters.add("oss", "oss", "os"), Iso6392Converters.add("pan", "pan", "pa"), Iso6392Converters.add("pli", "pli", "pi"), Iso6392Converters.add("pol", "pol", "pl"), Iso6392Converters.add("por", "por", "pt"), Iso6392Converters.add("pus", "pus", "ps"), Iso6392Converters.add("que", "que", "qu"), Iso6392Converters.add("roh", "roh", "rm"), Iso6392Converters.add("rum", "ron", "ro"), Iso6392Converters.add("run", "run", "rn"), Iso6392Converters.add("rus", "rus", "ru"), Iso6392Converters.add("sag", "sag", "sg"), Iso6392Converters.add("san", "san", "sa"), Iso6392Converters.add("sin", "sin", "si"), Iso6392Converters.add("slo", "slk", "sk"), Iso6392Converters.add("slv", "slv", "sl"), Iso6392Converters.add("sme", "sme", "se"), Iso6392Converters.add("smo", "smo", "sm"), Iso6392Converters.add("sna", "sna", "sn"), Iso6392Converters.add("snd", "snd", "sd"), Iso6392Converters.add("som", "som", "so"), Iso6392Converters.add("sot", "sot", "st"), Iso6392Converters.add("spa", "spa", "es"), Iso6392Converters.add("alb", "sqi", "sq"), Iso6392Converters.add("srd", "srd", "sc"), Iso6392Converters.add("srp", "srp", "sr"), Iso6392Converters.add("ssw", "ssw", "ss"), Iso6392Converters.add("sun", "sun", "su"), Iso6392Converters.add("swa", "swa", "sw"), Iso6392Converters.add("swe", "swe", "sv"), Iso6392Converters.add("tah", "tah", "ty"), Iso6392Converters.add("tam", "tam", "ta"), Iso6392Converters.add("tat", "tat", "tt"), Iso6392Converters.add("tel", "tel", "te"), Iso6392Converters.add("tgk", "tgk", "tg"), Iso6392Converters.add("tgl", "tgl", "tl"), Iso6392Converters.add("tha", "tha", "th"), Iso6392Converters.add("tir", "tir", "ti"), Iso6392Converters.add("ton", "ton", "to"), Iso6392Converters.add("tsn", "tsn", "tn"), Iso6392Converters.add("tso", "tso", "ts"), Iso6392Converters.add("tuk", "tuk", "tk"), Iso6392Converters.add("tur", "tur", "tr"), Iso6392Converters.add("twi", "twi", "tw"), Iso6392Converters.add("uig", "uig", "ug"), Iso6392Converters.add("ukr", "ukr", "uk"), Iso6392Converters.add("urd", "urd", "ur"), Iso6392Converters.add("uzb", "uzb", "uz"), Iso6392Converters.add("ven", "ven", "ve"), Iso6392Converters.add("vie", "vie", "vi"), Iso6392Converters.add("vol", "vol", "vo"), Iso6392Converters.add("wln", "wln", "wa"), Iso6392Converters.add("wol", "wol", "wo"), Iso6392Converters.add("xho", "xho", "xh"), Iso6392Converters.add("yid", "yid", "yi"), Iso6392Converters.add("yor", "yor", "yo"), Iso6392Converters.add("zha", "zha", "za"), Iso6392Converters.add("chi", "zho", "zh"), Iso6392Converters.add("zul", "zul", "zu")};
    private static final LanguageCodeEquivalence[] DEPRECATED_LANG_CODE_B_EQUIVALENCES = new LanguageCodeEquivalence[]{Iso6392Converters.add("scr", "hrv", "hr"), Iso6392Converters.add("scc", "srp", "sr")};

    private Iso6392Converters() {
    }

    private static LanguageCodeEquivalence add(String bibliographic, String terminological, String bcp47) {
        return new LanguageCodeEquivalence(bibliographic, terminological, bcp47);
    }

    private static class LanguageCodeEquivalence {
        private final String bibliographic;
        private final String terminological;
        private final String bcp47;

        private LanguageCodeEquivalence(String bibliographic, String terminological, String bcp47) {
            this.bibliographic = bibliographic;
            this.terminological = terminological;
            this.bcp47 = bcp47;
        }
    }

    public static final class TerminologicalConverter
    extends BaseConverter {
        public static final TerminologicalConverter CONVERTER = new TerminologicalConverter();

        private TerminologicalConverter() {
        }

        @Override
        protected String getAlpha3Code(LanguageCodeEquivalence languageCodeEquivalence) {
            return languageCodeEquivalence.terminological;
        }
    }

    public static final class BibliographicConverter
    extends BaseConverter {
        public static final BibliographicConverter CONVERTER = new BibliographicConverter();

        private BibliographicConverter() {
        }

        @Override
        protected String getAlpha3Code(LanguageCodeEquivalence languageCodeEquivalence) {
            return languageCodeEquivalence.bibliographic;
        }
    }

    private static abstract class BaseConverter
    implements CodeConverter<LanguageCode, String> {
        private final Converter<String, String> bimapConverter;
        private final Converter<String, String> dprctBimapConverter;

        protected BaseConverter() {
            HashBiMap<String, String> bimap = HashBiMap.create();
            for (LanguageCodeEquivalence languageCodeEquivalence : LANGUAGE_CODE_EQUIVALENCES) {
                bimap.put(this.getAlpha3Code(languageCodeEquivalence), languageCodeEquivalence.bcp47);
            }
            this.bimapConverter = Maps.asConverter(bimap);
            HashBiMap<String, String> dprctbimap = HashBiMap.create();
            for (LanguageCodeEquivalence dprctLangCodeEquivalence : DEPRECATED_LANG_CODE_B_EQUIVALENCES) {
                dprctbimap.put(this.getAlpha3Code(dprctLangCodeEquivalence), dprctLangCodeEquivalence.bcp47);
            }
            this.dprctBimapConverter = Maps.asConverter(dprctbimap);
        }

        protected abstract String getAlpha3Code(LanguageCodeEquivalence var1);

        @Override
        public LanguageCode getUnknown() {
            return LanguageCode.UNKNOWN;
        }

        @Override
        public CodeConverter.Status getStatusFromOther(String otherCode) {
            if ((otherCode = BaseConverter.toLowerCaseIfWellFormed(otherCode)) == null) {
                return CodeConverter.Status.ILL_FORMED;
            }
            LanguageCode languageCode = this.fromOther(otherCode);
            if (otherCode.equals("und")) {
                return languageCode.getStatus();
            }
            if (!languageCode.equals(LanguageCode.UNDEFINED)) {
                try {
                    this.dprctBimapConverter.convert(otherCode);
                    return CodeConverter.Status.NON_CANONICAL;
                }
                catch (IllegalArgumentException ea) {
                    return languageCode.getStatus();
                }
            }
            return CodeConverter.Status.INVALID;
        }

        @Override
        public CodeConverter.Status getStatus(LanguageCode code) {
            try {
                String otherCode = this.toOther(code);
                if (!otherCode.equals("und") || code.equals(LanguageCode.UNDEFINED)) {
                    return code.getStatus();
                }
                if (BaseConverter.toLowerCaseIfWellFormed(code.getLanguageSubtag().toString()) == null) {
                    return CodeConverter.Status.ILL_FORMED;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return CodeConverter.Status.INVALID;
        }

        @Override
        public String toOther(LanguageCode code) {
            LanguageCode canonicalLanguageCode = BaseConverter.toCanonicalLanguageCode(code.getLanguageSubtag());
            String language = canonicalLanguageCode.getLanguageSubtag().toString();
            try {
                return this.bimapConverter.reverse().convert(language);
            }
            catch (IllegalArgumentException ex) {
                if (canonicalLanguageCode.getStatus() == CodeConverter.Status.PRIVATE_USE || language.length() != 3) {
                    return "und";
                }
                return language;
            }
        }

        @Override
        public LanguageCode fromOther(String otherCode) {
            String languageCode;
            if ((otherCode = BaseConverter.toLowerCaseIfWellFormed(otherCode)) == null) {
                return this.getUnknown();
            }
            try {
                languageCode = this.bimapConverter.convert(otherCode);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                try {
                    languageCode = this.dprctBimapConverter.convert(otherCode);
                }
                catch (IllegalArgumentException | NullPointerException excp) {
                    languageCode = otherCode;
                }
            }
            try {
                return LanguageCode.forString(languageCode);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return this.getUnknown();
            }
        }

        private static LanguageCode toCanonicalLanguageCode(LanguageCode code) {
            if (!code.isCanonical()) {
                return LanguageCode.forString(code.toString());
            }
            return code;
        }

        private static String toLowerCaseIfWellFormed(String code) {
            String lower;
            if (code.length() == 3 && 'a' <= (lower = Ascii.toLowerCase(code)).charAt(0) && lower.charAt(0) <= 'z' && 'a' <= lower.charAt(1) && lower.charAt(1) <= 'z' && 'a' <= lower.charAt(2) && lower.charAt(2) <= 'z') {
                return lower;
            }
            return null;
        }
    }
}

