/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

public class JavaLocaleConverter
implements CodeConverter<LanguageCode, Locale> {
    public static final JavaLocaleConverter CONVERTER = new JavaLocaleConverter();
    private static final Locale JA_JP_JP = new Locale("ja", "JP", "JP");
    private static final Locale TH_TH_TH = new Locale("th", "TH", "TH");
    private static final Locale UND = new Locale("und");
    private static boolean isJava7OrLater = "1.7".compareTo(System.getProperty("java.specification.version")) <= 0;

    @Override
    public Locale toOther(LanguageCode languageCode) {
        if (LanguageCode.UNDEFINED.equals(languageCode)) {
            return UND;
        }
        if (!JavaLocaleConverter.isBcp47Locale()) {
            RegionCode region = languageCode.getRegionSubtag();
            if (languageCode.getStatus() == CodeConverter.Status.PRIVATE_USE && (null == region || region.getStatus() != CodeConverter.Status.PRIVATE_USE)) {
                return new Locale(languageCode.toString());
            }
        }
        Locale locale = ULocaleConverter.CONVERTER.toOther(languageCode).toLocale();
        if (LanguageCode.UNDEFINED.equals(languageCode.getLanguageSubtag())) {
            return new Locale.Builder().setLocale(locale).setLanguage(UND.getLanguage()).build();
        }
        return locale;
    }

    @Override
    public LanguageCode fromOther(Locale locale) {
        if (JA_JP_JP.equals(locale)) {
            return LanguageCode.forString("ja-JP@calendar=japanese");
        }
        if (TH_TH_TH.equals(locale)) {
            return LanguageCode.forString("th-TH@numbers=thai");
        }
        if (!JavaLocaleConverter.isBcp47Locale()) {
            ULocale ulocale = ULocale.forLocale(locale);
            if (!"".equals(ulocale.getCountry())) {
                try {
                    LanguageCode languageCodeForExtlang = LanguageCode.forString(locale.toString());
                    if (null == languageCodeForExtlang.getRegionSubtag() || !ulocale.getCountry().equals(languageCodeForExtlang.getRegionSubtag().toString())) {
                        return languageCodeForExtlang;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return ULocaleConverter.CONVERTER.fromOther(ulocale);
        }
        return ULocaleConverter.CONVERTER.fromOther(ULocale.forLocale(locale));
    }

    @Override
    public CodeConverter.Status getStatusFromOther(Locale locale) {
        return ULocaleConverter.CONVERTER.getStatusFromOther(ULocale.forLocale(locale));
    }

    @Override
    public CodeConverter.Status getStatus(LanguageCode languageCode) {
        return ULocaleConverter.CONVERTER.getStatus(languageCode);
    }

    @Override
    public LanguageCode getUnknown() {
        return LanguageCode.UNKNOWN;
    }

    protected static boolean isBcp47Locale() {
        return isJava7OrLater;
    }
}

