/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Maps;
import java.util.Set;
import java.util.SortedMap;

@Deprecated
@GwtCompatible(serializable=false, emulated=false)
public enum Language {
    ENGLISH("ENGLISH", "en", "eng", null),
    DANISH("DANISH", "da", "dan", null),
    DUTCH("DUTCH", "nl", "dut", null),
    FINNISH("FINNISH", "fi", "fin", null),
    FRENCH("FRENCH", "fr", "fre", null),
    GERMAN("GERMAN", "de", "ger", null),
    HEBREW("HEBREW", "iw", "heb", "he"),
    ITALIAN("ITALIAN", "it", "ita", null),
    JAPANESE("Japanese", "ja", "jpn", null),
    KOREAN("Korean", "ko", "kor", null),
    NORWEGIAN("NORWEGIAN", "no", "nor", "nb"),
    POLISH("POLISH", "pl", "pol", null),
    PORTUGUESE("PORTUGUESE", "pt", "por", null),
    RUSSIAN("RUSSIAN", "ru", "rus", null),
    SPANISH("SPANISH", "es", "spa", null),
    SWEDISH("SWEDISH", "sv", "swe", null),
    CHINESE("Chinese", "zh", "chi", "zh-CN"),
    CZECH("CZECH", "cs", "cze", null),
    GREEK("GREEK", "el", "gre", null),
    ICELANDIC("ICELANDIC", "is", "ice", null),
    LATVIAN("LATVIAN", "lv", "lav", null),
    LITHUANIAN("LITHUANIAN", "lt", "lit", null),
    ROMANIAN("ROMANIAN", "ro", "rum", null),
    HUNGARIAN("HUNGARIAN", "hu", "hun", null),
    ESTONIAN("ESTONIAN", "et", "est", null),
    TG_UNKNOWN_LANGUAGE("TG_UNKNOWN_LANGUAGE", null, null, "ut"),
    UNKNOWN_LANGUAGE("Unknown", null, null, "un"),
    BULGARIAN("BULGARIAN", "bg", "bul", null),
    CROATIAN("CROATIAN", "hr", "scr", null),
    SERBIAN("SERBIAN", "sr", "scc", null),
    IRISH("IRISH", "ga", "gle", null),
    GALICIAN("GALICIAN", "gl", "glg", null),
    TAGALOG("TAGALOG", "tl", "tgl", "fil"),
    TURKISH("TURKISH", "tr", "tur", null),
    UKRAINIAN("UKRAINIAN", "uk", "ukr", null),
    HINDI("HINDI", "hi", "hin", null),
    MACEDONIAN("MACEDONIAN", "mk", "mac", null),
    BENGALI("BENGALI", "bn", "ben", null),
    INDONESIAN("INDONESIAN", "id", "ind", "in"),
    LATIN("LATIN", "la", "lat", null),
    MALAY("MALAY", "ms", "may", null),
    MALAYALAM("MALAYALAM", "ml", "mal", null),
    WELSH("WELSH", "cy", "wel", null),
    NEPALI("NEPALI", "ne", "nep", null),
    TELUGU("TELUGU", "te", "tel", null),
    ALBANIAN("ALBANIAN", "sq", "alb", null),
    TAMIL("TAMIL", "ta", "tam", null),
    BELARUSIAN("BELARUSIAN", "be", "bel", null),
    JAVANESE("JAVANESE", "jw", "jav", "jv"),
    OCCITAN("OCCITAN", "oc", "oci", null),
    URDU("URDU", "ur", "urd", null),
    BIHARI("BIHARI", "bh", "bih", null),
    GUJARATI("GUJARATI", "gu", "guj", null),
    THAI("THAI", "th", "tha", null),
    ARABIC("ARABIC", "ar", "ara", null),
    CATALAN("CATALAN", "ca", "cat", null),
    ESPERANTO("ESPERANTO", "eo", "epo", null),
    BASQUE("BASQUE", "eu", "baq", null),
    INTERLINGUA("INTERLINGUA", "ia", "ina", null),
    KANNADA("KANNADA", "kn", "kan", null),
    PUNJABI("PUNJABI", "pa", "pan", null),
    SCOTS_GAELIC("SCOTS_GAELIC", "gd", "gla", null),
    SWAHILI("SWAHILI", "sw", "swa", null),
    SLOVENIAN("SLOVENIAN", "sl", "slv", null),
    MARATHI("MARATHI", "mr", "mar", null),
    MALTESE("MALTESE", "mt", "mlt", null),
    VIETNAMESE("VIETNAMESE", "vi", "vie", null),
    FRISIAN("FRISIAN", "fy", "fry", null),
    SLOVAK("SLOVAK", "sk", "slo", null),
    CHINESE_T("ChineseT", null, null, "zh-TW"),
    FAROESE("FAROESE", "fo", "fao", null),
    SUNDANESE("SUNDANESE", "su", "sun", null),
    UZBEK("UZBEK", "uz", "uzb", null),
    AMHARIC("AMHARIC", "am", "amh", null),
    AZERBAIJANI("AZERBAIJANI", "az", "aze", null),
    GEORGIAN("GEORGIAN", "ka", "geo", null),
    TIGRINYA("TIGRINYA", "ti", "tir", null),
    PERSIAN("PERSIAN", "fa", "per", null),
    BOSNIAN("BOSNIAN", "bs", "bos", null),
    SINHALESE("SINHALESE", "si", "sin", null),
    NORWEGIAN_N("NORWEGIAN_N", "nn", "nno", null),
    PORTUGUESE_P("PORTUGUESE_P", null, null, "pt-PT"),
    PORTUGUESE_B("PORTUGUESE_B", null, null, "pt-BR"),
    XHOSA("XHOSA", "xh", "xho", null),
    ZULU("ZULU", "zu", "zul", null),
    GUARANI("GUARANI", "gn", "grn", null),
    SESOTHO("SESOTHO", "st", "sot", null),
    TURKMEN("TURKMEN", "tk", "tuk", null),
    KYRGYZ("KYRGYZ", "ky", "kir", null),
    BRETON("BRETON", "br", "bre", null),
    TWI("TWI", "tw", "twi", null),
    YIDDISH("YIDDISH", "yi", "yid", "ji"),
    SERBO_CROATIAN("SERBO_CROATIAN", "sh", null, "sr-Latn"),
    SOMALI("SOMALI", "so", "som", null),
    UIGHUR("UIGHUR", "ug", "uig", null),
    KURDISH("KURDISH", "ku", "kur", null),
    MONGOLIAN("MONGOLIAN", "mn", "mon", null),
    ARMENIAN("ARMENIAN", "hy", "arm", null),
    LAOTHIAN("LAOTHIAN", "lo", "lao", null),
    SINDHI("SINDHI", "sd", "snd", null),
    RHAETO_ROMANCE("RHAETO_ROMANCE", "rm", "roh", null),
    AFRIKAANS("AFRIKAANS", "af", "afr", null),
    LUXEMBOURGISH("LUXEMBOURGISH", "lb", "ltz", null),
    BURMESE("BURMESE", "my", "bur", null),
    KHMER("KHMER", "km", "khm", null),
    TIBETAN("TIBETAN", "bo", "tib", null),
    DHIVEHI("DHIVEHI", "dv", "div", null),
    CHEROKEE("CHEROKEE", null, "chr", null),
    SYRIAC("SYRIAC", null, "syr", null),
    LIMBU("LIMBU", null, null, "sit-NP"),
    ORIYA("ORIYA", "or", "ori", null),
    ASSAMESE("ASSAMESE", "as", "asm", null),
    CORSICAN("CORSICAN", "co", "cos", null),
    INTERLINGUE("INTERLINGUE", "ie", "ine", null),
    KAZAKH("KAZAKH", "kk", "kaz", null),
    LINGALA("LINGALA", "ln", "lin", null),
    MOLDAVIAN("MOLDAVIAN", "mo", "mol", "ro-MD"),
    PASHTO("PASHTO", "ps", "pus", null),
    QUECHUA("QUECHUA", "qu", "que", null),
    SHONA("SHONA", "sn", "sna", null),
    TAJIK("TAJIK", "tg", "tgk", null),
    TATAR("TATAR", "tt", "tat", null),
    TONGA("TONGA", "to", "tog", null),
    YORUBA("YORUBA", "yo", "yor", null),
    CREOLES_AND_PIDGINS_ENGLISH_BASED("CREOLES_AND_PIDGINS_ENGLISH_BASED", null, "cpe", null),
    CREOLES_AND_PIDGINS_FRENCH_BASED("CREOLES_AND_PIDGINS_FRENCH_BASED", null, "cpf", null),
    CREOLES_AND_PIDGINS_PORTUGUESE_BASED("CREOLES_AND_PIDGINS_PORTUGUESE_BASED", null, "cpp", null),
    CREOLES_AND_PIDGINS_OTHER("CREOLES_AND_PIDGINS_OTHER", null, "crp", null),
    MAORI("MAORI", "mi", "mao", null),
    WOLOF("WOLOF", "wo", "wol", null),
    ABKHAZIAN("ABKHAZIAN", "ab", "abk", null),
    AFAR("AFAR", "aa", "aar", null),
    AYMARA("AYMARA", "ay", "aym", null),
    BASHKIR("BASHKIR", "ba", "bak", null),
    BISLAMA("BISLAMA", "bi", "bis", null),
    DZONGKHA("DZONGKHA", "dz", "dzo", null),
    FIJIAN("FIJIAN", "fj", "fij", null),
    GREENLANDIC("GREENLANDIC", "kl", "kal", null),
    HAUSA("HAUSA", "ha", "hau", null),
    HAITIAN_CREOLE("HAITIAN_CREOLE", "ht", "hat", null),
    INUPIAK("INUPIAK", "ik", "ipk", null),
    INUKTITUT("INUKTITUT", "iu", "iku", null),
    KASHMIRI("KASHMIRI", "ks", "kas", null),
    KINYARWANDA("KINYARWANDA", "rw", "kin", null),
    MALAGASY("MALAGASY", "mg", "mlg", null),
    NAURU("NAURU", "na", "nau", null),
    OROMO("OROMO", "om", "orm", null),
    RUNDI("RUNDI", "rn", "run", null),
    SAMOAN("SAMOAN", "sm", "smo", null),
    SANGO("SANGO", "sg", "sag", null),
    SANSKRIT("SANSKRIT", "sa", "san", null),
    SISWANT("SISWANT", "ss", "ssw", null),
    TSONGA("TSONGA", "ts", "tso", null),
    TSWANA("TSWANA", "tn", "tsn", null),
    VOLAPUK("VOLAPUK", "vo", "vol", null),
    ZHUANG("ZHUANG", "za", "zha", null),
    KHASI("KHASI", null, "kha", null),
    SCOTS("SCOTS", null, "sco", null),
    GANDA("GANDA", "lg", "lug", null),
    MANX("MANX", "gv", "glv", null),
    MONTENEGRIN("MONTENEGRIN", null, null, "sr-ME"),
    AKAN("AKAN", "ak", "aka", null),
    IGBO("IGBO", "ig", "ibo", null),
    MAURITIAN_CREOLE("MAURITIAN_CREOLE", null, "mfe", null),
    HAWAIIAN("HAWAIIAN", null, "haw", null),
    CEBUANO("CEBUANO", null, "ceb", null),
    EWE("EWE", "ee", "ewe", null),
    GA("GA", null, "gaa", null),
    HMONG("HMONG", null, "hmn", null),
    KRIO("KRIO", null, "kri", null),
    LOZI("LOZI", null, "loz", null),
    LUBA_LULUA("LUBA_LULUA", null, "lua", null),
    LUO_KENYA_AND_TANZANIA("LUO_KENYA_AND_TANZANIA", null, "luo", null),
    NEWARI("NEWARI", null, "new", null),
    NYANJA("NYANJA", "ny", "nya", null),
    OSSETIAN("OSSETIAN", "os", "oss", null),
    PAMPANGA("PAMPANGA", null, "pam", null),
    PEDI("PEDI", null, "nso", null),
    RAJASTHANI("RAJASTHANI", null, "raj", null),
    SESELWA_CREOLE_FRENCH("SESELWA_CREOLE_FRENCH", null, "crs", null),
    TUMBUKA("TUMBUKA", null, "tum", null),
    VENDA("VENDA", "ve", "ven", null),
    WARAY_PHILIPPINES("WARAY_PHILIPPINES", null, "war", null);

    private static final Language[] i18nValues;
    private static SortedMap<String, Language> nameToLangMap;
    private final String googLangName;
    private final String code639x1;
    private final String code639x2;
    private final String codeWithDialect;

    private Language(String googLangName, String code639x1, String code639x2, String codeWithDialect) {
        this.googLangName = googLangName;
        this.code639x1 = code639x1;
        this.code639x2 = code639x2;
        this.codeWithDialect = codeWithDialect;
    }

    public static int getNumLanguages() {
        return i18nValues.length;
    }

    public static Language forOrdinal(int ord) {
        return 0 <= ord && ord < i18nValues.length ? i18nValues[ord] : null;
    }

    public String toGoogleLanguageName() {
        return this.googLangName;
    }

    @Deprecated
    public String getCode() {
        String code = this.getCode639_1();
        if (code == null && (code = this.getCode639_2()) == null) {
            code = this.getCodeWithDialect();
        }
        return code;
    }

    public String getCode639_1() {
        return this.code639x1;
    }

    String getCode639_2() {
        return this.code639x2;
    }

    public String getCodeWithDialect() {
        return this.codeWithDialect;
    }

    public String toString() {
        return super.toString();
    }

    public static Set<String> getSortedGoogleLanguageNames() {
        return nameToLangMap.keySet();
    }

    public boolean isCjkLanguage() {
        return this == CHINESE || this == CHINESE_T || this == JAPANESE || this == KOREAN;
    }

    public static Language forGoogleLanguageName(String googleLangName) throws IllegalArgumentException {
        if (!nameToLangMap.containsKey(googleLangName)) {
            throw new IllegalArgumentException(String.valueOf(googleLangName).concat(" is not a valid language name."));
        }
        return (Language)((Object)nameToLangMap.get(googleLangName));
    }

    static {
        i18nValues = Language.values();
        nameToLangMap = Maps.newTreeMap();
        for (Language l : i18nValues) {
            nameToLangMap.put(l.toGoogleLanguageName(), l);
        }
    }
}

