/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.i18n.identifiers.CodeConverter;
import java.util.Map;

@GwtCompatible
public enum RegionCode {
    AC,
    AD,
    AE,
    AF,
    AG,
    AI,
    AL,
    AM,
    AN,
    AO,
    AQ,
    AR,
    AS,
    AT,
    AU,
    AW,
    AX,
    AZ,
    BA,
    BB,
    BD,
    BE,
    BF,
    BG,
    BH,
    BI,
    BJ,
    BL,
    BM,
    BN,
    BO,
    BQ,
    BR,
    BS,
    BT,
    BU,
    BV,
    BW,
    BY,
    BZ,
    CA,
    CC,
    CD,
    CF,
    CG,
    CH,
    CI,
    CK,
    CL,
    CM,
    CN,
    CO,
    CP,
    CR,
    CS,
    CU,
    CV,
    CW,
    CX,
    CY,
    CZ,
    DD,
    DE,
    DG,
    DJ,
    DK,
    DM,
    DO,
    DZ,
    EA,
    EC,
    EE,
    EG,
    EH,
    ER,
    ES,
    ET,
    EU,
    EZ,
    FI,
    FJ,
    FK,
    FM,
    FO,
    FR,
    FX,
    GA,
    GB,
    GD,
    GE,
    GF,
    GG,
    GH,
    GI,
    GL,
    GM,
    GN,
    GP,
    GQ,
    GR,
    GS,
    GT,
    GU,
    GW,
    GY,
    HK,
    HM,
    HN,
    HR,
    HT,
    HU,
    IC,
    ID,
    IE,
    IL,
    IM,
    IN,
    IO,
    IQ,
    IR,
    IS,
    IT,
    JE,
    JM,
    JO,
    JP,
    KE,
    KG,
    KH,
    KI,
    KM,
    KN,
    KP,
    KR,
    KW,
    KY,
    KZ,
    LA,
    LB,
    LC,
    LI,
    LK,
    LR,
    LS,
    LT,
    LU,
    LV,
    LY,
    MA,
    MC,
    MD,
    ME,
    MF,
    MG,
    MH,
    MK,
    ML,
    MM,
    MN,
    MO,
    MP,
    MQ,
    MR,
    MS,
    MT,
    MU,
    MV,
    MW,
    MX,
    MY,
    MZ,
    NA,
    NC,
    NE,
    NF,
    NG,
    NI,
    NL,
    NO,
    NP,
    NR,
    NT,
    NU,
    NZ,
    OM,
    PA,
    PE,
    PF,
    PG,
    PH,
    PK,
    PL,
    PM,
    PN,
    PR,
    PS,
    PT,
    PW,
    PY,
    QA,
    QO,
    QU,
    RE,
    RO,
    RS,
    RU,
    RW,
    SA,
    SB,
    SC,
    SD,
    SE,
    SG,
    SH,
    SI,
    SJ,
    SK,
    SL,
    SM,
    SN,
    SO,
    SR,
    SS,
    ST,
    SU,
    SV,
    SX,
    SY,
    SZ,
    TA,
    TC,
    TD,
    TF,
    TG,
    TH,
    TJ,
    TK,
    TL,
    TM,
    TN,
    TO,
    TP,
    TR,
    TT,
    TV,
    TW,
    TZ,
    UA,
    UG,
    UM,
    UN,
    US,
    UY,
    UZ,
    VA,
    VC,
    VE,
    VG,
    VI,
    VN,
    VU,
    WF,
    WS,
    XA,
    XB,
    XC,
    XK,
    YD,
    YE,
    YT,
    YU,
    ZA,
    ZM,
    ZR,
    ZW,
    ZZ,
    UN001,
    UN002,
    UN003,
    UN005,
    UN009,
    UN011,
    UN013,
    UN014,
    UN015,
    UN017,
    UN018,
    UN019,
    UN021,
    UN029,
    UN030,
    UN034,
    UN035,
    UN039,
    UN053,
    UN054,
    UN057,
    UN061,
    UN142,
    UN143,
    UN145,
    UN150,
    UN151,
    UN154,
    UN155,
    UN202,
    UN419;

    private static final ImmutableSet<RegionCode> NON_CANONICAL;
    private static final ImmutableSet<RegionCode> GOOGLE_VARIANTS;
    private static final Map<String, RegionCode> CLDR_TO_ENUM;
    private final String stringForm = this.name().replaceFirst("^UN(?=\\d)", "");

    public String toString() {
        return this.stringForm;
    }

    private static RegionCode forStringOrNull(String cldrCode) {
        String upperCaseCldrCode = Ascii.toUpperCase(cldrCode);
        return CLDR_TO_ENUM.get(upperCaseCldrCode);
    }

    public static RegionCode forString(String cldrCode) {
        RegionCode result = RegionCode.forStringOrNull(cldrCode);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(cldrCode).length()).append("'").append(cldrCode).append("' is not a valid CLDR region code.").toString());
    }

    public static RegionCode forStringOrUnknown(String cldrCode) {
        RegionCode result = RegionCode.forStringOrNull(cldrCode);
        return result != null ? result : ZZ;
    }

    public static RegionCode getWorld() {
        return UN001;
    }

    public static RegionCode getUnknown() {
        return ZZ;
    }

    public boolean isUnknown() {
        return this == ZZ;
    }

    public boolean isCanonical() {
        return this.getStatus() == CodeConverter.Status.CANONICAL;
    }

    public CodeConverter.Status getStatus() {
        if (GOOGLE_VARIANTS.contains((Object)this)) {
            return CodeConverter.Status.PRIVATE_USE;
        }
        if (NON_CANONICAL.contains((Object)this)) {
            return CodeConverter.Status.NON_CANONICAL;
        }
        return CodeConverter.Status.CANONICAL;
    }

    static {
        NON_CANONICAL = ImmutableSet.of(AN, BU, CS, DD, FX, NT, new RegionCode[]{QU, SU, TP, YD, YU, ZR});
        GOOGLE_VARIANTS = ImmutableSet.of(XA, XB, XC);
        RegionCode[] values = RegionCode.values();
        ImmutableMap.Builder<String, RegionCode> builder = ImmutableMap.builder();
        for (RegionCode r : values) {
            builder.put(r.toString(), r);
        }
        builder.put("UK", GB);
        CLDR_TO_ENUM = builder.build();
    }
}

