/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers;

import com.google.i18n.identifiers.BasicCodeConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.RegionCode;

public final class UnM49RegionConverter
extends BasicCodeConverter<RegionCode, Integer> {
    public static final UnM49RegionConverter CONVERTER = new UnM49RegionConverter();

    @Override
    public RegionCode getUnknown() {
        return RegionCode.ZZ;
    }

    @Override
    public CodeConverter.Status getStatusFromOther(Integer otherCode) {
        if (otherCode < 0 || otherCode > 999) {
            return CodeConverter.Status.ILL_FORMED;
        }
        RegionCode regionCode = (RegionCode)((Object)this.mapFromString.get(otherCode));
        if (regionCode != null) {
            if (otherCode >= 900) {
                if (otherCode == 961) {
                    return CodeConverter.Status.CANONICAL;
                }
                if (otherCode == 967) {
                    return CodeConverter.Status.CANONICAL;
                }
                return CodeConverter.Status.PRIVATE_USE;
            }
            if (otherCode.intValue() != ((Integer)this.mapToString.get((Object)regionCode)).intValue()) {
                return CodeConverter.Status.NON_CANONICAL;
            }
            return regionCode.isCanonical() ? CodeConverter.Status.CANONICAL : CodeConverter.Status.NON_CANONICAL;
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public CodeConverter.Status getStatus(RegionCode googleCode) {
        CodeConverter.Status googleStatus = googleCode.getStatus();
        if (googleStatus == CodeConverter.Status.PRIVATE_USE) {
            return CodeConverter.Status.PRIVATE_USE;
        }
        Integer unm49code = (Integer)this.mapToString.get((Object)googleCode);
        if (unm49code == null) {
            return CodeConverter.Status.INVALID;
        }
        if (unm49code >= 900) {
            if (unm49code == 961) {
                return CodeConverter.Status.CANONICAL;
            }
            if (unm49code == 967) {
                return CodeConverter.Status.CANONICAL;
            }
            return CodeConverter.Status.PRIVATE_USE;
        }
        return googleStatus;
    }

    private UnM49RegionConverter() {
        this.add(104, RegionCode.BU);
        this.add(280, RegionCode.DE);
        this.add(230, RegionCode.ET);
        this.add(967, RegionCode.QU);
        this.add(736, RegionCode.SD);
        this.add(626, RegionCode.TP);
        this.add(886, RegionCode.YE);
        this.add(180, RegionCode.ZR);
        this.add(20, RegionCode.AD);
        this.add(784, RegionCode.AE);
        this.add(4, RegionCode.AF);
        this.add(28, RegionCode.AG);
        this.add(660, RegionCode.AI);
        this.add(8, RegionCode.AL);
        this.add(51, RegionCode.AM);
        this.add(530, RegionCode.AN);
        this.add(24, RegionCode.AO);
        this.add(10, RegionCode.AQ);
        this.add(32, RegionCode.AR);
        this.add(16, RegionCode.AS);
        this.add(40, RegionCode.AT);
        this.add(36, RegionCode.AU);
        this.add(533, RegionCode.AW);
        this.add(248, RegionCode.AX);
        this.add(31, RegionCode.AZ);
        this.add(70, RegionCode.BA);
        this.add(52, RegionCode.BB);
        this.add(50, RegionCode.BD);
        this.add(56, RegionCode.BE);
        this.add(854, RegionCode.BF);
        this.add(100, RegionCode.BG);
        this.add(48, RegionCode.BH);
        this.add(108, RegionCode.BI);
        this.add(204, RegionCode.BJ);
        this.add(652, RegionCode.BL);
        this.add(60, RegionCode.BM);
        this.add(96, RegionCode.BN);
        this.add(68, RegionCode.BO);
        this.add(535, RegionCode.BQ);
        this.add(76, RegionCode.BR);
        this.add(44, RegionCode.BS);
        this.add(64, RegionCode.BT);
        this.add(74, RegionCode.BV);
        this.add(72, RegionCode.BW);
        this.add(112, RegionCode.BY);
        this.add(84, RegionCode.BZ);
        this.add(124, RegionCode.CA);
        this.add(166, RegionCode.CC);
        this.add(180, RegionCode.CD);
        this.add(140, RegionCode.CF);
        this.add(178, RegionCode.CG);
        this.add(756, RegionCode.CH);
        this.add(384, RegionCode.CI);
        this.add(184, RegionCode.CK);
        this.add(152, RegionCode.CL);
        this.add(120, RegionCode.CM);
        this.add(156, RegionCode.CN);
        this.add(170, RegionCode.CO);
        this.add(188, RegionCode.CR);
        this.add(891, RegionCode.CS);
        this.add(192, RegionCode.CU);
        this.add(132, RegionCode.CV);
        this.add(531, RegionCode.CW);
        this.add(162, RegionCode.CX);
        this.add(196, RegionCode.CY);
        this.add(203, RegionCode.CZ);
        this.add(278, RegionCode.DD);
        this.add(276, RegionCode.DE);
        this.add(262, RegionCode.DJ);
        this.add(208, RegionCode.DK);
        this.add(212, RegionCode.DM);
        this.add(214, RegionCode.DO);
        this.add(12, RegionCode.DZ);
        this.add(218, RegionCode.EC);
        this.add(233, RegionCode.EE);
        this.add(818, RegionCode.EG);
        this.add(732, RegionCode.EH);
        this.add(232, RegionCode.ER);
        this.add(724, RegionCode.ES);
        this.add(231, RegionCode.ET);
        this.add(967, RegionCode.EU);
        this.add(246, RegionCode.FI);
        this.add(242, RegionCode.FJ);
        this.add(238, RegionCode.FK);
        this.add(583, RegionCode.FM);
        this.add(234, RegionCode.FO);
        this.add(250, RegionCode.FR);
        this.add(249, RegionCode.FX);
        this.add(266, RegionCode.GA);
        this.add(826, RegionCode.GB);
        this.add(308, RegionCode.GD);
        this.add(268, RegionCode.GE);
        this.add(254, RegionCode.GF);
        this.add(831, RegionCode.GG);
        this.add(288, RegionCode.GH);
        this.add(292, RegionCode.GI);
        this.add(304, RegionCode.GL);
        this.add(270, RegionCode.GM);
        this.add(324, RegionCode.GN);
        this.add(312, RegionCode.GP);
        this.add(226, RegionCode.GQ);
        this.add(300, RegionCode.GR);
        this.add(239, RegionCode.GS);
        this.add(320, RegionCode.GT);
        this.add(316, RegionCode.GU);
        this.add(624, RegionCode.GW);
        this.add(328, RegionCode.GY);
        this.add(344, RegionCode.HK);
        this.add(334, RegionCode.HM);
        this.add(340, RegionCode.HN);
        this.add(191, RegionCode.HR);
        this.add(332, RegionCode.HT);
        this.add(348, RegionCode.HU);
        this.add(360, RegionCode.ID);
        this.add(372, RegionCode.IE);
        this.add(376, RegionCode.IL);
        this.add(833, RegionCode.IM);
        this.add(356, RegionCode.IN);
        this.add(86, RegionCode.IO);
        this.add(368, RegionCode.IQ);
        this.add(364, RegionCode.IR);
        this.add(352, RegionCode.IS);
        this.add(380, RegionCode.IT);
        this.add(832, RegionCode.JE);
        this.add(388, RegionCode.JM);
        this.add(400, RegionCode.JO);
        this.add(392, RegionCode.JP);
        this.add(404, RegionCode.KE);
        this.add(417, RegionCode.KG);
        this.add(116, RegionCode.KH);
        this.add(296, RegionCode.KI);
        this.add(174, RegionCode.KM);
        this.add(659, RegionCode.KN);
        this.add(408, RegionCode.KP);
        this.add(410, RegionCode.KR);
        this.add(414, RegionCode.KW);
        this.add(136, RegionCode.KY);
        this.add(398, RegionCode.KZ);
        this.add(418, RegionCode.LA);
        this.add(422, RegionCode.LB);
        this.add(662, RegionCode.LC);
        this.add(438, RegionCode.LI);
        this.add(144, RegionCode.LK);
        this.add(430, RegionCode.LR);
        this.add(426, RegionCode.LS);
        this.add(440, RegionCode.LT);
        this.add(442, RegionCode.LU);
        this.add(428, RegionCode.LV);
        this.add(434, RegionCode.LY);
        this.add(504, RegionCode.MA);
        this.add(492, RegionCode.MC);
        this.add(498, RegionCode.MD);
        this.add(499, RegionCode.ME);
        this.add(663, RegionCode.MF);
        this.add(450, RegionCode.MG);
        this.add(584, RegionCode.MH);
        this.add(807, RegionCode.MK);
        this.add(466, RegionCode.ML);
        this.add(104, RegionCode.MM);
        this.add(496, RegionCode.MN);
        this.add(446, RegionCode.MO);
        this.add(580, RegionCode.MP);
        this.add(474, RegionCode.MQ);
        this.add(478, RegionCode.MR);
        this.add(500, RegionCode.MS);
        this.add(470, RegionCode.MT);
        this.add(480, RegionCode.MU);
        this.add(462, RegionCode.MV);
        this.add(454, RegionCode.MW);
        this.add(484, RegionCode.MX);
        this.add(458, RegionCode.MY);
        this.add(508, RegionCode.MZ);
        this.add(516, RegionCode.NA);
        this.add(540, RegionCode.NC);
        this.add(562, RegionCode.NE);
        this.add(574, RegionCode.NF);
        this.add(566, RegionCode.NG);
        this.add(558, RegionCode.NI);
        this.add(528, RegionCode.NL);
        this.add(578, RegionCode.NO);
        this.add(524, RegionCode.NP);
        this.add(520, RegionCode.NR);
        this.add(536, RegionCode.NT);
        this.add(570, RegionCode.NU);
        this.add(554, RegionCode.NZ);
        this.add(512, RegionCode.OM);
        this.add(591, RegionCode.PA);
        this.add(604, RegionCode.PE);
        this.add(258, RegionCode.PF);
        this.add(598, RegionCode.PG);
        this.add(608, RegionCode.PH);
        this.add(586, RegionCode.PK);
        this.add(616, RegionCode.PL);
        this.add(666, RegionCode.PM);
        this.add(612, RegionCode.PN);
        this.add(630, RegionCode.PR);
        this.add(275, RegionCode.PS);
        this.add(620, RegionCode.PT);
        this.add(585, RegionCode.PW);
        this.add(600, RegionCode.PY);
        this.add(634, RegionCode.QA);
        this.add(961, RegionCode.QO);
        this.add(638, RegionCode.RE);
        this.add(642, RegionCode.RO);
        this.add(688, RegionCode.RS);
        this.add(643, RegionCode.RU);
        this.add(646, RegionCode.RW);
        this.add(682, RegionCode.SA);
        this.add(90, RegionCode.SB);
        this.add(690, RegionCode.SC);
        this.add(729, RegionCode.SD);
        this.add(752, RegionCode.SE);
        this.add(702, RegionCode.SG);
        this.add(654, RegionCode.SH);
        this.add(705, RegionCode.SI);
        this.add(744, RegionCode.SJ);
        this.add(703, RegionCode.SK);
        this.add(694, RegionCode.SL);
        this.add(674, RegionCode.SM);
        this.add(686, RegionCode.SN);
        this.add(706, RegionCode.SO);
        this.add(740, RegionCode.SR);
        this.add(728, RegionCode.SS);
        this.add(678, RegionCode.ST);
        this.add(810, RegionCode.SU);
        this.add(222, RegionCode.SV);
        this.add(534, RegionCode.SX);
        this.add(760, RegionCode.SY);
        this.add(748, RegionCode.SZ);
        this.add(796, RegionCode.TC);
        this.add(148, RegionCode.TD);
        this.add(260, RegionCode.TF);
        this.add(768, RegionCode.TG);
        this.add(764, RegionCode.TH);
        this.add(762, RegionCode.TJ);
        this.add(772, RegionCode.TK);
        this.add(626, RegionCode.TL);
        this.add(795, RegionCode.TM);
        this.add(788, RegionCode.TN);
        this.add(776, RegionCode.TO);
        this.add(792, RegionCode.TR);
        this.add(780, RegionCode.TT);
        this.add(798, RegionCode.TV);
        this.add(158, RegionCode.TW);
        this.add(834, RegionCode.TZ);
        this.add(804, RegionCode.UA);
        this.add(800, RegionCode.UG);
        this.add(581, RegionCode.UM);
        this.add(840, RegionCode.US);
        this.add(858, RegionCode.UY);
        this.add(860, RegionCode.UZ);
        this.add(336, RegionCode.VA);
        this.add(670, RegionCode.VC);
        this.add(862, RegionCode.VE);
        this.add(92, RegionCode.VG);
        this.add(850, RegionCode.VI);
        this.add(704, RegionCode.VN);
        this.add(548, RegionCode.VU);
        this.add(876, RegionCode.WF);
        this.add(882, RegionCode.WS);
        this.add(973, RegionCode.XA);
        this.add(974, RegionCode.XB);
        this.add(975, RegionCode.XC);
        this.add(983, RegionCode.XK);
        this.add(720, RegionCode.YD);
        this.add(887, RegionCode.YE);
        this.add(175, RegionCode.YT);
        this.add(891, RegionCode.YU);
        this.add(710, RegionCode.ZA);
        this.add(894, RegionCode.ZM);
        this.add(716, RegionCode.ZW);
        this.add(999, RegionCode.ZZ);
        this.add(1, RegionCode.UN001);
        this.add(2, RegionCode.UN002);
        this.add(3, RegionCode.UN003);
        this.add(5, RegionCode.UN005);
        this.add(9, RegionCode.UN009);
        this.add(11, RegionCode.UN011);
        this.add(13, RegionCode.UN013);
        this.add(14, RegionCode.UN014);
        this.add(15, RegionCode.UN015);
        this.add(17, RegionCode.UN017);
        this.add(18, RegionCode.UN018);
        this.add(19, RegionCode.UN019);
        this.add(21, RegionCode.UN021);
        this.add(29, RegionCode.UN029);
        this.add(30, RegionCode.UN030);
        this.add(34, RegionCode.UN034);
        this.add(35, RegionCode.UN035);
        this.add(39, RegionCode.UN039);
        this.add(53, RegionCode.UN053);
        this.add(54, RegionCode.UN054);
        this.add(57, RegionCode.UN057);
        this.add(61, RegionCode.UN061);
        this.add(142, RegionCode.UN142);
        this.add(143, RegionCode.UN143);
        this.add(145, RegionCode.UN145);
        this.add(150, RegionCode.UN150);
        this.add(151, RegionCode.UN151);
        this.add(154, RegionCode.UN154);
        this.add(155, RegionCode.UN155);
        this.add(202, RegionCode.UN202);
        this.add(419, RegionCode.UN419);
    }
}

