/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.i18n.identifiers.CurrencyInfo;
import com.google.i18n.identifiers.LanguageInfo;
import com.google.i18n.identifiers.LanguageNameInfo;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.SubdivisionNameService;
import com.google.i18n.identifiers.SubdivisionRepository;
import com.google.i18n.identifiers.impl.CurrencyInfoImpl;
import com.google.i18n.identifiers.impl.LanguageNameInfoRecordSetProvider;
import com.google.i18n.identifiers.impl.LanguageScriptInfoRecordSetProvider;
import com.google.i18n.identifiers.impl.RealSubdivisionRepository;
import com.google.i18n.identifiers.impl.RegionCurrencyRecordSetProvider;
import com.google.i18n.identifiers.impl.StandardLanguageInfo;
import com.google.i18n.identifiers.impl.StandardLanguageInfoHashMapProvider;
import com.google.i18n.identifiers.impl.StandardLanguageNameInfo;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import com.google.i18n.identifiers.impl.StandardSubdivisionNameService;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class IdentifiersModule
extends AbstractModule {
    private static final Key<Reader> CURRENCY_INFO_KEY = Key.get(Reader.class, (Annotation)Names.named((String)"CurrencyInfo"));
    private static final Key<Reader> LANGUAGE_INFO_KEY = Key.get(Reader.class, (Annotation)Names.named((String)"LanguageInfo"));
    private static final Key<Reader> LANGUAGE_NAME_INFO_KEY = Key.get(Reader.class, (Annotation)Names.named((String)"LanguageNameInfo"));
    private static final Key<Reader> LANGUAGE_SCRIPT_INFO_KEY = Key.get(Reader.class, (Annotation)Names.named((String)"LanguageScriptInfo"));
    private static final Key<Reader> SUBDIVISION_DATA_KEY = Key.get(Reader.class, (Annotation)Names.named((String)"SubdivisionDataInfo"));

    protected void configure() {
        this.bind(CURRENCY_INFO_KEY).toProvider(CurrencyTableProvider.class);
        this.bind(LANGUAGE_INFO_KEY).toProvider(LanguageInfoTableProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String>>(this){}).annotatedWith((Annotation)Names.named((String)"StandardLanguageInfoMap")).toProvider(StandardLanguageInfoHashMapProvider.class).in(Singleton.class);
        this.bind(LANGUAGE_NAME_INFO_KEY).toProvider(LanguageNameTableProvider.class);
        this.bind(LANGUAGE_SCRIPT_INFO_KEY).toProvider(LanguageScriptTableProvider.class);
        this.bind(SUBDIVISION_DATA_KEY).toProvider(SubdivisionDataTableProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<CurrencyInfoImpl.RegionCurrencyRecord>>(this){}).toProvider(RegionCurrencyRecordSetProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<StandardLanguageNameInfo.LanguageNameInfoRecord>>(this){}).toProvider(LanguageNameInfoRecordSetProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<Set<StandardLanguageNameInfo.LanguageScriptInfoRecord>>(this){}).toProvider(LanguageScriptInfoRecordSetProvider.class);
        this.bind(CurrencyInfo.class).to(CurrencyInfoImpl.class);
        this.bind(CurrencyInfoImpl.class).in(Scopes.SINGLETON);
        this.bind(LanguageInfo.class).to(StandardLanguageInfo.class).in(Scopes.SINGLETON);
        this.bind(LanguageNameInfo.class).to(StandardLanguageNameInfo.class).in(Scopes.SINGLETON);
        this.bind(RegionInfo.class).to(StandardRegionInfo.class).in(Scopes.SINGLETON);
        this.bind(SubdivisionRepository.class).to(RealSubdivisionRepository.class).in(Scopes.SINGLETON);
        this.bind(SubdivisionNameService.class).to(StandardSubdivisionNameService.class).in(Scopes.SINGLETON);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other != null && ((Object)((Object)this)).getClass().equals(other.getClass());
    }

    static class SubdivisionDataTableProvider
    implements Provider<Reader> {
        @Inject
        public SubdivisionDataTableProvider() {
        }

        public Reader get() {
            try {
                return new InputStreamReader(SubdivisionDataTableProvider.class.getResourceAsStream("/i18n/identifiers/data/subdivisiondata.txt"), "UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class LanguageScriptTableProvider
    implements Provider<Reader> {
        @Inject
        public LanguageScriptTableProvider() {
        }

        public Reader get() {
            try {
                return new InputStreamReader(LanguageScriptTableProvider.class.getResourceAsStream("resources/languageScriptTable.txt"), "UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class LanguageNameTableProvider
    implements Provider<Reader> {
        @Inject
        public LanguageNameTableProvider() {
        }

        public Reader get() {
            try {
                return new InputStreamReader(LanguageNameTableProvider.class.getResourceAsStream("resources/languageNameTable.txt"), "UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class LanguageInfoTableProvider
    implements Provider<Reader> {
        @Inject
        public LanguageInfoTableProvider() {
        }

        public Reader get() {
            try {
                return new InputStreamReader(LanguageInfoTableProvider.class.getResourceAsStream("resources/likelySubtags.txt"), "UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    static class CurrencyTableProvider
    implements Provider<Reader> {
        @Inject
        public CurrencyTableProvider() {
        }

        public Reader get() {
            try {
                return new InputStreamReader(CurrencyTableProvider.class.getResourceAsStream("resources/currencyTable.txt"), "UTF-8");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

