/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.i18n.identifiers.BasicCodeConverter;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.impl.LangEncConverter;
import java.util.Locale;
import java.util.regex.Pattern;

public class LangEncStringConverter
extends BasicCodeConverter<LanguageCode, String> {
    public static final LangEncStringConverter CONVERTER = new LangEncStringConverter();
    private static final Pattern validRfc1766 = Pattern.compile("[a-zA-Z]{1,8}([-][a-zA-Z0-9]{1,8})*");

    @Override
    public LanguageCode getUnknown() {
        return LanguageCode.forString("und");
    }

    @Override
    public CodeConverter.Status getStatusFromOther(String otherCode) {
        LanguageCode languageCode = this.fromOther(otherCode);
        if (!validRfc1766.matcher(otherCode).matches()) {
            return CodeConverter.Status.ILL_FORMED;
        }
        if (LanguageCode.UNKNOWN.equals(languageCode) && !"un".equals(otherCode.toLowerCase(Locale.ENGLISH))) {
            return CodeConverter.Status.INVALID;
        }
        return languageCode.getStatus();
    }

    @Override
    public CodeConverter.Status getStatus(LanguageCode languageCode) {
        String otherCode = this.toOther(languageCode);
        if (!"un".equals(otherCode.toLowerCase(Locale.ENGLISH)) || this.getUnknown().equals(languageCode)) {
            return languageCode.getStatus();
        }
        return CodeConverter.Status.INVALID;
    }

    @Override
    public LanguageCode fromOther(String other) {
        Integer enumValue = LanguageLanguageStringConverter.CONVERTER.fromOther(other);
        return (LanguageCode)LangEncConverter.CONVERTER.fromOther(enumValue);
    }

    @Override
    public String toOther(LanguageCode languageCode) {
        Integer enumValue = (Integer)LangEncConverter.CONVERTER.toOther(languageCode);
        return (String)LanguageLanguageStringConverter.CONVERTER.toOther(enumValue);
    }

    private LangEncStringConverter() {
    }

    private static class LanguageLanguageStringConverter
    extends BasicCodeConverter<Integer, String> {
        static final String[] LANGUAGES = new String[]{"en", "da", "nl", "fi", "fr", "de", "iw", "it", "ja", "ko", "no", "pl", "pt", "ru", "es", "sv", "zh", "cs", "el", "is", "lv", "lt", "ro", "hu", "et", "ut", "un", "bg", "hr", "sr", "ga", "gl", "tl", "tr", "uk", "hi", "mk", "bn", "id", "la", "ms", "ml", "cy", "ne", "te", "sq", "ta", "be", "jw", "oc", "ur", "bh", "gu", "th", "ar", "ca", "eo", "eu", "ia", "kn", "pa", "gd", "sw", "sl", "mr", "mt", "vi", "fy", "sk", "zh-TW", "fo", "su", "uz", "am", "az", "ka", "ti", "fa", "bs", "si", "nn", "pt-PT", "pt-BR", "xh", "zu", "gn", "st", "tk", "ky", "br", "tw", "yi", "sh", "so", "ug", "ku", "mn", "hy", "lo", "sd", "rm", "af", "lb", "my", "km", "bo", "dv", "chr", "syr", "sit-NP", "or", "as", "co", "ie", "kk", "ln", "mo", "ps", "qu", "sn", "tg", "tt", "to", "yo", "cpe", "cpf", "cpp", "crp", "mi", "wo", "ab", "aa", "ay", "ba", "bi", "dz", "fj", "kl", "ha", "ht", "ik", "iu", "ks", "rw", "mg", "na", "om", "rn", "sm", "sg", "sa", "ss", "ts", "tn", "vo", "za", "kha", "sco", "lg", "gv", "sr-ME", "ak", "ig", "mfe", "haw", "ceb", "ee", "gaa", "hmn", "kri", "loz", "lua", "luo", "new", "ny", "os", "pam", "nso", "raj", "crs", "tum", "ve", "war"};
        public static final LanguageLanguageStringConverter CONVERTER = new LanguageLanguageStringConverter();

        private LanguageLanguageStringConverter() {
            for (int i = 0; i < LANGUAGES.length; ++i) {
                this.mapFromString.put(LANGUAGES[i].toLowerCase(Locale.ENGLISH), i);
                this.mapToString.put(i, LANGUAGES[i]);
            }
            this.mapFromString.put("he", 6);
            this.mapFromString.put("nb", 10);
            this.mapFromString.put("zh-cn", 16);
            this.mapFromString.put("fil", 32);
            this.mapFromString.put("in", 38);
            this.mapFromString.put("jv", 48);
            this.mapFromString.put("ji", 91);
            this.mapFromString.put("sr-latn", 92);
            this.mapFromString.put("ro-md", 116);
        }

        @Override
        public Integer fromOther(String other) {
            if (null == other) {
                return this.getUnknown();
            }
            return (Integer)super.fromOther(other.toLowerCase(Locale.ENGLISH));
        }

        @Override
        public Integer getUnknown() {
            return 26;
        }

        @Override
        public CodeConverter.Status getStatusFromOther(String otherCode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CodeConverter.Status getStatus(Integer enumValue) {
            throw new UnsupportedOperationException();
        }
    }
}

