/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.base.Pair;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.CodeConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.impl.StandardLanguageNameInfo;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;

class LanguageNameInfoRecordSetProvider
implements Provider<Set<StandardLanguageNameInfo.LanguageNameInfoRecord>> {
    private final Reader reader;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/LanguageNameInfoRecordSetProvider");

    @Inject
    public LanguageNameInfoRecordSetProvider(@Named(value="LanguageNameInfo") Reader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<StandardLanguageNameInfo.LanguageNameInfoRecord> get() {
        HashSet<StandardLanguageNameInfo.LanguageNameInfoRecord> allRecords = Sets.newHashSet();
        HashSet<Pair<LanguageCode, LanguageCode>> langPairs = Sets.newHashSet();
        HashSet<StandardLanguageNameInfo.LanguageNameInfoRecord> canonicalizedRecords = Sets.newHashSet();
        BufferedReader br = new BufferedReader(this.reader);
        try {
            String line;
            while (null != (line = br.readLine())) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String[] fields = line.split(";");
                try {
                    LanguageCode language = LanguageCode.forString(fields[0], CodeConverter.SynonymConversion.DISTINGUISH_SYNONYMS);
                    LanguageCode translationLanguage = LanguageCode.forString(fields[1]);
                    String translation = fields[2];
                    Pair<LanguageCode, LanguageCode> langPair = Pair.of(language, translationLanguage);
                    allRecords.add(new StandardLanguageNameInfo.LanguageNameInfoRecord(language, translationLanguage, translation));
                    langPairs.add(langPair);
                    if (language.isCanonical()) continue;
                    canonicalizedRecords.add(new StandardLanguageNameInfo.LanguageNameInfoRecord(LanguageCode.forString(fields[0]), translationLanguage, translation));
                }
                catch (IllegalArgumentException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/LanguageNameInfoRecordSetProvider", "get", 70, "LanguageNameInfoRecordSetProvider.java")).log("%s: '%s'", (Object)e.getMessage(), (Object)line);
                }
            }
            Iterator iterator = canonicalizedRecords.iterator();
            while (iterator.hasNext()) {
                StandardLanguageNameInfo.LanguageNameInfoRecord record = (StandardLanguageNameInfo.LanguageNameInfoRecord)iterator.next();
                Pair<LanguageCode, LanguageCode> langPair = Pair.of(record.language, record.translationLanguage);
                if (langPairs.contains(langPair)) continue;
                allRecords.add(record);
                langPairs.add(langPair);
            }
            return Collections.unmodifiableSet(allRecords);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/LanguageNameInfoRecordSetProvider", "get", 83, "LanguageNameInfoRecordSetProvider.java")).log(e.getMessage());
            return Collections.unmodifiableSet(allRecords);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }
}

