/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.Subdivision;
import com.google.i18n.identifiers.SubdivisionRepository;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

class RealSubdivisionRepository
implements SubdivisionRepository {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/RealSubdivisionRepository");
    private static final RegionInfo REGION_INFO = StandardRegionInfo.getInstance();
    private static final Splitter SEMICOLON_SPLITTER = Splitter.on(";");
    private final Subdivision root;
    private final Map<String, Subdivision> codeToSubdivision;
    private final SetMultimap<Subdivision, Subdivision> subdivisionToChildren;

    static boolean isExcludedRegion(RegionCode region) {
        return !region.isCanonical() || REGION_INFO.isOverlap(region) || region.equals((Object)RegionCode.ZZ);
    }

    @Inject
    RealSubdivisionRepository(@Named(value="SubdivisionDataInfo") Reader data) {
        DataBuilder dataBuilder = new DataBuilder(this, RegionCode.UN001);
        dataBuilder.addData(data);
        this.root = dataBuilder.getRoot();
        this.codeToSubdivision = dataBuilder.getCodeToSubdivision();
        this.subdivisionToChildren = dataBuilder.getSubdivisionToChildren();
    }

    @Override
    public Subdivision forRegionCode(RegionCode rc) {
        Preconditions.checkNotNull(rc);
        return this.forString(rc.toString());
    }

    @Override
    public Subdivision forLocalString(RegionCode rc, String localCode) {
        Preconditions.checkNotNull(rc);
        Preconditions.checkNotNull(localCode);
        String string = String.valueOf((Object)rc);
        String id = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(localCode).length()).append(string).append("-").append(localCode).toString();
        return this.forString(id);
    }

    @Override
    public Subdivision forLocalString(RegionCode rc, String localCode, Subdivision.SubdivisionType type) {
        Preconditions.checkNotNull(rc);
        Preconditions.checkNotNull(localCode);
        Preconditions.checkNotNull(type);
        String string = String.valueOf((Object)rc);
        String id = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(localCode).length()).append(string).append("-").append(localCode).toString();
        Subdivision s = this.forString(id);
        if (s != null && type != s.type()) {
            Set<Subdivision> alts = s.alternates();
            s = null;
            if (alts != null) {
                for (Subdivision alt : alts) {
                    if (alt.type() != type) continue;
                    s = alt;
                    break;
                }
            }
        }
        return s;
    }

    @Override
    public Subdivision forString(String id) {
        Preconditions.checkNotNull(id);
        return this.codeToSubdivision.get(id);
    }

    @Override
    public Subdivision root() {
        return this.root;
    }

    private static class DataBuilder {
        private final RealSubdivisionRepository repository;
        private Subdivision root;
        private Map<String, Subdivision> toSubdivision;
        private SetMultimap<Subdivision, Subdivision> toChildren;

        private DataBuilder(RealSubdivisionRepository repository, RegionCode rootRegion) {
            this.repository = repository;
            this.toSubdivision = Maps.newHashMap();
            this.toChildren = HashMultimap.create();
            this.addRegionCodes(rootRegion);
        }

        private Subdivision getRoot() {
            return this.root;
        }

        private Map<String, Subdivision> getCodeToSubdivision() {
            return Collections.unmodifiableMap(this.toSubdivision);
        }

        private SetMultimap<Subdivision, Subdivision> getSubdivisionToChildren() {
            return Multimaps.unmodifiableSetMultimap(this.toChildren);
        }

        private boolean hasSubdivisionWithId(String id) {
            return this.toSubdivision.containsKey(id);
        }

        private Subdivision getSubdivisionWithId(String id) {
            return this.toSubdivision.get(id);
        }

        private SubdivisionImpl newSubdivision(Subdivision parent, String id, Subdivision.SubdivisionType type) {
            RealSubdivisionRepository realSubdivisionRepository = this.repository;
            Objects.requireNonNull(realSubdivisionRepository);
            return realSubdivisionRepository.new SubdivisionImpl((SubdivisionImpl)parent, id, type);
        }

        private Subdivision.SubdivisionType subdivisionTypeFor(RegionCode region) {
            return region.toString().charAt(0) >= '0' && region.toString().charAt(0) <= '9' ? Subdivision.SubdivisionType.UN : Subdivision.SubdivisionType.TERRITORY;
        }

        private void addSubdivision(Subdivision subdivision) {
            this.toSubdivision.put(subdivision.id(), subdivision);
            this.toChildren.put(subdivision.parent(), subdivision);
        }

        private void addRegionCodes(RegionCode rootRegion) {
            String rootId = rootRegion.toString();
            this.root = this.newSubdivision(null, rootId, this.subdivisionTypeFor(rootRegion));
            this.toSubdivision.put(rootId, this.root);
            for (RegionCode region : REGION_INFO.getAllContents(rootRegion)) {
                if (RealSubdivisionRepository.isExcludedRegion(region)) continue;
                this.addRegion(region);
            }
        }

        private Subdivision addRegion(RegionCode region) {
            String id = region.toString();
            Subdivision subdivision = this.toSubdivision.get(id);
            if (subdivision != null) {
                return subdivision;
            }
            RegionCode parentRegion = this.getSingleParentRegion(region);
            if (parentRegion == null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder", "addRegion", 382, "RealSubdivisionRepository.java")).log("no parent region for %s", id);
                return null;
            }
            Subdivision parentSubdivision = this.addRegion(parentRegion);
            if (parentSubdivision == null) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder", "addRegion", 388, "RealSubdivisionRepository.java")).log("no parent subdivision for %s", id);
                return null;
            }
            Subdivision.SubdivisionType type = this.subdivisionTypeFor(region);
            subdivision = this.newSubdivision(parentSubdivision, id, type);
            this.addSubdivision(subdivision);
            return subdivision;
        }

        private RegionCode getSingleParentRegion(RegionCode region) {
            RegionCode firstParent = null;
            for (RegionCode parent : REGION_INFO.getDirectContainers(region)) {
                if (RealSubdivisionRepository.isExcludedRegion(parent)) continue;
                if (firstParent != null) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder", "getSingleParentRegion", 408, "RealSubdivisionRepository.java")).log("region %s has multiple parents: %s and %s", (Object)region, (Object)firstParent, (Object)parent);
                    continue;
                }
                firstParent = parent;
            }
            return firstParent;
        }

        private void addData(Reader input) {
            new DataReader(this).read(input);
        }

        private static class DataReader {
            private final DataBuilder builder;
            private Multimap<String, SubdivisionImpl> parentIdToPendingChildren;
            private int lineNumber;
            private String currentLine;

            DataReader(DataBuilder builder) {
                this.builder = builder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void read(Reader input) {
                this.parentIdToPendingChildren = HashMultimap.create();
                this.lineNumber = 0;
                BufferedReader br = new BufferedReader(input);
                try {
                    String line = null;
                    while (null != (line = br.readLine())) {
                        ++this.lineNumber;
                        if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                        this.currentLine = line;
                        this.processCurrentLine();
                    }
                    if (!this.parentIdToPendingChildren.isEmpty()) {
                        String string = String.valueOf(this.parentIdToPendingChildren);
                        throw new IllegalStateException(new StringBuilder(57 + String.valueOf(string).length()).append("Could not resolve parent for children (parent=children): ").append(string).toString());
                    }
                }
                catch (IOException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder$DataReader", "read", 478, "RealSubdivisionRepository.java")).log("caught exception: %s", e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder$DataReader", "read", 480, "RealSubdivisionRepository.java")).log(e.getMessage());
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder$DataReader", "read", 485, "RealSubdivisionRepository.java")).log(e.getMessage());
                    }
                }
            }

            private void processCurrentLine() {
                List<String> fields = this.getValidFields();
                Subdivision.SubdivisionType type = this.getValidType(fields.get(2));
                if (this.hasRegionCodeSupport(type)) {
                    return;
                }
                String id = this.getValidId(fields.get(0));
                if (fields.size() > 3 && this.hasReplacements(fields.get(3))) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/i18n/identifiers/impl/RealSubdivisionRepository$DataBuilder$DataReader", "processCurrentLine", 504, "RealSubdivisionRepository.java")).log("skipping subdivision with replacements: %s", id);
                    return;
                }
                String parentId = this.getValidParentId(fields.get(1));
                Subdivision parentSubdivision = this.builder.getSubdivisionWithId(parentId);
                SubdivisionImpl subdivision = this.builder.newSubdivision(parentSubdivision, id, type);
                if (parentSubdivision == null) {
                    this.parentIdToPendingChildren.put(parentId, subdivision);
                    return;
                }
                this.addSubdivision(subdivision);
            }

            private void addSubdivision(Subdivision subdivision) {
                this.builder.addSubdivision(subdivision);
                this.processPending(subdivision);
            }

            private void processPending(Subdivision subdivision) {
                String id = subdivision.id();
                if (this.parentIdToPendingChildren.containsKey(id)) {
                    for (SubdivisionImpl childStandIn : this.parentIdToPendingChildren.get(id)) {
                        SubdivisionImpl child = this.builder.newSubdivision(subdivision, childStandIn.id, childStandIn.type);
                        this.builder.addSubdivision(child);
                    }
                    this.parentIdToPendingChildren.removeAll(id);
                }
            }

            private void throwError(String message) {
                String shortLine = this.currentLine.length() <= 20 ? this.currentLine : String.valueOf(this.currentLine.substring(0, 20)).concat("...");
                throw new IllegalStateException(String.format("%s on line %d: '%s...'", message, this.lineNumber, shortLine));
            }

            private String getValidId(String id) {
                if (Strings.isNullOrEmpty(id)) {
                    this.throwError("no ID");
                }
                if (this.builder.hasSubdivisionWithId(id)) {
                    String string = String.valueOf(id);
                    this.throwError(string.length() != 0 ? "duplicate ID ".concat(string) : new String("duplicate ID "));
                }
                return id;
            }

            private String getValidParentId(String parentId) {
                if (Strings.isNullOrEmpty(parentId)) {
                    this.throwError("no parent ID");
                }
                if (parentId.startsWith("UN")) {
                    parentId = parentId.substring(2);
                }
                return parentId;
            }

            private boolean hasReplacements(String replacements) {
                if (replacements.isEmpty()) {
                    return false;
                }
                if (replacements.trim().isEmpty()) {
                    this.throwError("empty replacement");
                }
                return true;
            }

            private boolean hasRegionCodeSupport(Subdivision.SubdivisionType type) {
                return type == Subdivision.SubdivisionType.UN || type == Subdivision.SubdivisionType.TERRITORY;
            }

            private List<String> getValidFields() {
                List<String> fields = SEMICOLON_SPLITTER.splitToList(this.currentLine);
                if (fields.size() < 3) {
                    this.throwError("too few fields");
                }
                return fields;
            }

            private Subdivision.SubdivisionType getValidType(String typeCode) {
                switch (typeCode.charAt(0)) {
                    case 'u': {
                        return Subdivision.SubdivisionType.UN;
                    }
                    case 't': {
                        return Subdivision.SubdivisionType.TERRITORY;
                    }
                    case 'm': {
                        return Subdivision.SubdivisionType.DIVISION;
                    }
                    case 's': {
                        return Subdivision.SubdivisionType.SUBDIVISION;
                    }
                }
                String string = String.valueOf(typeCode);
                this.throwError(string.length() != 0 ? "unknown type code: ".concat(string) : new String("unknown type code: "));
                throw new AssertionError();
            }
        }
    }

    class SubdivisionImpl
    implements Subdivision {
        private final String id;
        private final SubdivisionImpl parent;
        private final Subdivision.SubdivisionType type;

        private SubdivisionImpl(SubdivisionImpl parent, String id, Subdivision.SubdivisionType type) {
            this.parent = parent;
            this.id = id;
            this.type = type;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Subdivision.SubdivisionType type() {
            return this.type;
        }

        @Override
        public Subdivision parent() {
            return this.parent;
        }

        @Override
        public RegionCode region() {
            SubdivisionImpl s = this;
            while (s.type != Subdivision.SubdivisionType.TERRITORY && s.type != Subdivision.SubdivisionType.UN) {
                s = s.parent;
            }
            String regionId = s.id;
            if (regionId.startsWith("UN")) {
                regionId = regionId.substring(2);
            }
            return RegionCode.forString(regionId);
        }

        @Override
        public Set<Subdivision> children() {
            return RealSubdivisionRepository.this.subdivisionToChildren.get(this);
        }

        @Override
        public boolean isDescendantOf(Subdivision rhs) {
            Preconditions.checkNotNull(rhs);
            if (RealSubdivisionRepository.this.codeToSubdivision.get(rhs.id()) == null) {
                String string = String.valueOf(rhs.id());
                throw new IllegalArgumentException(string.length() != 0 ? "unknown subdivision: ".concat(string) : new String("unknown subdivision: "));
            }
            SubdivisionImpl s = this;
            while (s != rhs && s != null) {
                s = s.parent;
            }
            return s != null;
        }

        @Override
        public Subdivision commonRoot(Subdivision rhs) {
            Subdivision s;
            Subdivision s2;
            Preconditions.checkNotNull(rhs);
            if (RealSubdivisionRepository.this.codeToSubdivision.get(rhs.id()) == null) {
                String string = String.valueOf(rhs.id());
                throw new IllegalArgumentException(string.length() != 0 ? "unknown subdivision: ".concat(string) : new String("unknown subdivision: "));
            }
            if (this.parent == null || rhs.equals(this)) {
                return this;
            }
            if (this.parent.equals(rhs.parent())) {
                return this.parent;
            }
            ArrayList<SubdivisionImpl> tl = Lists.newArrayList();
            ArrayList<Subdivision> rl = Lists.newArrayList();
            for (s2 = this; s2 != null; s2 = s2.parent()) {
                tl.add((SubdivisionImpl)s2);
            }
            for (s2 = rhs; s2 != null; s2 = s2.parent()) {
                rl.add(s2);
            }
            Subdivision ancestor = null;
            int x = tl.size();
            int y = rl.size();
            while (--x >= 0 && --y >= 0 && (s = (Subdivision)tl.get(x)) == rl.get(y)) {
                ancestor = s;
            }
            return ancestor;
        }

        @Override
        @Deprecated
        public boolean isDeprecated() {
            return false;
        }

        @Override
        @Deprecated
        public Set<Subdivision> replacements() {
            return null;
        }

        @Override
        @Deprecated
        public boolean hasAlternates() {
            return false;
        }

        @Override
        @Deprecated
        public Set<Subdivision> alternates() {
            return null;
        }

        public String toString() {
            return this.id;
        }
    }
}

