/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class RegionDisplayNames {
    private ConcurrentMap<LanguageCode, ImmutableMap<String, RegionCode>> namesForLanguages = new ConcurrentHashMap<LanguageCode, ImmutableMap<String, RegionCode>>();
    private final ImmutableListMultimap<RegionCode, RegionCode> aliasMap;
    private static final Transliterator transliterator = Transliterator.getInstance("Lower; NFKD; [:^L:]Remove; NFC;", 0);
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/RegionDisplayNames");

    private RegionDisplayNames(ImmutableListMultimap<RegionCode, RegionCode> aliasMap) {
        this.aliasMap = aliasMap;
    }

    static RegionDisplayNames createWithExtraEnglishNames(ImmutableListMultimap<RegionCode, RegionCode> aliasMap, Map<String, RegionCode> extraEnglishNames) {
        RegionDisplayNames regionDisplayNames = new RegionDisplayNames(aliasMap);
        regionDisplayNames.addExtraDisplayNames(extraEnglishNames, LanguageCode.ENGLISH);
        return regionDisplayNames;
    }

    RegionCode getRegionCode(String name, LanguageCode lang) {
        String normalizedWithoutBrackets;
        String nameWithoutBrackets;
        String normalizedName;
        ImmutableMap<String, RegionCode> namesForLanguage = this.getNamesForLanguage(lang);
        RegionCode foundRegionCode = (RegionCode)((Object)namesForLanguage.get(normalizedName = RegionDisplayNames.normalizeDisplayName(name)));
        if (foundRegionCode == null && (nameWithoutBrackets = this.stripInformationInBrackets(name)) != null && !(normalizedWithoutBrackets = RegionDisplayNames.normalizeDisplayName(nameWithoutBrackets)).equals(normalizedName)) {
            foundRegionCode = (RegionCode)((Object)namesForLanguage.get(normalizedWithoutBrackets));
        }
        return foundRegionCode == null ? RegionCode.getUnknown() : foundRegionCode;
    }

    private String stripInformationInBrackets(String name) {
        int openingBracket = name.indexOf(40);
        int closingBracket = name.indexOf(41, openingBracket);
        if (openingBracket < 0) {
            openingBracket = name.indexOf(65288);
            closingBracket = name.indexOf(65289, openingBracket);
        }
        if (openingBracket >= 0 && closingBracket > openingBracket) {
            String string = String.valueOf(name.substring(0, openingBracket));
            String string2 = String.valueOf(name.substring(closingBracket));
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        return null;
    }

    private ImmutableMap<String, RegionCode> getNamesForLanguage(LanguageCode language) {
        ImmutableMap namesForLanguage = (ImmutableMap)this.namesForLanguages.get(language);
        if (namesForLanguage != null) {
            return namesForLanguage;
        }
        HashMap<String, RegionCode> newNamesForLanguage = new HashMap<String, RegionCode>();
        for (RegionCode region : RegionCode.values()) {
            String normalizedDisplayName;
            RegionCode currentRegionForName;
            String name = this.getDisplayNameFromCldr(region, language);
            if (name.isEmpty() || (currentRegionForName = (RegionCode)((Object)newNamesForLanguage.get(normalizedDisplayName = RegionDisplayNames.normalizeDisplayName(name)))) != null && !this.isPreferredTo(currentRegionForName, region)) continue;
            newNamesForLanguage.put(normalizedDisplayName, region);
        }
        ImmutableMap newNames = ImmutableMap.copyOf(newNamesForLanguage);
        ImmutableMap<String, RegionCode> existingNames = this.namesForLanguages.putIfAbsent(language, newNames);
        return existingNames != null ? existingNames : newNames;
    }

    private String getDisplayNameFromCldr(RegionCode region, LanguageCode language) {
        String result = new ULocale.Builder().setRegion(region.toString()).build().getDisplayCountry(ULocaleConverter.CONVERTER.toOther(language));
        return result.equals(region.toString()) ? "" : result;
    }

    private void addExtraDisplayNames(Map<String, RegionCode> nameRegionPairs, LanguageCode language) {
        HashMap<String, RegionCode> languageNames = new HashMap<String, RegionCode>();
        languageNames.putAll(this.getNamesForLanguage(language));
        for (Map.Entry<String, RegionCode> nameToRegionCode : nameRegionPairs.entrySet()) {
            RegionCode oldValue = languageNames.put(RegionDisplayNames.normalizeDisplayName(nameToRegionCode.getKey()), nameToRegionCode.getValue());
            if (oldValue == null) continue;
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/identifiers/impl/RegionDisplayNames", "addExtraDisplayNames", 154, "RegionDisplayNames.java")).log("Overriding %s with %s", (Object)oldValue, (Object)nameToRegionCode.getValue());
        }
        this.namesForLanguages.put(language, ImmutableMap.copyOf(languageNames));
    }

    private boolean isPreferredTo(RegionCode a, RegionCode b) {
        ImmutableCollection newerRegions = this.aliasMap.get((Object)b);
        return newerRegions == null || !newerRegions.contains((Object)a);
    }

    private static synchronized String normalizeDisplayName(String name) {
        int pos = name.indexOf(44);
        if (pos > 0) {
            String string = String.valueOf(name.substring(pos + 1));
            String string2 = String.valueOf(name.substring(0, pos));
            return transliterator.transliterate(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        return transliterator.transliterate(name);
    }
}

