/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;

class StandardLanguageInfoHashMapProvider
implements Provider<Map<String, String>> {
    private final Reader reader;
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/StandardLanguageInfoHashMapProvider");

    @Inject
    public StandardLanguageInfoHashMapProvider(@Named(value="LanguageInfo") Reader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> get() {
        HashMap<String, String> map = Maps.newHashMap();
        BufferedReader bufferedReader = new BufferedReader(this.reader);
        try {
            String line;
            while (null != (line = bufferedReader.readLine())) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int i = line.indexOf(59);
                String minimal = line.substring(0, i);
                String maximal = line.substring(i + 1).trim();
                map.put(minimal, maximal);
            }
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardLanguageInfoHashMapProvider", "get", 56, "StandardLanguageInfoHashMapProvider.java")).log(e.getMessage());
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.unmodifiableMap(map);
    }
}

