/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.labs.collect.BiMultimaps;
import com.google.common.labs.collect.HashBiMultimap;
import com.google.common.money.CurrencyCode;
import com.google.i18n.identifiers.JavaLocaleConverter;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.ULocaleConverter;
import com.google.i18n.identifiers.impl.CurrencyInfoFactory;
import com.google.i18n.identifiers.impl.CurrencyInfoImpl;
import com.google.i18n.identifiers.impl.RegionDisplayNames;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class StandardRegionInfo
implements RegionInfo {
    private Map<RegionCode, TerritoryData> populationData = new EnumMap<RegionCode, TerritoryData>(RegionCode.class);
    private final RegionDisplayNames regionDisplayNames;
    private final CurrencyInfoImpl cinfo;
    private static final ImmutableMultimap<RegionCode, RegionCode> CONTAINMENT_EDGES = new ImmutableMultimap.Builder<RegionCode, RegionCode>().putAll(RegionCode.UN001, RegionCode.UN019, RegionCode.UN002, RegionCode.UN150, RegionCode.UN142, RegionCode.UN009, RegionCode.EU, RegionCode.EZ, RegionCode.UN, RegionCode.QU).putAll(RegionCode.UN002, (RegionCode[])new RegionCode[]{RegionCode.UN015, RegionCode.UN011, RegionCode.UN017, RegionCode.UN014, RegionCode.UN018, RegionCode.UN202}).putAll(RegionCode.UN003, (RegionCode[])new RegionCode[]{RegionCode.UN021, RegionCode.UN013, RegionCode.UN029}).putAll(RegionCode.UN005, (RegionCode[])new RegionCode[]{RegionCode.AR, RegionCode.BO, RegionCode.BR, RegionCode.BV, RegionCode.CL, RegionCode.CO, RegionCode.EC, RegionCode.FK, RegionCode.GF, RegionCode.GS, RegionCode.GY, RegionCode.PE, RegionCode.PY, RegionCode.SR, RegionCode.UY, RegionCode.VE}).putAll(RegionCode.UN009, (RegionCode[])new RegionCode[]{RegionCode.UN053, RegionCode.UN054, RegionCode.UN057, RegionCode.UN061, RegionCode.QO}).putAll(RegionCode.UN011, (RegionCode[])new RegionCode[]{RegionCode.BF, RegionCode.BJ, RegionCode.CI, RegionCode.CV, RegionCode.GH, RegionCode.GM, RegionCode.GN, RegionCode.GW, RegionCode.LR, RegionCode.ML, RegionCode.MR, RegionCode.NE, RegionCode.NG, RegionCode.SH, RegionCode.SL, RegionCode.SN, RegionCode.TG}).putAll(RegionCode.UN013, (RegionCode[])new RegionCode[]{RegionCode.BZ, RegionCode.CR, RegionCode.GT, RegionCode.HN, RegionCode.MX, RegionCode.NI, RegionCode.PA, RegionCode.SV}).putAll(RegionCode.UN014, (RegionCode[])new RegionCode[]{RegionCode.BI, RegionCode.DJ, RegionCode.ER, RegionCode.ET, RegionCode.IO, RegionCode.KE, RegionCode.KM, RegionCode.MG, RegionCode.MU, RegionCode.MW, RegionCode.MZ, RegionCode.RE, RegionCode.RW, RegionCode.SC, RegionCode.SO, RegionCode.SS, RegionCode.TF, RegionCode.TZ, RegionCode.UG, RegionCode.YT, RegionCode.ZM, RegionCode.ZW}).putAll(RegionCode.UN015, (RegionCode[])new RegionCode[]{RegionCode.DZ, RegionCode.EG, RegionCode.EH, RegionCode.LY, RegionCode.MA, RegionCode.SD, RegionCode.TN, RegionCode.EA, RegionCode.IC}).putAll(RegionCode.UN017, (RegionCode[])new RegionCode[]{RegionCode.AO, RegionCode.CD, RegionCode.CF, RegionCode.CG, RegionCode.CM, RegionCode.GA, RegionCode.GQ, RegionCode.ST, RegionCode.TD, RegionCode.ZR}).putAll(RegionCode.UN018, (RegionCode[])new RegionCode[]{RegionCode.BW, RegionCode.LS, RegionCode.NA, RegionCode.SZ, RegionCode.ZA}).putAll(RegionCode.UN019, (RegionCode[])new RegionCode[]{RegionCode.UN021, RegionCode.UN013, RegionCode.UN029, RegionCode.UN005, RegionCode.UN003, RegionCode.UN419}).putAll(RegionCode.UN021, (RegionCode[])new RegionCode[]{RegionCode.BM, RegionCode.CA, RegionCode.GL, RegionCode.PM, RegionCode.US}).putAll(RegionCode.UN029, (RegionCode[])new RegionCode[]{RegionCode.AG, RegionCode.AI, RegionCode.AW, RegionCode.BB, RegionCode.BL, RegionCode.BQ, RegionCode.BS, RegionCode.CU, RegionCode.CW, RegionCode.DM, RegionCode.DO, RegionCode.GD, RegionCode.GP, RegionCode.HT, RegionCode.JM, RegionCode.KN, RegionCode.KY, RegionCode.LC, RegionCode.MF, RegionCode.MQ, RegionCode.MS, RegionCode.PR, RegionCode.SX, RegionCode.TC, RegionCode.TT, RegionCode.VC, RegionCode.VG, RegionCode.VI, RegionCode.AN}).putAll(RegionCode.UN030, (RegionCode[])new RegionCode[]{RegionCode.CN, RegionCode.HK, RegionCode.JP, RegionCode.KP, RegionCode.KR, RegionCode.MN, RegionCode.MO, RegionCode.TW}).putAll(RegionCode.UN034, (RegionCode[])new RegionCode[]{RegionCode.AF, RegionCode.BD, RegionCode.BT, RegionCode.IN, RegionCode.IR, RegionCode.LK, RegionCode.MV, RegionCode.NP, RegionCode.PK}).putAll(RegionCode.UN035, (RegionCode[])new RegionCode[]{RegionCode.BN, RegionCode.ID, RegionCode.KH, RegionCode.LA, RegionCode.MM, RegionCode.MY, RegionCode.PH, RegionCode.SG, RegionCode.TH, RegionCode.TL, RegionCode.VN, RegionCode.BU, RegionCode.TP}).putAll(RegionCode.UN039, (RegionCode[])new RegionCode[]{RegionCode.AD, RegionCode.AL, RegionCode.BA, RegionCode.ES, RegionCode.GI, RegionCode.GR, RegionCode.HR, RegionCode.IT, RegionCode.ME, RegionCode.MK, RegionCode.MT, RegionCode.RS, RegionCode.PT, RegionCode.SI, RegionCode.SM, RegionCode.VA, RegionCode.XK, RegionCode.CS, RegionCode.YU}).putAll(RegionCode.UN053, (RegionCode[])new RegionCode[]{RegionCode.AU, RegionCode.CC, RegionCode.CX, RegionCode.HM, RegionCode.NF, RegionCode.NZ}).putAll(RegionCode.UN054, (RegionCode[])new RegionCode[]{RegionCode.FJ, RegionCode.NC, RegionCode.PG, RegionCode.SB, RegionCode.VU}).putAll(RegionCode.UN057, (RegionCode[])new RegionCode[]{RegionCode.FM, RegionCode.GU, RegionCode.KI, RegionCode.MH, RegionCode.MP, RegionCode.NR, RegionCode.PW, RegionCode.UM}).putAll(RegionCode.UN061, (RegionCode[])new RegionCode[]{RegionCode.AS, RegionCode.CK, RegionCode.NU, RegionCode.PF, RegionCode.PN, RegionCode.TK, RegionCode.TO, RegionCode.TV, RegionCode.WF, RegionCode.WS}).putAll(RegionCode.UN142, (RegionCode[])new RegionCode[]{RegionCode.UN145, RegionCode.UN143, RegionCode.UN030, RegionCode.UN034, RegionCode.UN035}).putAll(RegionCode.UN143, (RegionCode[])new RegionCode[]{RegionCode.TM, RegionCode.TJ, RegionCode.KG, RegionCode.KZ, RegionCode.UZ}).putAll(RegionCode.UN145, (RegionCode[])new RegionCode[]{RegionCode.AE, RegionCode.AM, RegionCode.AZ, RegionCode.BH, RegionCode.CY, RegionCode.GE, RegionCode.IL, RegionCode.IQ, RegionCode.JO, RegionCode.KW, RegionCode.LB, RegionCode.OM, RegionCode.PS, RegionCode.QA, RegionCode.SA, RegionCode.SY, RegionCode.TR, RegionCode.YE, RegionCode.NT, RegionCode.YD}).putAll(RegionCode.UN150, (RegionCode[])new RegionCode[]{RegionCode.UN154, RegionCode.UN155, RegionCode.UN151, RegionCode.UN039}).putAll(RegionCode.UN151, (RegionCode[])new RegionCode[]{RegionCode.BG, RegionCode.BY, RegionCode.CZ, RegionCode.HU, RegionCode.MD, RegionCode.PL, RegionCode.RO, RegionCode.RU, RegionCode.SK, RegionCode.UA, RegionCode.SU}).putAll(RegionCode.UN154, (RegionCode[])new RegionCode[]{RegionCode.GG, RegionCode.IM, RegionCode.JE, RegionCode.AX, RegionCode.DK, RegionCode.EE, RegionCode.FI, RegionCode.FO, RegionCode.GB, RegionCode.IE, RegionCode.IS, RegionCode.LT, RegionCode.LV, RegionCode.NO, RegionCode.SE, RegionCode.SJ}).putAll(RegionCode.UN155, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CH, RegionCode.DE, RegionCode.FR, RegionCode.LI, RegionCode.LU, RegionCode.MC, RegionCode.NL, RegionCode.DD, RegionCode.FX}).putAll(RegionCode.UN202, (RegionCode[])new RegionCode[]{RegionCode.UN011, RegionCode.UN017, RegionCode.UN014, RegionCode.UN018}).putAll(RegionCode.UN419, (RegionCode[])new RegionCode[]{RegionCode.UN013, RegionCode.UN029, RegionCode.UN005}).putAll(RegionCode.EU, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CY, RegionCode.CZ, RegionCode.DE, RegionCode.DK, RegionCode.EE, RegionCode.ES, RegionCode.FI, RegionCode.FR, RegionCode.GB, RegionCode.GR, RegionCode.HR, RegionCode.HU, RegionCode.IE, RegionCode.IT, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.MT, RegionCode.NL, RegionCode.PL, RegionCode.PT, RegionCode.SE, RegionCode.SI, RegionCode.SK, RegionCode.BG, RegionCode.RO}).putAll(RegionCode.EZ, (RegionCode[])new RegionCode[]{RegionCode.AT, RegionCode.BE, RegionCode.CY, RegionCode.DE, RegionCode.EE, RegionCode.ES, RegionCode.FI, RegionCode.FR, RegionCode.GR, RegionCode.IE, RegionCode.IT, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.MT, RegionCode.NL, RegionCode.PT, RegionCode.SI, RegionCode.SK}).putAll(RegionCode.QO, (RegionCode[])new RegionCode[]{RegionCode.AQ, RegionCode.AC, RegionCode.CP, RegionCode.DG, RegionCode.TA}).putAll(RegionCode.UN, (RegionCode[])new RegionCode[]{RegionCode.AD, RegionCode.AE, RegionCode.AF, RegionCode.AG, RegionCode.AL, RegionCode.AM, RegionCode.AO, RegionCode.AR, RegionCode.AT, RegionCode.AU, RegionCode.AZ, RegionCode.BA, RegionCode.BB, RegionCode.BD, RegionCode.BE, RegionCode.BF, RegionCode.BG, RegionCode.BH, RegionCode.BI, RegionCode.BJ, RegionCode.BN, RegionCode.BO, RegionCode.BR, RegionCode.BS, RegionCode.BT, RegionCode.BW, RegionCode.BY, RegionCode.BZ, RegionCode.CA, RegionCode.CD, RegionCode.CF, RegionCode.CG, RegionCode.CH, RegionCode.CI, RegionCode.CL, RegionCode.CM, RegionCode.CN, RegionCode.CO, RegionCode.CR, RegionCode.CU, RegionCode.CV, RegionCode.CY, RegionCode.CZ, RegionCode.DE, RegionCode.DJ, RegionCode.DK, RegionCode.DM, RegionCode.DO, RegionCode.DZ, RegionCode.EC, RegionCode.EE, RegionCode.EG, RegionCode.ER, RegionCode.ES, RegionCode.ET, RegionCode.FI, RegionCode.FJ, RegionCode.FM, RegionCode.FR, RegionCode.GA, RegionCode.GB, RegionCode.GD, RegionCode.GE, RegionCode.GH, RegionCode.GM, RegionCode.GN, RegionCode.GQ, RegionCode.GR, RegionCode.GT, RegionCode.GW, RegionCode.GY, RegionCode.HN, RegionCode.HR, RegionCode.HT, RegionCode.HU, RegionCode.ID, RegionCode.IE, RegionCode.IL, RegionCode.IN, RegionCode.IQ, RegionCode.IR, RegionCode.IS, RegionCode.IT, RegionCode.JM, RegionCode.JO, RegionCode.JP, RegionCode.KE, RegionCode.KG, RegionCode.KH, RegionCode.KI, RegionCode.KM, RegionCode.KN, RegionCode.KP, RegionCode.KR, RegionCode.KW, RegionCode.KZ, RegionCode.LA, RegionCode.LB, RegionCode.LC, RegionCode.LI, RegionCode.LK, RegionCode.LR, RegionCode.LS, RegionCode.LT, RegionCode.LU, RegionCode.LV, RegionCode.LY, RegionCode.MA, RegionCode.MC, RegionCode.MD, RegionCode.ME, RegionCode.MG, RegionCode.MH, RegionCode.MK, RegionCode.ML, RegionCode.MM, RegionCode.MN, RegionCode.MR, RegionCode.MT, RegionCode.MU, RegionCode.MV, RegionCode.MX, RegionCode.MW, RegionCode.MY, RegionCode.MZ, RegionCode.NA, RegionCode.NE, RegionCode.NG, RegionCode.NI, RegionCode.NL, RegionCode.NO, RegionCode.NR, RegionCode.NP, RegionCode.NZ, RegionCode.OM, RegionCode.PA, RegionCode.PE, RegionCode.PG, RegionCode.PH, RegionCode.PK, RegionCode.PL, RegionCode.PT, RegionCode.PW, RegionCode.PY, RegionCode.QA, RegionCode.RO, RegionCode.RS, RegionCode.RU, RegionCode.RW, RegionCode.SA, RegionCode.SB, RegionCode.SC, RegionCode.SD, RegionCode.SE, RegionCode.SG, RegionCode.SI, RegionCode.SK, RegionCode.SL, RegionCode.SM, RegionCode.SN, RegionCode.SO, RegionCode.SR, RegionCode.SS, RegionCode.ST, RegionCode.SV, RegionCode.SY, RegionCode.SZ, RegionCode.TD, RegionCode.TG, RegionCode.TH, RegionCode.TJ, RegionCode.TL, RegionCode.TM, RegionCode.TN, RegionCode.TO, RegionCode.TR, RegionCode.TT, RegionCode.TV, RegionCode.TZ, RegionCode.UA, RegionCode.UG, RegionCode.US, RegionCode.UY, RegionCode.UZ, RegionCode.VC, RegionCode.VE, RegionCode.VN, RegionCode.VU, RegionCode.WS, RegionCode.YE, RegionCode.ZA, RegionCode.ZM, RegionCode.ZW}).build();
    private static final Dag<RegionCode> CONTAINMENT_GRAPH = new Dag(CONTAINMENT_EDGES);
    private static final ImmutableMap<RegionCode, String> DISPLAY_NAME_OVERRIDES = new ImmutableMap.Builder<RegionCode, String>().put(RegionCode.DD, "East Germany").put(RegionCode.GG, "Guernsey").put(RegionCode.IM, "Isle of Man").put(RegionCode.JE, "Jersey").put(RegionCode.ME, "Montenegro").put(RegionCode.NT, "Neutral Zone").put(RegionCode.QU, "European Union").put(RegionCode.RS, "Serbia").put(RegionCode.SU, "Union of Soviet Socialist Republics").put(RegionCode.YD, "People's Democratic Republic of Yemen").put(RegionCode.ZZ, "Unknown or Invalid Region").put(RegionCode.UN034, "Southern Asia").put(RegionCode.UN143, "Central Asia").build();
    private static final ImmutableMap<String, RegionCode> EXTRA_ENGLISH_NAMES = new ImmutableMap.Builder<String, RegionCode>().put("Bosnia", RegionCode.BA).put("Bolivia (Plurinational State of)", RegionCode.BO).put("The Bahamas", RegionCode.BS).put("Cocos Islands", RegionCode.CC).put("Dem. Rep. Congo", RegionCode.CD).put("Democratic Republic of the Congo", RegionCode.CD).put("The Democratic Republic of the Congo", RegionCode.CD).put("Congo (Democratic Republic of the)", RegionCode.CD).put("Congo (Democratic Republic of)", RegionCode.CD).put("Democratic Republic of Congo", RegionCode.CD).put("Rep. Congo", RegionCode.CG).put("Republic of the Congo", RegionCode.CG).put("Congo (Republic of the)", RegionCode.CG).put("Congo (Republic of)", RegionCode.CG).put("Ivory Coast", RegionCode.CI).put("Cabo Verde", RegionCode.CV).put("Arab Rep. Egypt", RegionCode.EG).put("Falkland Islands", RegionCode.FK).put("Fed. Sts. Micronesia", RegionCode.FM).put("Federated States of Micronesia", RegionCode.FM).put("Faeroe Islands", RegionCode.FO).put("Great Britain", RegionCode.GB).put("UK", RegionCode.GB).put("Channel Islands", RegionCode.GG).put("The Gambia", RegionCode.GM).put("Hong Kong SAR China", RegionCode.HK).put("China Hong Kong", RegionCode.HK).put("Islamic Rep. Iran", RegionCode.IR).put("Islamic Republic of Iran", RegionCode.IR).put("Kyrgyz Republic", RegionCode.KG).put("St. Kitts and Nevis", RegionCode.KN).put("Dem. Rep. Korea", RegionCode.KP).put("Democratic People's Republic of Korea", RegionCode.KP).put("Korea (Democratic People's Rep. of)", RegionCode.KP).put("Rep. Korea", RegionCode.KR).put("Republic of Korea", RegionCode.KR).put("Lao PDR", RegionCode.LA).put("Lao People's Democratic Republic", RegionCode.LA).put("Saint Lucia", RegionCode.LC).put("Republic of Moldova", RegionCode.MD).put("St. Martin (French part)", RegionCode.MF).put("Saint Martin", RegionCode.MF).put("Macedonia", RegionCode.MK).put("FYR Macedonia", RegionCode.MK).put("The Former Yugoslav Rep. of Macedonia", RegionCode.MK).put("TFYR of Macedonia", RegionCode.MK).put("The Former Yugoslav Republic of Macedonia", RegionCode.MK).put("Burma", RegionCode.MM).put("Myanmar", RegionCode.MM).put("Macau", RegionCode.MO).put("China Macau", RegionCode.MO).put("China Macao", RegionCode.MO).put("China, Macau Special Administrative Region", RegionCode.MO).put("China, Macao Special Administrative Region", RegionCode.MO).put("Macao SAR China", RegionCode.MO).put("Macau SAR China", RegionCode.MO).put("Macao SAR, China", RegionCode.MO).put("Macau SAR, China", RegionCode.MO).put("Gaza Strip", RegionCode.PS).put("Occupied Palestinian Territory", RegionCode.PS).put("Palestinian Autonomous Territories", RegionCode.PS).put("Palestinian Territories", RegionCode.PS).put("Palestinian", RegionCode.PS).put("West Bank and Gaza", RegionCode.PS).put("West Bank", RegionCode.PS).put("Russian Federation", RegionCode.RU).put("Saint Helena, Ascension, and Tristan da Cunha", RegionCode.SH).put("Svalbard", RegionCode.SJ).put("Svalbard and Jan Mayen", RegionCode.SJ).put("Slovak Republic", RegionCode.SK).put("Syrian Arab Republic", RegionCode.SY).put("East Timor", RegionCode.TL).put("Province of China Taiwan", RegionCode.TW).put("United Republic of Tanzania", RegionCode.TZ).put("USA", RegionCode.US).put("US", RegionCode.US).put("United States of America", RegionCode.US).put("The Vatican", RegionCode.VA).put("Holy See (Vatican City)", RegionCode.VA).put("Holy See (Vatican City State)", RegionCode.VA).put("St. Vincent and the Grenadines", RegionCode.VC).put("Saint Vincent and the Grenadines", RegionCode.VC).put("RB Venezuela", RegionCode.VE).put("Venezuela (Bolivarian Republic of)", RegionCode.VE).put("United States of Virgin Islands", RegionCode.VI).put("Rep. Yemen", RegionCode.YE).build();
    private static final ImmutableSet<RegionCode> OVERLAP_REGIONS = Sets.immutableEnumSet((Enum)RegionCode.UN003, (Enum[])new RegionCode[]{RegionCode.UN202, RegionCode.UN419, RegionCode.EU, RegionCode.QU, RegionCode.EZ, RegionCode.UN});
    private static final ImmutableSet<RegionCode> POLITICAL_OVERLAP_REGIONS = Sets.immutableEnumSet((Enum)RegionCode.EU, (Enum[])new RegionCode[]{RegionCode.QU, RegionCode.EZ, RegionCode.UN});
    private static final ImmutableListMultimap<RegionCode, RegionCode> REPLACEMENTS = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)new ImmutableListMultimap.Builder().putAll((Object)RegionCode.AN, (Object[])new RegionCode[]{RegionCode.CW, RegionCode.SX, RegionCode.BQ})).putAll((Object)RegionCode.BU, (Object[])new RegionCode[]{RegionCode.MM})).putAll((Object)RegionCode.CS, (Object[])new RegionCode[]{RegionCode.RS, RegionCode.ME})).putAll((Object)RegionCode.DD, (Object[])new RegionCode[]{RegionCode.DE})).putAll((Object)RegionCode.FX, (Object[])new RegionCode[]{RegionCode.FR})).putAll((Object)RegionCode.NT, (Object[])new RegionCode[]{RegionCode.SA, RegionCode.IQ})).putAll((Object)RegionCode.QU, (Object[])new RegionCode[]{RegionCode.EU})).putAll((Object)RegionCode.SU, (Object[])new RegionCode[]{RegionCode.RU, RegionCode.AM, RegionCode.AZ, RegionCode.BY, RegionCode.EE, RegionCode.GE, RegionCode.KZ, RegionCode.KG, RegionCode.LV, RegionCode.LT, RegionCode.MD, RegionCode.TJ, RegionCode.TM, RegionCode.UA, RegionCode.UZ})).putAll((Object)RegionCode.TP, (Object[])new RegionCode[]{RegionCode.TL})).putAll((Object)RegionCode.YD, (Object[])new RegionCode[]{RegionCode.YE})).putAll((Object)RegionCode.YU, (Object[])new RegionCode[]{RegionCode.RS, RegionCode.ME})).putAll((Object)RegionCode.ZR, (Object[])new RegionCode[]{RegionCode.CD})).build();
    private static final StandardRegionInfo INSTANCE = new StandardRegionInfo(CurrencyInfoFactory.CILoader.currencyInfo);

    @Inject
    StandardRegionInfo(CurrencyInfoImpl cinfo) {
        this.cinfo = Preconditions.checkNotNull(cinfo);
        this.buildTerritoryData();
        this.freezeTerritoryData();
        this.regionDisplayNames = RegionDisplayNames.createWithExtraEnglishNames(REPLACEMENTS, EXTRA_ENGLISH_NAMES);
    }

    public static StandardRegionInfo getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean contains(RegionCode regionCode, RegionCode possibleContainee) {
        Preconditions.checkNotNull(regionCode);
        Preconditions.checkNotNull(possibleContainee);
        return CONTAINMENT_GRAPH.hasPath(regionCode, possibleContainee);
    }

    @Override
    public Set<RegionCode> getDirectContents(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithEdgeFrom(regionCode);
    }

    @Override
    public Set<RegionCode> getAllContents(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithPathFrom(regionCode);
    }

    @Override
    public Set<RegionCode> getDirectContainers(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithEdgeTo(regionCode);
    }

    @Override
    public Set<RegionCode> getAllContainers(RegionCode regionCode) {
        Preconditions.checkNotNull(regionCode);
        return CONTAINMENT_GRAPH.getNodesWithPathTo(regionCode);
    }

    @Override
    public String getDisplayName(RegionCode regionCode, LanguageCode ... desiredDisplayLocales) {
        String rfcName = regionCode.toString();
        for (LanguageCode desiredDisplayLocale : desiredDisplayLocales) {
            String string = String.valueOf(rfcName);
            String result = ULocale.getDisplayCountry(string.length() != 0 ? "und-".concat(string) : new String("und-"), ULocaleConverter.CONVERTER.toOther(desiredDisplayLocale));
            if (result.equals(rfcName)) continue;
            return result;
        }
        String string = String.valueOf(rfcName);
        String result = ULocale.getDisplayCountry(string.length() != 0 ? "und-".concat(string) : new String("und-"), ULocale.ENGLISH);
        if (!result.equals(rfcName)) {
            return result;
        }
        return DISPLAY_NAME_OVERRIDES.containsKey((Object)regionCode) ? DISPLAY_NAME_OVERRIDES.get((Object)regionCode) : rfcName;
    }

    @Override
    public String getDisplayName(RegionCode regionCode, Locale desiredDisplayLocale, Locale ... fallbackDisplayLocales) {
        ArrayList<LanguageCode> desiredDisplayLanguages = new ArrayList<LanguageCode>();
        desiredDisplayLanguages.add(JavaLocaleConverter.CONVERTER.fromOther(desiredDisplayLocale));
        for (Locale fallbackDisplayLocale : fallbackDisplayLocales) {
            desiredDisplayLanguages.add(JavaLocaleConverter.CONVERTER.fromOther(fallbackDisplayLocale));
        }
        LanguageCode[] desiredLanguageCodes = desiredDisplayLanguages.toArray(new LanguageCode[desiredDisplayLanguages.size()]);
        return this.getDisplayName(regionCode, desiredLanguageCodes);
    }

    @Override
    public Comparator<RegionCode> getDisplayNameComparator(LanguageCode ... languages) {
        return StandardRegionInfo.getDisplayNameComparator(this, languages);
    }

    public static Ordering<RegionCode> getDisplayNameComparator(final RegionInfo regionInfo, final LanguageCode ... languages) {
        ULocale uLocale = languages.length == 0 ? ULocale.ROOT : ULocaleConverter.CONVERTER.toOther(languages[0]);
        Ordering<Object> collator = Ordering.from(Collator.getInstance(uLocale));
        return collator.onResultOf(new Function<RegionCode, String>(){

            @Override
            public String apply(RegionCode region) {
                return regionInfo.getDisplayName(region, languages);
            }
        }).compound(Ordering.usingToString());
    }

    @Override
    public boolean isOverlap(RegionCode regionCode) {
        return OVERLAP_REGIONS.contains((Object)regionCode);
    }

    @Override
    public boolean isPoliticalOverlap(RegionCode regionCode) {
        return POLITICAL_OVERLAP_REGIONS.contains((Object)regionCode);
    }

    @Override
    public RegionCode regionCodeFromDisplayName(String displayName, LanguageCode language) {
        return this.regionDisplayNames.getRegionCode(displayName, language);
    }

    @Override
    public List<RegionCode> getPreferredValues(RegionCode code) {
        return REPLACEMENTS.get((Object)code);
    }

    @Override
    public long getRegionPopulation(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        return data.population;
    }

    @Override
    public float getRegionLiteracy(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1.0f;
        }
        return data.literacy;
    }

    @Override
    public long getRegionGdp(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        return data.gdp;
    }

    @Override
    public Set<LanguageCode> getRegionLanguages(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return ImmutableSet.of();
        }
        return data.languageData.keySet();
    }

    @Override
    public Set<LanguageCode> getRegionOfficialLanguages(RegionCode region, final Set<LanguageCode.OfficialStatus> officialStatuses) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf(Maps.filterEntries(this.populationData.get((Object)((Object)region)).languageData, new Predicate<Map.Entry<LanguageCode, LanguageData>>(this){

            @Override
            public boolean apply(Map.Entry<LanguageCode, LanguageData> entry) {
                return entry.getValue().hasOfficialStatus() && officialStatuses.contains((Object)entry.getValue().officialStatus);
            }
        }).keySet());
    }

    @Override
    public LanguageCode getRegionMajorityLanguage(RegionCode region) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return LanguageCode.UNKNOWN;
        }
        long majorityLanguageSize = 0L;
        LanguageCode majorityLanguage = LanguageCode.UNKNOWN;
        for (Map.Entry<LanguageCode, LanguageData> dataEntry : data.languageData.entrySet()) {
            if (dataEntry.getValue().population <= majorityLanguageSize) continue;
            majorityLanguage = dataEntry.getKey();
            majorityLanguageSize = dataEntry.getValue().population;
        }
        return majorityLanguage;
    }

    @Override
    public long getRegionLanguagePopulation(RegionCode region, LanguageCode language) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1L;
        }
        LanguageData languageData = data.languageData.get(language);
        if (languageData == null) {
            return -1L;
        }
        return languageData.population;
    }

    @Override
    public float getRegionLanguageWritingPopulation(RegionCode region, LanguageCode language) {
        TerritoryData data = this.populationData.get((Object)region);
        if (data == null) {
            return -1.0f;
        }
        LanguageData languageData = data.languageData.get(language);
        if (languageData == null) {
            return -1.0f;
        }
        return languageData.writing;
    }

    @Override
    public RegionInfo.MeasurementSystem getMeasurementSystem(RegionCode region) {
        switch (region) {
            case LR: 
            case MM: 
            case US: {
                return RegionInfo.MeasurementSystem.US;
            }
        }
        return RegionInfo.MeasurementSystem.METRIC;
    }

    @Override
    public RegionInfo.TemperatureUnit getWeatherTemperatureUnit(RegionCode region) {
        switch (region) {
            case US: 
            case BS: 
            case BZ: 
            case KY: 
            case PR: 
            case PW: {
                return RegionInfo.TemperatureUnit.FAHRENHEIT;
            }
        }
        return RegionInfo.TemperatureUnit.CELSIUS;
    }

    @Override
    public RegionInfo.LengthUnits getRoadLengthUnits(RegionCode region) {
        switch (region) {
            case MM: 
            case GB: {
                return RegionInfo.LengthUnits.MILE_YARD;
            }
            case LR: 
            case US: {
                return RegionInfo.LengthUnits.MILE_FOOT;
            }
        }
        return RegionInfo.LengthUnits.KILOMETER_METER;
    }

    @Override
    public Set<CurrencyCode> getRegionCurrentCurrenciesInUse(RegionCode rc) {
        return this.cinfo.getCurrenciesInCurrentUseByRegion(rc);
    }

    @Override
    public Set<CurrencyCode> getRegionAllCurrenciesEverUsed(RegionCode rc) {
        return this.cinfo.getCurrenciesEverUsedByRegion(rc);
    }

    private TerritoryData addRegion(RegionCode codeToAddDataTo, double population, double literacy, double gdp) {
        TerritoryData data = new TerritoryData(population, literacy, gdp);
        this.populationData.put(codeToAddDataTo, data);
        return data;
    }

    private void freezeTerritoryData() {
        for (TerritoryData data : this.populationData.values()) {
            data.freeze();
        }
    }

    private void buildTerritoryData() {
        this.addRegion(RegionCode.AC, 940.0, 0.99, 4.223E7).addLanguage("en", 930.6, 0.99);
        this.addRegion(RegionCode.AD, 85708.0, 1.0, 3.327E9).addLanguage("ca", 43711.1, 1.0, "OFFICIAL").addLanguage("es", 36854.4, 1.0).addLanguage("fr", 5742.44, 1.0);
        this.addRegion(RegionCode.AE, 9701320.0, 0.9, 6.96E11).addLanguage("ar", 7567030.0, 0.9, "OFFICIAL").addLanguage("en", 4850660.0, 0.9).addLanguage("ml", 679092.0, 0.9).addLanguage("ps", 281338.0, 0.9).addLanguage("bal", 223130.0, 0.9).addLanguage("fa", 184325.0, 0.9);
        this.addRegion(RegionCode.AF, 3.49408E7, 0.281, 6.945E10).addLanguage("fa", 1.74704E7, 0.281, "OFFICIAL").addLanguage("ps", 1.50245E7, 0.281, "OFFICIAL").addLanguage("haz", 2061510.0, 0.281).addLanguage("uz_Arab", 1642220.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("tk", 593994.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("prd", 419290.0, 0.281).addLanguage("bal", 234103.0, 0.281, "OFFICIAL_REGIONAL").addLanguage("bgn", 220127.0, 0.05).addLanguage("ug", 3004.91, 0.281).addLanguage("kk_Arab", 1991.63, 0.281);
        this.addRegion(RegionCode.AG, 95882.0, 0.99, 2.398E9).addLanguage("en", 82458.5, 0.99, "OFFICIAL").addLanguage("pt", 1629.99, 0.99);
        this.addRegion(RegionCode.AI, 17422.0, 0.95, 1.754E8).addLanguage("en", 16550.9, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.AL, 3057220.0, 0.968, 3.601E10).addLanguage("sq", 3057220.0, 0.968, "OFFICIAL").addLanguage("el", 58087.2, 0.968).addLanguage("mk", 14368.9, 0.968);
        this.addRegion(RegionCode.AM, 3038220.0, 0.996, 2.834E10).addLanguage("hy", 2977460.0, 0.996, "OFFICIAL").addLanguage("ku", 100261.0, 0.996).addLanguage("az", 0.0, 0.996);
        this.addRegion(RegionCode.AO, 3.03559E7, 0.704, 1.936E11).addLanguage("pt", 2.03385E7, 0.704, "OFFICIAL").addLanguage("umb", 8803210.0, 0.704).addLanguage("kmb", 7588980.0, 0.704).addLanguage("ln", 203385.0, 0.704);
        this.addRegion(RegionCode.AQ, 300.0, 0.99, 1.776E7).addLanguage("und", 300.0, 0.99);
        this.addRegion(RegionCode.AR, 4.46942E7, 0.979, 9.221E11).addLanguage("es", 4.46942E7, 0.979, "OFFICIAL").addLanguage("en", 3128590.0, 0.979).addLanguage("cy", 29051.2, 0.979).addLanguage("gn", 21006.3, 0.979);
        this.addRegion(RegionCode.AS, 50826.0, 0.97, 6.58E8).addLanguage("sm", 50317.7, 0.97, "OFFICIAL").addLanguage("en", 49301.2, 0.97, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.AT, 8793370.0, 0.98, 4.41E11).addLanguage("de", 8529570.0, 0.98, "OFFICIAL").addLanguage("bar", 8353700.0, 0.98).addLanguage("en", 6419160.0, 0.98).addLanguage("fr", 967271.0, 0.98).addLanguage("it", 791403.0, 0.98).addLanguage("hr", 105520.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("sl", 32535.5, 0.98, "OFFICIAL_REGIONAL").addLanguage("hu", 23742.1, 0.98, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.AU, 2.34701E7, 0.99, 1.248E12).addLanguage("en", 2.25313E7, 0.99, "DE_FACTO_OFFICIAL").addLanguage("zh_Hant", 492872.0, 0.99).addLanguage("it", 445932.0, 0.99).addLanguage("wbp", 2581.71, 0.99);
        this.addRegion(RegionCode.AW, 116576.0, 0.968, 4.158E9).addLanguage("nl", 113079.0, 0.968, "OFFICIAL").addLanguage("pap", 71111.4, 0.968, "OFFICIAL").addLanguage("en", 3030.98, 0.968);
        this.addRegion(RegionCode.AX, 26200.0, 1.0, 9.298E8).addLanguage("sv", 25938.0, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.AZ, 1.00465E7, 0.998, 1.722E11).addLanguage("az", 8941380.0, 0.998, "OFFICIAL").addLanguage("az_Cyrl", 994604.0, 0.998, "OFFICIAL").addLanguage("tly", 984557.0, 0.998).addLanguage("ku", 24111.6, 0.998).addLanguage("ttt", 22102.3, 0.998).addLanguage("tkr", 16074.4, 0.998);
        this.addRegion(RegionCode.BA, 3849890.0, 0.98, 4.483E10).addLanguage("bs", 3811390.0, 0.98, "OFFICIAL").addLanguage("bs_Cyrl", 3811390.0, 0.05, "OFFICIAL").addLanguage("en", 1732450.0, 0.98).addLanguage("hr", 461987.0, 0.98, "OFFICIAL").addLanguage("sr", 384989.0, 0.98, "OFFICIAL").addLanguage("sr_Latn", 384989.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.BB, 293131.0, 0.997, 5.218E9).addLanguage("en", 293131.0, 0.997, "OFFICIAL");
        this.addRegion(RegionCode.BD, 1.59453E8, 0.577, 6.903E11).addLanguage("bn", 1.56264E8, 0.577, "OFFICIAL").addLanguage("en", 2.87015E7, 0.577).addLanguage("rkt", 1.03644E7, 0.577).addLanguage("syl", 7972650.0, 0.577).addLanguage("ccp", 350797.0, 0.577).addLanguage("my", 334851.0, 0.577).addLanguage("grt", 116401.0, 0.577).addLanguage("mro", 28701.5, 0.577).addLanguage("mni", 17539.8, 0.577);
        this.addRegion(RegionCode.BE, 1.15708E7, 0.99, 5.292E11).addLanguage("en", 6826770.0, 0.99).addLanguage("nl", 6363940.0, 0.99, "OFFICIAL").addLanguage("fr", 4396900.0, 0.99, "OFFICIAL").addLanguage("de", 2545580.0, 0.99, "OFFICIAL").addLanguage("vls", 1157080.0, 0.99).addLanguage("wa", 671106.0, 0.05);
        this.addRegion(RegionCode.BF, 1.97427E7, 0.287, 3.585E10).addLanguage("mos", 7897080.0, 0.287).addLanguage("dyu", 6317660.0, 0.287).addLanguage("fr", 4343390.0, 0.287, "OFFICIAL").addLanguage("ff", 0.0, 0.287).addLanguage("ff_Adlm", 0.0, 0.287);
        this.addRegion(RegionCode.BG, 7057500.0, 0.984, 1.535E11).addLanguage("bg", 7057500.0, 0.984, "OFFICIAL").addLanguage("en", 1764380.0, 0.984).addLanguage("ru", 1623220.0, 0.984).addLanguage("tr", 776325.0, 0.984).addLanguage("de", 564600.0, 0.984);
        this.addRegion(RegionCode.BH, 1442660.0, 0.946, 7.117E10).addLanguage("ar", 1255110.0, 0.946, "OFFICIAL").addLanguage("ml", 47607.8, 0.946);
        this.addRegion(RegionCode.BI, 1.18445E7, 0.672, 8.007E9).addLanguage("rn", 7462040.0, 0.672, "OFFICIAL").addLanguage("fr", 6988260.0, 0.672, "OFFICIAL").addLanguage("sw", 6396.03, 0.672).addLanguage("en", 6277.59, 0.672, "OFFICIAL");
        this.addRegion(RegionCode.BJ, 1.13405E7, 0.424, 2.539E10).addLanguage("fr", 3969180.0, 0.424, "OFFICIAL").addLanguage("fon", 2835120.0, 0.424).addLanguage("yo", 759814.0, 0.424);
        this.addRegion(RegionCode.BL, 7160.0, 0.99, 2.55E8).addLanguage("fr", 6873.6, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.BM, 71176.0, 0.98, 6.127E9).addLanguage("en", 65481.9, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.BN, 450565.0, 0.954, 3.387E10).addLanguage("ms", 419025.0, 0.954, "OFFICIAL").addLanguage("zh_Hant", 49562.2, 0.954).addLanguage("ms_Arab", 22528.2, 0.954, "OFFICIAL").addLanguage("en", 8110.17, 0.954);
        this.addRegion(RegionCode.BO, 1.13063E7, 0.912, 8.372E10).addLanguage("es", 6896840.0, 0.912, "OFFICIAL").addLanguage("qu", 3618020.0, 0.912, "OFFICIAL").addLanguage("ay", 2261260.0, 0.912, "OFFICIAL").addLanguage("gn", 50878.3, 0.912).addLanguage("aro", 113.063, 0.912);
        this.addRegion(RegionCode.BQ, 20000.0, 0.96, 4.164E8).addLanguage("pap", 16200.0, 0.96).addLanguage("nl", 1600.0, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.BR, 2.08847E8, 0.904, 3.248E12).addLanguage("pt", 1.90051E8, 0.904, "OFFICIAL").addLanguage("en", 1.67078E7, 0.904).addLanguage("de", 1754310.0, 0.904).addLanguage("it", 584772.0, 0.904).addLanguage("ja", 438579.0, 0.904).addLanguage("es", 77273.4, 0.904).addLanguage("ko", 43857.9, 0.904).addLanguage("kgp", 20884.7, 0.904).addLanguage("gub", 17543.1, 0.904).addLanguage("yrl", 10860.0, 0.904).addLanguage("xav", 10024.7, 0.904);
        this.addRegion(RegionCode.BS, 332634.0, 0.956, 1.206E10).addLanguage("en", 332634.0, 0.956, "OFFICIAL");
        this.addRegion(RegionCode.BT, 766397.0, 0.528, 7.205E9).addLanguage("dz", 360207.0, 0.528, "OFFICIAL").addLanguage("ne", 130287.0, 0.528).addLanguage("tsj", 114960.0, 0.528).addLanguage("en", 84303.7, 0.528).addLanguage("lep", 29889.5, 0.528);
        this.addRegion(RegionCode.BV, 1.0, 0.99, 44930.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.BW, 2249100.0, 0.851, 3.901E10).addLanguage("en", 1821770.0, 0.851, "OFFICIAL").addLanguage("tn", 1394440.0, 0.851, "OFFICIAL").addLanguage("af", 6072.57, 0.851);
        this.addRegion(RegionCode.BY, 9527540.0, 0.996, 1.794E11).addLanguage("be", 9527540.0, 0.996, "OFFICIAL").addLanguage("ru", 1143300.0, 0.996, "OFFICIAL");
        this.addRegion(RegionCode.BZ, 385854.0, 0.769, 3.218E9).addLanguage("en", 385854.0, 0.769, "OFFICIAL").addLanguage("es", 108039.0, 0.769);
        this.addRegion(RegionCode.CA, 3.58817E7, 0.99, 1.774E12).addLanguage("en", 3.08583E7, 0.99, "OFFICIAL").addLanguage("fr", 7893970.0, 0.99, "OFFICIAL").addLanguage("it", 717634.0, 0.99).addLanguage("de", 681752.0, 0.99).addLanguage("pdt", 86116.1, 0.99).addLanguage("cr", 39469.9, 0.99).addLanguage("crk", 39469.9, 0.99).addLanguage("yi", 16146.8, 0.99).addLanguage("iu", 15070.3, 0.99, "OFFICIAL_REGIONAL").addLanguage("iu_Latn", 15070.3, 0.99, "OFFICIAL_REGIONAL").addLanguage("moe", 11841.0, 0.99).addLanguage("crj", 7176.34, 0.99).addLanguage("atj", 5741.07, 0.99).addLanguage("crl", 5382.26, 0.99).addLanguage("csw", 5023.44, 0.99).addLanguage("crm", 4664.62, 0.99).addLanguage("ikt", 3946.99, 0.99, "OFFICIAL_REGIONAL").addLanguage("moh", 3516.41, 0.99).addLanguage("dgr", 2655.25, 0.99).addLanguage("den", 2296.43, 0.99).addLanguage("scs", 1255.86, 0.99).addLanguage("nsk", 1184.1, 0.99).addLanguage("chp", 753.516, 0.99).addLanguage("gwi", 574.107, 0.99);
        this.addRegion(RegionCode.CC, 596.0, 0.99, 3.169E7).addLanguage("ms_Arab", 494.68, 0.99).addLanguage("en", 101.32, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.CD, 8.5281E7, 0.668, 6.86E10).addLanguage("sw", 4.26405E7, 0.668, "OFFICIAL_REGIONAL").addLanguage("lua", 8186980.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("fr", 3240680.0, 0.668, "OFFICIAL").addLanguage("ln", 2643710.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("lu", 1961460.0, 0.668).addLanguage("kg", 1279220.0, 0.668, "OFFICIAL_REGIONAL").addLanguage("lol", 520214.0, 0.668).addLanguage("rw", 324068.0, 0.668);
        this.addRegion(RegionCode.CF, 5745060.0, 0.566, 3.39E9).addLanguage("fr", 2815080.0, 0.566, "OFFICIAL").addLanguage("sg", 2815080.0, 0.566, "OFFICIAL").addLanguage("ln", 13788.1, 0.566);
        this.addRegion(RegionCode.CG, 5062020.0, 0.838, 2.939E10).addLanguage("fr", 4252100.0, 0.838, "OFFICIAL").addLanguage("ln", 121488.0, 0.838);
        this.addRegion(RegionCode.CH, 8292810.0, 0.99, 5.231E11).addLanguage("de", 6053750.0, 0.99, "OFFICIAL").addLanguage("gsw", 5390330.0, 0.05, "DE_FACTO_OFFICIAL").addLanguage("en", 5058610.0, 0.99).addLanguage("fr", 1741490.0, 0.99, "OFFICIAL").addLanguage("it", 356591.0, 0.99, "OFFICIAL").addLanguage("lmo", 340005.0, 0.05).addLanguage("pt", 281956.0, 0.99).addLanguage("rm", 41464.1, 0.99, "OFFICIAL_REGIONAL").addLanguage("rmo", 24049.1, 0.99).addLanguage("wae", 9951.37, 0.99);
        this.addRegion(RegionCode.CI, 2.62606E7, 0.569, 9.716E10).addLanguage("fr", 1.28677E7, 0.569, "OFFICIAL").addLanguage("bci", 2888670.0, 0.569).addLanguage("sef", 1129210.0, 0.05).addLanguage("dnj", 1050420.0, 0.569).addLanguage("kfo", 60399.4, 0.569).addLanguage("bqv", 44643.0, 0.569);
        this.addRegion(RegionCode.CK, 9038.0, 0.95, 2.999E8).addLanguage("en", 8857.24, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.CL, 1.79253E7, 0.986, 4.521E11).addLanguage("es", 1.75668E7, 0.986, "OFFICIAL").addLanguage("en", 1702900.0, 0.986).addLanguage("arn", 268880.0, 0.986);
        this.addRegion(RegionCode.CM, 2.5641E7, 0.713, 8.954E10).addLanguage("fr", 1.74359E7, 0.713, "OFFICIAL").addLanguage("en", 9743580.0, 0.713, "OFFICIAL").addLanguage("bum", 1179490.0, 0.713).addLanguage("ff", 923076.0, 0.713).addLanguage("ewo", 794871.0, 0.713).addLanguage("ybb", 410256.0, 0.713).addLanguage("bbj", 358974.0, 0.713).addLanguage("nnh", 358974.0, 0.713).addLanguage("bkm", 333333.0, 0.05).addLanguage("bas", 307692.0, 0.713).addLanguage("bax", 307692.0, 0.713).addLanguage("byv", 282051.0, 0.713).addLanguage("mua", 256410.0, 0.713).addLanguage("maf", 189743.0, 0.713).addLanguage("bfd", 146154.0, 0.713).addLanguage("bss", 138461.0, 0.713).addLanguage("kkj", 138461.0, 0.713).addLanguage("dua", 123077.0, 0.713).addLanguage("mgo", 120513.0, 0.05).addLanguage("ar", 99999.9, 0.713).addLanguage("jgo", 87179.4, 0.713).addLanguage("ksf", 82051.2, 0.713).addLanguage("agq", 35897.4, 0.713).addLanguage("ha_Arab", 35897.4, 0.713).addLanguage("nmg", 8974.35, 0.713).addLanguage("yav", 2307.69, 0.713).addLanguage("ff_Adlm", 0.0, 0.713);
        this.addRegion(RegionCode.CN, 1.38469E9, 0.951, 2.321E13).addLanguage("zh", 1.24622E9, 0.951, "OFFICIAL").addLanguage("wuu", 8.30814E7, 0.951).addLanguage("yue_Hans", 7.20039E7, 0.951).addLanguage("hsn", 4.0156E7, 0.951).addLanguage("hak", 3.18479E7, 0.951).addLanguage("nan", 2.63091E7, 0.951).addLanguage("gan", 2.35397E7, 0.951).addLanguage("ii", 8308140.0, 0.951).addLanguage("ug", 7615800.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("za", 4292540.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("mn_Mong", 3600190.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("bo", 2769380.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("ko", 2077040.0, 0.951, "OFFICIAL_REGIONAL").addLanguage("kk_Arab", 1190830.0, 0.951).addLanguage("lis", 623110.0, 0.951).addLanguage("ky_Arab", 470795.0, 0.951).addLanguage("nxq", 332326.0, 0.951).addLanguage("khb", 263091.0, 0.951).addLanguage("tdd", 263091.0, 0.951).addLanguage("lcp", 80312.0, 0.951).addLanguage("en", 62311.0, 0.951).addLanguage("ru", 13846.9, 0.951).addLanguage("vi", 6923.45, 0.951).addLanguage("uz_Cyrl", 5538.76, 0.951).addLanguage("lzh", 0.0, 0.951);
        this.addRegion(RegionCode.CO, 4.8169E7, 0.936, 7.116E11).addLanguage("es", 4.47972E7, 0.936, "OFFICIAL").addLanguage("guc", 130056.0, 0.936);
        this.addRegion(RegionCode.CP, 1.0, 0.99, 42400.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.CR, 4987140.0, 0.963, 8.394E10).addLanguage("es", 4737780.0, 0.963, "OFFICIAL");
        this.addRegion(RegionCode.CU, 1.11164E7, 0.998, 1.37E11).addLanguage("es", 1.11164E7, 0.998, "OFFICIAL");
        this.addRegion(RegionCode.CV, 568373.0, 0.849, 3.777E9).addLanguage("kea", 517219.0, 0.849).addLanguage("pt", 431963.0, 0.849, "OFFICIAL");
        this.addRegion(RegionCode.CW, 150241.0, 0.96, 3.128E9).addLanguage("pap", 121695.0, 0.96, "DE_FACTO_OFFICIAL").addLanguage("nl", 12019.3, 0.96, "OFFICIAL").addLanguage("es", 5709.16, 0.96);
        this.addRegion(RegionCode.CX, 2205.0, 0.99, 1.172E8).addLanguage("en", 1389.15, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.CY, 1237090.0, 0.987, 3.178E10).addLanguage("el", 1175240.0, 0.987, "OFFICIAL").addLanguage("en", 903076.0, 0.987).addLanguage("tr", 284531.0, 0.987, "OFFICIAL").addLanguage("fr", 86596.3, 0.987).addLanguage("hy", 2721.6, 0.987).addLanguage("ar", 1360.8, 0.987);
        this.addRegion(RegionCode.CZ, 1.06863E7, 0.99, 3.759E11).addLanguage("cs", 1.04726E7, 0.99, "OFFICIAL").addLanguage("en", 2885300.0, 0.99).addLanguage("sk", 1709810.0, 0.99).addLanguage("de", 1602940.0, 0.99).addLanguage("pl", 52362.9, 0.99);
        this.addRegion(RegionCode.DE, 8.04577E7, 0.99, 4.199E12).addLanguage("de", 7.32165E7, 0.99, "OFFICIAL").addLanguage("en", 5.14929E7, 0.99).addLanguage("fr", 1.44824E7, 0.99).addLanguage("bar", 1.36778E7, 0.05).addLanguage("nds", 9654920.0, 0.05).addLanguage("nl", 7241190.0, 0.99).addLanguage("it", 5632040.0, 0.99).addLanguage("es", 4827460.0, 0.99).addLanguage("ru", 4827460.0, 0.99).addLanguage("vmf", 4827460.0, 0.99).addLanguage("tr", 2011440.0, 0.99).addLanguage("gsw", 1850530.0, 0.05).addLanguage("da", 1609150.0, 0.99).addLanguage("swg", 804577.0, 0.05).addLanguage("hr", 635616.0, 0.99).addLanguage("ku", 531021.0, 0.99).addLanguage("el", 305739.0, 0.99).addLanguage("ksh", 241373.0, 0.99).addLanguage("pl", 233327.0, 0.99).addLanguage("hsb", 12873.2, 0.05).addLanguage("frr", 9654.92, 0.99).addLanguage("dsb", 6999.82, 0.05).addLanguage("frs", 2011.44, 0.99).addLanguage("stq", 965.492, 0.99).addLanguage("pfl", 0.0, 0.99);
        this.addRegion(RegionCode.DG, 500.0, 0.99, 2.246E7).addLanguage("en", 495.0, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.DJ, 884017.0, 0.679, 3.64E9).addLanguage("aa", 371287.0, 0.679).addLanguage("so", 362447.0, 0.679).addLanguage("ar", 64533.2, 0.679, "OFFICIAL").addLanguage("fr", 18564.4, 0.679, "OFFICIAL");
        this.addRegion(RegionCode.DK, 5809500.0, 0.99, 2.878E11).addLanguage("da", 5402840.0, 0.99, "OFFICIAL").addLanguage("en", 4996170.0, 0.99).addLanguage("de", 2730460.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("sv", 755235.0, 0.99).addLanguage("fo", 22076.1, 0.99).addLanguage("kl", 6971.4, 0.99, "OFFICIAL_REGIONAL").addLanguage("jut", 0.0, 0.99);
        this.addRegion(RegionCode.DM, 74027.0, 0.94, 7.83E8).addLanguage("en", 69585.4, 0.94, "OFFICIAL");
        this.addRegion(RegionCode.DO, 1.02988E7, 0.901, 1.73E11).addLanguage("es", 8033060.0, 0.901, "OFFICIAL").addLanguage("en", 8033.06, 0.901);
        this.addRegion(RegionCode.DZ, 4.16575E7, 0.726, 6.3E11).addLanguage("arq", 3.45757E7, 0.726).addLanguage("ar", 3.08266E7, 0.726, "OFFICIAL").addLanguage("fr", 8331500.0, 0.726, "OFFICIAL").addLanguage("kab", 3249280.0, 0.726).addLanguage("en", 2916020.0, 0.726);
        this.addRegion(RegionCode.EA, 150000.0, 0.977, 5.406E9).addLanguage("es", 147000.0, 0.977, "OFFICIAL");
        this.addRegion(RegionCode.EC, 1.64985E7, 0.916, 1.93E11).addLanguage("es", 1.58386E7, 0.916, "OFFICIAL").addLanguage("qu", 2804740.0, 0.916, "OFFICIAL").addLanguage("qug", 940414.0, 0.916);
        this.addRegion(RegionCode.EE, 1244290.0, 0.998, 4.165E10).addLanguage("et", 883446.0, 0.998, "OFFICIAL").addLanguage("ru", 696802.0, 0.998).addLanguage("en", 622145.0, 0.998).addLanguage("fi", 261301.0, 0.998).addLanguage("vro", 70924.5, 0.998);
        this.addRegion(RegionCode.EG, 9.94133E7, 0.739, 1.204E12).addLanguage("ar", 9.34485E7, 0.739, "OFFICIAL").addLanguage("arz", 6.36245E7, 0.739).addLanguage("en", 3.47947E7, 0.739).addLanguage("el", 60642.1, 0.739);
        this.addRegion(RegionCode.EH, 619551.0, 0.5, 9.065E8).addLanguage("ar", 619551.0, 0.5, "OFFICIAL");
        this.addRegion(RegionCode.ER, 5970650.0, 0.689, 9.402E9).addLanguage("ti", 3582390.0, 0.689, "DE_FACTO_OFFICIAL").addLanguage("en", 3522680.0, 0.689, "OFFICIAL").addLanguage("tig", 1074720.0, 0.689).addLanguage("ar", 292562.0, 0.05, "OFFICIAL").addLanguage("aa", 214943.0, 0.689).addLanguage("ssy", 214943.0, 0.689).addLanguage("byn", 77618.4, 0.689);
        this.addRegion(RegionCode.ES, 4.93311E7, 0.977, 1.778E12).addLanguage("es", 4.88378E7, 0.977, "OFFICIAL").addLanguage("en", 1.18395E7, 0.977).addLanguage("ca", 8386290.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("gl", 3453180.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("eu", 986622.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("ast", 641304.0, 0.977, "OFFICIAL_REGIONAL").addLanguage("ext", 241722.0, 0.977);
        this.addRegion(RegionCode.ET, 1.08386E8, 0.39, 2.006E11).addLanguage("en", 4.6606E7, 0.39).addLanguage("am", 3.57674E7, 0.39, "OFFICIAL").addLanguage("om", 3.46835E7, 0.39).addLanguage("so", 6503160.0, 0.39).addLanguage("ti", 6503160.0, 0.39).addLanguage("sid", 3793510.0, 0.39).addLanguage("wal", 1950950.0, 0.39).addLanguage("aa", 1517400.0, 0.39);
        this.addRegion(RegionCode.FI, 5537360.0, 1.0, 2.449E11).addLanguage("fi", 5205120.0, 1.0, "OFFICIAL").addLanguage("en", 3876150.0, 1.0).addLanguage("sv", 2436440.0, 1.0, "OFFICIAL").addLanguage("de", 996725.0, 1.0).addLanguage("ru", 44852.6, 1.0).addLanguage("et", 6091.1, 1.0).addLanguage("rmf", 4983.62, 1.0).addLanguage("se", 1993.45, 1.0).addLanguage("smn", 609.11, 1.0).addLanguage("sms", 609.11, 1.0);
        this.addRegion(RegionCode.FJ, 926276.0, 0.937, 8.629E9).addLanguage("en", 870699.0, 0.937, "OFFICIAL").addLanguage("hi", 407561.0, 0.937).addLanguage("hif", 379773.0, 0.937, "OFFICIAL").addLanguage("fj", 361248.0, 0.937, "OFFICIAL").addLanguage("rtm", 2500.95, 0.937);
        this.addRegion(RegionCode.FK, 3198.0, 0.99, 2.064E8).addLanguage("en", 2814.24, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.FM, 103643.0, 0.89, 3.48E8).addLanguage("en", 59076.5, 0.89, "OFFICIAL").addLanguage("chk", 31092.9, 0.89).addLanguage("pon", 23837.9, 0.89).addLanguage("kos", 7980.51, 0.89).addLanguage("yap", 6633.15, 0.89).addLanguage("uli", 3005.65, 0.89);
        this.addRegion(RegionCode.FO, 51018.0, 0.99, 2.001E9).addLanguage("fo", 48467.1, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.FR, 6.73644E7, 0.99, 2.856E12).addLanguage("fr", 6.66908E7, 0.99, "OFFICIAL").addLanguage("en", 2.62721E7, 0.99).addLanguage("es", 8757370.0, 0.99).addLanguage("de", 3368220.0, 0.99).addLanguage("oc", 2020930.0, 0.05).addLanguage("it", 1145190.0, 0.99).addLanguage("pt", 875737.0, 0.99).addLanguage("pcd", 741008.0, 0.99).addLanguage("gsw", 613016.0, 0.05).addLanguage("br", 559125.0, 0.99).addLanguage("co", 161675.0, 0.05).addLanguage("ca", 114519.0, 0.99).addLanguage("nl", 87573.7, 0.99).addLanguage("eu", 87573.7, 0.99).addLanguage("frp", 63322.5, 0.99).addLanguage("ia", 134.729, 0.99);
        this.addRegion(RegionCode.GA, 2119040.0, 0.89, 3.666E10).addLanguage("fr", 1335000.0, 0.89, "OFFICIAL").addLanguage("puu", 190714.0, 0.89);
        this.addRegion(RegionCode.GB, 6.51052E7, 0.99, 2.925E12).addLanguage("en", 6.44541E7, 0.99, "OFFICIAL").addLanguage("fr", 1.237E7, 0.99).addLanguage("de", 3906310.0, 0.99).addLanguage("sco", 1757840.0, 0.05).addLanguage("pa", 514331.0, 0.99).addLanguage("cy", 501310.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("bn", 436205.0, 0.99).addLanguage("zh_Hant", 351568.0, 0.99).addLanguage("syl", 325526.0, 0.99).addLanguage("el", 221358.0, 0.99).addLanguage("it", 221358.0, 0.99).addLanguage("ks", 123700.0, 0.99).addLanguage("gd", 64454.1, 0.05, "OFFICIAL_REGIONAL").addLanguage("yi", 31901.5, 0.99).addLanguage("ml", 22786.8, 0.99).addLanguage("ga", 16927.4, 0.99, "OFFICIAL_REGIONAL").addLanguage("kw", 2018.26, 0.99);
        this.addRegion(RegionCode.GD, 112207.0, 0.96, 1.634E9).addLanguage("en", 107719.0, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.GE, 4926090.0, 0.997, 3.985E10).addLanguage("ka", 4236440.0, 0.997, "OFFICIAL").addLanguage("xmf", 541870.0, 0.997).addLanguage("ru", 443348.0, 0.997).addLanguage("hy", 344826.0, 0.997).addLanguage("ab", 108374.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("os", 108374.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ku", 43842.2, 0.997);
        this.addRegion(RegionCode.GF, 199509.0, 0.83, 1.551E9).addLanguage("fr", 153622.0, 0.83, "OFFICIAL").addLanguage("gcr", 51872.3, 0.83).addLanguage("zh_Hant", 4987.73, 0.83);
        this.addRegion(RegionCode.GG, 66697.0, 1.0, 3.465E9).addLanguage("en", 66697.0, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.GH, 2.81025E7, 0.715, 1.34E11).addLanguage("ak", 1.096E7, 0.715, "OFFICIAL_REGIONAL").addLanguage("en", 5901520.0, 0.715, "OFFICIAL").addLanguage("ee", 3091280.0, 0.715, "OFFICIAL_REGIONAL").addLanguage("abr", 1405120.0, 0.715).addLanguage("gur", 983588.0, 0.715).addLanguage("ada", 843075.0, 0.715).addLanguage("gaa", 786870.0, 0.715, "OFFICIAL_REGIONAL").addLanguage("nzi", 281025.0, 0.715).addLanguage("ha", 244492.0, 0.715).addLanguage("saf", 3934.35, 0.715).addLanguage("ff", 0.0, 0.715).addLanguage("ff_Adlm", 0.0, 0.715);
        this.addRegion(RegionCode.GI, 29461.0, 0.8, 2.044E9).addLanguage("en", 23568.8, 0.8, "OFFICIAL").addLanguage("es", 14730.5, 0.8);
        this.addRegion(RegionCode.GL, 57691.0, 1.0, 2.413E9).addLanguage("kl", 48460.4, 1.0, "OFFICIAL").addLanguage("da", 8076.74, 1.0);
        this.addRegion(RegionCode.GM, 2092730.0, 0.511, 5.556E9).addLanguage("en", 837092.0, 0.511, "OFFICIAL").addLanguage("man", 606892.0, 0.511).addLanguage("ff", 0.0, 0.511).addLanguage("ff_Adlm", 0.0, 0.511);
        this.addRegion(RegionCode.GN, 1.18554E7, 0.41, 2.797E10).addLanguage("fr", 3438070.0, 0.41, "OFFICIAL").addLanguage("ff", 3082400.0, 0.41).addLanguage("man_Nkoo", 2726740.0, 0.41).addLanguage("sus", 1304090.0, 0.41).addLanguage("nqo", 592770.0, 0.41).addLanguage("kpe", 450505.0, 0.41).addLanguage("ff_Adlm", 0.0, 0.41);
        this.addRegion(RegionCode.GP, 452776.0, 0.9, 3.513E9).addLanguage("fr", 407498.0, 0.9, "OFFICIAL");
        this.addRegion(RegionCode.GQ, 797457.0, 0.942, 3.152E10).addLanguage("es", 693788.0, 0.942, "OFFICIAL").addLanguage("fan", 406703.0, 0.942).addLanguage("fr", 70176.2, 0.942, "OFFICIAL").addLanguage("bvb", 62999.1, 0.942).addLanguage("pt", 0.797457, 0.942, "OFFICIAL");
        this.addRegion(RegionCode.GR, 1.07615E7, 0.973, 2.993E11).addLanguage("el", 1.06539E7, 0.973, "OFFICIAL").addLanguage("en", 5488360.0, 0.973).addLanguage("fr", 968535.0, 0.973).addLanguage("de", 538075.0, 0.973).addLanguage("pnt", 398176.0, 0.973).addLanguage("mk", 172184.0, 0.973).addLanguage("tr", 129138.0, 0.973).addLanguage("bg", 29056.0, 0.973).addLanguage("sq", 10008.2, 0.973).addLanguage("tsd", 204.468, 0.973);
        this.addRegion(RegionCode.GS, 20.0, 0.99, 898500.0).addLanguage("und", 20.0, 0.99);
        this.addRegion(RegionCode.GT, 1.65813E7, 0.759, 1.381E11).addLanguage("es", 1.54206E7, 0.759, "OFFICIAL").addLanguage("quc", 1160690.0, 0.759, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.GU, 167772.0, 0.99, 5.793E9).addLanguage("en", 152673.0, 0.99, "DE_FACTO_OFFICIAL").addLanguage("ch", 36909.8, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.GW, 1833250.0, 0.553, 3.171E9).addLanguage("pt", 1833250.0, 0.553, "OFFICIAL").addLanguage("knf", 47664.5, 0.553).addLanguage("ff", 1.83325, 0.553).addLanguage("ff_Adlm", 1.83325, 0.553);
        this.addRegion(RegionCode.GY, 740685.0, 0.918, 6.301E9).addLanguage("en", 740685.0, 0.918, "OFFICIAL");
        this.addRegion(RegionCode.HK, 7213340.0, 0.935, 4.559E11).addLanguage("zh_Hant", 6852670.0, 0.935, "OFFICIAL").addLanguage("yue", 6492010.0, 0.935).addLanguage("en", 3678800.0, 0.935, "OFFICIAL").addLanguage("zh", 360667.0, 0.935);
        this.addRegion(RegionCode.HM, 1.0, 0.99, 53170.0).addLanguage("und", 1.0, 0.99);
        this.addRegion(RegionCode.HN, 9182770.0, 0.851, 4.63E10).addLanguage("es", 7162560.0, 0.851, "OFFICIAL").addLanguage("en", 40404.2, 0.851);
        this.addRegion(RegionCode.HR, 4270480.0, 0.989, 1.021E11).addLanguage("hr", 4227780.0, 0.989, "OFFICIAL").addLanguage("en", 2092540.0, 0.989).addLanguage("it", 68327.7, 0.989, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.HT, 1.07884E7, 0.487, 1.997E10).addLanguage("ht", 8738600.0, 0.487, "OFFICIAL").addLanguage("fr", 507055.0, 0.487, "OFFICIAL");
        this.addRegion(RegionCode.HU, 9825700.0, 0.99, 2.896E11).addLanguage("hu", 9825700.0, 0.99, "OFFICIAL").addLanguage("en", 1965140.0, 0.99).addLanguage("de", 1768630.0, 0.99).addLanguage("fr", 294771.0, 0.99).addLanguage("ro", 97274.4, 0.99).addLanguage("hr", 31442.2, 0.99).addLanguage("sk", 10808.3, 0.99).addLanguage("sl", 5011.11, 0.99);
        this.addRegion(RegionCode.IC, 2098590.0, 0.977, 7.564E10).addLanguage("es", 2056620.0, 0.977, "OFFICIAL");
        this.addRegion(RegionCode.ID, 2.62787E8, 0.928, 3.25E12).addLanguage("id", 1.68184E8, 0.928, "OFFICIAL").addLanguage("jv", 8.93476E7, 0.928).addLanguage("su", 3.15344E7, 0.928).addLanguage("mad", 1.65556E7, 0.928).addLanguage("ms_Arab", 1.20882E7, 0.928).addLanguage("min", 7883610.0, 0.928).addLanguage("bew", 5518530.0, 0.928).addLanguage("ban", 4730170.0, 0.928).addLanguage("bug", 4204590.0, 0.928).addLanguage("bjn", 3941800.0, 0.928).addLanguage("ace", 3679020.0, 0.928).addLanguage("sas", 2549030.0, 0.928).addLanguage("bbc", 2417640.0, 0.928).addLanguage("zh_Hant", 2417640.0, 0.928).addLanguage("mak", 1918350.0, 0.928).addLanguage("ljp", 1813230.0, 0.928).addLanguage("rej", 1208820.0, 0.928).addLanguage("gor", 1077430.0, 0.928).addLanguage("nij", 972312.0, 0.928).addLanguage("kge", 840918.0, 0.928).addLanguage("aoz", 709525.0, 0.928).addLanguage("kvr", 367902.0, 0.928).addLanguage("lbw", 341623.0, 0.928).addLanguage("gay", 315344.0, 0.928).addLanguage("rob", 289066.0, 0.928).addLanguage("mdr", 241764.0, 0.928).addLanguage("sxn", 241764.0, 0.928).addLanguage("sly", 141905.0, 0.928).addLanguage("mwv", 63068.9, 0.928);
        this.addRegion(RegionCode.IE, 5068050.0, 0.99, 3.533E11).addLanguage("en", 4966690.0, 0.99, "OFFICIAL").addLanguage("ga", 1114970.0, 0.99, "OFFICIAL").addLanguage("fr", 861568.0, 0.99);
        this.addRegion(RegionCode.IL, 8424900.0, 0.971, 3.171E11).addLanguage("he", 8424900.0, 0.971, "OFFICIAL").addLanguage("en", 7161160.0, 0.971).addLanguage("ar", 1684980.0, 0.971, "OFFICIAL").addLanguage("ru", 926739.0, 0.971).addLanguage("ro", 311721.0, 0.971).addLanguage("yi", 252747.0, 0.971).addLanguage("pl", 126374.0, 0.971).addLanguage("lad", 109524.0, 0.971).addLanguage("hu", 84249.0, 0.971).addLanguage("am", 49706.9, 0.971).addLanguage("ti", 10109.9, 0.971).addLanguage("ml", 8003.65, 0.971);
        this.addRegion(RegionCode.IM, 89407.0, 0.99, 6.792E9).addLanguage("en", 89407.0, 0.99, "OFFICIAL").addLanguage("gv", 1698.73, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.IN, 1.29683E9, 0.628, 9.474E12).addLanguage("hi", 5.317E8, 0.628, "OFFICIAL").addLanguage("en", 2.46398E8, 0.628, "OFFICIAL").addLanguage("bn", 1.05043E8, 0.628, "OFFICIAL_REGIONAL").addLanguage("te", 9.33718E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("mr", 9.07781E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ta", 7.6513E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ur", 6.48415E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("gu", 5.83574E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("kn", 4.79827E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("ml", 4.14986E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("or", 4.14986E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("pa", 3.63112E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("bho", 2.98271E7, 0.628).addLanguage("awa", 2.33429E7, 0.05).addLanguage("as", 1.68588E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("bgc", 1.5562E7, 0.628).addLanguage("mag", 1.5562E7, 0.628).addLanguage("mwr", 1.5562E7, 0.628).addLanguage("mai", 1.5562E7, 0.628, "OFFICIAL_REGIONAL").addLanguage("hne", 1.42651E7, 0.628).addLanguage("dcc", 1.29683E7, 0.628).addLanguage("bjj", 7262250.0, 0.628).addLanguage("ne", 7262250.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("sat", 7132560.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("wtm", 5965420.0, 0.628).addLanguage("rkt", 5706050.0, 0.628).addLanguage("ks", 5317000.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("kok", 4798270.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("gom", 4149860.0, 0.628).addLanguage("swv", 3631120.0, 0.628).addLanguage("gbm", 3501440.0, 0.628).addLanguage("lmn", 3501440.0, 0.628).addLanguage("sd", 3371760.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("gon", 3112390.0, 0.628).addLanguage("kfy", 2853030.0, 0.628).addLanguage("doi", 2593660.0, 0.628).addLanguage("kru", 2463980.0, 0.628).addLanguage("sck", 2334290.0, 0.628).addLanguage("wbq", 2334290.0, 0.628).addLanguage("xnr", 2074930.0, 0.628).addLanguage("tcy", 1945240.0, 0.628).addLanguage("wbr", 1945240.0, 0.628).addLanguage("khn", 1945240.0, 0.628).addLanguage("brx", 1815560.0, 0.628).addLanguage("noe", 1685880.0, 0.628).addLanguage("bhb", 1556200.0, 0.628).addLanguage("mni", 1426510.0, 0.628).addLanguage("raj", 1296830.0, 0.628).addLanguage("hoc", 1296830.0, 0.628).addLanguage("mtr", 1270890.0, 0.628).addLanguage("unr", 1219020.0, 0.628).addLanguage("bhi", 1193080.0, 0.628).addLanguage("hoj", 1063400.0, 0.628).addLanguage("kha", 1037460.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("kfr", 972622.0, 0.628).addLanguage("grt", 687320.0, 0.628).addLanguage("unx", 622478.0, 0.628).addLanguage("bfy", 479827.0, 0.628).addLanguage("srx", 453891.0, 0.628).addLanguage("saz", 376081.0, 0.628).addLanguage("ccp", 363112.0, 0.628).addLanguage("sd_Deva", 337176.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("bfq", 298271.0, 0.628).addLanguage("njo", 298271.0, 0.628).addLanguage("ria", 168588.0, 0.628).addLanguage("bo", 142651.0, 0.628).addLanguage("bpy", 88184.4, 0.628).addLanguage("bft", 80403.5, 0.628).addLanguage("bra", 53170.0, 0.628).addLanguage("lep", 45389.1, 0.628).addLanguage("btv", 33717.6, 0.628).addLanguage("lif", 33717.6, 0.628).addLanguage("lah", 32420.8, 0.628).addLanguage("sa", 15562.0, 0.628, "OFFICIAL_REGIONAL").addLanguage("kht", 9077.81, 0.628).addLanguage("dv", 5187.32, 0.628).addLanguage("dz", 2593.66, 0.628);
        this.addRegion(RegionCode.IO, 3500.0, 0.99, 1.572E8).addLanguage("en", 3500.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.IQ, 4.01942E7, 0.785, 6.493E11).addLanguage("ar", 2.73321E7, 0.785, "OFFICIAL").addLanguage("en", 1.4068E7, 0.785).addLanguage("ckb", 8038840.0, 0.785, "OFFICIAL_REGIONAL").addLanguage("az_Arab", 723496.0, 0.785, "OFFICIAL_REGIONAL").addLanguage("fa", 349690.0, 0.785).addLanguage("lrc", 245185.0, 0.785).addLanguage("syr", 200971.0, 0.785);
        this.addRegion(RegionCode.IR, 8.30247E7, 0.85, 1.64E12).addLanguage("fa", 6.22685E7, 0.85, "OFFICIAL").addLanguage("az_Arab", 1.99259E7, 0.85).addLanguage("mzn", 4151240.0, 0.85).addLanguage("glk", 3819140.0, 0.85).addLanguage("ckb", 3237960.0, 0.85).addLanguage("sdh", 3071910.0, 0.85).addLanguage("tk", 2324690.0, 0.85).addLanguage("lrc", 1743520.0, 0.85).addLanguage("ar", 1660490.0, 0.85).addLanguage("bal", 1660490.0, 0.85).addLanguage("rmt", 1577470.0, 0.85).addLanguage("bqi", 1162350.0, 0.85).addLanguage("luz", 996296.0, 0.85).addLanguage("lki", 630988.0, 0.85).addLanguage("bgn", 464938.0, 0.05).addLanguage("prd", 415124.0, 0.85).addLanguage("hy", 199259.0, 0.85).addLanguage("ps", 132840.0, 0.85).addLanguage("ka", 58947.5, 0.85).addLanguage("gbz", 7970.37, 0.85).addLanguage("kk_Arab", 2988.89, 0.85);
        this.addRegion(RegionCode.IS, 343518.0, 0.99, 1.818E10).addLanguage("is", 343518.0, 0.99, "OFFICIAL").addLanguage("da", 2232.87, 0.99);
        this.addRegion(RegionCode.IT, 6.22467E7, 0.99, 2.317E12).addLanguage("it", 5.91344E7, 0.99, "OFFICIAL").addLanguage("en", 2.11639E7, 0.99).addLanguage("fr", 3921540.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("sc", 1058190.0, 0.99).addLanguage("de", 995947.0, 0.99).addLanguage("vec", 809207.0, 0.99).addLanguage("nap", 603793.0, 0.05).addLanguage("lij", 535322.0, 0.99).addLanguage("scn", 510423.0, 0.05).addLanguage("sl", 105819.0, 0.99).addLanguage("sdc", 105819.0, 0.99).addLanguage("fur", 37348.0, 0.05).addLanguage("egl", 31123.4, 0.99).addLanguage("ca", 21786.3, 0.99).addLanguage("el", 21786.3, 0.99).addLanguage("lmo", 18674.0, 0.99).addLanguage("pms", 6162.42, 0.99).addLanguage("hr", 3485.82, 0.99).addLanguage("rgn", 0.0, 0.99);
        this.addRegion(RegionCode.JE, 99602.0, 0.99, 5.569E9).addLanguage("en", 94621.9, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.JM, 2812090.0, 0.87, 2.606E10).addLanguage("en", 2755850.0, 0.87, "OFFICIAL").addLanguage("jam", 2671490.0, 0.87);
        this.addRegion(RegionCode.JO, 1.04584E7, 0.959, 8.9E10).addLanguage("ar", 1.04584E7, 0.959, "OFFICIAL").addLanguage("en", 4706280.0, 0.959);
        this.addRegion(RegionCode.JP, 1.26168E8, 0.99, 5.443E12).addLanguage("ja", 1.1986E8, 0.99, "OFFICIAL").addLanguage("ryu", 971494.0, 0.05).addLanguage("ko", 656074.0, 0.99);
        this.addRegion(RegionCode.KE, 4.83975E7, 0.874, 1.637E11).addLanguage("sw", 3.19424E7, 0.874, "OFFICIAL").addLanguage("en", 9195520.0, 0.874, "OFFICIAL").addLanguage("ki", 8227580.0, 0.874).addLanguage("luy", 5323720.0, 0.874).addLanguage("luo", 4742960.0, 0.874).addLanguage("kam", 3678210.0, 0.874).addLanguage("kln", 3678210.0, 0.874).addLanguage("guz", 2371480.0, 0.874).addLanguage("mer", 1935900.0, 0.874).addLanguage("mas", 774360.0, 0.874).addLanguage("ebu", 725962.0, 0.874).addLanguage("so", 629168.0, 0.874).addLanguage("dav", 396860.0, 0.05).addLanguage("teo", 358142.0, 0.874).addLanguage("pko", 338782.0, 0.874).addLanguage("om", 227468.0, 0.874).addLanguage("saq", 222628.0, 0.874).addLanguage("ar", 22262.9, 0.874).addLanguage("pa", 10163.5, 0.874).addLanguage("gu", 4839.75, 0.874);
        this.addRegion(RegionCode.KG, 5849300.0, 0.992, 2.315E10).addLanguage("ky", 2807660.0, 0.992, "OFFICIAL").addLanguage("ru", 2105750.0, 0.992, "OFFICIAL");
        this.addRegion(RegionCode.KH, 1.64495E7, 0.739, 6.421E10).addLanguage("km", 1.46401E7, 0.739, "OFFICIAL").addLanguage("cja", 263192.0, 0.739).addLanguage("kdt", 18094.5, 0.739);
        this.addRegion(RegionCode.KI, 109367.0, 0.9, 2.27E8).addLanguage("en", 109367.0, 0.9, "OFFICIAL").addLanguage("gil", 65620.2, 0.9, "OFFICIAL");
        this.addRegion(RegionCode.KM, 821164.0, 0.755, 1.319E9).addLanguage("ar", 541968.0, 0.755, "OFFICIAL").addLanguage("fr", 459852.0, 0.755, "OFFICIAL").addLanguage("zdj", 303831.0, 0.755, "OFFICIAL").addLanguage("wni", 279196.0, 0.755, "OFFICIAL");
        this.addRegion(RegionCode.KN, 53094.0, 0.978, 1.55E9).addLanguage("en", 52032.1, 0.978, "OFFICIAL");
        this.addRegion(RegionCode.KP, 2.53811E7, 1.0, 4.0E10).addLanguage("ko", 2.23354E7, 1.0, "OFFICIAL");
        this.addRegion(RegionCode.KR, 5.14181E7, 0.979, 2.035E12).addLanguage("ko", 5.14181E7, 0.979, "OFFICIAL");
        this.addRegion(RegionCode.KW, 2916470.0, 0.939, 2.897E11).addLanguage("ar", 2916470.0, 0.939, "OFFICIAL");
        this.addRegion(RegionCode.KY, 59613.0, 0.989, 2.507E9).addLanguage("en", 58420.7, 0.989, "OFFICIAL");
        this.addRegion(RegionCode.KZ, 1.87445E7, 0.997, 4.786E11).addLanguage("ru", 1.3496E7, 0.997, "OFFICIAL").addLanguage("kk", 1.19965E7, 0.997, "OFFICIAL").addLanguage("en", 2811680.0, 0.997).addLanguage("de", 1199650.0, 0.997).addLanguage("ug_Cyrl", 374890.0, 0.997);
        this.addRegion(RegionCode.LA, 7234170.0, 0.727, 4.934E10).addLanguage("lo", 4991580.0, 0.727, "OFFICIAL").addLanguage("kjg", 419582.0, 0.727).addLanguage("kdt", 69448.0, 0.727);
        this.addRegion(RegionCode.LB, 6100080.0, 0.896, 8.825E10).addLanguage("ar", 5246070.0, 0.896, "OFFICIAL").addLanguage("en", 2440030.0, 0.896).addLanguage("hy", 317204.0, 0.896).addLanguage("ku_Arab", 103701.0, 0.896).addLanguage("fr", 22570.3, 0.896);
        this.addRegion(RegionCode.LC, 165510.0, 0.901, 2.542E9).addLanguage("en", 148959.0, 0.901, "OFFICIAL");
        this.addRegion(RegionCode.LI, 38547.0, 1.0, 4.978E9).addLanguage("de", 38547.0, 1.0, "OFFICIAL").addLanguage("gsw", 32765.0, 0.05, "DE_FACTO_OFFICIAL").addLanguage("wae", 1310.6, 1.0);
        this.addRegion(RegionCode.LK, 2.25766E7, 0.912, 2.758E11).addLanguage("si", 1.53521E7, 0.912, "OFFICIAL").addLanguage("ta", 3386490.0, 0.912, "OFFICIAL").addLanguage("en", 2257660.0, 0.912);
        this.addRegion(RegionCode.LR, 4809770.0, 0.608, 6.112E9).addLanguage("en", 3992110.0, 0.608, "OFFICIAL").addLanguage("kpe", 673368.0, 0.608).addLanguage("vai", 125054.0, 0.608).addLanguage("men", 23086.9, 0.608).addLanguage("ff", 0.0, 0.608).addLanguage("ff_Adlm", 0.0, 0.608).addLanguage("vai_Latn", 0.0, 0.608);
        this.addRegion(RegionCode.LS, 1962460.0, 0.896, 6.656E9).addLanguage("st", 1923210.0, 0.896, "OFFICIAL").addLanguage("en", 529864.0, 0.896, "OFFICIAL").addLanguage("zu", 274744.0, 0.896).addLanguage("ss", 47099.0, 0.896).addLanguage("xh", 19624.6, 0.896);
        this.addRegion(RegionCode.LT, 2793280.0, 0.997, 9.147E10).addLanguage("lt", 2402220.0, 0.997, "OFFICIAL").addLanguage("ru", 2234620.0, 0.997).addLanguage("en", 1061450.0, 0.997).addLanguage("de", 391059.0, 0.997).addLanguage("sgs", 0.0, 0.997);
        this.addRegion(RegionCode.LU, 605764.0, 1.0, 6.211E10).addLanguage("fr", 527015.0, 1.0, "OFFICIAL").addLanguage("lb", 405862.0, 0.05, "OFFICIAL").addLanguage("de", 381631.0, 1.0, "OFFICIAL").addLanguage("en", 339228.0, 1.0).addLanguage("pt", 96922.2, 1.0);
        this.addRegion(RegionCode.LV, 1923560.0, 0.998, 5.402E10).addLanguage("lv", 1173370.0, 0.998, "OFFICIAL").addLanguage("en", 884838.0, 0.998).addLanguage("ru", 730953.0, 0.998).addLanguage("ltg", 171197.0, 0.998);
        this.addRegion(RegionCode.LY, 6754510.0, 0.895, 6.197E10).addLanguage("ar", 4998340.0, 0.895, "OFFICIAL");
        this.addRegion(RegionCode.MA, 3.43141E7, 0.671, 2.986E11).addLanguage("ary", 2.98533E7, 0.671).addLanguage("ar", 2.12747E7, 0.671, "OFFICIAL").addLanguage("zgh", 7549100.0, 0.671).addLanguage("fr", 6862820.0, 0.671, "DE_FACTO_OFFICIAL").addLanguage("en", 4803970.0, 0.671).addLanguage("tzm", 3362780.0, 0.671, "OFFICIAL").addLanguage("shi", 2985330.0, 0.671).addLanguage("shi_Latn", 2985330.0, 0.671).addLanguage("rif", 1681390.0, 0.05).addLanguage("rif_Latn", 1681390.0, 0.05).addLanguage("es", 22304.2, 0.671);
        this.addRegion(RegionCode.MC, 30727.0, 0.99, 7.672E9).addLanguage("fr", 30419.7, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.MD, 3437720.0, 0.99, 2.372E10).addLanguage("ro", 2165760.0, 0.99, "OFFICIAL").addLanguage("uk", 481281.0, 0.99).addLanguage("bg", 323146.0, 0.99).addLanguage("gag", 113445.0, 0.99).addLanguage("ru", 103132.0, 0.99);
        this.addRegion(RegionCode.ME, 614249.0, 0.985, 1.108E10).addLanguage("sr_Latn", 614249.0, 0.985, "OFFICIAL").addLanguage("sq", 48525.7, 0.985).addLanguage("sr", 30712.5, 0.985);
        this.addRegion(RegionCode.MF, 32284.0, 0.99, 5.615E8).addLanguage("fr", 32284.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.MG, 2.56836E7, 0.645, 3.985E10).addLanguage("mg", 2.31152E7, 0.645, "OFFICIAL").addLanguage("fr", 1.77217E7, 0.645, "OFFICIAL").addLanguage("en", 4623050.0, 0.645, "OFFICIAL");
        this.addRegion(RegionCode.MH, 75684.0, 0.937, 1.96E8).addLanguage("en", 70386.1, 0.937, "OFFICIAL").addLanguage("mh", 55249.3, 0.937, "OFFICIAL");
        this.addRegion(RegionCode.MK, 2118950.0, 0.974, 3.103E10).addLanguage("mk", 1419700.0, 0.974, "OFFICIAL").addLanguage("sq", 529738.0, 0.974, "OFFICIAL_REGIONAL").addLanguage("tr", 74163.2, 0.974);
        this.addRegion(RegionCode.ML, 1.84299E7, 0.334, 4.122E10).addLanguage("bm", 8477750.0, 0.334).addLanguage("fr", 8477750.0, 0.334, "OFFICIAL").addLanguage("ffm", 1419100.0, 0.334).addLanguage("snk", 1087360.0, 0.334).addLanguage("mwk", 921495.0, 0.334).addLanguage("ses", 626617.0, 0.334).addLanguage("tmh", 387028.0, 0.334).addLanguage("bm_Nkoo", 368598.0, 0.334).addLanguage("khq", 313308.0, 0.334).addLanguage("dtm", 202729.0, 0.334).addLanguage("kao", 184299.0, 0.334).addLanguage("ar", 164026.0, 0.334).addLanguage("bmq", 158497.0, 0.334).addLanguage("bze", 154811.0, 0.334);
        this.addRegion(RegionCode.MM, 5.56225E7, 0.927, 3.298E11).addLanguage("my", 3.55984E7, 0.927, "OFFICIAL").addLanguage("shn", 3559840.0, 0.927).addLanguage("kac", 945582.0, 0.927).addLanguage("mnw", 834338.0, 0.927).addLanguage("kht", 4227.31, 0.927);
        this.addRegion(RegionCode.MN, 3103430.0, 0.974, 3.973E10).addLanguage("mn", 2886190.0, 0.974, "OFFICIAL").addLanguage("kk_Arab", 223447.0, 0.974).addLanguage("zh", 43448.0, 0.974).addLanguage("ru", 4034.46, 0.974).addLanguage("ug_Cyrl", 993.098, 0.974);
        this.addRegion(RegionCode.MO, 606340.0, 0.956, 7.182E10).addLanguage("zh_Hant", 594213.0, 0.956, "OFFICIAL").addLanguage("pt", 30317.0, 0.956, "OFFICIAL").addLanguage("zh", 30317.0, 0.956).addLanguage("en", 13945.8, 0.956);
        this.addRegion(RegionCode.MP, 51994.0, 0.97, 1.242E9).addLanguage("en", 50434.2, 0.97, "DE_FACTO_OFFICIAL").addLanguage("ch", 9358.92, 0.97);
        this.addRegion(RegionCode.MQ, 436131.0, 0.98, 6.117E9).addLanguage("fr", 427408.0, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.MR, 3840430.0, 0.586, 1.728E10).addLanguage("ar", 3264370.0, 0.586, "OFFICIAL").addLanguage("fr", 652873.0, 0.586).addLanguage("ff", 218905.0, 0.586).addLanguage("wo", 9985.12, 0.586).addLanguage("ff_Adlm", 0.0, 0.586);
        this.addRegion(RegionCode.MS, 5315.0, 0.97, 1.674E8).addLanguage("en", 3507.9, 0.97, "OFFICIAL");
        this.addRegion(RegionCode.MT, 449043.0, 0.924, 1.926E10).addLanguage("mt", 449043.0, 0.924, "OFFICIAL").addLanguage("en", 395158.0, 0.924, "OFFICIAL").addLanguage("it", 251464.0, 0.924).addLanguage("fr", 49394.7, 0.924);
        this.addRegion(RegionCode.MU, 1364280.0, 0.888, 2.827E10).addLanguage("mfe", 1227850.0, 0.888).addLanguage("en", 982282.0, 0.888, "OFFICIAL").addLanguage("bho", 368356.0, 0.888).addLanguage("ur", 70942.6, 0.888).addLanguage("fr", 40928.4, 0.888, "OFFICIAL").addLanguage("ta", 34107.0, 0.888);
        this.addRegion(RegionCode.MV, 392473.0, 0.984, 6.901E9).addLanguage("dv", 368925.0, 0.984, "OFFICIAL");
        this.addRegion(RegionCode.MW, 1.98426E7, 0.748, 2.242E10).addLanguage("en", 1.25008E7, 0.748, "OFFICIAL").addLanguage("ny", 1.25008E7, 0.748, "OFFICIAL").addLanguage("tum", 1666780.0, 0.748).addLanguage("tog", 194457.0, 0.748).addLanguage("zu", 65480.6, 0.748);
        this.addRegion(RegionCode.MX, 1.25959E8, 0.935, 2.463E12).addLanguage("es", 1.04546E8, 0.935, "DE_FACTO_OFFICIAL").addLanguage("en", 1.63747E7, 0.935).addLanguage("yua", 843925.0, 0.935).addLanguage("nhe", 491240.0, 0.935).addLanguage("nhw", 491240.0, 0.935).addLanguage("maz", 428261.0, 0.935).addLanguage("nch", 239322.0, 0.935).addLanguage("sei", 881.713, 0.935);
        this.addRegion(RegionCode.MY, 3.18097E7, 0.931, 9.333E11).addLanguage("ms", 2.38573E7, 0.931, "OFFICIAL").addLanguage("en", 6680040.0, 0.931).addLanguage("zh_Hant", 5407650.0, 0.931).addLanguage("ta", 1336010.0, 0.931).addLanguage("iba", 795242.0, 0.931).addLanguage("jv", 381716.0, 0.931).addLanguage("zmi", 381716.0, 0.931).addLanguage("dtp", 178134.0, 0.931).addLanguage("ml", 47714.6, 0.931).addLanguage("bug", 25129.7, 0.931).addLanguage("bjn", 5089.55, 0.931);
        this.addRegion(RegionCode.MZ, 2.72338E7, 0.561, 3.709E10).addLanguage("pt", 7353130.0, 0.561, "OFFICIAL").addLanguage("vmw", 3540390.0, 0.561).addLanguage("ndc", 2696150.0, 0.561).addLanguage("ts", 2151470.0, 0.561).addLanguage("ngl", 1851900.0, 0.561).addLanguage("seh", 1252750.0, 0.561).addLanguage("mgh", 1225520.0, 0.561).addLanguage("rng", 925949.0, 0.561).addLanguage("ny", 708079.0, 0.561).addLanguage("yao", 653611.0, 0.561).addLanguage("sw", 9259.49, 0.561).addLanguage("zu", 1797.43, 0.561);
        this.addRegion(RegionCode.NA, 2533220.0, 0.888, 2.66E10).addLanguage("af", 1899920.0, 0.888).addLanguage("kj", 886627.0, 0.888).addLanguage("ng", 531976.0, 0.888).addLanguage("naq", 278654.0, 0.888).addLanguage("hz", 230523.0, 0.888).addLanguage("en", 177325.0, 0.888, "OFFICIAL").addLanguage("de", 22799.0, 0.888).addLanguage("tn", 14186.0, 0.888);
        this.addRegion(RegionCode.NC, 282754.0, 0.962, 1.111E10).addLanguage("fr", 271444.0, 0.962, "OFFICIAL");
        this.addRegion(RegionCode.NE, 1.98662E7, 0.287, 2.186E10).addLanguage("ha", 8145140.0, 0.287).addLanguage("fr", 5761200.0, 0.287, "OFFICIAL").addLanguage("dje", 3377250.0, 0.287).addLanguage("fuq", 1390630.0, 0.287).addLanguage("tmh", 1191970.0, 0.287).addLanguage("ar", 41719.0, 0.287).addLanguage("twq", 7946.48, 0.287).addLanguage("ff", 0.0, 0.287).addLanguage("ff_Adlm", 0.0, 0.287);
        this.addRegion(RegionCode.NF, 1748.0, 0.99, 9.295E7).addLanguage("en", 1678.08, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.NG, 2.03453E8, 0.613, 1.121E12).addLanguage("en", 1.0783E8, 0.613, "OFFICIAL").addLanguage("pcm", 4.27251E7, 0.613).addLanguage("ha", 2.64489E7, 0.613).addLanguage("ig", 2.64489E7, 0.613).addLanguage("yo", 2.64489E7, 0.613, "OFFICIAL").addLanguage("fuv", 1.36314E7, 0.613).addLanguage("tiv", 3255250.0, 0.613).addLanguage("efi", 2848340.0, 0.613).addLanguage("ibb", 2848340.0, 0.613).addLanguage("ha_Arab", 2034530.0, 0.613).addLanguage("bin", 1444520.0, 0.613).addLanguage("kaj", 427251.0, 0.613).addLanguage("kcg", 189211.0, 0.613).addLanguage("ar", 144452.0, 0.613).addLanguage("cch", 42725.1, 0.613).addLanguage("amo", 17903.9, 0.613).addLanguage("ff", 0.0, 0.613).addLanguage("ff_Adlm", 0.0, 0.613);
        this.addRegion(RegionCode.NI, 6085210.0, 0.78, 3.64E10).addLanguage("es", 4746460.0, 0.78, "OFFICIAL");
        this.addRegion(RegionCode.NL, 1.71512E7, 0.99, 9.244E11).addLanguage("nl", 1.71512E7, 0.99, "OFFICIAL").addLanguage("en", 1.54361E7, 0.99).addLanguage("de", 1.21774E7, 0.05).addLanguage("fr", 4973850.0, 0.99).addLanguage("nds", 1886630.0, 0.05).addLanguage("li", 943316.0, 0.05).addLanguage("fy", 737502.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("gos", 617443.0, 0.05).addLanguage("id", 308722.0, 0.99).addLanguage("zea", 240117.0, 0.99).addLanguage("rif_Latn", 205814.0, 0.99).addLanguage("tr", 205814.0, 0.99);
        this.addRegion(RegionCode.NO, 5372190.0, 1.0, 3.812E11).addLanguage("nb", 5372190.0, 1.0, "OFFICIAL").addLanguage("nn", 1343050.0, 1.0, "OFFICIAL").addLanguage("se", 15579.4, 1.0, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.NP, 2.97176E7, 0.574, 7.919E10).addLanguage("ne", 1.30757E7, 0.574, "OFFICIAL").addLanguage("mai", 3268940.0, 0.574).addLanguage("bho", 2020800.0, 0.574).addLanguage("new", 980681.0, 0.574).addLanguage("jml", 950963.0, 0.574).addLanguage("en", 891528.0, 0.574).addLanguage("taj", 1019310.0, 0.574).addLanguage("dty", 742940.0, 0.574).addLanguage("awa", 653787.0, 0.574).addLanguage("thl", 594352.0, 0.574).addLanguage("bap", 445764.0, 0.574).addLanguage("tdg", 386329.0, 0.574).addLanguage("thr", 356611.0, 0.574).addLanguage("mgp", 326894.0, 0.574).addLanguage("lif", 326894.0, 0.574).addLanguage("thq", 297176.0, 0.574).addLanguage("mrd", 246656.0, 0.574).addLanguage("bfy", 160475.0, 0.574).addLanguage("xsr", 154532.0, 0.574).addLanguage("rjs", 130757.0, 0.574).addLanguage("hi", 124814.0, 0.574).addLanguage("gvr", 210995.0, 0.574).addLanguage("bo", 71322.2, 0.574).addLanguage("tkt", 71322.2, 0.574).addLanguage("tdh", 35661.1, 0.574).addLanguage("bn", 27934.5, 0.574).addLanguage("unr_Deva", 5646.34, 0.574).addLanguage("lep", 2823.17, 0.574);
        this.addRegion(RegionCode.NR, 9692.0, 0.99, 1.6E8).addLanguage("en", 9401.24, 0.99, "OFFICIAL").addLanguage("na", 6881.32, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.NU, 1618.0, 0.95, 1.001E7).addLanguage("en", 1132.6, 0.95, "OFFICIAL").addLanguage("niu", 1132.6, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.NZ, 4545630.0, 0.99, 1.89E11).addLanguage("en", 4454720.0, 0.99, "DE_FACTO_OFFICIAL").addLanguage("mi", 127278.0, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.OM, 3494120.0, 0.869, 1.901E11).addLanguage("ar", 2830240.0, 0.869, "OFFICIAL").addLanguage("bal", 171212.0, 0.869).addLanguage("fa", 32844.7, 0.869);
        this.addRegion(RegionCode.PA, 3800640.0, 0.941, 1.041E11).addLanguage("es", 2622440.0, 0.941, "OFFICIAL").addLanguage("en", 532090.0, 0.941).addLanguage("zh_Hant", 6081.02, 0.941);
        this.addRegion(RegionCode.PE, 3.13312E7, 0.896, 4.303E11).addLanguage("es", 2.28718E7, 0.896, "OFFICIAL").addLanguage("qu", 4699680.0, 0.896, "OFFICIAL").addLanguage("ay", 501299.0, 0.896);
        this.addRegion(RegionCode.PF, 290373.0, 0.98, 5.49E9).addLanguage("fr", 177128.0, 0.98, "OFFICIAL").addLanguage("ty", 90015.6, 0.98, "OFFICIAL").addLanguage("zh_Hant", 22649.1, 0.98);
        this.addRegion(RegionCode.PG, 7027330.0, 0.624, 3.019E10).addLanguage("tpi", 4989400.0, 0.624, "OFFICIAL").addLanguage("en", 3513660.0, 0.624, "OFFICIAL").addLanguage("ho", 147574.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.PH, 1.05893E8, 0.954, 8.772E11).addLanguage("en", 6.77715E7, 0.954, "OFFICIAL").addLanguage("fil", 6.35358E7, 0.954, "OFFICIAL").addLanguage("es", 3.28268E7, 0.954).addLanguage("ceb", 2.54143E7, 0.954, "OFFICIAL_REGIONAL").addLanguage("ilo", 1.01657E7, 0.954, "OFFICIAL_REGIONAL").addLanguage("hil", 8895010.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("bik", 3176790.0, 0.954).addLanguage("war", 3070900.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("bhk", 2435540.0, 0.954).addLanguage("pam", 2435540.0, 0.954).addLanguage("pag", 1482500.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("mdh", 1270720.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("tsg", 1164820.0, 0.954, "OFFICIAL_REGIONAL").addLanguage("zh_Hant", 773019.0, 0.954).addLanguage("cps", 698894.0, 0.954).addLanguage("krj", 412983.0, 0.954).addLanguage("bto", 296500.0, 0.954).addLanguage("hnn", 16942.9, 0.954).addLanguage("tbw", 9953.94, 0.954).addLanguage("bku", 8047.87, 0.954);
        this.addRegion(RegionCode.PK, 2.07863E8, 0.549, 1.061E12).addLanguage("ur", 1.9747E8, 0.549, "OFFICIAL").addLanguage("pa_Arab", 1.45504E8, 0.549).addLanguage("en", 1.03932E8, 0.549, "OFFICIAL").addLanguage("lah", 8.31452E7, 0.549).addLanguage("ps", 3.11794E7, 0.549).addLanguage("sd", 2.49436E7, 0.549).addLanguage("skr", 1.89155E7, 0.549).addLanguage("bal", 7690930.0, 0.549).addLanguage("brh", 2702220.0, 0.549).addLanguage("hno", 2494360.0, 0.549).addLanguage("fa", 1371900.0, 0.549).addLanguage("bgn", 1184820.0, 0.05).addLanguage("hnd", 852238.0, 0.549).addLanguage("tg_Arab", 685948.0, 0.549).addLanguage("gju", 415726.0, 0.549).addLanguage("bft", 374153.0, 0.549).addLanguage("kvx", 332581.0, 0.549).addLanguage("khw", 311794.0, 0.549).addLanguage("mvy", 291008.0, 0.549).addLanguage("kxp", 249436.0, 0.549).addLanguage("gjk", 228649.0, 0.549).addLanguage("ks", 143425.0, 0.549).addLanguage("btv", 39494.0, 0.549);
        this.addRegion(RegionCode.PL, 3.84207E7, 0.997, 1.126E12).addLanguage("pl", 3.68839E7, 0.997, "OFFICIAL").addLanguage("en", 1.26788E7, 0.997).addLanguage("de", 7299930.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ru", 6915730.0, 0.997).addLanguage("szl", 499469.0, 0.997).addLanguage("be", 222840.0, 0.997).addLanguage("uk", 149841.0, 0.997).addLanguage("csb", 49946.9, 0.997, "OFFICIAL_REGIONAL").addLanguage("sli", 11910.4, 0.997).addLanguage("lt", 8068.35, 0.997, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.PM, 5471.0, 0.99, 2.613E8).addLanguage("fr", 5088.03, 0.99, "OFFICIAL").addLanguage("en", 186.014, 0.99);
        this.addRegion(RegionCode.PN, 54.0, 0.99, 2426000.0).addLanguage("en", 45.9, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.PR, 3294630.0, 0.903, 1.3E11).addLanguage("es", 2866330.0, 0.903, "OFFICIAL").addLanguage("en", 1614370.0, 0.903, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.PS, 4635210.0, 0.953, 2.122E10).addLanguage("ar", 4635210.0, 0.953, "OFFICIAL");
        this.addRegion(RegionCode.PT, 1.03555E7, 0.954, 3.141E11).addLanguage("pt", 9941280.0, 0.954, "OFFICIAL").addLanguage("en", 2795980.0, 0.954).addLanguage("fr", 1553320.0, 0.954).addLanguage("es", 1035550.0, 0.954).addLanguage("gl", 14497.7, 0.954);
        this.addRegion(RegionCode.PW, 21516.0, 0.92, 2.64E8).addLanguage("pau", 15921.8, 0.92, "OFFICIAL").addLanguage("en", 1871.89, 0.92, "OFFICIAL");
        this.addRegion(RegionCode.PY, 7025760.0, 0.939, 8.891E10).addLanguage("gn", 5620610.0, 0.939, "OFFICIAL").addLanguage("es", 224824.0, 0.939, "OFFICIAL").addLanguage("de", 203747.0, 0.939);
        this.addRegion(RegionCode.QA, 2363570.0, 0.963, 3.395E11).addLanguage("ar", 2103580.0, 0.963, "OFFICIAL").addLanguage("fa", 259993.0, 0.963).addLanguage("ml", 6618.0, 0.963);
        this.addRegion(RegionCode.RE, 787584.0, 0.88, 4.791E9).addLanguage("fr", 700950.0, 0.88, "OFFICIAL").addLanguage("rcf", 559185.0, 0.88).addLanguage("ta", 118138.0, 0.88);
        this.addRegion(RegionCode.RO, 2.14571E7, 0.977, 4.834E11).addLanguage("ro", 1.93114E7, 0.977, "OFFICIAL").addLanguage("en", 6651700.0, 0.977).addLanguage("fr", 3647710.0, 0.977).addLanguage("es", 2145710.0, 0.977).addLanguage("hu", 1416170.0, 0.977).addLanguage("de", 45059.9, 0.977).addLanguage("tr", 27894.2, 0.977).addLanguage("sr_Latn", 25748.5, 0.977).addLanguage("bg", 6651.7, 0.977).addLanguage("el", 4076.85, 0.977).addLanguage("pl", 2789.42, 0.977);
        this.addRegion(RegionCode.RS, 7078110.0, 0.98, 1.057E11).addLanguage("sr", 7007330.0, 0.98, "OFFICIAL").addLanguage("sr_Latn", 7007330.0, 0.05, "OFFICIAL").addLanguage("sq", 1344840.0, 0.98).addLanguage("hu", 339749.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("ro", 148640.0, 0.98, "OFFICIAL_REGIONAL").addLanguage("hr", 65826.4, 0.98, "OFFICIAL_REGIONAL").addLanguage("sk", 60871.7, 0.98, "OFFICIAL_REGIONAL").addLanguage("uk", 0.0, 0.98, "OFFICIAL_REGIONAL");
        this.addRegion(RegionCode.RU, 1.42123E8, 0.997, 4.016E12).addLanguage("ru", 1.33596E8, 0.997, "OFFICIAL").addLanguage("tt", 1989720.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ba", 1847600.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("cv", 1847600.0, 0.997).addLanguage("hy", 1193830.0, 0.997).addLanguage("ce", 938012.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("av", 554280.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("udm", 540067.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("chm", 525855.0, 0.997).addLanguage("sah", 454794.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("os", 454794.0, 0.997).addLanguage("kbd", 440581.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("myv", 440581.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("dar", 369520.0, 0.997).addLanguage("bua", 312671.0, 0.997).addLanguage("mdf", 298458.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("kum", 284246.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("kv", 255821.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("lez", 255821.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("krc", 241609.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("inh", 227397.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("tyv", 184760.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("az_Cyrl", 132174.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("ady", 125068.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("krl", 116541.0, 0.997).addLanguage("lbe", 110856.0, 0.997, "OFFICIAL_REGIONAL").addLanguage("koi", 63955.3, 0.997, "OFFICIAL_REGIONAL").addLanguage("mrj", 29845.8, 0.997).addLanguage("alt", 19897.2, 0.997).addLanguage("fi", 17054.8, 0.997).addLanguage("sr_Latn", 4974.31, 0.997).addLanguage("vep", 3553.08, 0.997).addLanguage("mn", 2131.85, 0.997).addLanguage("izh", 142.123, 0.997).addLanguage("vot", 0.0, 0.997).addLanguage("cu", 0.0, 0.997);
        this.addRegion(RegionCode.RW, 1.21874E7, 0.711, 2.468E10).addLanguage("rw", 9384300.0, 0.711, "OFFICIAL").addLanguage("en", 1828110.0, 0.711, "OFFICIAL").addLanguage("fr", 2315.61, 0.711, "OFFICIAL");
        this.addRegion(RegionCode.SA, 3.30911E7, 0.872, 1.775E12).addLanguage("ar", 3.30911E7, 0.872, "OFFICIAL");
        this.addRegion(RegionCode.SB, 660121.0, 0.841, 1.33E9).addLanguage("en", 660121.0, 0.841, "OFFICIAL").addLanguage("rug", 9901.82, 0.841);
        this.addRegion(RegionCode.SC, 94633.0, 0.918, 2.75E9).addLanguage("crs", 92740.3, 0.918).addLanguage("fr", 56779.8, 0.918, "OFFICIAL").addLanguage("en", 35960.5, 0.918, "OFFICIAL");
        this.addRegion(RegionCode.SD, 4.31208E7, 0.719, 1.774E11).addLanguage("ar", 2.63037E7, 0.719, "OFFICIAL").addLanguage("en", 2.63037E7, 0.719, "OFFICIAL").addLanguage("bej", 2328520.0, 0.719).addLanguage("fvr", 1164260.0, 0.719).addLanguage("ha_Arab", 776174.0, 0.719).addLanguage("mls", 426896.0, 0.719).addLanguage("fia", 357903.0, 0.719).addLanguage("zag", 219916.0, 0.719);
        this.addRegion(RegionCode.SE, 1.0041E7, 0.99, 5.18E11).addLanguage("sv", 9538950.0, 0.99, "OFFICIAL").addLanguage("en", 8635260.0, 0.99).addLanguage("fi", 220902.0, 0.99, "OFFICIAL_REGIONAL").addLanguage("fit", 55225.5, 0.99).addLanguage("se", 33135.3, 0.99).addLanguage("rmu", 9538.95, 0.99).addLanguage("yi", 3012.3, 0.99).addLanguage("smj", 1506.15, 0.99).addLanguage("sma", 301.23, 0.99).addLanguage("ia", 0.0, 0.99);
        this.addRegion(RegionCode.SG, 5995990.0, 0.959, 5.281E11).addLanguage("en", 5576270.0, 0.959, "OFFICIAL").addLanguage("zh", 4616910.0, 0.959, "OFFICIAL").addLanguage("ms", 839439.0, 0.959, "OFFICIAL").addLanguage("ta", 125916.0, 0.959, "OFFICIAL").addLanguage("ml", 10193.2, 0.959).addLanguage("pa", 9593.58, 0.959);
        this.addRegion(RegionCode.SH, 7841.0, 0.97, 3.11E7).addLanguage("en", 5410.29, 0.97, "OFFICIAL");
        this.addRegion(RegionCode.SI, 2102130.0, 0.997, 7.123E10).addLanguage("sl", 1828850.0, 0.997, "OFFICIAL").addLanguage("hr", 1282300.0, 0.997).addLanguage("en", 1240260.0, 0.997).addLanguage("de", 882895.0, 0.997).addLanguage("hu", 9249.37, 0.997).addLanguage("it", 3994.05, 0.997);
        this.addRegion(RegionCode.SJ, 2583.0, 1.0, 1.833E8).addLanguage("nb", 1498.14, 1.0, "OFFICIAL").addLanguage("ru", 1188.18, 1.0);
        this.addRegion(RegionCode.SK, 5445040.0, 0.996, 1.797E11).addLanguage("sk", 4900540.0, 0.996, "OFFICIAL").addLanguage("cs", 2559170.0, 0.996).addLanguage("en", 1415710.0, 0.996).addLanguage("de", 1197910.0, 0.996).addLanguage("hu", 598954.0, 0.996).addLanguage("uk", 103456.0, 0.996).addLanguage("pl", 50638.9, 0.996);
        this.addRegion(RegionCode.SL, 6312210.0, 0.433, 1.155E10).addLanguage("kri", 5996600.0, 0.433).addLanguage("en", 2209270.0, 0.433, "OFFICIAL").addLanguage("men", 1704300.0, 0.433).addLanguage("tem", 1641170.0, 0.433).addLanguage("ff", 0.0, 0.433).addLanguage("ff_Adlm", 0.0, 0.433);
        this.addRegion(RegionCode.SM, 33779.0, 0.96, 2.064E9).addLanguage("it", 30063.3, 0.96, "OFFICIAL").addLanguage("eo", 300.633, 0.96);
        this.addRegion(RegionCode.SN, 1.50209E7, 0.497, 5.48E10).addLanguage("wo", 1.05146E7, 0.497, "DE_FACTO_OFFICIAL").addLanguage("fr", 5858150.0, 0.497, "OFFICIAL").addLanguage("ff", 3154390.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("srr", 1652300.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("dyo", 390543.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("sav", 225314.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("mfv", 115661.0, 0.497, "OFFICIAL_REGIONAL").addLanguage("bjt", 91627.5, 0.497, "OFFICIAL_REGIONAL").addLanguage("snf", 36050.2, 0.497, "OFFICIAL_REGIONAL").addLanguage("knf", 31543.9, 0.497, "OFFICIAL_REGIONAL").addLanguage("bsc", 14570.3, 0.497, "OFFICIAL_REGIONAL").addLanguage("mey", 7210.03, 0.497, "OFFICIAL_REGIONAL").addLanguage("tnr", 3454.81, 0.497, "OFFICIAL_REGIONAL").addLanguage("ff_Adlm", 0.0, 0.497);
        this.addRegion(RegionCode.SO, 1.1259E7, 0.378, 2.044E10).addLanguage("so", 8782020.0, 0.378, "OFFICIAL").addLanguage("ar", 3828060.0, 0.378, "OFFICIAL").addLanguage("sw", 225180.0, 0.378).addLanguage("om", 47287.8, 0.378);
        this.addRegion(RegionCode.SR, 597927.0, 0.947, 8.688E9).addLanguage("nl", 538134.0, 0.947, "OFFICIAL").addLanguage("srn", 406590.0, 0.947).addLanguage("zh_Hant", 7175.12, 0.947);
        this.addRegion(RegionCode.SS, 1.02046E7, 0.27, 2.001E10).addLanguage("ar", 2755240.0, 0.27).addLanguage("en", 2755240.0, 0.27, "OFFICIAL").addLanguage("nus", 571458.0, 0.27);
        this.addRegion(RegionCode.ST, 204454.0, 0.695, 6.86E8).addLanguage("pt", 173786.0, 0.695, "OFFICIAL");
        this.addRegion(RegionCode.SV, 6187270.0, 0.845, 5.117E10).addLanguage("es", 5506670.0, 0.845, "OFFICIAL");
        this.addRegion(RegionCode.SX, 42677.0, 0.99, 3.658E8).addLanguage("en", 29020.4, 0.99, "OFFICIAL").addLanguage("es", 4694.47, 0.99).addLanguage("vic", 3115.42, 0.99).addLanguage("nl", 1579.05, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.SY, 1.94543E7, 0.841, 5.028E10).addLanguage("ar", 1.55634E7, 0.841, "OFFICIAL").addLanguage("ku", 1556340.0, 0.841).addLanguage("fr", 1147800.0, 0.841, "OFFICIAL").addLanguage("hy", 350177.0, 0.841).addLanguage("syr", 16341.6, 0.05);
        this.addRegion(RegionCode.SZ, 1087200.0, 0.878, 1.16E10).addLanguage("en", 869760.0, 0.878, "OFFICIAL").addLanguage("ss", 630576.0, 0.878, "OFFICIAL").addLanguage("zu", 73929.6, 0.878).addLanguage("ts", 18482.4, 0.878);
        this.addRegion(RegionCode.TA, 275.0, 0.99, 1.235E7).addLanguage("en", 272.25, 0.99);
        this.addRegion(RegionCode.TC, 53701.0, 0.98, 6.32E8).addLanguage("en", 52627.0, 0.98, "OFFICIAL");
        this.addRegion(RegionCode.TD, 1.58331E7, 0.354, 2.862E10).addLanguage("fr", 4116610.0, 0.354, "OFFICIAL").addLanguage("ar", 2691630.0, 0.354, "OFFICIAL");
        this.addRegion(RegionCode.TF, 140.0, 0.99, 5935000.0).addLanguage("fr", 140.0, 0.99);
        this.addRegion(RegionCode.TG, 8176450.0, 0.604, 1.297E10).addLanguage("fr", 4987630.0, 0.604, "OFFICIAL").addLanguage("ee", 1390000.0, 0.604).addLanguage("ife", 106294.0, 0.604);
        this.addRegion(RegionCode.TH, 6.86159E7, 0.935, 1.236E12).addLanguage("th", 5.48927E7, 0.935, "OFFICIAL").addLanguage("en", 1.85263E7, 0.935).addLanguage("tts", 1.64678E7, 0.05).addLanguage("nod", 6587130.0, 0.05).addLanguage("sou", 5489270.0, 0.05).addLanguage("mfa", 3430800.0, 0.935).addLanguage("zh_Hant", 1235090.0, 0.935).addLanguage("kxm", 1166470.0, 0.935).addLanguage("kdt", 329356.0, 0.935).addLanguage("mnw", 116647.0, 0.935).addLanguage("shn", 65871.3, 0.935).addLanguage("lcp", 6861.59, 0.935).addLanguage("lwl", 6861.59, 0.935);
        this.addRegion(RegionCode.TJ, 8604880.0, 0.997, 2.843E10).addLanguage("tg", 8604880.0, 0.997, "OFFICIAL").addLanguage("ru", 1032590.0, 0.997).addLanguage("fa", 67118.1, 0.997).addLanguage("ar", 1032.59, 0.997);
        this.addRegion(RegionCode.TK, 1285.0, 0.94, 1500000.0).addLanguage("en", 1285.0, 0.94, "OFFICIAL").addLanguage("tkl", 1285.0, 0.05, "OFFICIAL");
        this.addRegion(RegionCode.TL, 1321930.0, 0.583, 7.426E9).addLanguage("pt", 779939.0, 0.583, "OFFICIAL").addLanguage("tet", 779939.0, 0.583, "OFFICIAL");
        this.addRegion(RegionCode.TM, 5411010.0, 0.996, 1.037E11).addLanguage("tk", 3787710.0, 0.996, "OFFICIAL").addLanguage("ru", 649321.0, 0.996).addLanguage("uz", 486991.0, 0.996).addLanguage("ku", 22185.1, 0.996);
        this.addRegion(RegionCode.TN, 1.15162E7, 0.791, 1.377E11).addLanguage("aeb", 1.03646E7, 0.791).addLanguage("ar", 1.03646E7, 0.791, "OFFICIAL").addLanguage("fr", 8521990.0, 0.791, "OFFICIAL");
        this.addRegion(RegionCode.TO, 106398.0, 0.99, 5.91E8).addLanguage("to", 101078.0, 0.99, "OFFICIAL").addLanguage("en", 29791.4, 0.99, "OFFICIAL");
        this.addRegion(RegionCode.TR, 8.12572E7, 0.941, 2.186E12).addLanguage("tr", 7.55692E7, 0.941, "OFFICIAL").addLanguage("en", 1.38137E7, 0.941).addLanguage("ku", 4469150.0, 0.941).addLanguage("zza", 1137600.0, 0.941).addLanguage("kbd", 625680.0, 0.941).addLanguage("az", 601303.0, 0.941).addLanguage("az_Arab", 528172.0, 0.941).addLanguage("ar", 455040.0, 0.941).addLanguage("bgx", 373783.0, 0.941).addLanguage("bg", 341280.0, 0.941).addLanguage("ady", 316903.0, 0.941).addLanguage("kiu", 154389.0, 0.941).addLanguage("hy", 45504.0, 0.941).addLanguage("ka", 45504.0, 0.941).addLanguage("sr_Latn", 22752.0, 0.05).addLanguage("lzz", 22752.0, 0.941).addLanguage("sq", 17064.0, 0.941).addLanguage("ab", 3981.6, 0.941).addLanguage("el", 3981.6, 0.941).addLanguage("tru", 3006.52, 0.941).addLanguage("uz", 1950.17, 0.941).addLanguage("ky_Latn", 1137.6, 0.941).addLanguage("kk", 568.8, 0.941);
        this.addRegion(RegionCode.TT, 1215530.0, 0.988, 4.285E10).addLanguage("en", 1069670.0, 0.988, "OFFICIAL").addLanguage("es", 4132.8, 0.988);
        this.addRegion(RegionCode.TV, 11147.0, 0.95, 4.2E7).addLanguage("tvl", 9920.83, 0.95, "OFFICIAL").addLanguage("en", 1070.11, 0.95, "OFFICIAL");
        this.addRegion(RegionCode.TW, 2.3546E7, 0.961, 1.189E12).addLanguage("zh_Hant", 2.23687E7, 0.961, "OFFICIAL").addLanguage("trv", 4709.2, 0.961);
        this.addRegion(RegionCode.TZ, 5.54513E7, 0.678, 1.625E11).addLanguage("sw", 4.99062E7, 0.678, "OFFICIAL").addLanguage("en", 3.82614E7, 0.678, "OFFICIAL").addLanguage("suk", 4824260.0, 0.678).addLanguage("nym", 1829890.0, 0.678).addLanguage("kde", 1330830.0, 0.678).addLanguage("bez", 942672.0, 0.678).addLanguage("ksb", 942672.0, 0.678).addLanguage("mas", 831770.0, 0.678).addLanguage("mgy", 776318.0, 0.678).addLanguage("asa", 665416.0, 0.678).addLanguage("lag", 482426.0, 0.678).addLanguage("jmc", 415885.0, 0.678).addLanguage("rof", 415885.0, 0.678).addLanguage("vun", 415885.0, 0.678).addLanguage("rwk", 121993.0, 0.678).addLanguage("sbp", 110903.0, 0.678);
        this.addRegion(RegionCode.UA, 4.39523E7, 0.997, 3.696E11).addLanguage("uk", 2.8569E7, 0.997, "OFFICIAL").addLanguage("ru", 2.02181E7, 0.997, "DE_FACTO_OFFICIAL").addLanguage("pl", 1054860.0, 0.997).addLanguage("yi", 571380.0, 0.997).addLanguage("rue", 527428.0, 0.997).addLanguage("be", 364804.0, 0.997).addLanguage("crh", 246133.0, 0.997).addLanguage("ro", 228552.0, 0.997).addLanguage("bg", 215366.0, 0.997).addLanguage("tr", 184600.0, 0.997).addLanguage("hu", 162624.0, 0.997).addLanguage("el", 7032.37, 0.997);
        this.addRegion(RegionCode.UG, 4.08537E7, 0.732, 8.919E10).addLanguage("sw", 3.06403E7, 0.732, "OFFICIAL").addLanguage("lg", 5310980.0, 0.732).addLanguage("nyn", 2573780.0, 0.732).addLanguage("cgg", 2206100.0, 0.732).addLanguage("xog", 2165250.0, 0.732).addLanguage("en", 1593290.0, 0.732, "OFFICIAL").addLanguage("teo", 1593290.0, 0.732).addLanguage("laj", 1552440.0, 0.732).addLanguage("ach", 1511590.0, 0.732).addLanguage("myx", 1184760.0, 0.732).addLanguage("rw", 857928.0, 0.732).addLanguage("ttj", 776220.0, 0.732).addLanguage("hi", 2206.1, 0.732);
        this.addRegion(RegionCode.UM, 316.0, 0.99, 1.871E7).addLanguage("en", 316.0, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.US, 3.29256E8, 0.99, 1.949E13).addLanguage("en", 3.16086E8, 0.99, "DE_FACTO_OFFICIAL").addLanguage("es", 3.16086E7, 0.99, "OFFICIAL_REGIONAL").addLanguage("zh_Hant", 2271870.0, 0.99).addLanguage("fr", 1843830.0, 0.99).addLanguage("de", 1547500.0, 0.99).addLanguage("fil", 1382880.0, 0.99).addLanguage("it", 1119470.0, 0.99).addLanguage("vi", 1119470.0, 0.99).addLanguage("ko", 987768.0, 0.99).addLanguage("ru", 790214.0, 0.99).addLanguage("nv", 167921.0, 0.99).addLanguage("yi", 161335.0, 0.99).addLanguage("pdc", 128410.0, 0.99).addLanguage("haw", 29303.8, 0.99, "OFFICIAL_REGIONAL").addLanguage("frc", 27986.8, 0.99).addLanguage("chr", 25352.7, 0.05).addLanguage("esu", 20413.9, 0.99).addLanguage("dak", 19426.1, 0.99).addLanguage("cho", 10865.4, 0.99).addLanguage("lkt", 8231.4, 0.99).addLanguage("ik", 7902.14, 0.05).addLanguage("mus", 3951.07, 0.99);
        this.addRegion(RegionCode.UY, 3369300.0, 0.981, 7.816E10).addLanguage("es", 2964980.0, 0.981, "OFFICIAL");
        this.addRegion(RegionCode.UZ, 3.00237E7, 0.994, 2.23E11).addLanguage("uz", 2.55201E7, 0.994, "OFFICIAL").addLanguage("uz_Cyrl", 4503560.0, 0.994, "OFFICIAL").addLanguage("ru", 4203320.0, 0.994).addLanguage("kaa", 480379.0, 0.994).addLanguage("tr", 228180.0, 0.994);
        this.addRegion(RegionCode.VA, 1000.0, 1.0, 3.722E7).addLanguage("it", 820.0, 1.0, "DE_FACTO_OFFICIAL").addLanguage("la", 820.0, 1.0);
        this.addRegion(RegionCode.VC, 101844.0, 0.96, 1.265E9).addLanguage("en", 97770.2, 0.96, "OFFICIAL");
        this.addRegion(RegionCode.VE, 3.16892E7, 0.955, 3.816E11).addLanguage("es", 2.59851E7, 0.955, "OFFICIAL");
        this.addRegion(RegionCode.VG, 35802.0, 0.978, 5.0E8).addLanguage("en", 35086.0, 0.978, "OFFICIAL");
        this.addRegion(RegionCode.VI, 106977.0, 0.99, 3.872E9).addLanguage("en", 80232.8, 0.99, "DE_FACTO_OFFICIAL");
        this.addRegion(RegionCode.VN, 9.70403E7, 0.934, 6.487E11).addLanguage("vi", 8.34547E7, 0.934, "OFFICIAL").addLanguage("zh_Hant", 1067440.0, 0.934).addLanguage("cjm", 86365.9, 0.934);
        this.addRegion(RegionCode.VU, 288037.0, 0.832, 7.72E8).addLanguage("bi", 259233.0, 0.832, "OFFICIAL").addLanguage("en", 239071.0, 0.832, "OFFICIAL").addLanguage("fr", 144018.0, 0.832, "OFFICIAL");
        this.addRegion(RegionCode.WF, 15763.0, 0.5, 6.0E7).addLanguage("wls", 9457.8, 0.5).addLanguage("fr", 7566.24, 0.5, "OFFICIAL").addLanguage("fud", 4886.53, 0.5);
        this.addRegion(RegionCode.WS, 201316.0, 0.988, 1.137E9).addLanguage("sm", 201316.0, 0.988, "OFFICIAL").addLanguage("en", 4428.95, 0.988, "OFFICIAL");
        this.addRegion(RegionCode.XK, 1907590.0, 0.919, 1.96E10).addLanguage("sq", 1754980.0, 0.919, "OFFICIAL").addLanguage("aln", 1411620.0, 0.919).addLanguage("sr", 95379.5, 0.919, "OFFICIAL").addLanguage("sr_Latn", 95379.5, 0.919, "OFFICIAL");
        this.addRegion(RegionCode.YE, 2.86672E7, 0.653, 7.363E10).addLanguage("ar", 2.12137E7, 0.653, "OFFICIAL").addLanguage("en", 2580050.0, 0.653);
        this.addRegion(RegionCode.YT, 194000.0, 0.92, 9.536E8).addLanguage("swb", 170720.0, 0.92).addLanguage("fr", 110580.0, 0.92, "OFFICIAL").addLanguage("buc", 44620.0, 0.92).addLanguage("sw", 2716.0, 0.92);
        this.addRegion(RegionCode.ZA, 5.53802E7, 0.93, 7.672E11).addLanguage("en", 1.71679E7, 0.93, "OFFICIAL").addLanguage("zu", 1.32912E7, 0.93, "OFFICIAL_REGIONAL").addLanguage("xh", 9968440.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("af", 7199430.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("nso", 5205740.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("tn", 4541180.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("st", 4375040.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ts", 2436730.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ss", 1495270.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("ve", 1273740.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("hi", 1107600.0, 0.93).addLanguage("nr", 886083.0, 0.93, "OFFICIAL_REGIONAL").addLanguage("sw", 996.844, 0.93);
        this.addRegion(RegionCode.ZM, 1.64451E7, 0.614, 6.893E10).addLanguage("bem", 5097980.0, 0.614).addLanguage("en", 2631220.0, 0.614, "OFFICIAL").addLanguage("ny", 2466760.0, 0.614).addLanguage("loz", 986706.0, 0.614);
        this.addRegion(RegionCode.ZW, 1.40304E7, 0.836, 3.427E10).addLanguage("sn", 1.13646E7, 0.836, "OFFICIAL").addLanguage("en", 5892770.0, 0.836, "OFFICIAL").addLanguage("nd", 1683650.0, 0.836, "OFFICIAL").addLanguage("mxc", 911976.0, 0.836).addLanguage("ndc", 855854.0, 0.836).addLanguage("kck", 743611.0, 0.836).addLanguage("ny", 266578.0, 0.836).addLanguage("ve", 89794.6, 0.836).addLanguage("tn", 30866.9, 0.836);
    }

    private static class LanguageData {
        final long population;
        final float writing;
        final LanguageCode.OfficialStatus officialStatus;

        LanguageData(double population, double writing) {
            this.population = (long)population;
            this.writing = (float)writing;
            this.officialStatus = null;
        }

        LanguageData(double population, double writing, String officialStatus) {
            this.population = (long)population;
            this.writing = (float)writing;
            this.officialStatus = LanguageCode.OfficialStatus.valueOf(officialStatus);
        }

        public String toString() {
            long l = this.population;
            float f = this.writing;
            String string = this.hasOfficialStatus() ? this.officialStatus.toShortName() : "";
            return new StringBuilder(37 + String.valueOf(string).length()).append(l).append(",").append(f).append(",").append(string).toString();
        }

        boolean hasOfficialStatus() {
            return this.officialStatus != null;
        }
    }

    @VisibleForTesting
    static class TerritoryData {
        final long population;
        final float literacy;
        final long gdp;
        Map<LanguageCode, LanguageData> languageData;

        TerritoryData(double population, double literacy, double gdp) {
            this.population = (long)population;
            this.literacy = (float)literacy;
            this.gdp = (long)gdp;
            this.languageData = new LinkedHashMap<LanguageCode, LanguageData>();
        }

        TerritoryData addLanguage(String languageSubtag, double languagePopulation, double writingPopulation) {
            this.languageData.put(LanguageCode.forString(languageSubtag), new LanguageData(languagePopulation, writingPopulation));
            return this;
        }

        TerritoryData addLanguage(String languageSubtag, double languagePopulation, double writingPopulation, String officialStatus) {
            this.languageData.put(LanguageCode.forString(languageSubtag), new LanguageData(languagePopulation, writingPopulation, officialStatus));
            return this;
        }

        void freeze() {
            this.languageData = ImmutableMap.copyOf(this.languageData);
        }

        public String toString() {
            long l = this.population;
            long l2 = this.gdp;
            float f = this.literacy;
            String string = String.valueOf(this.languageData);
            return new StringBuilder(58 + String.valueOf(string).length()).append(l).append(",").append(l2).append(",").append(f).append(",").append(string).toString();
        }
    }

    private static class Dag<N> {
        private final SetMultimap<N, N> edges;
        private final SetMultimap<N, N> inverseEdges;
        private final SetMultimap<N, N> connections;
        private final SetMultimap<N, N> inverseConnections;

        private Dag(Multimap<N, N> edges) {
            HashBiMultimap copy = BiMultimaps.newHashBiMultimap();
            copy.putAll(edges);
            this.edges = Multimaps.unmodifiableSetMultimap(copy);
            this.inverseEdges = Multimaps.unmodifiableSetMultimap(copy.inverse());
            SetMultimap closure = new Traverser().computeClosure();
            this.connections = Multimaps.unmodifiableSetMultimap(closure);
            this.inverseConnections = Multimaps.unmodifiableSetMultimap(Multimaps.invertFrom(this.connections, HashMultimap.create()));
        }

        public boolean hasPath(N from, N to) {
            return this.connections.containsEntry(from, to);
        }

        public Set<N> getNodesWithEdgeFrom(N node) {
            return this.edges.get((Object)node);
        }

        public Set<N> getNodesWithEdgeTo(N node) {
            return this.inverseEdges.get((Object)node);
        }

        public Set<N> getNodesWithPathFrom(N node) {
            return this.connections.get((Object)node);
        }

        public Set<N> getNodesWithPathTo(N node) {
            return this.inverseConnections.get((Object)node);
        }

        private static <N> Set<N> minus(Set<N> set, Collection<N> collection) {
            HashSet<N> result = Sets.newHashSet(set);
            result.removeAll(collection);
            return result;
        }

        private class Traverser {
            private final SetMultimap<N, N> collector = HashMultimap.create();
            private final Set<N> upline = Sets.newHashSet();

            private Traverser() {
            }

            private SetMultimap<N, N> computeClosure() {
                Set sources = Dag.minus(Dag.this.edges.keySet(), Dag.this.edges.values());
                for (Object source : sources) {
                    this.recurse(source);
                }
                return this.collector;
            }

            private void recurse(N node) {
                for (Object ancestor : this.upline) {
                    if (ancestor.equals(node)) {
                        throw new IllegalArgumentException("cycle found");
                    }
                    this.collector.put(ancestor, node);
                }
                this.upline.add(node);
                for (Object child : Dag.this.edges.get(node)) {
                    this.recurse(child);
                }
                this.upline.remove(node);
            }
        }
    }
}

