/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.RegionCode;
import com.google.i18n.identifiers.RegionInfo;
import com.google.i18n.identifiers.Subdivision;
import com.google.i18n.identifiers.SubdivisionNameService;
import com.google.i18n.identifiers.SupportedLanguages;
import com.google.i18n.identifiers.impl.RealSubdivisionRepository;
import com.google.i18n.identifiers.impl.StandardRegionInfo;
import com.ibm.icu.text.Transliterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;

public final class StandardSubdivisionNameService
implements SubdivisionNameService {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/i18n/identifiers/impl/StandardSubdivisionNameService");
    private final Map<String, SubdivisionData> db = Maps.newHashMap();
    private static final Set<String> latnLanguages = ImmutableSet.of("aa", "af", "ak", "ay", "az", "bal", new String[]{"br", "bs", "ca", "cch", "ceb", "ch", "co", "cpe", "cs", "cy", "da", "de", "ee", "en", "eo", "es", "et", "eu", "fi", "fil", "fj", "fo", "fr", "fur", "ga", "gaa", "gd", "gl", "gn", "gsw", "gv", "ha", "haw", "ho", "hr", "ht", "hu", "ia", "id", "ig", "is", "it", "jv", "kaj", "kam", "kcg", "kfo", "kl", "kpe", "ku", "kw", "la", "lb", "ln", "lt", "lv", "men", "mg", "mh", "mo", "ms", "mt", "na", "nb", "nd", "niu", "nl", "nn", "no", "nr", "nso", "ny", "oc", "om", "pau", "pl", "pt", "qu", "rn", "ro", "rw", "se", "sg", "sid", "sk", "sl", "sm", "sma", "smi", "smj", "smn", "sms", "so", "sq", "sr", "ss", "st", "sv", "sw", "tem", "tet", "tg", "tk", "tkl", "tl", "tn", "to", "tpi", "tr", "ts", "tvl", "uz", "ve", "vi", "wo", "xh", "yo", "zu"});
    private static final SubdivisionData EMPTY_SDATA = new SubdivisionData((List)ImmutableList.of(), (List)ImmutableList.of()){

        @Override
        String name(String language) {
            return null;
        }

        @Override
        List<String> languages() {
            return Collections.emptyList();
        }
    };
    private static final Pattern LINE_PAT = Pattern.compile("^([^;]+);([^;]*);([^;]*);([^;]*);([^;]*);([^;]*)$");
    private static final Pattern LANG_PAT = Pattern.compile("([^=]+)=([^+]+)\\+?");

    @Inject
    public StandardSubdivisionNameService(@Named(value="SubdivisionDataInfo") Reader data) throws IOException {
        this.addRegionData();
        this.addFileData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileData(Reader data) throws IOException {
        try (BufferedReader br = new BufferedReader(data);){
            String line;
            while (null != (line = br.readLine())) {
                this.createAndAddSubdivisionData(line);
            }
        }
    }

    @Override
    public String getName(Subdivision s, LanguageCode ... languages) {
        SubdivisionData data = this.getData(s);
        for (LanguageCode lc : languages) {
            String result = data.name(lc.toString());
            if (result == null) continue;
            return result;
        }
        return this.getLatinName(s);
    }

    @Override
    public String getLatinName(Subdivision s) {
        SubdivisionData data = this.getData(s);
        for (int i = 0; i < data.langs.length; ++i) {
            String lang = data.langs[i];
            if (!latnLanguages.contains(lang) && lang.indexOf("-Latn") == -1) continue;
            return data.names[i];
        }
        return s.id();
    }

    @Override
    public List<LanguageCode> getSupportedLanguages(Subdivision s) {
        ArrayList<LanguageCode> result = Lists.newArrayList();
        for (String name : this.getData(s).languages()) {
            try {
                LanguageCode lc = LanguageCode.forString(name);
                if (lc == null) continue;
                result.add(lc);
            }
            catch (IllegalArgumentException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardSubdivisionNameService", "getSupportedLanguages", 134, "StandardSubdivisionNameService.java")).log("language '%s' for subdivision '%s': %s", name, s.id(), e.getMessage());
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Set<Subdivision> find(Subdivision root, String text) {
        Predicate<Subdivision> predicate = Predicates.or(new NameStringPredicate(text), new IdStringPredicate(text));
        return this.find(root, predicate);
    }

    @Override
    public Set<Subdivision> find(Subdivision root, Pattern pattern) {
        Predicate<Subdivision> predicate = Predicates.or(new NamePredicate(pattern), new IdPredicate(pattern));
        return this.find(root, predicate);
    }

    @Override
    public Set<Subdivision> find(Subdivision root, Predicate<Subdivision> filter) {
        return this.find(root, filter, new HashSet<Subdivision>());
    }

    private Set<Subdivision> find(Subdivision root, Predicate<Subdivision> filter, Set<Subdivision> results) {
        if (filter.apply(root)) {
            results.add(root);
        }
        for (Subdivision child : root.children()) {
            this.find(child, filter, results);
        }
        return results;
    }

    private SubdivisionData getData(Subdivision s) {
        SubdivisionData data = this.db.get(s.id());
        if (data == null) {
            data = EMPTY_SDATA;
        }
        return data;
    }

    private void createAndAddSubdivisionData(String line) {
        if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') {
            return;
        }
        Matcher m = LINE_PAT.matcher(line);
        if (!m.matches()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardSubdivisionNameService", "createAndAddSubdivisionData", 361, "StandardSubdivisionNameService.java")).log("pattern %s does not match line '%s'", (Object)LINE_PAT, (Object)line);
            return;
        }
        String id = m.group(1);
        ArrayList<String> languageCodeList = Lists.newArrayList();
        ArrayList<String> subdivisionNameList = Lists.newArrayList();
        String names = m.group(6);
        Matcher languageMatcher = LANG_PAT.matcher(names);
        while (languageMatcher.find()) {
            String languageCode = LanguageCode.forString(languageMatcher.group(1)).toString();
            String subdivisionName = languageMatcher.group(2);
            if (subdivisionName.contains("=")) {
                String string = String.valueOf(id);
                throw new IllegalStateException(string.length() != 0 ? "Malformed name string for subdivision ".concat(string) : new String("Malformed name string for subdivision "));
            }
            if (subdivisionName.startsWith("UN")) {
                subdivisionName = subdivisionName.substring(2);
            }
            languageCodeList.add(languageCode);
            subdivisionNameList.add(subdivisionName);
        }
        SubdivisionData data = new SubdivisionData(languageCodeList, subdivisionNameList);
        this.db.put(id, data);
    }

    private void addRegionData() {
        StandardRegionInfo info = StandardRegionInfo.getInstance();
        this.addRegion(RegionCode.UN001, info);
        Set<RegionCode> allRegions = info.getAllContents(RegionCode.UN001);
        for (RegionCode region : allRegions) {
            this.addRegion(region, info);
        }
    }

    private void addRegion(RegionCode region, RegionInfo info) {
        if (RealSubdivisionRepository.isExcludedRegion(region)) {
            return;
        }
        String id = region.toString();
        if (this.db.containsKey(id)) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardSubdivisionNameService", "addRegion", 406, "StandardSubdivisionNameService.java")).log("duplicate region: %s", (Object)region);
            return;
        }
        ArrayList<String> languageCodeList = Lists.newArrayList();
        ArrayList<String> subdivisionNameList = Lists.newArrayList();
        ImmutableSet<LanguageCode> languagesToSupport = SupportedLanguages.getLanguagesUpToAndIncluding(SupportedLanguages.TierId.TIER_4);
        for (LanguageCode languageCode : languagesToSupport) {
            String subdivisionName = info.getDisplayName(region, languageCode);
            languageCodeList.add(languageCode.toString());
            subdivisionNameList.add(subdivisionName);
        }
        if (languageCodeList.size() == 0) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withInjectedLogSite("com/google/i18n/identifiers/impl/StandardSubdivisionNameService", "addRegion", 421, "StandardSubdivisionNameService.java")).log("no languages for region id: %s", id);
        }
        SubdivisionData data = new SubdivisionData(languageCodeList, subdivisionNameList);
        this.db.put(id, data);
    }

    private static class SubdivisionData {
        private final String[] langs;
        private final String[] names;

        SubdivisionData(List<String> langs, List<String> names) {
            this.langs = langs.toArray(new String[0]);
            this.names = names.toArray(new String[0]);
            if (this.langs.length != this.names.length) {
                throw new IllegalStateException();
            }
        }

        String name(String language) {
            while (true) {
                for (int i = 0; i < this.langs.length; ++i) {
                    String lang = this.langs[i];
                    if (!lang.equals(language)) continue;
                    return this.names[i];
                }
                int x = language.lastIndexOf(45);
                if (x == -1) break;
                language = language.substring(0, x);
            }
            return null;
        }

        List<String> languages() {
            return Collections.unmodifiableList(Arrays.asList(this.langs));
        }
    }

    private static class IdPredicate
    implements Predicate<Subdivision> {
        private Pattern pattern;

        IdPredicate(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean apply(Subdivision s) {
            return this.pattern.matcher(s.id()).find();
        }
    }

    private class NamePredicate
    implements Predicate<Subdivision> {
        private Pattern pattern;

        NamePredicate(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean apply(Subdivision s) {
            SubdivisionData data = StandardSubdivisionNameService.this.getData(s);
            for (String name : data.names) {
                if (!this.pattern.matcher(name).find()) continue;
                return true;
            }
            return false;
        }
    }

    private static class IdStringPredicate
    implements Predicate<Subdivision> {
        private String string;

        private IdStringPredicate(String string) {
            this.string = string;
        }

        @Override
        public boolean apply(Subdivision s) {
            return s.id().indexOf(this.string) != -1;
        }
    }

    private class NameStringPredicate
    implements Predicate<Subdivision> {
        private String string;

        private String simplify(String s) {
            return Loader.transliterator.transliterate(s);
        }

        private NameStringPredicate(String string) {
            this.string = this.simplify(string);
        }

        @Override
        public boolean apply(Subdivision s) {
            SubdivisionData data = StandardSubdivisionNameService.this.getData(s);
            for (String name : data.names) {
                if (this.simplify(name).indexOf(this.string) == -1) continue;
                return true;
            }
            return false;
        }
    }

    private static class Loader {
        private static final Transliterator transliterator = Transliterator.getInstance("Lower;NFD;[:Diacritic:]Remove;NFC", 0);

        private Loader() {
        }
    }
}

