/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.identifiers.impl;

import com.google.i18n.identifiers.LanguageCode;
import com.google.i18n.identifiers.LanguageMatcher;
import com.google.i18n.identifiers.LanguagePriorityList;
import com.google.i18n.identifiers.ULocaleConverter;
import com.ibm.icu.impl.locale.LocaleDistance;
import com.ibm.icu.impl.locale.XLocaleMatcher;
import com.ibm.icu.util.LocalePriorityList;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;

public class XStandardLanguageMatcher
implements LanguageMatcher {
    private final XLocaleMatcher xLocaleMatcher;

    private static ULocale fromLanguageCode(LanguageCode languageCode) {
        return ULocaleConverter.CONVERTER.toOther(languageCode);
    }

    private static LanguageCode fromULocale(ULocale locale) {
        return ULocaleConverter.CONVERTER.fromOther(locale);
    }

    private static LocalePriorityList fromLanguagePriorityList(LanguagePriorityList langList) {
        LocalePriorityList.Builder builder = null;
        for (LanguageCode lang : langList) {
            if (builder == null) {
                builder = LocalePriorityList.add(XStandardLanguageMatcher.fromLanguageCode(lang));
                continue;
            }
            builder.add(XStandardLanguageMatcher.fromLanguageCode(lang));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private XStandardLanguageMatcher(Builder builder) {
        this.xLocaleMatcher = builder.internalBuilder.build();
    }

    public XStandardLanguageMatcher(LanguagePriorityList supportedLanguages, LanguageCode defaultLanguage) {
        this(XStandardLanguageMatcher.builder().setSupportedLanguages(supportedLanguages).setDefaultLanguage(defaultLanguage));
    }

    public XStandardLanguageMatcher(LanguagePriorityList supportedLanguages) {
        this(XStandardLanguageMatcher.builder().setSupportedLanguages(supportedLanguages));
    }

    public XStandardLanguageMatcher(String supportedLanguages, LanguageCode defaultLang) {
        this(LanguagePriorityList.add(supportedLanguages).build(), defaultLang);
    }

    public XStandardLanguageMatcher(String supportedLanguages) {
        this(LanguagePriorityList.add(supportedLanguages).build(), null);
    }

    public static double match(LanguageCode a, LanguageCode b) {
        LocaleDistance localeDistance = LocaleDistance.INSTANCE;
        int defaultThreshold = localeDistance.getDefaultScriptDistance();
        int distance = localeDistance.testOnlyDistance(XStandardLanguageMatcher.fromLanguageCode(a), XStandardLanguageMatcher.fromLanguageCode(b), defaultThreshold, LocaleDistance.DistanceOption.REGION_FIRST);
        return (double)(100 - distance) / 100.0;
    }

    public LanguageCode getBestMatch(LanguageCode desiredLanguage, Output<LanguageCode> bestDesiredLanguage) {
        if (bestDesiredLanguage == null) {
            return XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(XStandardLanguageMatcher.fromLanguageCode(desiredLanguage)));
        }
        Output<ULocale> bestDesiredLocale = new Output<ULocale>();
        LanguageCode bestSupportedLanguage = XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(XStandardLanguageMatcher.fromLanguageCode(desiredLanguage), bestDesiredLocale));
        bestDesiredLanguage.value = XStandardLanguageMatcher.fromULocale((ULocale)bestDesiredLocale.value);
        return bestSupportedLanguage;
    }

    @Override
    public LanguageCode getBestMatch(LanguageCode desiredLanguage) {
        return this.getBestMatch(desiredLanguage, null);
    }

    public LanguageCode getBestMatch(LanguagePriorityList desiredLanguages, Output<LanguageCode> bestDesiredLanguage) {
        if (bestDesiredLanguage == null) {
            return XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(XStandardLanguageMatcher.fromLanguagePriorityList(desiredLanguages)));
        }
        Output<ULocale> bestDesiredLocale = new Output<ULocale>();
        LanguageCode bestSupportedLanguage = XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(XStandardLanguageMatcher.fromLanguagePriorityList(desiredLanguages), bestDesiredLocale));
        bestDesiredLanguage.value = bestDesiredLocale.value == null ? null : XStandardLanguageMatcher.fromULocale((ULocale)bestDesiredLocale.value);
        return bestSupportedLanguage;
    }

    @Override
    public LanguageCode getBestMatch(LanguagePriorityList desiredLanguages) {
        return this.getBestMatch(desiredLanguages, null);
    }

    public LanguageCode getBestMatch(String desiredLanguages, Output<LanguageCode> bestDesiredLanguage) {
        if (bestDesiredLanguage == null) {
            return XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(desiredLanguages));
        }
        Output<ULocale> bestDesiredLocale = new Output<ULocale>();
        LanguageCode bestSupportedLanguage = XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(XStandardLanguageMatcher.fromLanguagePriorityList(new LanguagePriorityList.LanguagePriorityListBuilder().add(desiredLanguages).build()), bestDesiredLocale));
        bestDesiredLanguage.value = XStandardLanguageMatcher.fromULocale((ULocale)bestDesiredLocale.value);
        return bestSupportedLanguage;
    }

    @Override
    public LanguageCode getBestMatch(String desiredLanguages) {
        return XStandardLanguageMatcher.fromULocale(this.xLocaleMatcher.getBestMatch(desiredLanguages));
    }

    public static class Builder {
        private XLocaleMatcher.Builder internalBuilder = new XLocaleMatcher.Builder();

        Builder() {
        }

        public Builder setSupportedLanguages(LanguagePriorityList supportedLanguages) {
            this.internalBuilder.setSupportedLocales(XStandardLanguageMatcher.fromLanguagePriorityList(supportedLanguages));
            return this;
        }

        public Builder setDefaultLanguage(LanguageCode defaultLanguage) {
            this.internalBuilder.setDefaultLanguage(XStandardLanguageMatcher.fromLanguageCode(defaultLanguage));
            return this;
        }

        public Builder setThreshold(int threshold) {
            this.internalBuilder.setThresholdDistance(threshold);
            return this;
        }

        public Builder setDistanceOption(LocaleDistance.DistanceOption distanceOption) {
            this.internalBuilder.setDistanceOption(distanceOption);
            return this;
        }

        public XStandardLanguageMatcher build() {
            return new XStandardLanguageMatcher(this);
        }
    }
}

