/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.i18n.RegexTransformer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaToJavaScriptTransformer
implements RegexTransformer {
    private static final Pattern leadBracket = Pattern.compile("\\G(\\\\.|[^\\[\\]])*+\\[");
    private static final Pattern nextBracketLead = Pattern.compile("\\G(\\\\.|[^\\[])*+\\[");
    private static final Pattern trailBracket = Pattern.compile("\\G(\\\\.|[^\\[\\]])*+\\]");
    private static final Pattern property = Pattern.compile("\\\\[pP]\\{\\w+\\}");
    private static final Pattern endingDollar = Pattern.compile("(\\\\.|[^$])*+\\$(?=\\])");
    private static final Pattern checkPoint = Pattern.compile("(\\\\.|[^&\\[\\]])*+[&\\[\\]]");
    private static final int SUPPL_MIN = 65536;
    private static final UnicodeSet FULL_TRAIL_RANGE = new UnicodeSet(56320, 57343);
    private static final Transliterator JS_REGEX_ESCAPER = Transliterator.createFromRules("javascript", "([ \\| \\[ \\] \\- \\* \\? \\+ \\{ \\} \\( \\) \\\\ \\# \\$ \\^ \\. \\! \\< \\> \\= \\: \\/ ]) > '\\' $1 ;([[:Z:][[:C:]-[:Co:]][:M:][:^NFC_QuickCheck=Yes:]]) > &hex($1);", 0);

    @Override
    public String transform(String regex) {
        StringBuilder result = new StringBuilder();
        Matcher matcher = leadBracket.matcher(regex);
        int currentLoc = 0;
        while (matcher.usePattern(leadBracket).find(currentLoc)) {
            int start = matcher.end();
            result.append(this.transformNonCharacterClass(regex.substring(currentLoc, start - 1)));
            currentLoc = start;
            int leadCount = 1;
            int trailCount = 0;
            boolean leadMatch = true;
            boolean trailMatch = true;
            do {
                if (!leadMatch && !trailMatch) {
                    throw new PatternSyntaxException("Unpaired Brackets", regex, currentLoc);
                }
                leadMatch = matcher.usePattern(leadBracket).find(currentLoc);
                if (leadMatch) {
                    ++leadCount;
                    currentLoc = matcher.end();
                }
                if (!(trailMatch = matcher.usePattern(trailBracket).find(currentLoc))) continue;
                ++trailCount;
                currentLoc = matcher.end();
            } while (leadCount != trailCount);
            result.append(this.transformCharacterClass(regex.substring(start - 1, currentLoc)));
        }
        int length = regex.length();
        if (currentLoc <= length) {
            result.append(this.transformNonCharacterClass(regex.substring(currentLoc, length)));
        }
        return result.toString();
    }

    protected String transformNonCharacterClass(String exp) {
        Matcher m = property.matcher(exp);
        if (m.find()) {
            return this.transform(exp.replaceAll("(\\\\[pP]\\{\\w+\\})", "[$1]"));
        }
        return exp;
    }

    protected String transformCharacterClass(String exp) {
        return this.generatePattern(new UnicodeSet(this.transformCharacterClassToICU(exp)));
    }

    @VisibleForTesting
    String transformCharacterClassToICU(String exp) {
        exp = exp.replace("&&", "&");
        exp = exp.replaceAll("\\\\([pP])\\{In", "\\\\$1\\{Block=");
        StringBuilder result = new StringBuilder(exp);
        Matcher matcher = endingDollar.matcher(result);
        int dollarMatchPointer = 0;
        while (matcher.find(dollarMatchPointer)) {
            dollarMatchPointer = matcher.end();
            result.insert(dollarMatchPointer - 1, "\\");
            dollarMatchPointer += 2;
        }
        int currentLoc = 0;
        while (matcher.usePattern(nextBracketLead).find(currentLoc)) {
            int start = matcher.end();
            if (result.charAt(start) != '[' && matcher.usePattern(checkPoint).find()) {
                currentLoc = matcher.end();
                if (result.charAt(currentLoc - 1) != '&') continue;
                result.insert(start, "[");
                result.insert(currentLoc, "]");
                currentLoc += 2;
                continue;
            }
            currentLoc = start;
        }
        return result.toString();
    }

    protected String generatePattern(UnicodeSet uSet) {
        int numberOfOR;
        if (uSet.size() == 0) {
            return "";
        }
        UnicodeSetIterator it = new UnicodeSetIterator(uSet);
        if (uSet.size() == 1) {
            it.next();
            return this.escape(UTF16.valueOf(it.codepoint));
        }
        StringBuilder strings = new StringBuilder();
        StringBuilder bmp = new StringBuilder();
        TreeMap<UnicodeSet, UnicodeSet> trailRangeToLeadRangeMap = Maps.newTreeMap();
        int previousLeadSurrogate = 0;
        UnicodeSet previousTrailRange = new UnicodeSet();
        while (it.nextRange()) {
            if (it.codepoint != UnicodeSetIterator.IS_STRING) {
                if (it.codepointEnd < 65536) {
                    this.appendRange(bmp, it.codepoint, it.codepointEnd);
                    continue;
                }
                if (it.codepoint >= 65536) {
                    previousLeadSurrogate = JavaToJavaScriptTransformer.addSupplementaryRange(previousTrailRange, previousLeadSurrogate, it.codepoint, it.codepointEnd, trailRangeToLeadRangeMap);
                    continue;
                }
                this.appendRange(bmp, it.codepoint, 65535);
                previousLeadSurrogate = JavaToJavaScriptTransformer.addSupplementaryRange(previousTrailRange, previousLeadSurrogate, 65536, it.codepointEnd, trailRangeToLeadRangeMap);
                continue;
            }
            strings.append('|').append(this.escape(it.string));
        }
        if (previousLeadSurrogate != 0) {
            JavaToJavaScriptTransformer.addRangeToMap(trailRangeToLeadRangeMap, previousTrailRange, previousLeadSurrogate);
        }
        boolean bmpEmpty = bmp.length() == 0;
        boolean supplEmpty = trailRangeToLeadRangeMap.isEmpty();
        StringBuilder result = new StringBuilder();
        if (!bmpEmpty) {
            result.append('[').append((CharSequence)bmp).append(']');
        }
        if (!supplEmpty) {
            if (result.length() > 0) {
                result.append('|');
            }
            result.append("(?=[").append(this.escape(UTF16.valueOf(55296))).append("-").append(this.escape(UTF16.valueOf(56319))).append("])(?:");
            for (Map.Entry entry : trailRangeToLeadRangeMap.entrySet()) {
                this.appendCodePointForSurrogate(result, (UnicodeSet)entry.getValue());
                this.appendCodePointForSurrogate(result, (UnicodeSet)entry.getKey());
                result.append('|');
            }
            result.deleteCharAt(result.length() - 1);
            result.append(')');
        }
        if (strings.length() != 0) {
            if (result.length() == 0) {
                strings.deleteCharAt(0);
            }
            result.append(strings.toString());
        }
        if ((numberOfOR = (bmpEmpty ? 0 : 1) + (supplEmpty ? 0 : 1) + strings.length() - 1) > 0) {
            result.insert(0, "(?:");
            result.append(')');
        }
        return result.toString();
    }

    protected synchronized String escape(String text) {
        return JS_REGEX_ESCAPER.transliterate(text);
    }

    private static int addSupplementaryRange(UnicodeSet previousTrailRange, int previousLeadSurrogate, int start, int end, Map<UnicodeSet, UnicodeSet> trailRangeToLeadRangeMap) {
        char startLead = UTF16.getLeadSurrogate(start);
        char startTrail = UTF16.getTrailSurrogate(start);
        char endLead = UTF16.getLeadSurrogate(end);
        char endTrail = UTF16.getTrailSurrogate(end);
        if (startLead != previousLeadSurrogate) {
            if (previousLeadSurrogate != 0) {
                JavaToJavaScriptTransformer.addRangeToMap(trailRangeToLeadRangeMap, previousTrailRange, previousLeadSurrogate);
            }
            previousTrailRange.clear();
        }
        if (startLead == endLead) {
            previousTrailRange.add(startTrail, endTrail);
        } else {
            previousTrailRange.add(startTrail, 57343);
            JavaToJavaScriptTransformer.addRangeToMap(trailRangeToLeadRangeMap, previousTrailRange, startLead);
            for (int i = startLead + '\u0001'; i < endLead; ++i) {
                JavaToJavaScriptTransformer.addRangeToMap(trailRangeToLeadRangeMap, FULL_TRAIL_RANGE, i);
            }
            previousTrailRange.clear();
            previousTrailRange.add(56320, endTrail);
        }
        return endLead;
    }

    private static void addRangeToMap(Map<UnicodeSet, UnicodeSet> trailRangeToLeadRangeMap, UnicodeSet trailRange, int lead) {
        UnicodeSet trailRangeTemp = new UnicodeSet(trailRange);
        UnicodeSet leadRange = trailRangeToLeadRangeMap.containsKey(trailRangeTemp) ? new UnicodeSet(trailRangeToLeadRangeMap.get(trailRangeTemp)) : new UnicodeSet();
        leadRange.add(lead);
        trailRangeToLeadRangeMap.put(trailRangeTemp, leadRange);
    }

    private void appendCodePointForSurrogate(StringBuilder buf, UnicodeSet uSet) {
        if (uSet.size() == 1) {
            buf.append(this.escape(UTF16.valueOf(uSet.getRangeStart(0))));
        } else {
            buf.append('[');
            for (int i = 0; i < uSet.getRangeCount(); ++i) {
                this.appendRange(buf, uSet.getRangeStart(i), uSet.getRangeEnd(i));
            }
            buf.append(']');
        }
    }

    private void appendRange(StringBuilder buf, int start, int end) {
        buf.append(this.escape(UTF16.valueOf(start)));
        if (start != end) {
            if (start + 1 != end) {
                buf.append('-');
            }
            buf.append(this.escape(UTF16.valueOf(end)));
        }
    }
}

