/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.unicode;

import com.google.common.annotations.GwtCompatible;

@GwtCompatible
public class Validation {
    public static final int REPLACEMENT_CHARACTER = 65533;

    private Validation() {
    }

    public static boolean isStructurallyValid(CharSequence s) {
        int length = s.length();
        int i = 0;
        while (i != length) {
            char ch;
            if ((ch = s.charAt(i++)) < '\ud800' || ch > '\udfff') continue;
            if (ch >= '\udc00' || i == length || !Character.isLowSurrogate(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isStructurallyValidCodePoint(int cp) {
        return cp >= 0 && (cp < 55296 || cp > 57343 && cp <= 0x10FFFF);
    }

    public static boolean isInterchangeValid(CharSequence s) {
        int length = s.length();
        int i = 0;
        while (i != length) {
            char ch;
            if ((ch = s.charAt(i++)) > '~' ? ch < '\ud800' && ch >= '\u00a0' : ch >= ' ') continue;
            if (ch < '\ud800') {
                if (ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f') continue;
                return false;
            }
            if (ch > '\udfff') {
                if (ch < '\ufdd0' || ch > '\ufdef' && ch < '\ufffe') continue;
                return false;
            }
            int cp = Character.codePointAt(s, i - 1);
            if (cp < 65536 || (cp & 0xFFFE) == 65534) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInterchangeValidCodePoint(int cp) {
        return cp <= 126 ? cp >= 32 || cp == 10 || cp == 13 || cp == 9 || cp == 12 : (cp < 55296 ? cp >= 160 : (cp < 64976 ? cp > 57343 : cp > 65007 && (cp & 0xFFFE) != 65534 && cp <= 0x10FFFF));
    }

    public static String coerceToStructurallyValid(String s) {
        return Validation.coerceToStructurallyValid(s, 65533);
    }

    public static String coerceToStructurallyValid(String s, int substituteCharacter) {
        if (Validation.isStructurallyValid(s)) {
            return s;
        }
        return Validation.replaceStructurallyInvalid(s, substituteCharacter);
    }

    public static String coerceToInterchangeValid(String s) {
        return Validation.coerceToInterchangeValid(s, 65533);
    }

    public static String coerceToInterchangeValid(String s, int substituteCharacter) {
        if (Validation.isInterchangeValid(s)) {
            return s;
        }
        return Validation.replaceInterchangeInvalid(s, substituteCharacter);
    }

    private static String replaceStructurallyInvalid(String s, int substituteCharacter) {
        if (substituteCharacter != 65533) {
            Validation.checkStructurallyValidCodePoint(substituteCharacter);
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch2;
            char ch = s.charAt(i);
            if (!Validation.isSurrogate(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch <= '\udbff' && i + 1 < length && Character.isLowSurrogate(ch2 = s.charAt(i + 1))) {
                sb.append(ch).append(ch2);
                ++i;
                continue;
            }
            sb.appendCodePoint(substituteCharacter);
        }
        return sb.toString();
    }

    private static String replaceInterchangeInvalid(String s, int substituteCharacter) {
        if (substituteCharacter != 65533) {
            Validation.checkInterchangeValidCodePoint(substituteCharacter);
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if (Validation.isInterchangeValidCodePoint(ch)) {
                sb.append(ch);
                ++i;
                continue;
            }
            int cp = Character.codePointAt(s, i);
            sb.appendCodePoint(Validation.isInterchangeValidCodePoint(cp) ? cp : substituteCharacter);
            i += Character.charCount(cp);
        }
        return sb.toString();
    }

    private static void checkStructurallyValidCodePoint(int cp) {
        if (!Validation.isStructurallyValidCodePoint(cp)) {
            String string = Integer.toHexString(cp);
            throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("U+").append(string).append(" is not structurally valid.").toString());
        }
    }

    private static void checkInterchangeValidCodePoint(int cp) {
        if (!Validation.isInterchangeValidCodePoint(cp)) {
            String string = Integer.toHexString(cp);
            throw new IllegalArgumentException(new StringBuilder(28 + String.valueOf(string).length()).append("U+").append(string).append(" is not interchange valid.").toString());
        }
    }

    private static boolean isSurrogate(int cp) {
        return cp >= 55296 && cp <= 57343;
    }
}

