/*
 * Decompiled with CFR 0.152.
 */
package com.google.io.base.shell;

import com.google.io.base.shell.AbnormalTerminationException;
import com.google.io.base.shell.BadExitStatusException;
import com.google.io.base.shell.CommandException;
import com.google.io.base.shell.CommandResult;
import com.google.io.base.shell.Consumers;
import com.google.io.base.shell.ExecFailedException;
import com.google.io.base.shell.FutureCommandResult;
import com.google.io.base.shell.Killable;
import com.google.io.base.shell.KillableObserver;
import com.google.io.base.shell.LogUtil;
import com.google.io.base.shell.ProcessKillable;
import com.google.io.base.shell.Shell;
import com.google.io.base.shell.TerminationStatus;
import com.google.io.base.shell.TimeoutKillableObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Command {
    private static final Logger log = Logger.getLogger("com.google.io.base.shell.Command");
    public static final byte[] NO_INPUT = new byte[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final KillableObserver NO_OBSERVER = new KillableObserver(){

        @Override
        public void startObserving(Killable killable) {
        }

        @Override
        public void stopObserving(Killable killable) {
        }
    };
    private final ProcessBuilder processBuilder;

    public Command(ProcessBuilder processBuilder) {
        this(processBuilder.command().toArray(EMPTY_STRING_ARRAY), processBuilder.environment(), processBuilder.directory());
    }

    public Command(String[] commandLineElements) {
        this(commandLineElements, null, null);
    }

    public Command(String[] commandLineElements, boolean useShell) {
        this(commandLineElements, useShell, null, null);
    }

    public Command(String[] commandLineElements, @Nullable Map<String, String> environmentVariables, @Nullable File workingDirectory) {
        this(commandLineElements, false, environmentVariables, workingDirectory);
    }

    public Command(String[] commandLineElements, boolean useShell, @Nullable Map<String, String> environmentVariables, @Nullable File workingDirectory) {
        if (commandLineElements == null || commandLineElements.length == 0) {
            throw new IllegalArgumentException("command line is null or empty");
        }
        this.processBuilder = new ProcessBuilder(Command.maybeAddShell(commandLineElements, useShell));
        if (environmentVariables != null) {
            this.processBuilder.environment().clear();
            this.processBuilder.environment().putAll(environmentVariables);
        }
        this.processBuilder.directory(workingDirectory);
    }

    private static String[] maybeAddShell(String[] commandLineElements, boolean useShell) {
        if (useShell) {
            StringBuilder builder = new StringBuilder();
            for (String element : commandLineElements) {
                if (builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(element);
            }
            return Shell.getPlatformShell().shellify(builder.toString());
        }
        return commandLineElements;
    }

    public String[] getCommandLineElements() {
        List<String> elements = this.processBuilder.command();
        return elements.toArray(new String[elements.size()]);
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.processBuilder.environment());
    }

    @Nullable
    public File getWorkingDirectory() {
        return this.processBuilder.directory();
    }

    public CommandResult execute() throws CommandException {
        return this.execute(NO_INPUT);
    }

    public CommandResult execute(byte[] stdinInput) throws CommandException {
        this.nullCheck(stdinInput, "stdinInput");
        return this.doExecute(new ByteArrayInputSource(stdinInput), NO_OBSERVER, Consumers.createAccumulatingConsumers(), false, false).get();
    }

    public CommandResult execute(byte[] stdinInput, long timeout, boolean ignoreOutput) throws CommandException {
        return this.execute(stdinInput, new TimeoutKillableObserver(timeout), ignoreOutput);
    }

    public CommandResult execute(byte[] stdinInput, @Nullable KillableObserver observer, boolean ignoreOutput) throws CommandException {
        KillableObserver theObserver = observer == null ? NO_OBSERVER : observer;
        return this.doExecute(new ByteArrayInputSource(stdinInput), theObserver, ignoreOutput ? Consumers.createDiscardingConsumers() : Consumers.createAccumulatingConsumers(), false, false).get();
    }

    public CommandResult execute(byte[] stdinInput, KillableObserver observer, OutputStream stdOut, OutputStream stdErr) throws CommandException {
        return this.execute(stdinInput, observer, stdOut, stdErr, false);
    }

    public CommandResult execute(byte[] stdinInput, KillableObserver observer, OutputStream stdOut, OutputStream stdErr, boolean killSubprocessOnInterrupt) throws CommandException {
        this.nullCheck(stdinInput, "stdinInput");
        this.nullCheck(observer, "observer");
        this.nullCheck(stdOut, "stdOut");
        this.nullCheck(stdErr, "stdErr");
        return this.doExecute(new ByteArrayInputSource(stdinInput), observer, Consumers.createStreamingConsumers(stdOut, stdErr), killSubprocessOnInterrupt, false).get();
    }

    public CommandResult execute(InputStream stdinInput, KillableObserver observer, OutputStream stdOut, OutputStream stdErr) throws CommandException {
        this.nullCheck(stdinInput, "stdinInput");
        this.nullCheck(observer, "observer");
        this.nullCheck(stdOut, "stdOut");
        this.nullCheck(stdErr, "stdErr");
        return this.doExecute(new InputStreamInputSource(stdinInput), observer, Consumers.createStreamingConsumers(stdOut, stdErr), false, false).get();
    }

    public CommandResult execute(InputStream stdinInput, KillableObserver observer, OutputStream stdOut, OutputStream stdErr, boolean closeOut) throws CommandException {
        this.nullCheck(stdinInput, "stdinInput");
        this.nullCheck(observer, "observer");
        this.nullCheck(stdOut, "stdOut");
        this.nullCheck(stdErr, "stdErr");
        return this.doExecute(new InputStreamInputSource(stdinInput), observer, Consumers.createStreamingConsumers(stdOut, stdErr), false, closeOut).get();
    }

    public FutureCommandResult executeAsynchronously(byte[] stdinInput) throws CommandException {
        return this.executeAsynchronously(stdinInput, NO_OBSERVER);
    }

    public FutureCommandResult executeAsynchronously(byte[] stdinInput, @Nullable KillableObserver observer) throws CommandException {
        KillableObserver theObserver = observer == null ? NO_OBSERVER : observer;
        this.nullCheck(stdinInput, "stdinInput");
        return this.doExecute(new ByteArrayInputSource(stdinInput), theObserver, Consumers.createDiscardingConsumers(), false, false);
    }

    public FutureCommandResult executeAsynchronously(InputStream stdinInput, @Nullable KillableObserver observer, OutputStream stdOut, OutputStream stdErr) throws CommandException {
        KillableObserver theObserver = observer == null ? NO_OBSERVER : observer;
        this.nullCheck(stdinInput, "stdinInput");
        return this.doExecute(new InputStreamInputSource(stdinInput), theObserver, Consumers.createStreamingConsumers(stdOut, stdErr), false, false);
    }

    private void nullCheck(Object argument, String argumentName) {
        if (argument == null) {
            String message = String.valueOf(argumentName).concat(" argument must not be null.");
            throw new NullPointerException(message);
        }
    }

    private FutureCommandResult doExecute(InputSource stdinInput, final KillableObserver observer, final Consumers.OutErrConsumers outErrConsumers, final boolean killSubprocessOnInterrupt, boolean closeOutputStreams) throws CommandException {
        this.logCommand();
        final Process process = this.startProcess();
        outErrConsumers.logConsumptionStrategy();
        outErrConsumers.registerInputs(process.getInputStream(), process.getErrorStream(), closeOutputStreams);
        Command.processInput(stdinInput, process, outErrConsumers);
        final Killable processKillable = Command.observeProcess(process, observer);
        return new FutureCommandResult(){

            @Override
            public CommandResult get() throws AbnormalTerminationException {
                return Command.this.waitForProcessToComplete(process, observer, processKillable, outErrConsumers, killSubprocessOnInterrupt);
            }

            @Override
            public boolean isDone() {
                try {
                    process.exitValue();
                    return true;
                }
                catch (IllegalThreadStateException e) {
                    return false;
                }
            }

            @Override
            public int getProcessId() {
                try {
                    Field pidField = process.getClass().getDeclaredField("pid");
                    pidField.setAccessible(true);
                    return pidField.getInt(process);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new UnsupportedOperationException("Only supported on Unix.", e);
                }
            }
        };
    }

    private Process startProcess() throws ExecFailedException {
        try {
            return this.processBuilder.start();
        }
        catch (IOException ioe) {
            throw new ExecFailedException(this, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processInput(InputSource stdinInput, Process process, Consumers.OutErrConsumers outErr) {
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, "com.google.io.base.shell.Command", "processInput", stdinInput.toLogString("stdin"));
        }
        try {
            if (stdinInput.isEmpty()) {
                return;
            }
            stdinInput.copyTo(process.getOutputStream());
        }
        catch (IOException iOException) {
        }
        finally {
            Command.silentClose(process.getOutputStream());
        }
    }

    private static Killable observeProcess(Process process, KillableObserver observer) {
        ProcessKillable processKillable = new ProcessKillable(process);
        observer.startObserving(processKillable);
        return processKillable;
    }

    private CommandResult waitForProcessToComplete(Process process, KillableObserver observer, Killable processKillable, Consumers.OutErrConsumers outErr, boolean killSubprocessOnInterrupt) throws AbnormalTerminationException {
        log.logp(Level.FINER, "com.google.io.base.shell.Command", "waitForProcessToComplete", "Waiting for process...");
        TerminationStatus status = Command.waitForProcess(process, killSubprocessOnInterrupt);
        observer.stopObserving(processKillable);
        log.logp(Level.FINER, "com.google.io.base.shell.Command", "waitForProcessToComplete", status.toString());
        try {
            if (Thread.currentThread().isInterrupted()) {
                outErr.cancel();
            } else {
                outErr.waitForCompletion();
            }
        }
        catch (IOException ioe) {
            CommandResult noOutputResult = new CommandResult(CommandResult.EMPTY_OUTPUT, CommandResult.EMPTY_OUTPUT, status);
            if (status.success()) {
                throw new AbnormalTerminationException(this, noOutputResult, (Throwable)ioe);
            }
            String string = String.valueOf(status);
            String message = new StringBuilder(63 + String.valueOf(string).length()).append(string).append("; also encountered an error while attempting to retrieve output").toString();
            throw status.exited() ? new BadExitStatusException(this, noOutputResult, message, ioe) : new AbnormalTerminationException(this, noOutputResult, message, ioe);
        }
        CommandResult result = new CommandResult(outErr.getAccumulatedOut(), outErr.getAccumulatedErr(), status);
        result.logThis();
        if (status.success()) {
            return result;
        }
        if (status.exited()) {
            throw new BadExitStatusException(this, result, status.toString());
        }
        throw new AbnormalTerminationException(this, result, status.toString());
    }

    private static TerminationStatus waitForProcess(Process process, boolean killSubprocessOnInterrupt) {
        boolean wasInterrupted = false;
        while (true) {
            try {
                TerminationStatus terminationStatus = new TerminationStatus(process.waitFor());
                return terminationStatus;
            }
            catch (InterruptedException ie) {
                wasInterrupted = true;
                if (!killSubprocessOnInterrupt) continue;
                process.destroy();
                continue;
            }
            break;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void logCommand() {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        log.logp(Level.FINE, "com.google.io.base.shell.Command", "logCommand", this.toDebugString());
    }

    public String toDebugString() {
        StringBuilder message = new StringBuilder(128);
        message.append("Executing (without brackets):");
        for (String arg : this.processBuilder.command()) {
            message.append(" [");
            message.append(arg);
            message.append(']');
        }
        message.append("; environment: ");
        message.append(this.processBuilder.environment().toString());
        File workingDirectory = this.processBuilder.directory();
        message.append("; working dir: ");
        message.append(workingDirectory == null ? "(current)" : workingDirectory.toString());
        return message.toString();
    }

    private static void silentClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException ioe) {
            String message = "Unexpected exception while closing output stream";
            log.logp(Level.WARNING, "com.google.io.base.shell.Command", "silentClose", message, ioe);
        }
    }

    private static class InputStreamInputSource
    implements InputSource {
        private InputStream inputStream;

        InputStreamInputSource(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void copyTo(OutputStream out) throws IOException {
            int r;
            byte[] buf = new byte[4096];
            while ((r = this.inputStream.read(buf)) != -1) {
                out.write(buf, 0, r);
                out.flush();
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public String toLogString(String sourceName) {
            return new StringBuilder(22 + String.valueOf(sourceName).length()).append("Input to ").append(sourceName).append(" is a stream.").toString();
        }
    }

    private static class ByteArrayInputSource
    implements InputSource {
        private byte[] bytes;

        ByteArrayInputSource(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public void copyTo(OutputStream out) throws IOException {
            out.write(this.bytes);
            out.flush();
        }

        @Override
        public boolean isEmpty() {
            return this.bytes.length == 0;
        }

        @Override
        public String toLogString(String sourceName) {
            if (this.isEmpty()) {
                String string = String.valueOf(sourceName);
                return string.length() != 0 ? "No input to ".concat(string) : new String("No input to ");
            }
            String string = LogUtil.toTruncatedString(this.bytes);
            return new StringBuilder(11 + String.valueOf(sourceName).length() + String.valueOf(string).length()).append("Input to ").append(sourceName).append(": ").append(string).toString();
        }
    }

    private static interface InputSource {
        public void copyTo(OutputStream var1) throws IOException;

        public boolean isEmpty();

        public String toLogString(String var1);
    }
}

