/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http;

import com.google.common.base.Preconditions;
import com.google.net.http.ConnectionInfo;
import com.google.net.http.HttpTransactionException;
import com.google.net.http.HttpTransactionHandler;
import com.google.net.http.RawHttpHeaders;
import com.google.net.http.RawRequestHeaders;
import com.google.net.http.RawResponseHeaders;
import com.google.net.http.TransportMetaData;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class HttpTransaction {
    protected final RawRequestHeaders initialRequestHeaders;
    protected final ConnectionInfo connectionInfo;
    private final AtomicReference<HttpTransactionHandler> handler = new AtomicReference();

    public HttpTransaction(RawRequestHeaders initialRequestHeaders, ConnectionInfo connectionInfo) {
        Preconditions.checkNotNull(initialRequestHeaders);
        Preconditions.checkNotNull(connectionInfo);
        this.initialRequestHeaders = initialRequestHeaders;
        this.connectionInfo = connectionInfo;
    }

    public void start(HttpTransactionHandler handler) {
        Preconditions.checkState(this.handler.getAndSet(handler) == null);
    }

    public HttpTransactionHandler getTransactionHandler() {
        return this.handler.get();
    }

    public RawRequestHeaders getInitialRequestHeaders() {
        return this.initialRequestHeaders;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public abstract void sendInitialHeaders(RawResponseHeaders var1) throws HttpTransactionException;

    public void sendInitialHeaders(RawRequestHeaders headers) throws HttpTransactionException {
        throw new HttpTransactionException("Client-side transport is not yet supported.");
    }

    public abstract void sendMoreHeaders(RawHttpHeaders var1) throws HttpTransactionException;

    public abstract void sendMetadata(TransportMetaData var1) throws HttpTransactionException;

    public abstract void close() throws HttpTransactionException;

    public abstract void abort();

    public boolean isReadDone() {
        return false;
    }

    public abstract void readMoreBody() throws HttpTransactionException;

    public abstract void writeMoreBody() throws HttpTransactionException;

    public abstract int read(byte[] var1, int var2, int var3);

    public abstract int write(byte[] var1, int var2, int var3);

    public abstract void forwardBody(HttpTransaction var1) throws HttpTransactionException;
}

