/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class RawHttpHeaders {
    private final List<Header> headers;

    protected RawHttpHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public List<Header> getAllHeaders() {
        return this.headers;
    }

    public Header getHeader(String name) {
        for (Header nameVal : this.headers) {
            if (!nameVal.name().equalsIgnoreCase(name)) continue;
            return nameVal;
        }
        return null;
    }

    public List<Header> getHeaders(String name) {
        return this.headers.stream().filter(header -> header.name().equalsIgnoreCase(name)).collect(Collectors.toList());
    }

    public void addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
    }

    public void removeHeaders(final String name) {
        Iterables.removeIf(this.headers, new Predicate<Header>(this){

            @Override
            public boolean apply(@Nullable Header input) {
                return input.name().equalsIgnoreCase(name);
            }
        });
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            Preconditions.checkNotNull(name, "name");
            Preconditions.checkNotNull(value, "value");
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            String string = this.name;
            String string2 = this.value;
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
        }
    }
}

