/*
 * Decompiled with CFR 0.152.
 */
package com.google.net.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ServerOptions {
    private final List<InetSocketAddress> ports = Lists.newArrayList();
    private Executor executor = null;
    private int listenerBacklog = 0;

    private ServerOptions() {
    }

    public InetSocketAddress getFirstPort() {
        if (this.ports.isEmpty()) {
            throw new IllegalArgumentException("port is not specified");
        }
        return this.ports.get(0);
    }

    public int getListenerBacklog() {
        return this.listenerBacklog;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public static class Builder {
        private final ServerOptions instance = new ServerOptions();

        public Builder addPort(int port) {
            this.instance.ports.add(new InetSocketAddress(port));
            return this;
        }

        public Builder addPort(InetSocketAddress port) {
            Preconditions.checkNotNull(port);
            this.instance.ports.add(port);
            return this;
        }

        public Builder setExecutor(Executor executor) {
            Preconditions.checkNotNull(executor);
            this.instance.executor = executor;
            return this;
        }

        public Builder setBacklog(int backlog) {
            this.instance.listenerBacklog = backlog;
            return this;
        }

        public ServerOptions build() {
            return this.instance;
        }
    }
}

